/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.media;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityManagerCompat;
import android.support.v4.hardware.display.DisplayManagerCompat;
import android.support.v4.media.VolumeProviderCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v7.media.MediaRouteDescriptor;
import android.support.v7.media.MediaRouteDiscoveryRequest;
import android.support.v7.media.MediaRouteProvider;
import android.support.v7.media.MediaRouteProviderDescriptor;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.RegisteredMediaRouteProviderWatcher;
import android.support.v7.media.RemoteControlClientCompat;
import android.support.v7.media.SystemMediaRouteProvider;
import android.util.Log;
import android.view.Display;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class MediaRouter {
    private static final String TAG = "MediaRouter";
    private static final boolean DEBUG = Log.isLoggable((String)"MediaRouter", (int)3);
    public static final int UNSELECT_REASON_UNKNOWN = 0;
    public static final int UNSELECT_REASON_DISCONNECTED = 1;
    public static final int UNSELECT_REASON_STOPPED = 2;
    public static final int UNSELECT_REASON_ROUTE_CHANGED = 3;
    static GlobalMediaRouter sGlobal;
    final Context mContext;
    final ArrayList<CallbackRecord> mCallbackRecords = new ArrayList();
    public static final int CALLBACK_FLAG_PERFORM_ACTIVE_SCAN = 1;
    public static final int CALLBACK_FLAG_UNFILTERED_EVENTS = 2;
    public static final int CALLBACK_FLAG_REQUEST_DISCOVERY = 4;
    public static final int CALLBACK_FLAG_FORCE_DISCOVERY = 8;
    public static final int AVAILABILITY_FLAG_IGNORE_DEFAULT_ROUTE = 1;
    public static final int AVAILABILITY_FLAG_REQUIRE_MATCH = 2;

    MediaRouter(Context context) {
        this.mContext = context;
    }

    public static MediaRouter getInstance(@NonNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        MediaRouter.checkCallingThread();
        if (sGlobal == null) {
            sGlobal = new GlobalMediaRouter(context.getApplicationContext());
            sGlobal.start();
        }
        return sGlobal.getRouter(context);
    }

    public List<RouteInfo> getRoutes() {
        MediaRouter.checkCallingThread();
        return sGlobal.getRoutes();
    }

    public List<ProviderInfo> getProviders() {
        MediaRouter.checkCallingThread();
        return sGlobal.getProviders();
    }

    @NonNull
    public RouteInfo getDefaultRoute() {
        MediaRouter.checkCallingThread();
        return sGlobal.getDefaultRoute();
    }

    @NonNull
    public RouteInfo getSelectedRoute() {
        MediaRouter.checkCallingThread();
        return sGlobal.getSelectedRoute();
    }

    @NonNull
    public RouteInfo updateSelectedRoute(@NonNull MediaRouteSelector selector) {
        RouteInfo route;
        if (selector == null) {
            throw new IllegalArgumentException("selector must not be null");
        }
        MediaRouter.checkCallingThread();
        if (DEBUG) {
            Log.d((String)TAG, (String)("updateSelectedRoute: " + selector));
        }
        if (!(route = sGlobal.getSelectedRoute()).isDefault() && !route.matchesSelector(selector)) {
            route = sGlobal.getDefaultRoute();
            sGlobal.selectRoute(route);
        }
        return route;
    }

    public void selectRoute(@NonNull RouteInfo route) {
        if (route == null) {
            throw new IllegalArgumentException("route must not be null");
        }
        MediaRouter.checkCallingThread();
        if (DEBUG) {
            Log.d((String)TAG, (String)("selectRoute: " + route));
        }
        sGlobal.selectRoute(route);
    }

    public void unselect(int reason) {
        if (reason < 0 || reason > 3) {
            throw new IllegalArgumentException("Unsupported reason to unselect route");
        }
        MediaRouter.checkCallingThread();
        sGlobal.selectRoute(this.getDefaultRoute(), reason);
    }

    public boolean isRouteAvailable(@NonNull MediaRouteSelector selector, int flags) {
        if (selector == null) {
            throw new IllegalArgumentException("selector must not be null");
        }
        MediaRouter.checkCallingThread();
        return sGlobal.isRouteAvailable(selector, flags);
    }

    public void addCallback(MediaRouteSelector selector, Callback callback) {
        this.addCallback(selector, callback, 0);
    }

    public void addCallback(@NonNull MediaRouteSelector selector, @NonNull Callback callback, int flags) {
        CallbackRecord record;
        int index;
        if (selector == null) {
            throw new IllegalArgumentException("selector must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        MediaRouter.checkCallingThread();
        if (DEBUG) {
            Log.d((String)TAG, (String)("addCallback: selector=" + selector + ", callback=" + callback + ", flags=" + Integer.toHexString(flags)));
        }
        if ((index = this.findCallbackRecord(callback)) < 0) {
            record = new CallbackRecord(this, callback);
            this.mCallbackRecords.add(record);
        } else {
            record = this.mCallbackRecords.get(index);
        }
        boolean updateNeeded = false;
        if ((flags & ~record.mFlags) != 0) {
            record.mFlags |= flags;
            updateNeeded = true;
        }
        if (!record.mSelector.contains(selector)) {
            record.mSelector = new MediaRouteSelector.Builder(record.mSelector).addSelector(selector).build();
            updateNeeded = true;
        }
        if (updateNeeded) {
            sGlobal.updateDiscoveryRequest();
        }
    }

    public void removeCallback(@NonNull Callback callback) {
        int index;
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        MediaRouter.checkCallingThread();
        if (DEBUG) {
            Log.d((String)TAG, (String)("removeCallback: callback=" + callback));
        }
        if ((index = this.findCallbackRecord(callback)) >= 0) {
            this.mCallbackRecords.remove(index);
            sGlobal.updateDiscoveryRequest();
        }
    }

    private int findCallbackRecord(Callback callback) {
        int count = this.mCallbackRecords.size();
        for (int i = 0; i < count; ++i) {
            if (this.mCallbackRecords.get((int)i).mCallback != callback) continue;
            return i;
        }
        return -1;
    }

    public void addProvider(@NonNull MediaRouteProvider providerInstance) {
        if (providerInstance == null) {
            throw new IllegalArgumentException("providerInstance must not be null");
        }
        MediaRouter.checkCallingThread();
        if (DEBUG) {
            Log.d((String)TAG, (String)("addProvider: " + providerInstance));
        }
        sGlobal.addProvider(providerInstance);
    }

    public void removeProvider(@NonNull MediaRouteProvider providerInstance) {
        if (providerInstance == null) {
            throw new IllegalArgumentException("providerInstance must not be null");
        }
        MediaRouter.checkCallingThread();
        if (DEBUG) {
            Log.d((String)TAG, (String)("removeProvider: " + providerInstance));
        }
        sGlobal.removeProvider(providerInstance);
    }

    public void addRemoteControlClient(@NonNull Object remoteControlClient) {
        if (remoteControlClient == null) {
            throw new IllegalArgumentException("remoteControlClient must not be null");
        }
        MediaRouter.checkCallingThread();
        if (DEBUG) {
            Log.d((String)TAG, (String)("addRemoteControlClient: " + remoteControlClient));
        }
        sGlobal.addRemoteControlClient(remoteControlClient);
    }

    public void removeRemoteControlClient(@NonNull Object remoteControlClient) {
        if (remoteControlClient == null) {
            throw new IllegalArgumentException("remoteControlClient must not be null");
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)("removeRemoteControlClient: " + remoteControlClient));
        }
        sGlobal.removeRemoteControlClient(remoteControlClient);
    }

    public void setMediaSession(Object mediaSession) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("addMediaSession: " + mediaSession));
        }
        sGlobal.setMediaSession(mediaSession);
    }

    public void setMediaSessionCompat(MediaSessionCompat mediaSession) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("addMediaSessionCompat: " + mediaSession));
        }
        sGlobal.setMediaSessionCompat(mediaSession);
    }

    public MediaSessionCompat.Token getMediaSessionToken() {
        return sGlobal.getMediaSessionToken();
    }

    static void checkCallingThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("The media router service must only be accessed on the application's main thread.");
        }
    }

    static <T> boolean equal(T a, T b) {
        return a == b || a != null && b != null && a.equals(b);
    }

    private static final class GlobalMediaRouter
    implements SystemMediaRouteProvider.SyncCallback,
    RegisteredMediaRouteProviderWatcher.Callback {
        private final Context mApplicationContext;
        private final ArrayList<WeakReference<MediaRouter>> mRouters = new ArrayList();
        private final ArrayList<RouteInfo> mRoutes = new ArrayList();
        private final ArrayList<ProviderInfo> mProviders = new ArrayList();
        private final ArrayList<RemoteControlClientRecord> mRemoteControlClients = new ArrayList();
        private final RemoteControlClientCompat.PlaybackInfo mPlaybackInfo = new RemoteControlClientCompat.PlaybackInfo();
        private final ProviderCallback mProviderCallback = new ProviderCallback();
        private final CallbackHandler mCallbackHandler = new CallbackHandler();
        private final DisplayManagerCompat mDisplayManager;
        private final SystemMediaRouteProvider mSystemProvider;
        private final boolean mLowRam;
        private RegisteredMediaRouteProviderWatcher mRegisteredProviderWatcher;
        private RouteInfo mDefaultRoute;
        private RouteInfo mSelectedRoute;
        private MediaRouteProvider.RouteController mSelectedRouteController;
        private MediaRouteDiscoveryRequest mDiscoveryRequest;
        private MediaSessionRecord mMediaSession;
        private MediaSessionCompat mRccMediaSession;
        private MediaSessionCompat mCompatSession;
        private MediaSessionCompat.OnActiveChangeListener mSessionActiveListener = new MediaSessionCompat.OnActiveChangeListener(){

            public void onActiveChanged() {
                if (GlobalMediaRouter.this.mRccMediaSession != null) {
                    if (GlobalMediaRouter.this.mRccMediaSession.isActive()) {
                        GlobalMediaRouter.this.addRemoteControlClient(GlobalMediaRouter.this.mRccMediaSession.getRemoteControlClient());
                    } else {
                        GlobalMediaRouter.this.removeRemoteControlClient(GlobalMediaRouter.this.mRccMediaSession.getRemoteControlClient());
                    }
                }
            }
        };

        GlobalMediaRouter(Context applicationContext) {
            this.mApplicationContext = applicationContext;
            this.mDisplayManager = DisplayManagerCompat.getInstance((Context)applicationContext);
            this.mLowRam = ActivityManagerCompat.isLowRamDevice((ActivityManager)((ActivityManager)applicationContext.getSystemService("activity")));
            this.mSystemProvider = SystemMediaRouteProvider.obtain(applicationContext, this);
            this.addProvider(this.mSystemProvider);
        }

        public void start() {
            this.mRegisteredProviderWatcher = new RegisteredMediaRouteProviderWatcher(this.mApplicationContext, this);
            this.mRegisteredProviderWatcher.start();
        }

        public MediaRouter getRouter(Context context) {
            MediaRouter router;
            int i = this.mRouters.size();
            while (--i >= 0) {
                router = (MediaRouter)this.mRouters.get(i).get();
                if (router == null) {
                    this.mRouters.remove(i);
                    continue;
                }
                if (router.mContext != context) continue;
                return router;
            }
            router = new MediaRouter(context);
            this.mRouters.add(new WeakReference<MediaRouter>(router));
            return router;
        }

        public ContentResolver getContentResolver() {
            return this.mApplicationContext.getContentResolver();
        }

        public Context getProviderContext(String packageName) {
            if (packageName.equals("android")) {
                return this.mApplicationContext;
            }
            try {
                return this.mApplicationContext.createPackageContext(packageName, 4);
            }
            catch (PackageManager.NameNotFoundException ex) {
                return null;
            }
        }

        public Display getDisplay(int displayId) {
            return this.mDisplayManager.getDisplay(displayId);
        }

        public void sendControlRequest(RouteInfo route, Intent intent, ControlRequestCallback callback) {
            if (route == this.mSelectedRoute && this.mSelectedRouteController != null && this.mSelectedRouteController.onControlRequest(intent, callback)) {
                return;
            }
            if (callback != null) {
                callback.onError(null, null);
            }
        }

        public void requestSetVolume(RouteInfo route, int volume) {
            if (route == this.mSelectedRoute && this.mSelectedRouteController != null) {
                this.mSelectedRouteController.onSetVolume(volume);
            }
        }

        public void requestUpdateVolume(RouteInfo route, int delta) {
            if (route == this.mSelectedRoute && this.mSelectedRouteController != null) {
                this.mSelectedRouteController.onUpdateVolume(delta);
            }
        }

        public List<RouteInfo> getRoutes() {
            return this.mRoutes;
        }

        public List<ProviderInfo> getProviders() {
            return this.mProviders;
        }

        public RouteInfo getDefaultRoute() {
            if (this.mDefaultRoute == null) {
                throw new IllegalStateException("There is no default route.  The media router has not yet been fully initialized.");
            }
            return this.mDefaultRoute;
        }

        public RouteInfo getSelectedRoute() {
            if (this.mSelectedRoute == null) {
                throw new IllegalStateException("There is no currently selected route.  The media router has not yet been fully initialized.");
            }
            return this.mSelectedRoute;
        }

        public void selectRoute(RouteInfo route) {
            this.selectRoute(route, 3);
        }

        public void selectRoute(RouteInfo route, int unselectReason) {
            if (!this.mRoutes.contains(route)) {
                Log.w((String)MediaRouter.TAG, (String)("Ignoring attempt to select removed route: " + route));
                return;
            }
            if (!route.mEnabled) {
                Log.w((String)MediaRouter.TAG, (String)("Ignoring attempt to select disabled route: " + route));
                return;
            }
            this.setSelectedRouteInternal(route, unselectReason);
        }

        public boolean isRouteAvailable(MediaRouteSelector selector, int flags) {
            if (selector.isEmpty()) {
                return false;
            }
            if ((flags & 2) == 0 && this.mLowRam) {
                return true;
            }
            int routeCount = this.mRoutes.size();
            for (int i = 0; i < routeCount; ++i) {
                RouteInfo route = this.mRoutes.get(i);
                if ((flags & 1) != 0 && route.isDefault() || !route.matchesSelector(selector)) continue;
                return true;
            }
            return false;
        }

        public void updateDiscoveryRequest() {
            MediaRouteSelector selector;
            boolean discover = false;
            boolean activeScan = false;
            MediaRouteSelector.Builder builder = new MediaRouteSelector.Builder();
            int i = this.mRouters.size();
            while (--i >= 0) {
                MediaRouter router = (MediaRouter)this.mRouters.get(i).get();
                if (router == null) {
                    this.mRouters.remove(i);
                    continue;
                }
                int count = router.mCallbackRecords.size();
                for (int j = 0; j < count; ++j) {
                    CallbackRecord callback = router.mCallbackRecords.get(j);
                    builder.addSelector(callback.mSelector);
                    if ((callback.mFlags & 1) != 0) {
                        activeScan = true;
                        discover = true;
                    }
                    if ((callback.mFlags & 4) != 0 && !this.mLowRam) {
                        discover = true;
                    }
                    if ((callback.mFlags & 8) == 0) continue;
                    discover = true;
                }
            }
            MediaRouteSelector mediaRouteSelector = selector = discover ? builder.build() : MediaRouteSelector.EMPTY;
            if (this.mDiscoveryRequest != null && this.mDiscoveryRequest.getSelector().equals(selector) && this.mDiscoveryRequest.isActiveScan() == activeScan) {
                return;
            }
            if (selector.isEmpty() && !activeScan) {
                if (this.mDiscoveryRequest == null) {
                    return;
                }
                this.mDiscoveryRequest = null;
            } else {
                this.mDiscoveryRequest = new MediaRouteDiscoveryRequest(selector, activeScan);
            }
            if (DEBUG) {
                Log.d((String)MediaRouter.TAG, (String)("Updated discovery request: " + this.mDiscoveryRequest));
            }
            if (discover && !activeScan && this.mLowRam) {
                Log.i((String)MediaRouter.TAG, (String)"Forcing passive route discovery on a low-RAM device, system performance may be affected.  Please consider using CALLBACK_FLAG_REQUEST_DISCOVERY instead of CALLBACK_FLAG_FORCE_DISCOVERY.");
            }
            int providerCount = this.mProviders.size();
            for (int i2 = 0; i2 < providerCount; ++i2) {
                this.mProviders.get(i2).mProviderInstance.setDiscoveryRequest(this.mDiscoveryRequest);
            }
        }

        @Override
        public void addProvider(MediaRouteProvider providerInstance) {
            int index = this.findProviderInfo(providerInstance);
            if (index < 0) {
                ProviderInfo provider = new ProviderInfo(providerInstance);
                this.mProviders.add(provider);
                if (DEBUG) {
                    Log.d((String)MediaRouter.TAG, (String)("Provider added: " + provider));
                }
                this.mCallbackHandler.post(513, provider);
                this.updateProviderContents(provider, providerInstance.getDescriptor());
                providerInstance.setCallback(this.mProviderCallback);
                providerInstance.setDiscoveryRequest(this.mDiscoveryRequest);
            }
        }

        @Override
        public void removeProvider(MediaRouteProvider providerInstance) {
            int index = this.findProviderInfo(providerInstance);
            if (index >= 0) {
                providerInstance.setCallback(null);
                providerInstance.setDiscoveryRequest(null);
                ProviderInfo provider = this.mProviders.get(index);
                this.updateProviderContents(provider, null);
                if (DEBUG) {
                    Log.d((String)MediaRouter.TAG, (String)("Provider removed: " + provider));
                }
                this.mCallbackHandler.post(514, provider);
                this.mProviders.remove(index);
            }
        }

        private void updateProviderDescriptor(MediaRouteProvider providerInstance, MediaRouteProviderDescriptor descriptor) {
            int index = this.findProviderInfo(providerInstance);
            if (index >= 0) {
                ProviderInfo provider = this.mProviders.get(index);
                this.updateProviderContents(provider, descriptor);
            }
        }

        private int findProviderInfo(MediaRouteProvider providerInstance) {
            int count = this.mProviders.size();
            for (int i = 0; i < count; ++i) {
                if (this.mProviders.get(i).mProviderInstance != providerInstance) continue;
                return i;
            }
            return -1;
        }

        private void updateProviderContents(ProviderInfo provider, MediaRouteProviderDescriptor providerDescriptor) {
            if (provider.updateDescriptor(providerDescriptor)) {
                int i;
                int targetIndex = 0;
                boolean selectedRouteDescriptorChanged = false;
                if (providerDescriptor != null) {
                    if (providerDescriptor.isValid()) {
                        List<MediaRouteDescriptor> routeDescriptors = providerDescriptor.getRoutes();
                        int routeCount = routeDescriptors.size();
                        for (int i2 = 0; i2 < routeCount; ++i2) {
                            MediaRouteDescriptor routeDescriptor = routeDescriptors.get(i2);
                            String id2 = routeDescriptor.getId();
                            int sourceIndex = provider.findRouteByDescriptorId(id2);
                            if (sourceIndex < 0) {
                                String uniqueId = this.assignRouteUniqueId(provider, id2);
                                RouteInfo route = new RouteInfo(provider, id2, uniqueId);
                                provider.mRoutes.add(targetIndex++, route);
                                this.mRoutes.add(route);
                                route.updateDescriptor(routeDescriptor);
                                if (DEBUG) {
                                    Log.d((String)MediaRouter.TAG, (String)("Route added: " + route));
                                }
                                this.mCallbackHandler.post(257, route);
                                continue;
                            }
                            if (sourceIndex < targetIndex) {
                                Log.w((String)MediaRouter.TAG, (String)("Ignoring route descriptor with duplicate id: " + routeDescriptor));
                                continue;
                            }
                            RouteInfo route = (RouteInfo)provider.mRoutes.get(sourceIndex);
                            Collections.swap(provider.mRoutes, sourceIndex, targetIndex++);
                            int changes = route.updateDescriptor(routeDescriptor);
                            if (changes == 0) continue;
                            if ((changes & 1) != 0) {
                                if (DEBUG) {
                                    Log.d((String)MediaRouter.TAG, (String)("Route changed: " + route));
                                }
                                this.mCallbackHandler.post(259, route);
                            }
                            if ((changes & 2) != 0) {
                                if (DEBUG) {
                                    Log.d((String)MediaRouter.TAG, (String)("Route volume changed: " + route));
                                }
                                this.mCallbackHandler.post(260, route);
                            }
                            if ((changes & 4) != 0) {
                                if (DEBUG) {
                                    Log.d((String)MediaRouter.TAG, (String)("Route presentation display changed: " + route));
                                }
                                this.mCallbackHandler.post(261, route);
                            }
                            if (route != this.mSelectedRoute) continue;
                            selectedRouteDescriptorChanged = true;
                        }
                    } else {
                        Log.w((String)MediaRouter.TAG, (String)("Ignoring invalid provider descriptor: " + providerDescriptor));
                    }
                }
                for (i = provider.mRoutes.size() - 1; i >= targetIndex; --i) {
                    RouteInfo route = (RouteInfo)provider.mRoutes.get(i);
                    route.updateDescriptor(null);
                    this.mRoutes.remove(route);
                }
                this.updateSelectedRouteIfNeeded(selectedRouteDescriptorChanged);
                for (i = provider.mRoutes.size() - 1; i >= targetIndex; --i) {
                    RouteInfo route = (RouteInfo)provider.mRoutes.remove(i);
                    if (DEBUG) {
                        Log.d((String)MediaRouter.TAG, (String)("Route removed: " + route));
                    }
                    this.mCallbackHandler.post(258, route);
                }
                if (DEBUG) {
                    Log.d((String)MediaRouter.TAG, (String)("Provider changed: " + provider));
                }
                this.mCallbackHandler.post(515, provider);
            }
        }

        private String assignRouteUniqueId(ProviderInfo provider, String routeDescriptorId) {
            String uniqueId = provider.getComponentName().flattenToShortString() + ":" + routeDescriptorId;
            if (this.findRouteByUniqueId(uniqueId) < 0) {
                return uniqueId;
            }
            int i = 2;
            String newUniqueId;
            while (this.findRouteByUniqueId(newUniqueId = String.format(Locale.US, "%s_%d", uniqueId, i)) >= 0) {
                ++i;
            }
            return newUniqueId;
        }

        private int findRouteByUniqueId(String uniqueId) {
            int count = this.mRoutes.size();
            for (int i = 0; i < count; ++i) {
                if (!this.mRoutes.get(i).mUniqueId.equals(uniqueId)) continue;
                return i;
            }
            return -1;
        }

        private void updateSelectedRouteIfNeeded(boolean selectedRouteDescriptorChanged) {
            if (this.mDefaultRoute != null && !this.isRouteSelectable(this.mDefaultRoute)) {
                Log.i((String)MediaRouter.TAG, (String)("Clearing the default route because it is no longer selectable: " + this.mDefaultRoute));
                this.mDefaultRoute = null;
            }
            if (this.mDefaultRoute == null && !this.mRoutes.isEmpty()) {
                for (RouteInfo route : this.mRoutes) {
                    if (!this.isSystemDefaultRoute(route) || !this.isRouteSelectable(route)) continue;
                    this.mDefaultRoute = route;
                    Log.i((String)MediaRouter.TAG, (String)("Found default route: " + this.mDefaultRoute));
                    break;
                }
            }
            if (this.mSelectedRoute != null && !this.isRouteSelectable(this.mSelectedRoute)) {
                Log.i((String)MediaRouter.TAG, (String)("Unselecting the current route because it is no longer selectable: " + this.mSelectedRoute));
                this.setSelectedRouteInternal(null, 0);
            }
            if (this.mSelectedRoute == null) {
                this.setSelectedRouteInternal(this.chooseFallbackRoute(), 0);
            } else if (selectedRouteDescriptorChanged) {
                this.updatePlaybackInfoFromSelectedRoute();
            }
        }

        private RouteInfo chooseFallbackRoute() {
            for (RouteInfo route : this.mRoutes) {
                if (route == this.mDefaultRoute || !this.isSystemLiveAudioOnlyRoute(route) || !this.isRouteSelectable(route)) continue;
                return route;
            }
            return this.mDefaultRoute;
        }

        private boolean isSystemLiveAudioOnlyRoute(RouteInfo route) {
            return route.getProviderInstance() == this.mSystemProvider && route.supportsControlCategory("android.media.intent.category.LIVE_AUDIO") && !route.supportsControlCategory("android.media.intent.category.LIVE_VIDEO");
        }

        private boolean isRouteSelectable(RouteInfo route) {
            return route.mDescriptor != null && route.mEnabled;
        }

        private boolean isSystemDefaultRoute(RouteInfo route) {
            return route.getProviderInstance() == this.mSystemProvider && route.mDescriptorId.equals("DEFAULT_ROUTE");
        }

        private void setSelectedRouteInternal(RouteInfo route, int unselectReason) {
            if (this.mSelectedRoute != route) {
                if (this.mSelectedRoute != null) {
                    if (DEBUG) {
                        Log.d((String)MediaRouter.TAG, (String)("Route unselected: " + this.mSelectedRoute + " reason: " + unselectReason));
                    }
                    this.mCallbackHandler.post(263, this.mSelectedRoute);
                    if (this.mSelectedRouteController != null) {
                        this.mSelectedRouteController.onUnselect(unselectReason);
                        this.mSelectedRouteController.onRelease();
                        this.mSelectedRouteController = null;
                    }
                }
                this.mSelectedRoute = route;
                if (this.mSelectedRoute != null) {
                    this.mSelectedRouteController = route.getProviderInstance().onCreateRouteController(route.mDescriptorId);
                    if (this.mSelectedRouteController != null) {
                        this.mSelectedRouteController.onSelect();
                    }
                    if (DEBUG) {
                        Log.d((String)MediaRouter.TAG, (String)("Route selected: " + this.mSelectedRoute));
                    }
                    this.mCallbackHandler.post(262, this.mSelectedRoute);
                }
                this.updatePlaybackInfoFromSelectedRoute();
            }
        }

        @Override
        public RouteInfo getSystemRouteByDescriptorId(String id2) {
            ProviderInfo provider;
            int routeIndex;
            int providerIndex = this.findProviderInfo(this.mSystemProvider);
            if (providerIndex >= 0 && (routeIndex = (provider = this.mProviders.get(providerIndex)).findRouteByDescriptorId(id2)) >= 0) {
                return (RouteInfo)provider.mRoutes.get(routeIndex);
            }
            return null;
        }

        public void addRemoteControlClient(Object rcc) {
            int index = this.findRemoteControlClientRecord(rcc);
            if (index < 0) {
                RemoteControlClientRecord record = new RemoteControlClientRecord(rcc);
                this.mRemoteControlClients.add(record);
            }
        }

        public void removeRemoteControlClient(Object rcc) {
            int index = this.findRemoteControlClientRecord(rcc);
            if (index >= 0) {
                RemoteControlClientRecord record = this.mRemoteControlClients.remove(index);
                record.disconnect();
            }
        }

        public void setMediaSession(Object session) {
            if (this.mMediaSession != null) {
                this.mMediaSession.clearVolumeHandling();
            }
            if (session == null) {
                this.mMediaSession = null;
            } else {
                this.mMediaSession = new MediaSessionRecord(session);
                this.updatePlaybackInfoFromSelectedRoute();
            }
        }

        public void setMediaSessionCompat(MediaSessionCompat session) {
            this.mCompatSession = session;
            if (Build.VERSION.SDK_INT >= 21) {
                this.setMediaSession(session != null ? session.getMediaSession() : null);
            } else if (Build.VERSION.SDK_INT >= 14) {
                if (this.mRccMediaSession != null) {
                    this.removeRemoteControlClient(this.mRccMediaSession.getRemoteControlClient());
                    this.mRccMediaSession.removeOnActiveChangeListener(this.mSessionActiveListener);
                }
                this.mRccMediaSession = session;
                if (session != null) {
                    session.addOnActiveChangeListener(this.mSessionActiveListener);
                    if (session.isActive()) {
                        this.addRemoteControlClient(session.getRemoteControlClient());
                    }
                }
            }
        }

        public MediaSessionCompat.Token getMediaSessionToken() {
            if (this.mMediaSession != null) {
                return this.mMediaSession.getToken();
            }
            if (this.mCompatSession != null) {
                return this.mCompatSession.getSessionToken();
            }
            return null;
        }

        private int findRemoteControlClientRecord(Object rcc) {
            int count = this.mRemoteControlClients.size();
            for (int i = 0; i < count; ++i) {
                RemoteControlClientRecord record = this.mRemoteControlClients.get(i);
                if (record.getRemoteControlClient() != rcc) continue;
                return i;
            }
            return -1;
        }

        private void updatePlaybackInfoFromSelectedRoute() {
            if (this.mSelectedRoute != null) {
                this.mPlaybackInfo.volume = this.mSelectedRoute.getVolume();
                this.mPlaybackInfo.volumeMax = this.mSelectedRoute.getVolumeMax();
                this.mPlaybackInfo.volumeHandling = this.mSelectedRoute.getVolumeHandling();
                this.mPlaybackInfo.playbackStream = this.mSelectedRoute.getPlaybackStream();
                this.mPlaybackInfo.playbackType = this.mSelectedRoute.getPlaybackType();
                int count = this.mRemoteControlClients.size();
                for (int i = 0; i < count; ++i) {
                    RemoteControlClientRecord record = this.mRemoteControlClients.get(i);
                    record.updatePlaybackInfo();
                }
                if (this.mMediaSession != null) {
                    if (this.mSelectedRoute == this.getDefaultRoute()) {
                        this.mMediaSession.clearVolumeHandling();
                    } else {
                        int controlType = 0;
                        if (this.mPlaybackInfo.volumeHandling == 1) {
                            controlType = 2;
                        }
                        this.mMediaSession.configureVolume(controlType, this.mPlaybackInfo.volumeMax, this.mPlaybackInfo.volume);
                    }
                }
            } else if (this.mMediaSession != null) {
                this.mMediaSession.clearVolumeHandling();
            }
        }

        private final class CallbackHandler
        extends Handler {
            private final ArrayList<CallbackRecord> mTempCallbackRecords = new ArrayList();
            private static final int MSG_TYPE_MASK = 65280;
            private static final int MSG_TYPE_ROUTE = 256;
            private static final int MSG_TYPE_PROVIDER = 512;
            public static final int MSG_ROUTE_ADDED = 257;
            public static final int MSG_ROUTE_REMOVED = 258;
            public static final int MSG_ROUTE_CHANGED = 259;
            public static final int MSG_ROUTE_VOLUME_CHANGED = 260;
            public static final int MSG_ROUTE_PRESENTATION_DISPLAY_CHANGED = 261;
            public static final int MSG_ROUTE_SELECTED = 262;
            public static final int MSG_ROUTE_UNSELECTED = 263;
            public static final int MSG_PROVIDER_ADDED = 513;
            public static final int MSG_PROVIDER_REMOVED = 514;
            public static final int MSG_PROVIDER_CHANGED = 515;

            private CallbackHandler() {
            }

            public void post(int msg, Object obj) {
                this.obtainMessage(msg, obj).sendToTarget();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                int what = msg.what;
                Object obj = msg.obj;
                this.syncWithSystemProvider(what, obj);
                try {
                    int i = GlobalMediaRouter.this.mRouters.size();
                    while (--i >= 0) {
                        MediaRouter router = (MediaRouter)((WeakReference)GlobalMediaRouter.this.mRouters.get(i)).get();
                        if (router == null) {
                            GlobalMediaRouter.this.mRouters.remove(i);
                            continue;
                        }
                        this.mTempCallbackRecords.addAll(router.mCallbackRecords);
                    }
                    int callbackCount = this.mTempCallbackRecords.size();
                    for (int i2 = 0; i2 < callbackCount; ++i2) {
                        this.invokeCallback(this.mTempCallbackRecords.get(i2), what, obj);
                    }
                }
                finally {
                    this.mTempCallbackRecords.clear();
                }
            }

            private void syncWithSystemProvider(int what, Object obj) {
                switch (what) {
                    case 257: {
                        GlobalMediaRouter.this.mSystemProvider.onSyncRouteAdded((RouteInfo)obj);
                        break;
                    }
                    case 258: {
                        GlobalMediaRouter.this.mSystemProvider.onSyncRouteRemoved((RouteInfo)obj);
                        break;
                    }
                    case 259: {
                        GlobalMediaRouter.this.mSystemProvider.onSyncRouteChanged((RouteInfo)obj);
                        break;
                    }
                    case 262: {
                        GlobalMediaRouter.this.mSystemProvider.onSyncRouteSelected((RouteInfo)obj);
                    }
                }
            }

            private void invokeCallback(CallbackRecord record, int what, Object obj) {
                MediaRouter router = record.mRouter;
                Callback callback = record.mCallback;
                block0 : switch (what & 0xFF00) {
                    case 256: {
                        RouteInfo route = (RouteInfo)obj;
                        if (!record.filterRouteEvent(route)) break;
                        switch (what) {
                            case 257: {
                                callback.onRouteAdded(router, route);
                                break;
                            }
                            case 258: {
                                callback.onRouteRemoved(router, route);
                                break;
                            }
                            case 259: {
                                callback.onRouteChanged(router, route);
                                break;
                            }
                            case 260: {
                                callback.onRouteVolumeChanged(router, route);
                                break;
                            }
                            case 261: {
                                callback.onRoutePresentationDisplayChanged(router, route);
                                break;
                            }
                            case 262: {
                                callback.onRouteSelected(router, route);
                                break;
                            }
                            case 263: {
                                callback.onRouteUnselected(router, route);
                            }
                        }
                        break;
                    }
                    case 512: {
                        ProviderInfo provider = (ProviderInfo)obj;
                        switch (what) {
                            case 513: {
                                callback.onProviderAdded(router, provider);
                                break block0;
                            }
                            case 514: {
                                callback.onProviderRemoved(router, provider);
                                break block0;
                            }
                            case 515: {
                                callback.onProviderChanged(router, provider);
                            }
                        }
                    }
                }
            }
        }

        private final class RemoteControlClientRecord
        implements RemoteControlClientCompat.VolumeCallback {
            private final RemoteControlClientCompat mRccCompat;
            private boolean mDisconnected;

            public RemoteControlClientRecord(Object rcc) {
                this.mRccCompat = RemoteControlClientCompat.obtain(GlobalMediaRouter.this.mApplicationContext, rcc);
                this.mRccCompat.setVolumeCallback(this);
                this.updatePlaybackInfo();
            }

            public Object getRemoteControlClient() {
                return this.mRccCompat.getRemoteControlClient();
            }

            public void disconnect() {
                this.mDisconnected = true;
                this.mRccCompat.setVolumeCallback(null);
            }

            public void updatePlaybackInfo() {
                this.mRccCompat.setPlaybackInfo(GlobalMediaRouter.this.mPlaybackInfo);
            }

            @Override
            public void onVolumeSetRequest(int volume) {
                if (!this.mDisconnected && GlobalMediaRouter.this.mSelectedRoute != null) {
                    GlobalMediaRouter.this.mSelectedRoute.requestSetVolume(volume);
                }
            }

            @Override
            public void onVolumeUpdateRequest(int direction) {
                if (!this.mDisconnected && GlobalMediaRouter.this.mSelectedRoute != null) {
                    GlobalMediaRouter.this.mSelectedRoute.requestUpdateVolume(direction);
                }
            }
        }

        private final class MediaSessionRecord {
            private final MediaSessionCompat mMsCompat;
            private int mControlType;
            private int mMaxVolume;
            private VolumeProviderCompat mVpCompat;

            public MediaSessionRecord(Object mediaSession) {
                this.mMsCompat = MediaSessionCompat.obtain((Context)GlobalMediaRouter.this.mApplicationContext, (Object)mediaSession);
            }

            public void configureVolume(int controlType, int max, int current) {
                if (this.mVpCompat != null && controlType == this.mControlType && max == this.mMaxVolume) {
                    this.mVpCompat.setCurrentVolume(current);
                } else {
                    this.mVpCompat = new VolumeProviderCompat(controlType, max, current){

                        public void onSetVolumeTo(final int volume) {
                            GlobalMediaRouter.this.mCallbackHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    if (GlobalMediaRouter.this.mSelectedRoute != null) {
                                        GlobalMediaRouter.this.mSelectedRoute.requestSetVolume(volume);
                                    }
                                }
                            });
                        }

                        public void onAdjustVolume(final int direction) {
                            GlobalMediaRouter.this.mCallbackHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    if (GlobalMediaRouter.this.mSelectedRoute != null) {
                                        GlobalMediaRouter.this.mSelectedRoute.requestUpdateVolume(direction);
                                    }
                                }
                            });
                        }
                    };
                    this.mMsCompat.setPlaybackToRemote(this.mVpCompat);
                }
            }

            public void clearVolumeHandling() {
                this.mMsCompat.setPlaybackToLocal(((GlobalMediaRouter)GlobalMediaRouter.this).mPlaybackInfo.playbackStream);
                this.mVpCompat = null;
            }

            public MediaSessionCompat.Token getToken() {
                return this.mMsCompat.getSessionToken();
            }
        }

        private final class ProviderCallback
        extends MediaRouteProvider.Callback {
            private ProviderCallback() {
            }

            @Override
            public void onDescriptorChanged(MediaRouteProvider provider, MediaRouteProviderDescriptor descriptor) {
                GlobalMediaRouter.this.updateProviderDescriptor(provider, descriptor);
            }
        }
    }

    private static final class CallbackRecord {
        public final MediaRouter mRouter;
        public final Callback mCallback;
        public MediaRouteSelector mSelector;
        public int mFlags;

        public CallbackRecord(MediaRouter router, Callback callback) {
            this.mRouter = router;
            this.mCallback = callback;
            this.mSelector = MediaRouteSelector.EMPTY;
        }

        public boolean filterRouteEvent(RouteInfo route) {
            return (this.mFlags & 2) != 0 || route.matchesSelector(this.mSelector);
        }
    }

    public static abstract class ControlRequestCallback {
        public void onResult(Bundle data) {
        }

        public void onError(String error, Bundle data) {
        }
    }

    public static abstract class Callback {
        public void onRouteSelected(MediaRouter router, RouteInfo route) {
        }

        public void onRouteUnselected(MediaRouter router, RouteInfo route) {
        }

        public void onRouteAdded(MediaRouter router, RouteInfo route) {
        }

        public void onRouteRemoved(MediaRouter router, RouteInfo route) {
        }

        public void onRouteChanged(MediaRouter router, RouteInfo route) {
        }

        public void onRouteVolumeChanged(MediaRouter router, RouteInfo route) {
        }

        public void onRoutePresentationDisplayChanged(MediaRouter router, RouteInfo route) {
        }

        public void onProviderAdded(MediaRouter router, ProviderInfo provider) {
        }

        public void onProviderRemoved(MediaRouter router, ProviderInfo provider) {
        }

        public void onProviderChanged(MediaRouter router, ProviderInfo provider) {
        }
    }

    public static final class ProviderInfo {
        private final MediaRouteProvider mProviderInstance;
        private final ArrayList<RouteInfo> mRoutes = new ArrayList();
        private final MediaRouteProvider.ProviderMetadata mMetadata;
        private MediaRouteProviderDescriptor mDescriptor;
        private Resources mResources;
        private boolean mResourcesNotAvailable;

        ProviderInfo(MediaRouteProvider provider) {
            this.mProviderInstance = provider;
            this.mMetadata = provider.getMetadata();
        }

        public MediaRouteProvider getProviderInstance() {
            MediaRouter.checkCallingThread();
            return this.mProviderInstance;
        }

        public String getPackageName() {
            return this.mMetadata.getPackageName();
        }

        public ComponentName getComponentName() {
            return this.mMetadata.getComponentName();
        }

        public List<RouteInfo> getRoutes() {
            MediaRouter.checkCallingThread();
            return this.mRoutes;
        }

        Resources getResources() {
            if (this.mResources == null && !this.mResourcesNotAvailable) {
                String packageName = this.getPackageName();
                Context context = sGlobal.getProviderContext(packageName);
                if (context != null) {
                    this.mResources = context.getResources();
                } else {
                    Log.w((String)MediaRouter.TAG, (String)("Unable to obtain resources for route provider package: " + packageName));
                    this.mResourcesNotAvailable = true;
                }
            }
            return this.mResources;
        }

        boolean updateDescriptor(MediaRouteProviderDescriptor descriptor) {
            if (this.mDescriptor != descriptor) {
                this.mDescriptor = descriptor;
                return true;
            }
            return false;
        }

        int findRouteByDescriptorId(String id2) {
            int count = this.mRoutes.size();
            for (int i = 0; i < count; ++i) {
                if (!this.mRoutes.get(i).mDescriptorId.equals(id2)) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            return "MediaRouter.RouteProviderInfo{ packageName=" + this.getPackageName() + " }";
        }
    }

    public static final class RouteInfo {
        private final ProviderInfo mProvider;
        private final String mDescriptorId;
        private final String mUniqueId;
        private String mName;
        private String mDescription;
        private boolean mEnabled;
        private boolean mConnecting;
        private boolean mCanDisconnect;
        private final ArrayList<IntentFilter> mControlFilters = new ArrayList();
        private int mPlaybackType;
        private int mPlaybackStream;
        private int mVolumeHandling;
        private int mVolume;
        private int mVolumeMax;
        private Display mPresentationDisplay;
        private int mPresentationDisplayId = -1;
        private Bundle mExtras;
        private IntentSender mSettingsIntent;
        private MediaRouteDescriptor mDescriptor;
        public static final int PLAYBACK_TYPE_LOCAL = 0;
        public static final int PLAYBACK_TYPE_REMOTE = 1;
        public static final int PLAYBACK_VOLUME_FIXED = 0;
        public static final int PLAYBACK_VOLUME_VARIABLE = 1;
        static final int CHANGE_GENERAL = 1;
        static final int CHANGE_VOLUME = 2;
        static final int CHANGE_PRESENTATION_DISPLAY = 4;

        RouteInfo(ProviderInfo provider, String descriptorId, String uniqueId) {
            this.mProvider = provider;
            this.mDescriptorId = descriptorId;
            this.mUniqueId = uniqueId;
        }

        public ProviderInfo getProvider() {
            return this.mProvider;
        }

        @NonNull
        public String getId() {
            return this.mUniqueId;
        }

        public String getName() {
            return this.mName;
        }

        @Nullable
        public String getDescription() {
            return this.mDescription;
        }

        public boolean isEnabled() {
            return this.mEnabled;
        }

        public boolean isConnecting() {
            return this.mConnecting;
        }

        public boolean isSelected() {
            MediaRouter.checkCallingThread();
            return sGlobal.getSelectedRoute() == this;
        }

        public boolean isDefault() {
            MediaRouter.checkCallingThread();
            return sGlobal.getDefaultRoute() == this;
        }

        public List<IntentFilter> getControlFilters() {
            return this.mControlFilters;
        }

        public boolean matchesSelector(@NonNull MediaRouteSelector selector) {
            if (selector == null) {
                throw new IllegalArgumentException("selector must not be null");
            }
            MediaRouter.checkCallingThread();
            return selector.matchesControlFilters(this.mControlFilters);
        }

        public boolean supportsControlCategory(@NonNull String category) {
            if (category == null) {
                throw new IllegalArgumentException("category must not be null");
            }
            MediaRouter.checkCallingThread();
            int count = this.mControlFilters.size();
            for (int i = 0; i < count; ++i) {
                if (!this.mControlFilters.get(i).hasCategory(category)) continue;
                return true;
            }
            return false;
        }

        public boolean supportsControlAction(@NonNull String category, @NonNull String action) {
            if (category == null) {
                throw new IllegalArgumentException("category must not be null");
            }
            if (action == null) {
                throw new IllegalArgumentException("action must not be null");
            }
            MediaRouter.checkCallingThread();
            int count = this.mControlFilters.size();
            for (int i = 0; i < count; ++i) {
                IntentFilter filter = this.mControlFilters.get(i);
                if (!filter.hasCategory(category) || !filter.hasAction(action)) continue;
                return true;
            }
            return false;
        }

        public boolean supportsControlRequest(@NonNull Intent intent) {
            if (intent == null) {
                throw new IllegalArgumentException("intent must not be null");
            }
            MediaRouter.checkCallingThread();
            ContentResolver contentResolver = sGlobal.getContentResolver();
            int count = this.mControlFilters.size();
            for (int i = 0; i < count; ++i) {
                if (this.mControlFilters.get(i).match(contentResolver, intent, true, MediaRouter.TAG) < 0) continue;
                return true;
            }
            return false;
        }

        public void sendControlRequest(@NonNull Intent intent, @Nullable ControlRequestCallback callback) {
            if (intent == null) {
                throw new IllegalArgumentException("intent must not be null");
            }
            MediaRouter.checkCallingThread();
            sGlobal.sendControlRequest(this, intent, callback);
        }

        public int getPlaybackType() {
            return this.mPlaybackType;
        }

        public int getPlaybackStream() {
            return this.mPlaybackStream;
        }

        public int getVolumeHandling() {
            return this.mVolumeHandling;
        }

        public int getVolume() {
            return this.mVolume;
        }

        public int getVolumeMax() {
            return this.mVolumeMax;
        }

        public boolean canDisconnect() {
            return this.mCanDisconnect;
        }

        public void requestSetVolume(int volume) {
            MediaRouter.checkCallingThread();
            sGlobal.requestSetVolume(this, Math.min(this.mVolumeMax, Math.max(0, volume)));
        }

        public void requestUpdateVolume(int delta) {
            MediaRouter.checkCallingThread();
            if (delta != 0) {
                sGlobal.requestUpdateVolume(this, delta);
            }
        }

        @Nullable
        public Display getPresentationDisplay() {
            MediaRouter.checkCallingThread();
            if (this.mPresentationDisplayId >= 0 && this.mPresentationDisplay == null) {
                this.mPresentationDisplay = sGlobal.getDisplay(this.mPresentationDisplayId);
            }
            return this.mPresentationDisplay;
        }

        @Nullable
        public Bundle getExtras() {
            return this.mExtras;
        }

        @Nullable
        public IntentSender getSettingsIntent() {
            return this.mSettingsIntent;
        }

        public void select() {
            MediaRouter.checkCallingThread();
            sGlobal.selectRoute(this);
        }

        public String toString() {
            return "MediaRouter.RouteInfo{ uniqueId=" + this.mUniqueId + ", name=" + this.mName + ", description=" + this.mDescription + ", enabled=" + this.mEnabled + ", connecting=" + this.mConnecting + ", canDisconnect=" + this.mCanDisconnect + ", playbackType=" + this.mPlaybackType + ", playbackStream=" + this.mPlaybackStream + ", volumeHandling=" + this.mVolumeHandling + ", volume=" + this.mVolume + ", volumeMax=" + this.mVolumeMax + ", presentationDisplayId=" + this.mPresentationDisplayId + ", extras=" + this.mExtras + ", settingsIntent=" + this.mSettingsIntent + ", providerPackageName=" + this.mProvider.getPackageName() + " }";
        }

        int updateDescriptor(MediaRouteDescriptor descriptor) {
            int changes = 0;
            if (this.mDescriptor != descriptor) {
                this.mDescriptor = descriptor;
                if (descriptor != null) {
                    if (!MediaRouter.equal(this.mName, descriptor.getName())) {
                        this.mName = descriptor.getName();
                        changes |= 1;
                    }
                    if (!MediaRouter.equal(this.mDescription, descriptor.getDescription())) {
                        this.mDescription = descriptor.getDescription();
                        changes |= 1;
                    }
                    if (this.mEnabled != descriptor.isEnabled()) {
                        this.mEnabled = descriptor.isEnabled();
                        changes |= 1;
                    }
                    if (this.mConnecting != descriptor.isConnecting()) {
                        this.mConnecting = descriptor.isConnecting();
                        changes |= 1;
                    }
                    if (!this.mControlFilters.equals(descriptor.getControlFilters())) {
                        this.mControlFilters.clear();
                        this.mControlFilters.addAll(descriptor.getControlFilters());
                        changes |= 1;
                    }
                    if (this.mPlaybackType != descriptor.getPlaybackType()) {
                        this.mPlaybackType = descriptor.getPlaybackType();
                        changes |= 1;
                    }
                    if (this.mPlaybackStream != descriptor.getPlaybackStream()) {
                        this.mPlaybackStream = descriptor.getPlaybackStream();
                        changes |= 1;
                    }
                    if (this.mVolumeHandling != descriptor.getVolumeHandling()) {
                        this.mVolumeHandling = descriptor.getVolumeHandling();
                        changes |= 3;
                    }
                    if (this.mVolume != descriptor.getVolume()) {
                        this.mVolume = descriptor.getVolume();
                        changes |= 3;
                    }
                    if (this.mVolumeMax != descriptor.getVolumeMax()) {
                        this.mVolumeMax = descriptor.getVolumeMax();
                        changes |= 3;
                    }
                    if (this.mPresentationDisplayId != descriptor.getPresentationDisplayId()) {
                        this.mPresentationDisplayId = descriptor.getPresentationDisplayId();
                        this.mPresentationDisplay = null;
                        changes |= 5;
                    }
                    if (!MediaRouter.equal(this.mExtras, descriptor.getExtras())) {
                        this.mExtras = descriptor.getExtras();
                        changes |= 1;
                    }
                    if (!MediaRouter.equal(this.mSettingsIntent, descriptor.getSettingsActivity())) {
                        this.mSettingsIntent = descriptor.getSettingsActivity();
                        changes |= 1;
                    }
                    if (this.mCanDisconnect != descriptor.canDisconnectAndKeepPlaying()) {
                        this.mCanDisconnect = descriptor.canDisconnectAndKeepPlaying();
                        changes |= 5;
                    }
                }
            }
            return changes;
        }

        String getDescriptorId() {
            return this.mDescriptorId;
        }

        MediaRouteProvider getProviderInstance() {
            return this.mProvider.getProviderInstance();
        }
    }
}

