/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatTextHelper;
import android.support.v7.widget.TintInfo;
import android.support.v7.widget.TintManager;
import android.util.AttributeSet;
import android.widget.TextView;

class AppCompatTextHelperV17
extends AppCompatTextHelper {
    private static final int[] VIEW_ATTRS_v17 = new int[]{16843666, 16843667};
    private TintInfo mDrawableStartTint;
    private TintInfo mDrawableEndTint;

    AppCompatTextHelperV17(TextView view) {
        super(view);
    }

    @Override
    void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        super.loadFromAttributes(attrs, defStyleAttr);
        Context context = this.mView.getContext();
        TintManager tintManager = TintManager.get(context);
        TypedArray a = context.obtainStyledAttributes(attrs, VIEW_ATTRS_v17, defStyleAttr, 0);
        if (a.hasValue(0)) {
            this.mDrawableStartTint = AppCompatTextHelperV17.createTintInfo(context, tintManager, a.getResourceId(0, 0));
        }
        if (a.hasValue(1)) {
            this.mDrawableEndTint = AppCompatTextHelperV17.createTintInfo(context, tintManager, a.getResourceId(1, 0));
        }
        a.recycle();
    }

    @Override
    void applyCompoundDrawablesTints() {
        super.applyCompoundDrawablesTints();
        if (this.mDrawableStartTint != null || this.mDrawableEndTint != null) {
            Drawable[] compoundDrawables = this.mView.getCompoundDrawablesRelative();
            this.applyCompoundDrawableTint(compoundDrawables[0], this.mDrawableStartTint);
            this.applyCompoundDrawableTint(compoundDrawables[2], this.mDrawableEndTint);
        }
    }
}

