/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzqb;
import com.google.android.gms.internal.zzsn;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.BitSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class zzaj
extends zzy {
    zzaj(zzw zzw2) {
        super(zzw2);
    }

    static boolean zzfq(String string2) {
        zzx.zzcM((String)string2);
        return string2.charAt(0) != '_';
    }

    void zzc(String string2, int n, String string3) {
        if (string3 == null) {
            throw new IllegalArgumentException(string2 + " name is required and can't be null");
        }
        if (string3.length() == 0) {
            throw new IllegalArgumentException(string2 + " name is required and can't be empty");
        }
        char c = string3.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            throw new IllegalArgumentException(string2 + " name must start with a letter or _");
        }
        for (int i = 1; i < string3.length(); ++i) {
            char c2 = string3.charAt(i);
            if (c2 == '_' || Character.isLetterOrDigit(c2)) continue;
            throw new IllegalArgumentException(string2 + " name must consist of letters, digits or _ (underscores)");
        }
        if (string3.length() > n) {
            throw new IllegalArgumentException(string2 + " name is too long. The maximum supported length is " + n);
        }
    }

    public void zzfr(String string2) {
        this.zzc("event", this.zzCp().zzBB(), string2);
    }

    public void zzfs(String string2) {
        this.zzc("user attribute", this.zzCp().zzBC(), string2);
    }

    public void zzft(String string2) {
        this.zzc("event param", this.zzCp().zzBC(), string2);
    }

    private void zza(String string2, String string3, int n, Object object) {
        if (object == null) {
            this.zzAo().zzCH().zzj(string2 + " value can't be null. Ignoring " + string2, string3);
            return;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string4 = String.valueOf(object);
            if (string4.length() > n) {
                this.zzAo().zzCH().zze("Ignoring " + string2 + ". Value is too long. name, value length", string3, string4.length());
            }
            return;
        }
    }

    private Object zza(int n, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Float) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Double) {
            return Float.valueOf((float)((Double)object).doubleValue());
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string2 = String.valueOf(object);
            if (string2.length() > n) {
                if (bl) {
                    return string2.substring(0, n);
                }
                return null;
            }
            return string2;
        }
        return null;
    }

    public Object zzk(String string2, Object object) {
        return this.zza(zzaj.zzfv(string2) ? this.zzCp().zzBE() : this.zzCp().zzBD(), object, false);
    }

    private int zzfu(String string2) {
        if ("_ldl".equals(string2)) {
            return this.zzCp().zzBG();
        }
        return this.zzCp().zzBF();
    }

    public void zzl(String string2, Object object) {
        if ("_ldl".equals(string2)) {
            this.zza("user attribute referrer", string2, this.zzfu(string2), object);
        } else {
            this.zza("user attribute", string2, this.zzfu(string2), object);
        }
    }

    public Object zzm(String string2, Object object) {
        if ("_ldl".equals(string2)) {
            return this.zza(this.zzfu(string2), object, true);
        }
        return this.zza(this.zzfu(string2), object, false);
    }

    public void zza(zzqb.zzg zzg2, Object object) {
        zzx.zzz((Object)object);
        zzg2.zzamJ = null;
        zzg2.zzbai = null;
        zzg2.zzaZo = null;
        if (object instanceof String) {
            zzg2.zzamJ = (String)object;
        } else if (object instanceof Long) {
            zzg2.zzbai = (Long)object;
        } else if (object instanceof Float) {
            zzg2.zzaZo = (Float)object;
        } else {
            this.zzAo().zzCE().zzj("Ignoring invalid (type) user attribute value", object);
        }
    }

    public void zza(zzqb.zzc zzc2, Object object) {
        zzx.zzz((Object)object);
        zzc2.zzamJ = null;
        zzc2.zzbai = null;
        zzc2.zzaZo = null;
        if (object instanceof String) {
            zzc2.zzamJ = (String)object;
        } else if (object instanceof Long) {
            zzc2.zzbai = (Long)object;
        } else if (object instanceof Float) {
            zzc2.zzaZo = (Float)object;
        } else {
            this.zzAo().zzCE().zzj("Ignoring invalid (type) event param value", object);
        }
    }

    public void zza(Bundle bundle, String string2, Object object) {
        if (object instanceof Long) {
            bundle.putLong(string2, ((Long)object).longValue());
            return;
        }
        if (object instanceof Float) {
            bundle.putFloat(string2, ((Float)object).floatValue());
            return;
        }
        if (object instanceof String) {
            String string3 = String.valueOf(object);
            bundle.putString(string2, string3);
            return;
        }
        if (string2 != null) {
            this.zzAo().zzCH().zze("Not putting event parameter. Invalid value type. name, type", string2, object.getClass().getSimpleName());
        }
    }

    public byte[] zzg(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzAo().zzCE().zzj("Failed to gzip content", iOException);
            throw iOException;
        }
    }

    public byte[] zzp(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzAo().zzCE().zzj("Failed to ungzip content", iOException);
            throw iOException;
        }
    }

    static MessageDigest zzbv(String string2) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string2);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    static long zzq(byte[] byArray) {
        zzx.zzz((Object)byArray);
        zzx.zzab((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    public long zzr(byte[] byArray) {
        zzx.zzz((Object)byArray);
        MessageDigest messageDigest = zzaj.zzbv("MD5");
        if (messageDigest == null) {
            this.zzAo().zzCE().zzfg("Failed to get MD5");
            return 0L;
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        return zzaj.zzq(byArray2);
    }

    public byte[] zza(zzqb.zzd zzd2) {
        try {
            int n = zzd2.getSerializedSize();
            byte[] byArray = new byte[n];
            zzsn zzsn2 = zzsn.zzE((byte[])byArray);
            zzd2.writeTo(zzsn2);
            zzsn2.zzJo();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzAo().zzCE().zzj("Data loss. Failed to serialize batch", iOException);
            return null;
        }
    }

    public boolean zzc(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(this.zzjl().currentTimeMillis() - l) > l2;
    }

    public static boolean zza(Context context, Class<? extends BroadcastReceiver> clazz, boolean bl) {
        try {
            ActivityInfo activityInfo = context.getPackageManager().getReceiverInfo(new ComponentName(context, clazz), 2);
            if (activityInfo != null && activityInfo.enabled && (!bl || activityInfo.exported)) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean zza(Context context, Class<? extends Service> clazz) {
        try {
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(new ComponentName(context, clazz), 4);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    @WorkerThread
    public boolean zzbk(String string2) {
        this.zzjk();
        int n = this.getContext().checkCallingOrSelfPermission(string2);
        if (n == 0) {
            return true;
        }
        this.zzAo().zzCJ().zzj("Permission not granted", string2);
        return false;
    }

    public static boolean zzfv(String string2) {
        return !TextUtils.isEmpty((CharSequence)string2) && string2.startsWith("_");
    }

    public static boolean zzQ(String string2, String string3) {
        if (string2 == null && string3 == null) {
            return true;
        }
        if (string2 == null) {
            return false;
        }
        return string2.equals(string3);
    }

    public static boolean zzI(Bundle bundle) {
        long l = bundle.getLong("_c");
        return l == 1L;
    }

    public static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && 64 * i + j < bitSet.length(); ++j) {
                if (!bitSet.get(64 * i + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    public static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length * 64) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string2, Object object) {
        if (object == null) {
            return;
        }
        zzaj.zza(stringBuilder, n + 1);
        stringBuilder.append(string2);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    private static void zza(StringBuilder stringBuilder, int n, zzqb.zze zze2) {
        if (zze2 == null) {
            return;
        }
        zzaj.zza(stringBuilder, n);
        stringBuilder.append("bundle {\n");
        zzaj.zza(stringBuilder, n, "protocol_version", zze2.zzbal);
        zzaj.zza(stringBuilder, n, "platform", zze2.zzbat);
        zzaj.zza(stringBuilder, n, "gmp_version", zze2.zzbax);
        zzaj.zza(stringBuilder, n, "uploading_gmp_version", zze2.zzbay);
        zzaj.zza(stringBuilder, n, "gmp_app_id", zze2.zzaVt);
        zzaj.zza(stringBuilder, n, "app_id", zze2.appId);
        zzaj.zza(stringBuilder, n, "app_version", zze2.zzaMV);
        zzaj.zza(stringBuilder, n, "dev_cert_hash", zze2.zzbaC);
        zzaj.zza(stringBuilder, n, "app_store", zze2.zzaVu);
        zzaj.zza(stringBuilder, n, "upload_timestamp_millis", zze2.zzbao);
        zzaj.zza(stringBuilder, n, "start_timestamp_millis", zze2.zzbap);
        zzaj.zza(stringBuilder, n, "end_timestamp_millis", zze2.zzbaq);
        zzaj.zza(stringBuilder, n, "previous_bundle_start_timestamp_millis", zze2.zzbar);
        zzaj.zza(stringBuilder, n, "previous_bundle_end_timestamp_millis", zze2.zzbas);
        zzaj.zza(stringBuilder, n, "app_instance_id", zze2.zzbaB);
        zzaj.zza(stringBuilder, n, "resettable_device_id", zze2.zzbaz);
        zzaj.zza(stringBuilder, n, "limited_ad_tracking", zze2.zzbaA);
        zzaj.zza(stringBuilder, n, "os_version", zze2.osVersion);
        zzaj.zza(stringBuilder, n, "device_model", zze2.zzbau);
        zzaj.zza(stringBuilder, n, "user_default_language", zze2.zzbav);
        zzaj.zza(stringBuilder, n, "time_zone_offset_minutes", zze2.zzbaw);
        zzaj.zza(stringBuilder, n, "bundle_sequential_index", zze2.zzbaD);
        zzaj.zza(stringBuilder, n, "service_upload", zze2.zzbaE);
        zzaj.zza(stringBuilder, n, "health_monitor", zze2.zzaVx);
        zzaj.zza(stringBuilder, n, zze2.zzban);
        zzaj.zza(stringBuilder, n, zze2.zzbaF);
        zzaj.zza(stringBuilder, n, zze2.zzbam);
        zzaj.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, zzqb.zzg[] zzgArray) {
        if (zzgArray == null) {
            return;
        }
        ++n;
        for (zzqb.zzg zzg2 : zzgArray) {
            if (zzg2 == null) continue;
            zzaj.zza(stringBuilder, n);
            stringBuilder.append("user_property {\n");
            zzaj.zza(stringBuilder, n, "set_timestamp_millis", zzg2.zzbaJ);
            zzaj.zza(stringBuilder, n, "name", zzg2.name);
            zzaj.zza(stringBuilder, n, "string_value", zzg2.zzamJ);
            zzaj.zza(stringBuilder, n, "int_value", zzg2.zzbai);
            zzaj.zza(stringBuilder, n, "float_value", zzg2.zzaZo);
            zzaj.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzqb.zzc[] zzcArray) {
        if (zzcArray == null) {
            return;
        }
        ++n;
        for (zzqb.zzc zzc2 : zzcArray) {
            if (zzc2 == null) continue;
            zzaj.zza(stringBuilder, n);
            stringBuilder.append("event {\n");
            zzaj.zza(stringBuilder, n, "name", zzc2.name);
            zzaj.zza(stringBuilder, n, "string_value", zzc2.zzamJ);
            zzaj.zza(stringBuilder, n, "int_value", zzc2.zzbai);
            zzaj.zza(stringBuilder, n, "float_value", zzc2.zzaZo);
            zzaj.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzqb.zzb[] zzbArray) {
        if (zzbArray == null) {
            return;
        }
        ++n;
        for (zzqb.zzb zzb2 : zzbArray) {
            if (zzb2 == null) continue;
            zzaj.zza(stringBuilder, n);
            stringBuilder.append("event {\n");
            zzaj.zza(stringBuilder, n, "name", zzb2.name);
            zzaj.zza(stringBuilder, n, "timestamp_millis", zzb2.zzbaf);
            zzaj.zza(stringBuilder, n, "previous_timestamp_millis", zzb2.zzbag);
            zzaj.zza(stringBuilder, n, "count", zzb2.count);
            zzaj.zza(stringBuilder, n, zzb2.zzbae);
            zzaj.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzqb.zza[] zzaArray) {
        if (zzaArray == null) {
            return;
        }
        ++n;
        for (zzqb.zza zza2 : zzaArray) {
            if (zza2 == null) continue;
            zzaj.zza(stringBuilder, n);
            stringBuilder.append("audience_membership {\n");
            zzaj.zza(stringBuilder, n, "audience_id", zza2.zzaZr);
            zzaj.zza(stringBuilder, n, "new_audience", zza2.zzbac);
            zzaj.zza(stringBuilder, n, "current_data", zza2.zzbaa);
            zzaj.zza(stringBuilder, n, "previous_data", zza2.zzbab);
            zzaj.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string2, zzqb.zzf zzf2) {
        Long l;
        int n2;
        int n3;
        long[] lArray;
        int n4;
        if (zzf2 == null) {
            return;
        }
        zzaj.zza(stringBuilder, ++n);
        stringBuilder.append(string2);
        stringBuilder.append(" {\n");
        if (zzf2.zzbaH != null) {
            zzaj.zza(stringBuilder, n + 1);
            stringBuilder.append("results: ");
            n4 = 0;
            lArray = zzf2.zzbaH;
            n3 = lArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzf2.zzbaG != null) {
            zzaj.zza(stringBuilder, n + 1);
            stringBuilder.append("status: ");
            n4 = 0;
            lArray = zzf2.zzbaG;
            n3 = lArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        zzaj.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    public static String zzb(zzqb.zzd zzd2) {
        if (zzd2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzd2.zzbaj != null) {
            for (zzqb.zze zze2 : zzd2.zzbaj) {
                if (zze2 == null) continue;
                zzaj.zza(stringBuilder, 1, zze2);
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }
}

