/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzpz;
import com.google.android.gms.internal.zzqb;
import com.google.android.gms.internal.zzsm;
import com.google.android.gms.internal.zzsn;
import com.google.android.gms.internal.zzsu;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class zze
extends zzz {
    private static final Map<String, String> zzaVB = new ArrayMap(13);
    private final zzc zzaVC;
    private final zzaf zzaVD = new zzaf(this.zzjl());

    zze(zzw zzw2) {
        super(zzw2);
        String string2 = this.zzjQ();
        this.zzaVC = new zzc(this.getContext(), string2);
    }

    @Override
    protected void zziJ() {
    }

    @WorkerThread
    public void beginTransaction() {
        this.zzjv();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public void setTransactionSuccessful() {
        this.zzjv();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public void endTransaction() {
        this.zzjv();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private long zzb(String string2, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string2, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzAo().zzCE().zze("Database error", string2, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private long zza(String string2, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string2, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            long l3 = l;
            return l3;
        }
    }

    @WorkerThread
    SQLiteDatabase getWritableDatabase() {
        this.zzjk();
        try {
            return this.zzaVC.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCF().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    private String zzjQ() {
        if (!this.zzCp().zzkr()) {
            return this.zzCp().zzkR();
        }
        if (this.zzCp().zzks()) {
            return this.zzCp().zzkR();
        }
        this.zzAo().zzCG().zzfg("Using secondary database");
        return this.zzCp().zzkS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzi zzI(String string2, String string3) {
        zzx.zzcM((String)string2);
        zzx.zzcM((String)string3);
        this.zzjk();
        this.zzjv();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string2, string3}, null, null, null);
            if (!cursor.moveToFirst()) {
                zzi zzi2 = null;
                return zzi2;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzi zzi3 = new zzi(string2, string3, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzAo().zzCE().zzfg("Got multiple records for event aggregates, expected one");
            }
            zzi zzi4 = zzi3;
            return zzi4;
        }
    }

    @WorkerThread
    public void zza(zzi zzi2) {
        zzx.zzz((Object)zzi2);
        this.zzjk();
        this.zzjv();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzi2.zzaUa);
        contentValues.put("name", zzi2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzi2.zzaVP));
        contentValues.put("current_bundle_count", Long.valueOf(zzi2.zzaVQ));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzi2.zzaVR));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("events", null, contentValues, 5);
            if (l == -1L) {
                this.zzAo().zzCE().zzfg("Failed to insert/update event aggregates (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzj("Error storing event aggregates", (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzJ(String string2, String string3) {
        zzx.zzcM((String)string2);
        zzx.zzcM((String)string3);
        this.zzjk();
        this.zzjv();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = sQLiteDatabase.delete("user_attributes", "app_id=? and name=?", new String[]{string2, string3});
            this.zzAo().zzCK().zzj("Deleted user attribute rows:", n);
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzd("Error deleting user attribute", string2, string3, (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzA(String string2, int n) {
        zzx.zzcM((String)string2);
        this.zzjk();
        this.zzjv();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string2, string2, String.valueOf(n)});
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zze("Error pruning currencies", string2, (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public boolean zza(zzai zzai2) {
        long l;
        zzx.zzz((Object)zzai2);
        this.zzjk();
        this.zzjv();
        zzai zzai3 = this.zzK(zzai2.zzaUa, zzai2.mName);
        if (zzai3 == null && (zzaj.zzfq(zzai2.mName) ? (l = this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzai2.zzaUa})) >= (long)this.zzCp().zzBL() : (l = this.zzb("select count(1) from user_attributes where app_id=?", new String[]{zzai2.zzaUa})) >= (long)this.zzCp().zzBM())) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzai2.zzaUa);
        contentValues.put("name", zzai2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzai2.zzaZp));
        this.zza(contentValues, "value", zzai2.zzNc);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l2 = sQLiteDatabase.insertWithOnConflict("user_attributes", null, contentValues, 5);
            if (l2 == -1L) {
                this.zzAo().zzCE().zzfg("Failed to insert/update user property (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzj("Error storing user property", (Object)sQLiteException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzai zzK(String string2, String string3) {
        zzx.zzcM((String)string2);
        zzx.zzcM((String)string3);
        this.zzjk();
        this.zzjv();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"set_timestamp", "value"}, "app_id=? and name=?", new String[]{string2, string3}, null, null, null);
            if (!cursor.moveToFirst()) {
                zzai zzai2 = null;
                return zzai2;
            }
            long l = cursor.getLong(0);
            Object object = this.zzb(cursor, 1);
            zzai zzai3 = new zzai(string2, string3, l, object);
            if (cursor.moveToNext()) {
                this.zzAo().zzCE().zzfg("Got multiple records for user property, expected one");
            }
            zzai zzai4 = zzai3;
            return zzai4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<zzai> zzeX(String string2) {
        zzx.zzcM((String)string2);
        this.zzjk();
        this.zzjv();
        ArrayList<zzai> arrayList = new ArrayList<zzai>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"name", "set_timestamp", "value"}, "app_id=?", new String[]{string2}, null, null, "rowid", String.valueOf(this.zzCp().zzBM()));
            if (!cursor.moveToFirst()) {
                ArrayList<zzai> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zzb(cursor, 2);
                if (object2 == null) {
                    this.zzAo().zzCE().zzfg("Read invalid user property value, ignoring it");
                    continue;
                }
                zzai zzai2 = new zzai(string2, (String)object, l, object2);
                arrayList.add(zzai2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public com.google.android.gms.measurement.internal.zza zzeY(String string2) {
        zzx.zzcM((String)string2);
        this.zzjk();
        this.zzjv();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time"}, "app_id=?", new String[]{string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                com.google.android.gms.measurement.internal.zza zza2 = null;
                return zza2;
            }
            com.google.android.gms.measurement.internal.zza zza3 = new com.google.android.gms.measurement.internal.zza(this.zzaTV, string2);
            zza3.zzeM(cursor.getString(0));
            zza3.zzeN(cursor.getString(1));
            zza3.zzeO(cursor.getString(2));
            zza3.zzS(cursor.getLong(3));
            zza3.zzO(cursor.getLong(4));
            zza3.zzP(cursor.getLong(5));
            zza3.setAppVersion(cursor.getString(6));
            zza3.zzeP(cursor.getString(7));
            zza3.zzQ(cursor.getLong(8));
            zza3.zzR(cursor.getLong(9));
            zza3.setMeasurementEnabled((cursor.isNull(10) ? 1 : cursor.getInt(10)) != 0);
            zza3.zzV(cursor.getLong(11));
            zza3.zzW(cursor.getLong(12));
            zza3.zzX(cursor.getLong(13));
            zza3.zzY(cursor.getLong(14));
            zza3.zzT(cursor.getLong(15));
            zza3.zzU(cursor.getLong(16));
            zza3.zzBi();
            if (cursor.moveToNext()) {
                this.zzAo().zzCE().zzfg("Got multiple records for app, expected one");
            }
            com.google.android.gms.measurement.internal.zza zza4 = zza3;
            return zza4;
        }
    }

    @WorkerThread
    public void zza(com.google.android.gms.measurement.internal.zza zza2) {
        zzx.zzz((Object)zza2);
        this.zzjk();
        this.zzjv();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zza2.zzwK());
        contentValues.put("app_instance_id", zza2.zzBj());
        contentValues.put("gmp_app_id", zza2.zzBk());
        contentValues.put("resettable_device_id_hash", zza2.zzBl());
        contentValues.put("last_bundle_index", Long.valueOf(zza2.zzBr()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zza2.zzBm()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zza2.zzBn()));
        contentValues.put("app_version", zza2.zzli());
        contentValues.put("app_store", zza2.zzBo());
        contentValues.put("gmp_version", Long.valueOf(zza2.zzBp()));
        contentValues.put("dev_cert_hash", Long.valueOf(zza2.zzBq()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zza2.zzAr()));
        contentValues.put("day", Long.valueOf(zza2.zzBv()));
        contentValues.put("daily_public_events_count", Long.valueOf(zza2.zzBw()));
        contentValues.put("daily_events_count", Long.valueOf(zza2.zzBx()));
        contentValues.put("daily_conversions_count", Long.valueOf(zza2.zzBy()));
        contentValues.put("config_fetched_time", Long.valueOf(zza2.zzBs()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zza2.zzBt()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5);
            if (l == -1L) {
                this.zzAo().zzCE().zzfg("Failed to insert/update app (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzj("Error storing app", (Object)sQLiteException);
        }
    }

    public long zzeZ(String string2) {
        zzx.zzcM((String)string2);
        this.zzjk();
        this.zzjv();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string3 = String.valueOf(this.zzCp().zzeW(string2));
            long l = sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string2, string3});
            return l;
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzj("Error deleting over the limit events", (Object)sQLiteException);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zza zza(long l, String string2, boolean bl, boolean bl2) {
        zzx.zzcM((String)string2);
        this.zzjk();
        this.zzjv();
        String[] stringArray = new String[]{string2};
        zza zza2 = new zza();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count"}, "app_id=?", new String[]{string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzAo().zzCF().zzj("Not updating daily counts, app is not known", string2);
                zza zza3 = zza2;
                return zza3;
            }
            long l2 = cursor.getLong(0);
            if (l2 == l) {
                zza2.zzaVF = cursor.getLong(1);
                zza2.zzaVE = cursor.getLong(2);
                zza2.zzaVG = cursor.getLong(3);
            }
            ++zza2.zzaVF;
            if (bl) {
                ++zza2.zzaVE;
            }
            if (bl2) {
                ++zza2.zzaVG;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zza2.zzaVE));
            contentValues.put("daily_events_count", Long.valueOf(zza2.zzaVF));
            contentValues.put("daily_conversions_count", Long.valueOf(zza2.zzaVG));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zza zza4 = zza2;
            return zza4;
        }
    }

    @WorkerThread
    public void zzd(String string2, byte[] byArray) {
        zzx.zzcM((String)string2);
        this.zzjk();
        this.zzjv();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{string2});
            if (l == 0L) {
                this.zzAo().zzCE().zzfg("Failed to update remote config (got 0)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzj("Error storing remote config", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zzfa(String string2) {
        zzx.zzcM((String)string2);
        this.zzjk();
        this.zzjv();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzAo().zzCE().zzfg("Got multiple records for app config, expected one");
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public void zza(zzqb.zze zze2) {
        byte[] byArray;
        Object object;
        this.zzjk();
        this.zzjv();
        zzx.zzz((Object)((Object)zze2));
        zzx.zzcM((String)zze2.appId);
        zzx.zzz((Object)zze2.zzbaq);
        this.zzCr();
        long l = this.zzjl().currentTimeMillis();
        if (zze2.zzbaq < l - this.zzCp().zzBQ() || zze2.zzbaq > l + this.zzCp().zzBQ()) {
            this.zzAo().zzCF().zze("Storing bundle outside of the max uploading time span. now, timestamp", l, zze2.zzbaq);
        }
        try {
            int n = zze2.getSerializedSize();
            object = new byte[n];
            zzsn zzsn2 = zzsn.zzE((byte[])object);
            zze2.writeTo(zzsn2);
            zzsn2.zzJo();
            byArray = this.zzCk().zzg((byte[])object);
        }
        catch (IOException iOException) {
            this.zzAo().zzCE().zzj("Data loss. Failed to serialize bundle", iOException);
            return;
        }
        this.zzAo().zzCK().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.appId);
        contentValues.put("bundle_end_timestamp", zze2.zzbaq);
        contentValues.put("data", byArray);
        try {
            object = this.getWritableDatabase();
            long l2 = object.insert("queue", null, contentValues);
            if (l2 == -1L) {
                this.zzAo().zzCE().zzfg("Failed to insert bundle (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzj("Error storing bundle", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public String zzCq() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string2 = "select app_id from queue where app_id not in (select app_id from apps where measurement_enabled=0) order by rowid limit 1;";
            cursor = sQLiteDatabase.rawQuery(string2, null);
            if (cursor.moveToFirst()) {
                String string3 = cursor.getString(0);
                return string3;
            }
            String string4 = null;
            return string4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<Pair<zzqb.zze, Long>> zzn(String string2, int n, int n2) {
        this.zzjk();
        this.zzjv();
        zzx.zzac((n > 0 ? 1 : 0) != 0);
        zzx.zzac((n2 > 0 ? 1 : 0) != 0);
        zzx.zzcM((String)string2);
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string2}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzqb.zze, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzqb.zze, Long>> arrayList = new ArrayList<Pair<zzqb.zze, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzCk().zzp((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzAo().zzCE().zze("Failed to unzip queued bundle", string2, iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                object = zzsm.zzD((byte[])byArray);
                zzqb.zze zze2 = new zzqb.zze();
                try {
                    zze2.zzG((zzsm)object);
                }
                catch (IOException iOException) {
                    this.zzAo().zzCE().zze("Failed to merge queued bundle", string2, iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzqb.zze, Long>)Pair.create((Object)((Object)zze2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzqb.zze, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    public void zzZ(long l) {
        this.zzjk();
        this.zzjv();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(l)};
        int n = sQLiteDatabase.delete("queue", "rowid=?", stringArray);
        if (n != 1) {
            this.zzAo().zzCE().zzfg("Deleted fewer rows from queue than expected");
        }
    }

    @WorkerThread
    void zzCr() {
        this.zzjk();
        this.zzjv();
        if (!this.zzCw()) {
            return;
        }
        long l = this.zzCo().zzaXm.get();
        long l2 = this.zzjl().elapsedRealtime();
        if (Math.abs(l2 - l) > this.zzCp().zzBR()) {
            this.zzCo().zzaXm.set(l2);
            this.zzCs();
        }
    }

    @WorkerThread
    void zzCs() {
        this.zzjk();
        this.zzjv();
        if (!this.zzCw()) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(this.zzjl().currentTimeMillis()), String.valueOf(this.zzCp().zzBQ())};
        int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
        if (n > 0) {
            this.zzAo().zzCK().zzj("Deleted stale rows. rowsDeleted", n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string2, zzpz.zza[] zzaArray) {
        this.zzjv();
        this.zzjk();
        zzx.zzcM((String)string2);
        zzx.zzz((Object)zzaArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            this.zzfb(string2);
            for (zzpz.zza zza2 : zzaArray) {
                this.zza(string2, zza2);
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    void zzfb(String string2) {
        this.zzjv();
        this.zzjk();
        zzx.zzcM((String)string2);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=?", new String[]{string2});
        sQLiteDatabase.delete("event_filters", "app_id=?", new String[]{string2});
    }

    void zzB(String string2, int n) {
        this.zzjv();
        this.zzjk();
        zzx.zzcM((String)string2);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=? and audience_id=?", new String[]{string2, String.valueOf(n)});
        sQLiteDatabase.delete("event_filters", "app_id=? and audience_id=?", new String[]{string2, String.valueOf(n)});
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private void zza(String string2, zzpz.zza zza2) {
        void var7_13;
        this.zzjv();
        this.zzjk();
        zzx.zzcM((String)string2);
        zzx.zzz((Object)((Object)zza2));
        zzx.zzz((Object)zza2.zzaZt);
        zzx.zzz((Object)zza2.zzaZs);
        if (zza2.zzaZr == null) {
            this.zzAo().zzCF().zzfg("Audience with no ID");
            return;
        }
        int n = zza2.zzaZr;
        for (zzpz.zzb zzb2 : zza2.zzaZt) {
            if (zzb2.zzaZv != null) continue;
            this.zzAo().zzCF().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", string2, zza2.zzaZr);
            return;
        }
        for (zzsu zzsu2 : zza2.zzaZs) {
            if (zzsu2.zzaZv != null) continue;
            this.zzAo().zzCF().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", string2, zza2.zzaZr);
            return;
        }
        boolean bl = true;
        zzsu[] zzsuArray = zza2.zzaZt;
        int n2 = zzsuArray.length;
        boolean bl2 = false;
        while (var7_13 < n2) {
            zzpz.zzb zzb2 = zzsuArray[var7_13];
            if (!this.zza(string2, n, zzb2)) {
                bl = false;
                break;
            }
            ++var7_13;
        }
        if (bl) {
            void var7_15;
            zzsuArray = zza2.zzaZs;
            n2 = zzsuArray.length;
            boolean bl3 = false;
            while (var7_15 < n2) {
                zzsu zzsu3 = zzsuArray[var7_15];
                if (!this.zza(string2, n, (zzpz.zze)zzsu3)) {
                    bl = false;
                    break;
                }
                ++var7_15;
            }
        }
        if (!bl) {
            this.zzB(string2, n);
        }
    }

    @WorkerThread
    private boolean zza(String string2, int n, zzpz.zzb zzb2) {
        zzsn zzsn2;
        byte[] byArray;
        this.zzjv();
        this.zzjk();
        zzx.zzcM((String)string2);
        zzx.zzz((Object)((Object)zzb2));
        if (TextUtils.isEmpty((CharSequence)zzb2.zzaZw)) {
            this.zzAo().zzCF().zze("Event filter had no event name. Audience definition ignored. audienceId, filterId", n, String.valueOf(zzb2.zzaZv));
            return false;
        }
        try {
            int n2 = zzb2.getSerializedSize();
            byArray = new byte[n2];
            zzsn2 = zzsn.zzE((byte[])byArray);
            zzb2.writeTo(zzsn2);
            zzsn2.zzJo();
        }
        catch (IOException iOException) {
            this.zzAo().zzCE().zzj("Configuration loss. Failed to serialize event filter", iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string2);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzb2.zzaZv);
        contentValues.put("event_name", zzb2.zzaZw);
        contentValues.put("data", byArray);
        try {
            zzsn2 = this.getWritableDatabase();
            long l = zzsn2.insertWithOnConflict("event_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzAo().zzCE().zzfg("Failed to insert event filter (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzj("Error storing event filter", (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private boolean zza(String string2, int n, zzpz.zze zze2) {
        zzsn zzsn2;
        byte[] byArray;
        this.zzjv();
        this.zzjk();
        zzx.zzcM((String)string2);
        zzx.zzz((Object)((Object)zze2));
        if (TextUtils.isEmpty((CharSequence)zze2.zzaZL)) {
            this.zzAo().zzCF().zze("Property filter had no property name. Audience definition ignored. audienceId, filterId", n, String.valueOf(zze2.zzaZv));
            return false;
        }
        try {
            int n2 = zze2.getSerializedSize();
            byArray = new byte[n2];
            zzsn2 = zzsn.zzE((byte[])byArray);
            zze2.writeTo(zzsn2);
            zzsn2.zzJo();
        }
        catch (IOException iOException) {
            this.zzAo().zzCE().zzj("Configuration loss. Failed to serialize property filter", iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string2);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zze2.zzaZv);
        contentValues.put("property_name", zze2.zzaZL);
        contentValues.put("data", byArray);
        try {
            zzsn2 = this.getWritableDatabase();
            long l = zzsn2.insertWithOnConflict("property_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzAo().zzCE().zzfg("Failed to insert property filter (got -1)");
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzj("Error storing property filter", (Object)sQLiteException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzpz.zzb>> zzL(String string2, String string3) {
        this.zzjv();
        this.zzjk();
        zzx.zzcM((String)string2);
        zzx.zzcM((String)string3);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string2, string3}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzpz.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzsm zzsm2 = zzsm.zzD((byte[])byArray);
                zzpz.zzb zzb2 = new zzpz.zzb();
                try {
                    zzb2.zzu(zzsm2);
                }
                catch (IOException iOException) {
                    this.zzAo().zzCE().zze("Failed to merge filter", string2, iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzpz.zzb> arrayList = (ArrayList<zzpz.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzpz.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzpz.zze>> zzM(String string2, String string3) {
        this.zzjv();
        this.zzjk();
        zzx.zzcM((String)string2);
        zzx.zzcM((String)string3);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string2, string3}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzpz.zze>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzsm zzsm2 = zzsm.zzD((byte[])byArray);
                zzpz.zze zze2 = new zzpz.zze();
                try {
                    zze2.zzx(zzsm2);
                }
                catch (IOException iOException) {
                    this.zzAo().zzCE().zze("Failed to merge filter", string2, iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzpz.zze> arrayList = (ArrayList<zzpz.zze>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzpz.zze>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zze2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    void zza(String string2, int n, zzqb.zzf zzf2) {
        zzsn zzsn2;
        byte[] byArray;
        this.zzjv();
        this.zzjk();
        zzx.zzcM((String)string2);
        zzx.zzz((Object)((Object)zzf2));
        try {
            int n2 = zzf2.getSerializedSize();
            byArray = new byte[n2];
            zzsn2 = zzsn.zzE((byte[])byArray);
            zzf2.writeTo(zzsn2);
            zzsn2.zzJo();
        }
        catch (IOException iOException) {
            this.zzAo().zzCE().zzj("Configuration loss. Failed to serialize filter results", iOException);
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string2);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("current_results", byArray);
        try {
            zzsn2 = this.getWritableDatabase();
            long l = zzsn2.insertWithOnConflict("audience_filter_values", null, contentValues, 5);
            if (l == -1L) {
                this.zzAo().zzCE().zzfg("Failed to insert filter results (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzj("Error storing filter results", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    zzqb.zzf zzC(String string2, int n) {
        this.zzjv();
        this.zzjk();
        zzx.zzcM((String)string2);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"current_results"}, "app_id=? AND audience_id=?", new String[]{string2, String.valueOf(n)}, null, null, null);
            if (!cursor.moveToFirst()) {
                zzqb.zzf zzf2 = null;
                return zzf2;
            }
            byte[] byArray = cursor.getBlob(0);
            zzsm zzsm2 = zzsm.zzD((byte[])byArray);
            zzqb.zzf zzf3 = new zzqb.zzf();
            try {
                zzf3.zzH(zzsm2);
            }
            catch (IOException iOException) {
                this.zzAo().zzCE().zze("Failed to merge filter results", string2, iOException);
            }
            zzqb.zzf zzf4 = zzf3;
            return zzf4;
        }
    }

    @WorkerThread
    void zza(ContentValues contentValues, String string2, Object object) {
        zzx.zzcM((String)string2);
        zzx.zzz((Object)object);
        if (object instanceof String) {
            contentValues.put(string2, (String)object);
        } else if (object instanceof Long) {
            contentValues.put(string2, (Long)object);
        } else if (object instanceof Float) {
            contentValues.put(string2, (Float)object);
        } else {
            throw new IllegalArgumentException("Invalid value type");
        }
    }

    @WorkerThread
    @TargetApi(value=11)
    static int zza(Cursor cursor, int n) {
        int n2;
        if (Build.VERSION.SDK_INT >= 11) {
            return cursor.getType(n);
        }
        SQLiteCursor sQLiteCursor = (SQLiteCursor)cursor;
        CursorWindow cursorWindow = sQLiteCursor.getWindow();
        if (cursorWindow.isNull(n2 = cursor.getPosition(), n)) {
            return 0;
        }
        if (cursorWindow.isLong(n2, n)) {
            return 1;
        }
        if (cursorWindow.isFloat(n2, n)) {
            return 2;
        }
        if (cursorWindow.isString(n2, n)) {
            return 3;
        }
        if (cursorWindow.isBlob(n2, n)) {
            return 4;
        }
        return -1;
    }

    @WorkerThread
    Object zzb(Cursor cursor, int n) {
        int n2 = zze.zza(cursor, n);
        switch (n2) {
            case 0: {
                this.zzAo().zzCE().zzfg("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return Float.valueOf(cursor.getFloat(n));
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzAo().zzCE().zzfg("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzAo().zzCE().zzj("Loaded invalid unknown value type, ignoring it", n2);
        return null;
    }

    @WorkerThread
    public long zzCt() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    public long zzCu() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public long zzb(zzqb.zze zze2) throws IOException {
        byte[] byArray;
        this.zzjk();
        this.zzjv();
        zzx.zzz((Object)((Object)zze2));
        zzx.zzcM((String)zze2.appId);
        try {
            int n = zze2.getSerializedSize();
            byArray = new byte[n];
            zzsn zzsn2 = zzsn.zzE((byte[])byArray);
            zze2.writeTo(zzsn2);
            zzsn2.zzJo();
        }
        catch (IOException iOException) {
            this.zzAo().zzCE().zzj("Data loss. Failed to serialize event metadata", iOException);
            throw iOException;
        }
        long l = this.zzCk().zzr(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.appId);
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l2 = sQLiteDatabase.insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzj("Error storing raw event metadata", (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    public boolean zzCv() {
        long l = this.zzb("select count(1) > 0 from raw_events", (String[])null);
        return l != 0L;
    }

    public void zzz(List<Long> list) {
        zzx.zzz(list);
        this.zzjk();
        this.zzjv();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzAo().zzCE().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public void zzfc(String string2) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzj("Failed to remove unused event metadata", (Object)sQLiteException);
        }
    }

    public long zzfd(String string2) {
        zzx.zzcM((String)string2);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string2}, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzaa(long l) {
        this.zzjk();
        this.zzjv();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzAo().zzCK().zzfg("No expired configs for apps with pending events");
                String string2 = null;
                return string2;
            }
            String string3 = cursor.getString(0);
            return string3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string2, long l, zzb zzb2) {
        zzx.zzz((Object)zzb2);
        this.zzjk();
        this.zzjv();
        try (Cursor cursor = null;){
            String string3;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if (TextUtils.isEmpty((CharSequence)string2)) {
                cursor = sQLiteDatabase.rawQuery("select app_id, metadata_fingerprint from raw_events where app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", new String[]{String.valueOf(l)});
                if (!cursor.moveToFirst()) {
                    return;
                }
                string2 = cursor.getString(0);
                string3 = cursor.getString(1);
                cursor.close();
            } else {
                cursor = sQLiteDatabase.rawQuery("select metadata_fingerprint from raw_events where app_id = ? order by rowid limit 1;", new String[]{string2});
                if (!cursor.moveToFirst()) {
                    return;
                }
                string3 = cursor.getString(0);
                cursor.close();
            }
            cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id=? and metadata_fingerprint=?", new String[]{string2, string3}, null, null, "rowid", "2");
            if (!cursor.moveToFirst()) {
                this.zzAo().zzCE().zzfg("Raw event metadata record is missing");
                return;
            }
            byte[] byArray = cursor.getBlob(0);
            zzsm zzsm2 = zzsm.zzD((byte[])byArray);
            zzqb.zze zze2 = new zzqb.zze();
            try {
                zze2.zzG(zzsm2);
            }
            catch (IOException iOException) {
                this.zzAo().zzCE().zze("Data loss. Failed to merge raw event metadata", string2, iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return;
            }
            if (cursor.moveToNext()) {
                this.zzAo().zzCF().zzfg("Get multiple raw event metadata records, expected one");
            }
            cursor.close();
            zzb2.zzc(zze2);
            cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, "app_id=? and metadata_fingerprint=?", new String[]{string2, string3}, null, null, "rowid", null);
            if (!cursor.moveToFirst()) {
                this.zzAo().zzCF().zzfg("Raw event data disappeared while in transaction");
                return;
            }
            do {
                long l2 = cursor.getLong(0);
                byArray = cursor.getBlob(3);
                zzsm2 = zzsm.zzD((byte[])byArray);
                zzqb.zzb zzb3 = new zzqb.zzb();
                try {
                    zzb3.zzD(zzsm2);
                }
                catch (IOException iOException) {
                    this.zzAo().zzCE().zze("Data loss. Failed to merge raw event", string2, iOException);
                    continue;
                }
                zzb3.name = cursor.getString(1);
                zzb3.zzbaf = cursor.getLong(2);
                if (zzb2.zza(l2, zzb3)) continue;
                return;
            } while (cursor.moveToNext());
        }
    }

    public void zza(zzh zzh2, long l) {
        Object object;
        zzqb.zzc zzc2;
        this.zzjk();
        this.zzjv();
        zzx.zzz((Object)zzh2);
        zzx.zzcM((String)zzh2.zzaUa);
        zzqb.zzb zzb2 = new zzqb.zzb();
        zzb2.zzbag = zzh2.zzaVN;
        zzb2.zzbae = new zzqb.zzc[zzh2.zzaVO.size()];
        int n = 0;
        for (String string2 : zzh2.zzaVO) {
            zzc2 = new zzqb.zzc();
            zzb2.zzbae[n++] = zzc2;
            zzc2.name = string2;
            Object object2 = zzh2.zzaVO.get(string2);
            this.zzCk().zza(zzc2, object2);
        }
        try {
            int n2 = zzb2.getSerializedSize();
            object = new byte[n2];
            zzc2 = zzsn.zzE((byte[])object);
            zzb2.writeTo((zzsn)zzc2);
            zzc2.zzJo();
        }
        catch (IOException iOException) {
            this.zzAo().zzCE().zzj("Data loss. Failed to serialize event params/data", iOException);
            return;
        }
        this.zzAo().zzCK().zze("Saving event, name, data size", zzh2.mName, ((Object)object).length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzh2.zzaUa);
        contentValues.put("name", zzh2.mName);
        contentValues.put("timestamp", Long.valueOf(zzh2.zzaez));
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("data", (byte[])object);
        try {
            zzc2 = this.getWritableDatabase();
            long l2 = zzc2.insert("raw_events", null, contentValues);
            if (l2 == -1L) {
                this.zzAo().zzCE().zzfg("Failed to insert raw event (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzAo().zzCE().zzj("Error storing raw event", (Object)sQLiteException);
        }
    }

    private boolean zzCw() {
        return this.getContext().getDatabasePath(this.zzjQ()).exists();
    }

    static {
        zzaVB.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        zzaVB.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        zzaVB.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        zzaVB.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        zzaVB.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
        zzaVB.put("last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;");
        zzaVB.put("day", "ALTER TABLE apps ADD COLUMN day INTEGER;");
        zzaVB.put("daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;");
        zzaVB.put("daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;");
        zzaVB.put("daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;");
        zzaVB.put("remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;");
        zzaVB.put("config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;");
        zzaVB.put("failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;");
    }

    private class zzc
    extends SQLiteOpenHelper {
        zzc(Context context, String string2) {
            super(context, string2, null, 1);
        }

        @WorkerThread
        public SQLiteDatabase getWritableDatabase() {
            if (!zze.this.zzaVD.zzv(zze.this.zzCp().zzBN())) {
                throw new SQLiteException("Database open failed");
            }
            try {
                return super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zze.this.zzaVD.start();
                zze.this.zzAo().zzCE().zzfg("Opening the database failed, dropping and recreating it");
                String string2 = zze.this.zzjQ();
                zze.this.getContext().getDatabasePath(string2).delete();
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zze.this.zzaVD.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zze.this.zzAo().zzCE().zzj("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private boolean zza(SQLiteDatabase sQLiteDatabase, String string2) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string2}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string2) {
            HashSet<String> hashSet = new HashSet<String>();
            String string3 = "SELECT * FROM " + string2 + " LIMIT 0";
            try (Cursor cursor = sQLiteDatabase.rawQuery(string3, null);){
                Collections.addAll(hashSet, cursor.getColumnNames());
            }
            return hashSet;
        }

        @WorkerThread
        private void zza(SQLiteDatabase sQLiteDatabase, String string2, String string3, Map<String, String> map) throws SQLiteException {
            Set<String> set = this.zzb(sQLiteDatabase, string2);
            for (String string4 : string3.split(",")) {
                if (set.remove(string4)) continue;
                throw new SQLiteException("Table " + string2 + " is missing required column: " + string4);
            }
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    if (set.remove(entry.getKey())) continue;
                    sQLiteDatabase.execSQL((String)entry.getValue());
                }
            }
            if (!set.isEmpty()) {
                throw new SQLiteException("Table " + string2 + " table has extra columns");
            }
        }

        @WorkerThread
        private void zza(SQLiteDatabase sQLiteDatabase, String string2, String string3, String string4, Map<String, String> map) throws SQLiteException {
            if (!this.zza(sQLiteDatabase, string2)) {
                sQLiteDatabase.execSQL(string3);
            }
            try {
                this.zza(sQLiteDatabase, string2, string4, map);
            }
            catch (SQLiteException sQLiteException) {
                zze.this.zzAo().zzCE().zzj("Failed to verify columns on table that was just created", string2);
                throw sQLiteException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void onOpen(SQLiteDatabase database) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = database.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            this.zza(database, "events", "CREATE TABLE IF NOT EXISTS events ( app_id TEXT NOT NULL, name TEXT NOT NULL, lifetime_count INTEGER NOT NULL, current_bundle_count INTEGER NOT NULL, last_fire_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,lifetime_count,current_bundle_count,last_fire_timestamp", null);
            this.zza(database, "user_attributes", "CREATE TABLE IF NOT EXISTS user_attributes ( app_id TEXT NOT NULL, name TEXT NOT NULL, set_timestamp INTEGER NOT NULL, value BLOB NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,set_timestamp,value", null);
            this.zza(database, "apps", "CREATE TABLE IF NOT EXISTS apps ( app_id TEXT NOT NULL, app_instance_id TEXT, gmp_app_id TEXT, resettable_device_id_hash TEXT, last_bundle_index INTEGER NOT NULL, last_bundle_end_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id)) ;", "app_id,app_instance_id,gmp_app_id,resettable_device_id_hash,last_bundle_index,last_bundle_end_timestamp", zzaVB);
            this.zza(database, "queue", "CREATE TABLE IF NOT EXISTS queue ( app_id TEXT NOT NULL, bundle_end_timestamp INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,bundle_end_timestamp,data", null);
            this.zza(database, "raw_events_metadata", "CREATE TABLE IF NOT EXISTS raw_events_metadata ( app_id TEXT NOT NULL, metadata_fingerprint INTEGER NOT NULL, metadata BLOB NOT NULL, PRIMARY KEY (app_id, metadata_fingerprint));", "app_id,metadata_fingerprint,metadata", null);
            this.zza(database, "raw_events", "CREATE TABLE IF NOT EXISTS raw_events ( app_id TEXT NOT NULL, name TEXT NOT NULL, timestamp INTEGER NOT NULL, metadata_fingerprint INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,name,timestamp,metadata_fingerprint,data", null);
            this.zza(database, "event_filters", "CREATE TABLE IF NOT EXISTS event_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, event_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, event_name, audience_id, filter_id));", "app_id,audience_id,filter_id,event_name,data", null);
            this.zza(database, "property_filters", "CREATE TABLE IF NOT EXISTS property_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, property_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, property_name, audience_id, filter_id));", "app_id,audience_id,filter_id,property_name,data", null);
            this.zza(database, "audience_filter_values", "CREATE TABLE IF NOT EXISTS audience_filter_values ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, current_results BLOB, PRIMARY KEY (app_id, audience_id));", "app_id,audience_id,current_results", null);
        }

        @WorkerThread
        public void onCreate(SQLiteDatabase database) {
            if (Build.VERSION.SDK_INT >= 9) {
                File file = new File(database.getPath());
                file.setReadable(false, false);
                file.setWritable(false, false);
                file.setReadable(true, true);
                file.setWritable(true, true);
            }
        }

        @WorkerThread
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }

    static interface zzb {
        public void zzc(zzqb.zze var1);

        public boolean zza(long var1, zzqb.zzb var3);
    }

    public static class zza {
        long zzaVE;
        long zzaVF;
        long zzaVG;
    }
}

