/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;

class zzt
extends zzz {
    static final Pair<String, Long> zzaXh = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzTh;
    public final zzc zzaXi = new zzc("health_monitor", this.zzCp().zzkX());
    public final zzb zzaXj = new zzb("last_upload", 0L);
    public final zzb zzaXk = new zzb("last_upload_attempt", 0L);
    public final zzb zzaXl = new zzb("backoff", 0L);
    public final zzb zzaXm = new zzb("last_delete_stale", 0L);
    public final zzb zzaXn;
    private String zzaXo;
    private boolean zzaXp;
    private long zzaXq;
    private final SecureRandom zzaXr;
    public final zzb zzaXs = new zzb("time_before_start", 10000L);
    public final zzb zzaXt = new zzb("session_timeout", 1800000L);
    public final zza zzaXu = new zza("start_new_session", true);
    public final zzb zzaXv = new zzb("last_pause_time", 0L);
    public final zzb zzaXw = new zzb("time_active", 0L);
    public boolean zzaXx;

    @WorkerThread
    Pair<String, Boolean> zzfh(String string2) {
        this.zzjk();
        long l = this.zzjl().elapsedRealtime();
        if (this.zzaXo != null && l < this.zzaXq) {
            return new Pair((Object)this.zzaXo, (Object)this.zzaXp);
        }
        this.zzaXq = l + this.zzCp().zzeS(string2);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            this.zzaXo = info.getId();
            this.zzaXp = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzAo().zzCJ().zzj("Unable to get advertising id", throwable);
            this.zzaXo = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzaXo, (Object)this.zzaXp);
    }

    String zzfi(String string2) {
        String string3 = (String)this.zzfh((String)string2).first;
        MessageDigest messageDigest = zzaj.zzbv("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string3.getBytes())));
    }

    String zzCM() {
        byte[] byArray = new byte[16];
        this.zzaXr.nextBytes(byArray);
        String string2 = String.format(Locale.US, "%032x", new BigInteger(1, byArray));
        return string2;
    }

    @WorkerThread
    long zzCN() {
        this.zzjv();
        this.zzjk();
        long l = this.zzaXn.get();
        if (l == 0L) {
            l = 1 + this.zzaXr.nextInt(86400000);
            this.zzaXn.set(l);
        }
        return l;
    }

    zzt(zzw zzw2) {
        super(zzw2);
        this.zzaXr = new SecureRandom();
        this.zzaXn = new zzb("midnight_offset", 0L);
    }

    @Override
    protected void zziJ() {
        this.zzTh = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzaXx = this.zzTh.getBoolean("has_been_opened", false);
        if (!this.zzaXx) {
            SharedPreferences.Editor editor = this.zzTh.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private SharedPreferences zzCO() {
        this.zzjk();
        this.zzjv();
        return this.zzTh;
    }

    @WorkerThread
    Boolean zzCP() {
        this.zzjk();
        if (!this.zzCO().contains("use_service")) {
            return null;
        }
        return this.zzCO().getBoolean("use_service", false);
    }

    @WorkerThread
    void zzar(boolean bl) {
        this.zzjk();
        this.zzAo().zzCK().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzCO().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    boolean zzAr() {
        this.zzjk();
        return this.zzCO().getBoolean("measurement_enabled", !com.google.android.gms.measurement.zza.zzAs());
    }

    @WorkerThread
    void setMeasurementEnabled(boolean enabled) {
        this.zzjk();
        this.zzAo().zzCK().zzj("Setting measurementEnabled", enabled);
        SharedPreferences.Editor editor = this.zzCO().edit();
        editor.putBoolean("measurement_enabled", enabled);
        editor.apply();
    }

    @WorkerThread
    protected String zzCQ() {
        this.zzjk();
        String string2 = this.zzCO().getString("previous_os_version", null);
        String string3 = this.zzCh().zzCy();
        if (!TextUtils.isEmpty((CharSequence)string3) && !string3.equals(string2)) {
            SharedPreferences.Editor editor = this.zzCO().edit();
            editor.putString("previous_os_version", string3);
            editor.apply();
        }
        return string2;
    }

    public final class zza {
        private final String zzvs;
        private final boolean zzaXy;
        private boolean zzaXz;
        private boolean zzagf;

        public zza(String string2, boolean bl) {
            zzx.zzcM((String)string2);
            this.zzvs = string2;
            this.zzaXy = bl;
        }

        @WorkerThread
        private void zzCR() {
            if (this.zzaXz) {
                return;
            }
            this.zzaXz = true;
            this.zzagf = zzt.this.zzTh.getBoolean(this.zzvs, this.zzaXy);
        }

        @WorkerThread
        public boolean get() {
            this.zzCR();
            return this.zzagf;
        }

        @WorkerThread
        public void set(boolean value) {
            SharedPreferences.Editor editor = zzt.this.zzTh.edit();
            editor.putBoolean(this.zzvs, value);
            editor.apply();
            this.zzagf = value;
        }
    }

    public final class zzb {
        private final String zzvs;
        private final long zzaXB;
        private boolean zzaXz;
        private long zzaDV;

        public zzb(String string2, long l) {
            zzx.zzcM((String)string2);
            this.zzvs = string2;
            this.zzaXB = l;
        }

        @WorkerThread
        private void zzCR() {
            if (this.zzaXz) {
                return;
            }
            this.zzaXz = true;
            this.zzaDV = zzt.this.zzTh.getLong(this.zzvs, this.zzaXB);
        }

        @WorkerThread
        public long get() {
            this.zzCR();
            return this.zzaDV;
        }

        @WorkerThread
        public void set(long value) {
            SharedPreferences.Editor editor = zzt.this.zzTh.edit();
            editor.putLong(this.zzvs, value);
            editor.apply();
            this.zzaDV = value;
        }
    }

    public final class zzc {
        final String zzaXC;
        private final String zzaXD;
        private final String zzaXE;
        private final long zzTl;

        private zzc(String string2, long l) {
            zzx.zzcM((String)string2);
            zzx.zzac((l > 0L ? 1 : 0) != 0);
            this.zzaXC = string2 + ":start";
            this.zzaXD = string2 + ":count";
            this.zzaXE = string2 + ":value";
            this.zzTl = l;
        }

        @WorkerThread
        private void zzlL() {
            zzt.this.zzjk();
            long l = zzt.this.zzjl().currentTimeMillis();
            SharedPreferences.Editor editor = zzt.this.zzTh.edit();
            editor.remove(this.zzaXD);
            editor.remove(this.zzaXE);
            editor.putLong(this.zzaXC, l);
            editor.apply();
        }

        @WorkerThread
        private long zzlM() {
            zzt.this.zzjk();
            long l = this.zzlO();
            if (l == 0L) {
                this.zzlL();
                return 0L;
            }
            return Math.abs(l - zzt.this.zzjl().currentTimeMillis());
        }

        @WorkerThread
        public void zzbq(String string2) {
            this.zzf(string2, 1L);
        }

        @WorkerThread
        public void zzf(String string2, long l) {
            long l2;
            zzt.this.zzjk();
            long l3 = this.zzlO();
            if (l3 == 0L) {
                this.zzlL();
            }
            if (string2 == null) {
                string2 = "";
            }
            if ((l2 = zzt.this.zzTh.getLong(this.zzaXD, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzt.this.zzTh.edit();
                editor.putString(this.zzaXE, string2);
                editor.putLong(this.zzaXD, l);
                editor.apply();
                return;
            }
            long l4 = zzt.this.zzaXr.nextLong() & Long.MAX_VALUE;
            boolean bl = l4 < Long.MAX_VALUE / (l2 + l) * l;
            SharedPreferences.Editor editor = zzt.this.zzTh.edit();
            if (bl) {
                editor.putString(this.zzaXE, string2);
            }
            editor.putLong(this.zzaXD, l2 + l);
            editor.apply();
        }

        @WorkerThread
        public Pair<String, Long> zzlN() {
            zzt.this.zzjk();
            long l = this.zzlM();
            if (l < this.zzTl) {
                return null;
            }
            if (l > this.zzTl * 2L) {
                this.zzlL();
                return null;
            }
            String string2 = zzt.this.zzCO().getString(this.zzaXE, null);
            long l2 = zzt.this.zzCO().getLong(this.zzaXD, 0L);
            this.zzlL();
            if (string2 == null || l2 <= 0L) {
                return zzaXh;
            }
            return new Pair((Object)string2, (Object)l2);
        }

        @WorkerThread
        private long zzlO() {
            return zzt.this.zzCO().getLong(this.zzaXC, 0L);
        }
    }
}

