/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqb;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.AppMeasurementReceiver;
import com.google.android.gms.measurement.AppMeasurementService;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzy;
import com.google.android.gms.measurement.internal.zzz;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class zzw {
    private static zzaa zzaXV;
    private static volatile zzw zzaXW;
    private final Context mContext;
    private final zzd zzaXX;
    private final zzt zzaXY;
    private final zzp zzaXZ;
    private final zzv zzaYa;
    private final zzad zzaYb;
    private final zzu zzaYc;
    private final AppMeasurement zzaYd;
    private final zzaj zzaYe;
    private final zze zzaYf;
    private final zzq zzaYg;
    private final zzmq zzqW;
    private final zzac zzaYh;
    private final zzg zzaYi;
    private final zzab zzaYj;
    private final zzn zzaYk;
    private final zzr zzaYl;
    private final zzag zzaYm;
    private final zzc zzaYn;
    private final boolean zzQk;
    private Boolean zzaYo;
    private List<Long> zzaYp;
    private int zzaYq;
    private int zzaYr;

    zzw(zzaa zzaa2) {
        zzx.zzz((Object)zzaa2);
        this.mContext = zzaa2.mContext;
        this.zzqW = zzaa2.zzl(this);
        this.zzaXX = zzaa2.zza(this);
        zzt zzt2 = zzaa2.zzb(this);
        zzt2.zza();
        this.zzaXY = zzt2;
        zzp zzp2 = zzaa2.zzc(this);
        zzp2.zza();
        this.zzaXZ = zzp2;
        this.zzAo().zzCI().zzj("App measurement is starting up, version", this.zzCp().zzBp());
        this.zzAo().zzCI().zzfg("To enable debug logging run: adb shell setprop log.tag.GMPM VERBOSE");
        this.zzAo().zzCJ().zzfg("Debug logging enabled");
        this.zzaYe = zzaa2.zzi(this);
        zzg zzg2 = zzaa2.zzn(this);
        zzg2.zza();
        this.zzaYi = zzg2;
        zzn zzn2 = zzaa2.zzo(this);
        zzn2.zza();
        this.zzaYk = zzn2;
        zze zze2 = zzaa2.zzj(this);
        zze2.zza();
        this.zzaYf = zze2;
        zzc zzc2 = zzaa2.zzr(this);
        zzc2.zza();
        this.zzaYn = zzc2;
        zzq zzq2 = zzaa2.zzk(this);
        zzq2.zza();
        this.zzaYg = zzq2;
        zzac zzac2 = zzaa2.zzm(this);
        zzac2.zza();
        this.zzaYh = zzac2;
        zzab zzab2 = zzaa2.zzh(this);
        zzab2.zza();
        this.zzaYj = zzab2;
        zzag zzag2 = zzaa2.zzq(this);
        zzag2.zza();
        this.zzaYm = zzag2;
        this.zzaYl = zzaa2.zzp(this);
        this.zzaYd = zzaa2.zzg(this);
        zzad zzad2 = zzaa2.zze(this);
        zzad2.zza();
        this.zzaYb = zzad2;
        zzu zzu2 = zzaa2.zzf(this);
        zzu2.zza();
        this.zzaYc = zzu2;
        zzv zzv2 = zzaa2.zzd(this);
        zzv2.zza();
        this.zzaYa = zzv2;
        if (this.zzaYq != this.zzaYr) {
            this.zzAo().zzCE().zze("Not all components initialized", this.zzaYq, this.zzaYr);
        }
        this.zzQk = true;
        if (!this.zzaXX.zzkr() && !this.zzCZ()) {
            if (this.mContext.getApplicationContext() instanceof Application) {
                if (Build.VERSION.SDK_INT >= 14) {
                    this.zzCf().zzDk();
                } else {
                    this.zzAo().zzCJ().zzfg("Not tracking deep linking pre-ICS");
                }
            } else {
                this.zzAo().zzCF().zzfg("Application context is not an Application");
            }
        }
        this.zzaYa.zzg(new Runnable(){

            @Override
            public void run() {
                zzw.this.start();
            }
        });
    }

    void zzjv() {
        if (!this.zzQk) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected boolean zzCS() {
        this.zzjv();
        this.zzjk();
        if (this.zzaYo == null) {
            this.zzaYo = this.zzCk().zzbk("android.permission.INTERNET") && this.zzCk().zzbk("android.permission.ACCESS_NETWORK_STATE") && AppMeasurementReceiver.zzY(this.getContext()) && AppMeasurementService.zzZ(this.getContext());
            if (this.zzaYo.booleanValue() && !this.zzCp().zzkr()) {
                this.zzaYo = !TextUtils.isEmpty((CharSequence)this.zzCg().zzBk());
            }
        }
        return this.zzaYo;
    }

    @WorkerThread
    protected void start() {
        this.zzjk();
        if (this.zzCZ() && (!this.zzaYa.isInitialized() || this.zzaYa.zzDi())) {
            this.zzAo().zzCE().zzfg("Scheduler shutting down before Scion.start() called");
            return;
        }
        this.zzCj().zzCr();
        if (!this.zzCS()) {
            if (this.zzCo().zzAr()) {
                if (!this.zzCk().zzbk("android.permission.INTERNET")) {
                    this.zzAo().zzCE().zzfg("App is missing INTERNET permission");
                }
                if (!this.zzCk().zzbk("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzAo().zzCE().zzfg("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!AppMeasurementReceiver.zzY(this.getContext())) {
                    this.zzAo().zzCE().zzfg("AppMeasurementReceiver not registered/enabled");
                }
                if (!AppMeasurementService.zzZ(this.getContext())) {
                    this.zzAo().zzCE().zzfg("AppMeasurementService not registered/enabled");
                }
                this.zzAo().zzCE().zzfg("Uploading is not possible. App measurement disabled");
            }
        } else if (!(this.zzCp().zzkr() || this.zzCZ() || TextUtils.isEmpty((CharSequence)this.zzCg().zzBk()))) {
            this.zzCf().zzDl();
        }
        this.zzDe();
    }

    public zzd zzCp() {
        return this.zzaXX;
    }

    public zzt zzCo() {
        this.zza((zzy)this.zzaXY);
        return this.zzaXY;
    }

    public zzp zzAo() {
        this.zza(this.zzaXZ);
        return this.zzaXZ;
    }

    public zzp zzCT() {
        return this.zzaXZ != null && this.zzaXZ.isInitialized() ? this.zzaXZ : null;
    }

    public zzv zzCn() {
        this.zza(this.zzaYa);
        return this.zzaYa;
    }

    public zzad zzCm() {
        this.zza(this.zzaYb);
        return this.zzaYb;
    }

    public zzu zzCl() {
        this.zza(this.zzaYc);
        return this.zzaYc;
    }

    zzv zzCU() {
        return this.zzaYa;
    }

    public zzab zzCf() {
        this.zza(this.zzaYj);
        return this.zzaYj;
    }

    public AppMeasurement zzCV() {
        return this.zzaYd;
    }

    public zzaj zzCk() {
        this.zza(this.zzaYe);
        return this.zzaYe;
    }

    public zze zzCj() {
        this.zza(this.zzaYf);
        return this.zzaYf;
    }

    public zzq zzCW() {
        this.zza(this.zzaYg);
        return this.zzaYg;
    }

    public Context getContext() {
        return this.mContext;
    }

    public zzmq zzjl() {
        return this.zzqW;
    }

    public zzac zzCi() {
        this.zza(this.zzaYh);
        return this.zzaYh;
    }

    public zzg zzCh() {
        this.zza(this.zzaYi);
        return this.zzaYi;
    }

    public zzn zzCg() {
        this.zza(this.zzaYk);
        return this.zzaYk;
    }

    public zzr zzCX() {
        if (this.zzaYl == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzaYl;
    }

    public zzag zzCY() {
        this.zza(this.zzaYm);
        return this.zzaYm;
    }

    public zzc zzCe() {
        this.zza(this.zzaYn);
        return this.zzaYn;
    }

    @WorkerThread
    public void zzjk() {
        this.zzCn().zzjk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzw zzaT(Context context) {
        zzx.zzz((Object)context);
        zzx.zzz((Object)context.getApplicationContext());
        if (zzaXW != null) return zzaXW;
        Class<zzw> clazz = zzw.class;
        synchronized (zzw.class) {
            if (zzaXW != null) return zzaXW;
            zzaa zzaa2 = zzaXV != null ? zzaXV : new zzaa(context);
            zzaXW = zzaa2.zzDj();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaXW;
        }
    }

    private void zza(zzz zzz2) {
        if (zzz2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzz2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private void zza(zzy zzy2) {
        if (zzy2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    protected boolean zzCZ() {
        return false;
    }

    void zzc(AppMetadata appMetadata) {
        this.zzjk();
        this.zzjv();
        zzx.zzcM((String)appMetadata.packageName);
        this.zze(appMetadata);
    }

    void zza(EventParcel eventParcel, String string2) {
        Object object;
        com.google.android.gms.measurement.internal.zza zza2 = this.zzCj().zzeY(string2);
        if (zza2 == null || TextUtils.isEmpty((CharSequence)zza2.zzli())) {
            this.zzAo().zzCJ().zzj("No app data available; dropping event", string2);
            return;
        }
        try {
            object = this.getContext().getPackageManager().getPackageInfo((String)string2, (int)0).versionName;
            if (zza2.zzli() != null && !zza2.zzli().equals(object)) {
                this.zzAo().zzCF().zzj("App version does not match; dropping event", string2);
                return;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzAo().zzCF().zzj("Could not find package", string2);
        }
        object = new AppMetadata(string2, zza2.zzBk(), zza2.zzli(), zza2.zzBo(), zza2.zzBp(), zza2.zzBq(), null, zza2.zzAr(), false);
        this.zzb(eventParcel, (AppMetadata)object);
    }

    long zzDa() {
        long l = this.zzjl().currentTimeMillis() + this.zzCo().zzCN();
        return l / 1000L / 60L / 60L / 24L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(EventParcel eventParcel, AppMetadata appMetadata) {
        long l = System.nanoTime();
        this.zzjk();
        this.zzjv();
        String string2 = appMetadata.packageName;
        zzx.zzcM((String)string2);
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzaVt)) {
            return;
        }
        if (!appMetadata.zzaVy) {
            this.zze(appMetadata);
            return;
        }
        if (this.zzCl().zzP(string2, eventParcel.name)) {
            this.zzAo().zzCK().zzj("Dropping blacklisted event", eventParcel.name);
            return;
        }
        if (this.zzAo().zzQ(2)) {
            this.zzAo().zzCK().zzj("Logging event", eventParcel);
        }
        this.zzCj().beginTransaction();
        try {
            zzi zzi2;
            long l2;
            Bundle bundle = eventParcel.zzaVV.zzCC();
            this.zze(appMetadata);
            if ("_iap".equals(eventParcel.name) || "ecommerce_purchase".equals(eventParcel.name)) {
                String string3 = bundle.getString("currency");
                long l3 = bundle.getLong("value");
                if (!TextUtils.isEmpty((CharSequence)string3) && l3 > 0L && (string3 = string3.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string4 = "_ltv_" + string3;
                    zzai zzai2 = this.zzCj().zzK(string2, string4);
                    if (zzai2 == null || !(zzai2.zzNc instanceof Long)) {
                        this.zzCj().zzA(string2, this.zzCp().zzeT(string2) - 1);
                        zzai2 = new zzai(string2, string4, this.zzjl().currentTimeMillis(), l3);
                    } else {
                        l2 = (Long)zzai2.zzNc;
                        zzai2 = new zzai(string2, string4, this.zzjl().currentTimeMillis(), l2 + l3);
                    }
                    this.zzCj().zza(zzai2);
                }
            }
            boolean bl = zzaj.zzfq(eventParcel.name);
            boolean bl2 = zzaj.zzI(bundle);
            zze.zza zza2 = this.zzCj().zza(this.zzDa(), string2, bl, bl && bl2);
            long l4 = zza2.zzaVF - this.zzCp().zzBI();
            if (l4 > 0L) {
                if (l4 % 1000L == 1L) {
                    this.zzAo().zzCF().zzj("Data loss. Too many events logged. count", zza2.zzaVF);
                }
                this.zzCj().setTransactionSuccessful();
                return;
            }
            if (bl && (l4 = zza2.zzaVE - this.zzCp().zzBJ()) > 0L) {
                this.zzE(string2, 2);
                if (l4 % 1000L == 1L) {
                    this.zzAo().zzCF().zzj("Data loss. Too many public events logged. count", zza2.zzaVE);
                }
                this.zzCj().setTransactionSuccessful();
                return;
            }
            if (bl && bl2 && (l4 = zza2.zzaVG - this.zzCp().zzBK()) > 0L) {
                bundle.remove("_c");
                this.zzb(bundle, 4);
            }
            if ((l2 = this.zzCj().zzeZ(string2)) > 0L) {
                this.zzAo().zzCF().zzj("Data lost. Too many events stored on disk, deleted", l2);
            }
            zzh zzh2 = new zzh(this, eventParcel.zzaVW, string2, eventParcel.name, eventParcel.zzaVX, 0L, bundle);
            zzi zzi3 = this.zzCj().zzI(string2, zzh2.mName);
            if (zzi3 == null) {
                long l5 = this.zzCj().zzfd(string2);
                if (l5 >= (long)this.zzCp().zzBH()) {
                    this.zzAo().zzCF().zze("Too many event names used, ignoring event. name, supported count", zzh2.mName, this.zzCp().zzBH());
                    this.zzE(string2, 1);
                    return;
                }
                zzi2 = new zzi(string2, zzh2.mName, 0L, 0L, zzh2.zzaez);
            } else {
                zzh2 = zzh2.zza(this, zzi3.zzaVR);
                zzi2 = zzi3.zzab(zzh2.zzaez);
            }
            this.zzCj().zza(zzi2);
            this.zza(zzh2, appMetadata);
            this.zzCj().setTransactionSuccessful();
            if (this.zzAo().zzQ(2)) {
                this.zzAo().zzCK().zzj("Event recorded", zzh2);
            }
        }
        finally {
            this.zzCj().endTransaction();
        }
        this.zzDe();
        this.zzAo().zzCK().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    private void zzb(Bundle bundle, int n) {
        long l = bundle.getLong("_err");
        if (l == 0L) {
            bundle.putLong("_err", (long)n);
        }
    }

    void zzE(String string2, int n) {
    }

    void zza(zzh zzh2, AppMetadata appMetadata) {
        this.zzjk();
        this.zzjv();
        zzx.zzz((Object)zzh2);
        zzx.zzz((Object)appMetadata);
        zzx.zzcM((String)zzh2.zzaUa);
        zzx.zzac((boolean)zzh2.zzaUa.equals(appMetadata.packageName));
        zzqb.zze zze2 = new zzqb.zze();
        zze2.zzbal = 1;
        zze2.zzbat = "android";
        zze2.appId = appMetadata.packageName;
        zze2.zzaVu = appMetadata.zzaVu;
        zze2.zzaMV = appMetadata.zzaMV;
        zze2.zzbax = appMetadata.zzaVv;
        zze2.zzaVt = appMetadata.zzaVt;
        zze2.zzbaC = appMetadata.zzaVw == 0L ? null : Long.valueOf(appMetadata.zzaVw);
        Pair<String, Boolean> pair = this.zzCo().zzfh(appMetadata.packageName);
        if (pair != null && pair.first != null && pair.second != null) {
            zze2.zzbaz = (String)pair.first;
            zze2.zzbaA = (Boolean)pair.second;
        }
        zze2.zzbau = this.zzCh().zzht();
        zze2.osVersion = this.zzCh().zzCy();
        zze2.zzbaw = (int)this.zzCh().zzCz();
        zze2.zzbav = this.zzCh().zzCA();
        zze2.zzbay = null;
        zze2.zzbao = null;
        zze2.zzbap = null;
        zze2.zzbaq = null;
        com.google.android.gms.measurement.internal.zza zza2 = this.zzCj().zzeY(appMetadata.packageName);
        if (zza2 == null) {
            zza2 = new com.google.android.gms.measurement.internal.zza(this, appMetadata.packageName);
            zza2.zzeM(this.zzCo().zzCM());
            zza2.zzeN(appMetadata.zzaVt);
            zza2.zzeO(this.zzCo().zzfi(appMetadata.packageName));
            zza2.zzS(0L);
            zza2.zzO(0L);
            zza2.zzP(0L);
            zza2.setAppVersion(appMetadata.zzaMV);
            zza2.zzeP(appMetadata.zzaVu);
            zza2.zzQ(appMetadata.zzaVv);
            zza2.zzR(appMetadata.zzaVw);
            zza2.setMeasurementEnabled(appMetadata.zzaVy);
            this.zzCj().zza(zza2);
        }
        zze2.zzbaB = zza2.zzBj();
        List<zzai> list = this.zzCj().zzeX(appMetadata.packageName);
        zze2.zzban = new zzqb.zzg[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            zzqb.zzg zzg2;
            zze2.zzban[i] = zzg2 = new zzqb.zzg();
            zzg2.name = list.get((int)i).mName;
            zzg2.zzbaJ = list.get((int)i).zzaZp;
            this.zzCk().zza(zzg2, list.get((int)i).zzNc);
        }
        long l = 0L;
        try {
            l = this.zzCj().zzb(zze2);
        }
        catch (IOException iOException) {
            this.zzAo().zzCE().zzj("Data loss. Failed to insert raw event metadata", iOException);
            return;
        }
        this.zzCj().zza(zzh2, l);
    }

    void zzjj() {
        if (this.zzCp().zzkr()) {
            throw new IllegalStateException("Unexpected call on package side");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzjk();
        this.zzjv();
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzaVt)) {
            return;
        }
        if (!appMetadata.zzaVy) {
            this.zze(appMetadata);
            return;
        }
        this.zzCk().zzfs(userAttributeParcel.name);
        Object object = this.zzCk().zzm(userAttributeParcel.name, userAttributeParcel.getValue());
        if (object == null) {
            return;
        }
        zzai zzai2 = new zzai(appMetadata.packageName, userAttributeParcel.name, userAttributeParcel.zzaZm, object);
        this.zzAo().zzCJ().zze("Setting user property", zzai2.mName, object);
        this.zzCj().beginTransaction();
        try {
            this.zze(appMetadata);
            boolean bl = this.zzCj().zza(zzai2);
            this.zzCj().setTransactionSuccessful();
            if (bl) {
                this.zzAo().zzCJ().zze("User property set", zzai2.mName, zzai2.zzNc);
            } else {
                this.zzAo().zzCH().zze("Ignoring user property. Value too long", zzai2.mName, zzai2.zzNc);
            }
        }
        finally {
            this.zzCj().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzc(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzjk();
        this.zzjv();
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzaVt)) {
            return;
        }
        if (!appMetadata.zzaVy) {
            this.zze(appMetadata);
            return;
        }
        this.zzAo().zzCJ().zzj("Removing user property", userAttributeParcel.name);
        this.zzCj().beginTransaction();
        try {
            this.zze(appMetadata);
            this.zzCj().zzJ(appMetadata.packageName, userAttributeParcel.name);
            this.zzCj().setTransactionSuccessful();
            this.zzAo().zzCJ().zzj("User property removed", userAttributeParcel.name);
        }
        finally {
            this.zzCj().endTransaction();
        }
    }

    @WorkerThread
    private boolean zzDb() {
        this.zzjk();
        return this.zzaYp != null;
    }

    private void zzA(List<Long> list) {
        zzx.zzac((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzaYp != null) {
            this.zzAo().zzCE().zzfg("Set uploading progress before finishing the previous upload");
        } else {
            this.zzaYp = new ArrayList<Long>(list);
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public void zzDc() {
        String string2;
        this.zzjk();
        this.zzjv();
        if (!this.zzCp().zzkr()) {
            Boolean bl = this.zzCo().zzCP();
            if (bl == null) {
                this.zzAo().zzCF().zzfg("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzAo().zzCE().zzfg("Upload called in the client side when service should be used");
                return;
            }
        }
        if (this.zzDb()) {
            this.zzAo().zzCF().zzfg("Uploading requested multiple times");
            return;
        }
        if (!this.zzCW().zzlB()) {
            this.zzAo().zzCF().zzfg("Network not connected, ignoring upload request");
            this.zzDe();
            return;
        }
        long l = this.zzjl().currentTimeMillis();
        this.zzad(l - this.zzCp().zzBW());
        long l2 = this.zzCo().zzaXj.get();
        if (l2 != 0L) {
            this.zzAo().zzCJ().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l2));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = this.zzCj().zzCq()))) {
            int n = this.zzCp().zzeU(string2);
            int n2 = this.zzCp().zzeV(string2);
            List<Pair<zzqb.zze, Long>> list = this.zzCj().zzn(string2, n, n2);
            if (!list.isEmpty()) {
                String string3 = null;
                for (Pair<zzqb.zze, Long> object2 : list) {
                    zzqb.zze zze2 = (zzqb.zze)((Object)object2.first);
                    if (TextUtils.isEmpty((CharSequence)zze2.zzbaz)) continue;
                    string3 = zze2.zzbaz;
                    break;
                }
                if (string3 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzqb.zze zze3 = (zzqb.zze)((Object)list.get((int)i).first);
                        if (TextUtils.isEmpty((CharSequence)zze3.zzbaz) || zze3.zzbaz.equals(string3)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
                Object object3 = new zzqb.zzd();
                ((zzqb.zzd)((Object)object3)).zzbaj = new zzqb.zze[list.size()];
                ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
                for (int i = 0; i < ((zzqb.zzd)((Object)object3)).zzbaj.length; ++i) {
                    ((zzqb.zzd)((Object)object3)).zzbaj[i] = (zzqb.zze)((Object)list.get((int)i).first);
                    arrayList.add((Long)list.get((int)i).second);
                    ((zzqb.zzd)((Object)object3)).zzbaj[i].zzbay = this.zzCp().zzBp();
                    ((zzqb.zzd)((Object)object3)).zzbaj[i].zzbao = l;
                    ((zzqb.zzd)((Object)object3)).zzbaj[i].zzbaE = this.zzCp().zzkr();
                }
                String string4 = null;
                if (this.zzAo().zzQ(2)) {
                    string4 = zzaj.zzb(object3);
                }
                byte[] byArray = this.zzCk().zza((zzqb.zzd)((Object)object3));
                String string5 = this.zzCp().zzBV();
                try {
                    URL uRL = new URL(string5);
                    this.zzA(arrayList);
                    this.zzCo().zzaXk.set(l);
                    String string6 = "?";
                    if (((zzqb.zzd)((Object)object3)).zzbaj.length > 0) {
                        string6 = ((zzqb.zzd)((Object)object3)).zzbaj[0].appId;
                    }
                    this.zzAo().zzCK().zzd("Uploading data. app, uncompressed size, data", string6, byArray.length, string4);
                    this.zzCW().zza(string2, uRL, byArray, null, new zzq.zza(){

                        @Override
                        public void zza(String string2, int n, Throwable throwable, byte[] byArray) {
                            zzw.this.zza(n, throwable, byArray);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzAo().zzCE().zzj("Failed to parse upload URL. Not uploading", string5);
                }
            }
        } else {
            String string7 = this.zzCj().zzaa(l - this.zzCp().zzBW());
            if (!TextUtils.isEmpty((CharSequence)string7)) {
                com.google.android.gms.measurement.internal.zza zza2 = this.zzCj().zzeY(string7);
                if (zza2 != null) {
                    String string8 = this.zzCp().zzH(zza2.zzBk(), zza2.zzBj());
                    try {
                        void var11_23;
                        URL uRL = new URL(string8);
                        this.zzAo().zzCK().zzj("Fetching remote configuration", zza2.zzwK());
                        zzqa.zzb zzb2 = this.zzCl().zzfk(zza2.zzwK());
                        Object var11_21 = null;
                        if (zzb2 != null && zzb2.zzaZT != null) {
                            ArrayMap arrayMap = new ArrayMap();
                            arrayMap.put("Config-Version", String.valueOf(zzb2.zzaZT));
                        }
                        this.zzCW().zza(string7, uRL, (Map<String, String>)var11_23, new zzq.zza(){

                            @Override
                            public void zza(String string2, int n, Throwable throwable, byte[] byArray) {
                                zzw.this.zzb(string2, n, throwable, byArray);
                            }
                        });
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzAo().zzCE().zzj("Failed to parse config URL. Not fetching", string8);
                    }
                }
                return;
            }
        }
    }

    boolean zzad(long l) {
        return this.zzg(null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzg(String string2, long l) {
        this.zzCj().beginTransaction();
        try {
            zza zza2 = new zza();
            this.zzCj().zza(string2, l, zza2);
            if (!zza2.isEmpty()) {
                Object object;
                int n;
                zzqb.zze zze2 = zza2.zzaYt;
                zze2.zzbam = new zzqb.zzb[zza2.zzpH.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zzpH.size(); ++n) {
                    if (this.zzCl().zzP(zza2.zzaYt.appId, zza2.zzpH.get((int)n).name)) {
                        this.zzAo().zzCK().zzj("Dropping blacklisted raw event", zza2.zzpH.get((int)n).name);
                        continue;
                    }
                    zze2.zzbam[n2++] = zza2.zzpH.get(n);
                }
                if (n2 < zza2.zzpH.size()) {
                    zze2.zzbam = Arrays.copyOf(zze2.zzbam, n2);
                }
                zze2.zzbaF = this.zza(zza2.zzaYt.appId, zza2.zzaYt.zzban, zze2.zzbam);
                zze2.zzbap = zze2.zzbam[0].zzbaf;
                zze2.zzbaq = zze2.zzbam[0].zzbaf;
                for (n = 1; n < zze2.zzbam.length; ++n) {
                    object = zze2.zzbam[n];
                    if (((zzqb.zzb)((Object)object)).zzbaf < zze2.zzbap) {
                        zze2.zzbap = ((zzqb.zzb)((Object)object)).zzbaf;
                    }
                    if (((zzqb.zzb)((Object)object)).zzbaf <= zze2.zzbaq) continue;
                    zze2.zzbaq = ((zzqb.zzb)((Object)object)).zzbaf;
                }
                String string3 = zza2.zzaYt.appId;
                object = this.zzCj().zzeY(string3);
                if (object == null) {
                    this.zzAo().zzCE().zzfg("Bundling raw events w/o app info");
                } else {
                    long l2 = ((com.google.android.gms.measurement.internal.zza)object).zzBn();
                    zze2.zzbas = l2 != 0L ? Long.valueOf(l2) : null;
                    long l3 = ((com.google.android.gms.measurement.internal.zza)object).zzBm();
                    if (l3 == 0L) {
                        l3 = l2;
                    }
                    zze2.zzbar = l3 != 0L ? Long.valueOf(l3) : null;
                    ((com.google.android.gms.measurement.internal.zza)object).zzBu();
                    zze2.zzbaD = (int)((com.google.android.gms.measurement.internal.zza)object).zzBr();
                    ((com.google.android.gms.measurement.internal.zza)object).zzO(zze2.zzbap);
                    ((com.google.android.gms.measurement.internal.zza)object).zzP(zze2.zzbaq);
                    this.zzCj().zza((com.google.android.gms.measurement.internal.zza)object);
                }
                zze2.zzaVx = this.zzAo().zzCL();
                this.zzCj().zza(zze2);
                this.zzCj().zzz(zza2.zzaYu);
                this.zzCj().zzfc(string3);
                this.zzCj().setTransactionSuccessful();
                boolean bl = true;
                return bl;
            }
            this.zzCj().setTransactionSuccessful();
            boolean bl = false;
            return bl;
        }
        finally {
            this.zzCj().endTransaction();
        }
    }

    private zzqb.zza[] zza(String string2, zzqb.zzg[] zzgArray, zzqb.zzb[] zzbArray) {
        zzx.zzcM((String)string2);
        return this.zzCe().zza(string2, zzbArray, zzgArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void zzb(String string2, int n, Throwable throwable, byte[] byArray) {
        this.zzjk();
        this.zzjv();
        zzx.zzcM((String)string2);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.zzCj().beginTransaction();
        try {
            boolean bl;
            com.google.android.gms.measurement.internal.zza zza2 = this.zzCj().zzeY(string2);
            boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
            if (bl || n == 404) {
                if (n == 404 || n == 304 ? this.zzCl().zzfk(string2) == null && !this.zzCl().zze(string2, null) : !this.zzCl().zze(string2, byArray)) {
                    return;
                }
                zza2.zzT(this.zzjl().currentTimeMillis());
                this.zzCj().zza(zza2);
                if (n == 404) {
                    this.zzAo().zzCF().zzfg("Config not found. Using empty config");
                } else {
                    this.zzAo().zzCK().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                }
                if (this.zzCW().zzlB() && this.zzDd()) {
                    this.zzDc();
                } else {
                    this.zzDe();
                }
            } else {
                boolean bl3;
                zza2.zzU(this.zzjl().currentTimeMillis());
                this.zzCj().zza(zza2);
                this.zzAo().zzCK().zze("Fetching config failed. code, error", n, throwable);
                this.zzCo().zzaXk.set(this.zzjl().currentTimeMillis());
                boolean bl4 = bl3 = n == 503 || n == 429;
                if (bl3) {
                    this.zzCo().zzaXl.set(this.zzjl().currentTimeMillis());
                }
                this.zzDe();
            }
            this.zzCj().setTransactionSuccessful();
        }
        finally {
            this.zzCj().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void zza(int n, Throwable throwable, byte[] byArray) {
        this.zzjk();
        this.zzjv();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        List<Long> list = this.zzaYp;
        this.zzaYp = null;
        if ((n == 200 || n == 204) && throwable == null) {
            this.zzCo().zzaXj.set(this.zzjl().currentTimeMillis());
            this.zzCo().zzaXk.set(0L);
            this.zzDe();
            this.zzAo().zzCK().zze("Successful upload. Got network response. code, size", n, byArray.length);
            this.zzCj().beginTransaction();
            try {
                for (Long l : list) {
                    this.zzCj().zzZ(l);
                }
                this.zzCj().setTransactionSuccessful();
            }
            finally {
                this.zzCj().endTransaction();
            }
            if (this.zzCW().zzlB() && this.zzDd()) {
                this.zzDc();
            } else {
                this.zzDe();
            }
        } else {
            boolean bl;
            this.zzAo().zzCK().zze("Network upload failed. Will retry later. code, error", n, throwable);
            this.zzCo().zzaXk.set(this.zzjl().currentTimeMillis());
            boolean bl2 = bl = n == 503 || n == 429;
            if (bl) {
                this.zzCo().zzaXl.set(this.zzjl().currentTimeMillis());
            }
            this.zzDe();
        }
    }

    private boolean zzDd() {
        this.zzjk();
        this.zzjv();
        boolean bl = this.zzCj().zzCv();
        return bl || !TextUtils.isEmpty((CharSequence)this.zzCj().zzCq());
    }

    @WorkerThread
    private void zzDe() {
        this.zzjk();
        this.zzjv();
        if (!this.zzCS() || !this.zzDd()) {
            this.zzCX().unregister();
            this.zzCY().cancel();
            return;
        }
        long l = this.zzDf();
        if (l == 0L) {
            this.zzCX().unregister();
            this.zzCY().cancel();
            return;
        }
        if (!this.zzCW().zzlB()) {
            this.zzCX().zzly();
            this.zzCY().cancel();
            return;
        }
        long l2 = this.zzCo().zzaXl.get();
        long l3 = this.zzCp().zzBX();
        if (!this.zzCk().zzc(l2, l3)) {
            l = Math.max(l, l2 + l3);
        }
        this.zzCX().unregister();
        long l4 = l - this.zzjl().currentTimeMillis();
        if (l4 <= 0L) {
            this.zzCY().zzt(1L);
        } else {
            this.zzAo().zzCK().zzj("Upload scheduled in approximately ms", l4);
            this.zzCY().zzt(l4);
        }
    }

    private long zzDf() {
        long l;
        long l2 = this.zzjl().currentTimeMillis();
        long l3 = this.zzCp().zzCa();
        long l4 = this.zzCp().zzBY();
        long l5 = this.zzCo().zzaXj.get();
        long l6 = this.zzCo().zzaXk.get();
        long l7 = this.zzCj().zzCt();
        long l8 = Math.max(l7, l = this.zzCj().zzCu());
        if (l8 == 0L) {
            return 0L;
        }
        l8 = l2 - Math.abs(l8 - l2);
        l5 = l2 - Math.abs(l5 - l2);
        l6 = l2 - Math.abs(l6 - l2);
        long l9 = Math.max(l5, l6);
        long l10 = l8 + l3;
        if (!this.zzCk().zzc(l9, l4)) {
            l10 = l9 + l4;
        }
        if (l6 != 0L && l6 >= l8) {
            long l11 = l10;
            for (int i = 0; i < this.zzCp().zzCc(); ++i) {
                long l12 = 1 << i;
                if ((l11 += this.zzCp().zzCb() * l12) <= l6) continue;
                return l11;
            }
            return 0L;
        }
        return l10;
    }

    public void zzJ(boolean bl) {
        this.zzDe();
    }

    void zzb(zzz zzz2) {
        ++this.zzaYq;
    }

    void zzDg() {
        ++this.zzaYr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zzd(AppMetadata appMetadata) {
        this.zzjk();
        this.zzjv();
        zzx.zzz((Object)appMetadata);
        zzx.zzcM((String)appMetadata.packageName);
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzaVt)) {
            return;
        }
        if (!appMetadata.zzaVy) {
            this.zze(appMetadata);
            return;
        }
        long l = this.zzjl().currentTimeMillis();
        this.zzCj().beginTransaction();
        try {
            EventParcel eventParcel;
            zzi zzi2;
            com.google.android.gms.measurement.internal.zza zza2 = this.zzCj().zzeY(appMetadata.packageName);
            if (zza2 != null && zza2.zzli() != null && !zza2.zzli().equals(appMetadata.zzaMV)) {
                zzi2 = new Bundle();
                zzi2.putString("_pv", zza2.zzli());
                eventParcel = new EventParcel("_au", new EventParams((Bundle)zzi2), "auto", l);
                this.zzb(eventParcel, appMetadata);
            }
            this.zze(appMetadata);
            zzi2 = this.zzCj().zzI(appMetadata.packageName, "_f");
            if (zzi2 == null) {
                long l2 = (1L + l / 3600000L) * 3600000L;
                UserAttributeParcel userAttributeParcel = new UserAttributeParcel("_fot", l, l2, "auto");
                this.zzb(userAttributeParcel, appMetadata);
                Bundle bundle = new Bundle();
                bundle.putLong("_c", 1L);
                EventParcel eventParcel2 = new EventParcel("_f", new EventParams(bundle), "auto", l);
                this.zzb(eventParcel2, appMetadata);
            } else if (appMetadata.zzaVz) {
                eventParcel = new EventParcel("_cd", new EventParams(new Bundle()), "auto", l);
                this.zzb(eventParcel, appMetadata);
            }
            this.zzCj().setTransactionSuccessful();
        }
        finally {
            this.zzCj().endTransaction();
        }
    }

    @WorkerThread
    private void zze(AppMetadata appMetadata) {
        this.zzjk();
        this.zzjv();
        zzx.zzz((Object)appMetadata);
        zzx.zzcM((String)appMetadata.packageName);
        com.google.android.gms.measurement.internal.zza zza2 = this.zzCj().zzeY(appMetadata.packageName);
        String string2 = this.zzCo().zzfi(appMetadata.packageName);
        boolean bl = false;
        if (zza2 == null) {
            zza2 = new com.google.android.gms.measurement.internal.zza(this, appMetadata.packageName);
            zza2.zzeM(this.zzCo().zzCM());
            zza2.zzeO(string2);
            bl = true;
        } else if (!string2.equals(zza2.zzBl())) {
            zza2.zzeO(string2);
            zza2.zzeM(this.zzCo().zzCM());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.zzaVt) && !appMetadata.zzaVt.equals(zza2.zzBk())) {
            zza2.zzeN(appMetadata.zzaVt);
            bl = true;
        }
        if (appMetadata.zzaVv != 0L && appMetadata.zzaVv != zza2.zzBp()) {
            zza2.zzQ(appMetadata.zzaVv);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.zzaMV) && !appMetadata.zzaMV.equals(zza2.zzli())) {
            zza2.setAppVersion(appMetadata.zzaMV);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.zzaVu) && !appMetadata.zzaVu.equals(zza2.zzBo())) {
            zza2.zzeP(appMetadata.zzaVu);
            bl = true;
        }
        if (appMetadata.zzaVw != zza2.zzBq()) {
            zza2.zzR(appMetadata.zzaVw);
            bl = true;
        }
        if (appMetadata.zzaVy != zza2.zzAr()) {
            zza2.setMeasurementEnabled(appMetadata.zzaVy);
            bl = true;
        }
        if (bl) {
            this.zzCj().zza(zza2);
        }
    }

    private class zza
    implements zze.zzb {
        zzqb.zze zzaYt;
        List<Long> zzaYu;
        List<zzqb.zzb> zzpH;
        long zzaYv;

        private zza() {
        }

        @Override
        public void zzc(zzqb.zze zze2) {
            zzx.zzz((Object)((Object)zze2));
            this.zzaYt = zze2;
        }

        @Override
        public boolean zza(long l, zzqb.zzb zzb2) {
            zzx.zzz((Object)((Object)zzb2));
            if (this.zzpH == null) {
                this.zzpH = new ArrayList<zzqb.zzb>();
            }
            if (this.zzaYu == null) {
                this.zzaYu = new ArrayList<Long>();
            }
            if (this.zzpH.size() > 0 && this.zza(this.zzpH.get(0)) != this.zza(zzb2)) {
                return false;
            }
            long l2 = this.zzaYv + (long)zzb2.getSerializedSize();
            if (l2 >= (long)zzw.this.zzCp().zzBT()) {
                return false;
            }
            this.zzaYv = l2;
            this.zzpH.add(zzb2);
            this.zzaYu.add(l);
            return this.zzpH.size() < zzw.this.zzCp().zzBU();
        }

        private long zza(zzqb.zzb zzb2) {
            return zzb2.zzbaf / 1000L / 60L / 60L;
        }

        boolean isEmpty() {
            return this.zzpH == null || this.zzpH.isEmpty();
        }
    }
}

