/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.internal.zzab;
import com.google.android.gms.drive.internal.zzat;
import com.google.android.gms.drive.internal.zzau;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.zze;
import com.google.android.gms.internal.zzst;
import com.google.android.gms.internal.zzsu;

public class DriveId
implements SafeParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zze();
    final int mVersionCode;
    final String zzaoL;
    final long zzaoM;
    final long zzaou;
    final int zzaoN;
    private volatile String zzaow = null;
    private volatile String zzaoO = null;

    public static DriveId zzcW(String string) {
        zzx.zzz((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzaoL;
    }

    public int getResourceType() {
        return this.zzaoN;
    }

    public DriveFile asDriveFile() {
        if (this.zzaoN == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzw(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.zzaoN == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzy(this);
    }

    public DriveResource asDriveResource() {
        if (this.zzaoN == 1) {
            return this.asDriveFolder();
        }
        if (this.zzaoN == 0) {
            return this.asDriveFile();
        }
        return new zzab(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zze.zza(this, out, flags);
    }

    DriveId(int versionCode, String resourceId, long sqlId, long databaseInstanceId, int resourceType) {
        this.mVersionCode = versionCode;
        this.zzaoL = resourceId;
        zzx.zzac((!"".equals(resourceId) ? 1 : 0) != 0);
        zzx.zzac((resourceId != null || sqlId != -1L ? 1 : 0) != 0);
        this.zzaoM = sqlId;
        this.zzaou = databaseInstanceId;
        this.zzaoN = resourceType;
    }

    public DriveId(String resourceId, long sqlId, long databaseInstanceId, int resourceType) {
        this(1, resourceId, sqlId, databaseInstanceId, resourceType);
    }

    public int hashCode() {
        if (this.zzaoM == -1L) {
            return this.zzaoL.hashCode();
        }
        return (String.valueOf(this.zzaou) + String.valueOf(this.zzaoM)).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)obj;
        if (driveId.zzaou != this.zzaou) {
            return false;
        }
        if (driveId.zzaoM == -1L && this.zzaoM == -1L) {
            return driveId.zzaoL.equals(this.zzaoL);
        }
        if (this.zzaoL == null || driveId.zzaoL == null) {
            return driveId.zzaoM == this.zzaoM;
        }
        if (driveId.zzaoM == this.zzaoM) {
            if (driveId.zzaoL.equals(this.zzaoL)) {
                return true;
            }
            zzz.zzz("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzaow == null) {
            byte[] byArray = this.zzsu();
            String string = Base64.encodeToString((byte[])byArray, (int)10);
            this.zzaow = "DriveId:" + string;
        }
        return this.zzaow;
    }

    public final String toInvariantString() {
        if (this.zzaoO == null) {
            byte[] byArray = this.zzsA();
            this.zzaoO = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzaoO;
    }

    final byte[] zzsu() {
        zzat zzat2 = new zzat();
        zzat2.versionCode = this.mVersionCode;
        zzat2.zzarY = this.zzaoL == null ? "" : this.zzaoL;
        zzat2.zzarZ = this.zzaoM;
        zzat2.zzarW = this.zzaou;
        zzat2.zzasa = this.zzaoN;
        byte[] byArray = zzsu.toByteArray((zzsu)zzat2);
        return byArray;
    }

    private byte[] zzsA() {
        zzau zzau2 = new zzau();
        zzau2.zzarZ = this.zzaoM;
        zzau2.zzarW = this.zzaou;
        byte[] byArray = zzsu.toByteArray((zzsu)zzau2);
        return byArray;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String s) {
        zzx.zzb((boolean)s.startsWith("DriveId:"), (Object)("Invalid DriveId: " + s));
        String string = s.substring("DriveId:".length());
        byte[] byArray = Base64.decode((String)string, (int)10);
        return DriveId.zzl(byArray);
    }

    static DriveId zzl(byte[] byArray) {
        zzat zzat2;
        try {
            zzat2 = zzat.zzm(byArray);
        }
        catch (zzst zzst2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzat2.zzarY) ? null : zzat2.zzarY;
        DriveId driveId = new DriveId(zzat2.versionCode, string, zzat2.zzarZ, zzat2.zzarW, zzat2.zzasa);
        return driveId;
    }
}

