/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zznm;
import com.google.android.gms.internal.zzno;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet zzapd = new MetadataChangeSet(MetadataBundle.zztE());
    private final MetadataBundle zzape;

    public MetadataChangeSet(MetadataBundle bag) {
        this.zzape = bag.zztF();
    }

    public Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzape.zza(zznm.zzasW);
        return appVisibleCustomProperties == null ? Collections.emptyMap() : appVisibleCustomProperties.zztz();
    }

    public String getDescription() {
        return this.zzape.zza(zznm.zzasX);
    }

    public String getIndexableText() {
        return this.zzape.zza(zznm.zzatd);
    }

    public Date getLastViewedByMeDate() {
        return this.zzape.zza(zzno.zzatN);
    }

    public String getMimeType() {
        return this.zzape.zza(zznm.zzatr);
    }

    public String getTitle() {
        return this.zzape.zza(zznm.zzatA);
    }

    public Boolean isPinned() {
        return this.zzape.zza(zznm.zzatj);
    }

    public Boolean isStarred() {
        return this.zzape.zza(zznm.zzaty);
    }

    public Boolean isViewed() {
        return this.zzape.zza(zznm.zzatq);
    }

    public MetadataBundle zzsL() {
        return this.zzape;
    }

    public MetadataChangeSet zzsM() {
        return new MetadataChangeSet(this.zzsL());
    }

    public <T> MetadataChangeSet zza(MetadataField<T> metadataField, T t) {
        MetadataChangeSet metadataChangeSet = this.zzsM();
        metadataChangeSet.zzsL().zzc(metadataField, t);
        return metadataChangeSet;
    }

    public static class Builder {
        private final MetadataBundle zzape = MetadataBundle.zztE();
        private AppVisibleCustomProperties.zza zzapf;

        private AppVisibleCustomProperties.zza zzsN() {
            if (this.zzapf == null) {
                this.zzapf = new AppVisibleCustomProperties.zza();
            }
            return this.zzapf;
        }

        private int zzda(String string) {
            return string == null ? 0 : string.getBytes().length;
        }

        private String zzj(String string, int n, int n2) {
            return String.format("%s must be no more than %d bytes, but is %d bytes.", string, n, n2);
        }

        private void zzk(String string, int n, int n2) {
            zzx.zzb((n2 <= n ? 1 : 0) != 0, (Object)this.zzj(string, n, n2));
        }

        public Builder setCustomProperty(CustomPropertyKey key, String value) {
            zzx.zzb((Object)key, (Object)"key");
            zzx.zzb((Object)value, (Object)"value");
            int n = this.zzda(key.getKey()) + this.zzda(value);
            this.zzk("The total size of key string and value string of a custom property", 124, n);
            this.zzsN().zza(key, value);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey key) {
            zzx.zzb((Object)key, (Object)"key");
            this.zzsN().zza(key, null);
            return this;
        }

        public Builder setDescription(String description) {
            this.zzape.zzc(zznm.zzasX, description);
            return this;
        }

        public Builder setIndexableText(String text) {
            int n = this.zzda(text);
            this.zzk("Indexable text size", 131072, n);
            this.zzape.zzc(zznm.zzatd, text);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzape.zzc(zzno.zzatN, date);
            return this;
        }

        public Builder setMimeType(String mimeType) {
            this.zzape.zzc(zznm.zzatr, mimeType);
            return this;
        }

        public Builder setPinned(boolean pinned) {
            this.zzape.zzc(zznm.zzatj, pinned);
            return this;
        }

        public Builder setStarred(boolean starred) {
            this.zzape.zzc(zznm.zzaty, starred);
            return this;
        }

        public Builder setTitle(String title) {
            this.zzape.zzc(zznm.zzatA, title);
            return this;
        }

        public Builder setViewed(boolean viewed) {
            this.zzape.zzc(zznm.zzatq, viewed);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzapf != null) {
                this.zzape.zzc(zznm.zzasW, this.zzapf.zztA());
            }
            return new MetadataChangeSet(this.zzape);
        }
    }
}

