/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.annotation.SuppressLint;
import android.os.RemoteException;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.internal.CreateContentsRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.OnListEntriesResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.QueryRequest;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzbu;
import com.google.android.gms.drive.internal.zzp;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzv;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.query.Query;
import java.util.List;

public class zzs
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient apiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return apiClient.zza((zza.zza)new zzh(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new QueryRequest(query), (zzan)new zzi((zza.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> newDriveContents(GoogleApiClient apiClient) {
        return this.zza(apiClient, 0x20000000);
    }

    public PendingResult<DriveApi.DriveContentsResult> zza(GoogleApiClient googleApiClient, final int n) {
        return googleApiClient.zza((zza.zza)new zzc(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new CreateContentsRequest(n), (zzan)new zza((zza.zzb<DriveApi.DriveContentsResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient apiClient, final String resourceId) {
        return apiClient.zza((zza.zza)new zzf(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new GetMetadataRequest(DriveId.zzcW(resourceId), false), (zzan)new zzd((zza.zzb<DriveApi.DriveIdResult>)this));
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzw(driveId);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzy(driveId);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient apiClient) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzUI);
        if (!zzu2.zzth()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzu2.zztf();
        return driveId != null ? new zzy(driveId) : null;
    }

    @Override
    public DriveFolder getAppFolder(GoogleApiClient apiClient) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzUI);
        if (!zzu2.zzth()) {
            throw new IllegalStateException("Client is not yet connected");
        }
        DriveId driveId = zzu2.zztg();
        return driveId != null ? new zzy(driveId) : null;
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient apiClient) {
        return apiClient.zzb((zza.zza)new zzt.zza(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzte().zza(new zzbu((zza.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<BooleanResult> isAutobackupEnabled(GoogleApiClient apiClient) {
        return apiClient.zza((zza.zza)new zzt<BooleanResult>(apiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                final 5 var2_2 = this;
                zzu2.zzte().zze(new com.google.android.gms.drive.internal.zzd(){

                    @Override
                    public void zzaf(boolean bl) {
                        var2_2.zza((Result)new BooleanResult(Status.zzagC, bl));
                    }
                });
            }

            protected BooleanResult zzA(Status status) {
                return new BooleanResult(status, false);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzA(status);
            }
        });
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, List<String> trackingTags) {
        zzu zzu2 = (zzu)apiClient.zza(Drive.zzUI);
        return zzu2.cancelPendingActions(apiClient, trackingTags);
    }

    private static class zzi
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveApi.MetadataBufferResult> zzamC;

        public zzi(zza.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzamC = zzb2;
        }

        @Override
        public void zza(OnListEntriesResponse onListEntriesResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListEntriesResponse.zztt());
            this.zzamC.zzs((Object)new zzg(Status.zzagC, metadataBuffer, onListEntriesResponse.zztu()));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzamC.zzs((Object)new zzg(status, null, false));
        }
    }

    static class zzg
    implements DriveApi.MetadataBufferResult {
        private final Status zzUX;
        private final MetadataBuffer zzaqI;
        private final boolean zzaqJ;

        public zzg(Status status, MetadataBuffer metadataBuffer, boolean bl) {
            this.zzUX = status;
            this.zzaqI = metadataBuffer;
            this.zzaqJ = bl;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public MetadataBuffer getMetadataBuffer() {
            return this.zzaqI;
        }

        public void release() {
            if (this.zzaqI != null) {
                this.zzaqI.release();
            }
        }
    }

    static abstract class zzh
    extends zzt<DriveApi.MetadataBufferResult> {
        zzh(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.MetadataBufferResult zzD(Status status) {
            return new zzg(status, null, false);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzD(status);
        }
    }

    static class zzd
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveApi.DriveIdResult> zzamC;

        public zzd(zza.zzb<DriveApi.DriveIdResult> zzb2) {
            this.zzamC = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzamC.zzs((Object)new zze(Status.zzagC, new zzp(onMetadataResponse.zztw()).getDriveId()));
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzamC.zzs((Object)new zze(Status.zzagC, onDriveIdResponse.getDriveId()));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzamC.zzs((Object)new zze(status, null));
        }
    }

    private static class zze
    implements DriveApi.DriveIdResult {
        private final Status zzUX;
        private final DriveId zzaoz;

        public zze(Status status, DriveId driveId) {
            this.zzUX = status;
            this.zzaoz = driveId;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public DriveId getDriveId() {
            return this.zzaoz;
        }
    }

    static abstract class zzf
    extends zzt<DriveApi.DriveIdResult> {
        zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveIdResult zzC(Status status) {
            return new zze(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzC(status);
        }
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveApi.DriveContentsResult> zzamC;

        public zza(zza.zzb<DriveApi.DriveContentsResult> zzb2) {
            this.zzamC = zzb2;
        }

        @Override
        public void zza(OnContentsResponse onContentsResponse) throws RemoteException {
            this.zzamC.zzs((Object)new zzb(Status.zzagC, new zzv(onContentsResponse.zztn())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.zzamC.zzs((Object)new zzb(status, null));
        }
    }

    static class zzb
    implements Releasable,
    DriveApi.DriveContentsResult {
        private final Status zzUX;
        private final DriveContents zzaoC;

        public zzb(Status status, DriveContents driveContents) {
            this.zzUX = status;
            this.zzaoC = driveContents;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public DriveContents getDriveContents() {
            return this.zzaoC;
        }

        public void release() {
            if (this.zzaoC != null) {
                this.zzaoC.zzsy();
            }
        }
    }

    static abstract class zzc
    extends zzt<DriveApi.DriveContentsResult> {
        zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveContentsResult zzB(Status status) {
            return new zzb(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzB(status);
        }
    }

    @SuppressLint(value={"MissingRemoteException"})
    static class zzj
    extends zzt.zza {
        zzj(GoogleApiClient googleApiClient, Status status) {
            super(googleApiClient);
            this.zza((Result)status);
        }

        protected void zza(zzu zzu2) {
        }
    }
}

