/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.zzms;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzZC;
    private final String zzWQ;
    private final String zzaCa;
    private final String zzaCb;
    private final String zzaxl;
    private final String zzaCc;
    private final Uri zzaCd;
    private final Uri zzaCe;
    private final Uri zzaCf;
    private final boolean zzaCg;
    private final boolean zzaCh;
    private final String zzaCi;
    private final int zzaCj;
    private final int zzaCk;
    private final int zzaCl;
    private final boolean zzaCm;
    private final boolean zzaCn;
    private final String zzaCo;
    private final String zzaCp;
    private final String zzaCq;
    private final boolean zzDZ;
    private final boolean zzaCr;
    private final boolean zzaCs;
    private final String zzaCt;
    private final boolean zzaCu;

    public GameEntity(Game game) {
        this.mVersionCode = 7;
        this.zzZC = game.getApplicationId();
        this.zzaCa = game.getPrimaryCategory();
        this.zzaCb = game.getSecondaryCategory();
        this.zzaxl = game.getDescription();
        this.zzaCc = game.getDeveloperName();
        this.zzWQ = game.getDisplayName();
        this.zzaCd = game.getIconImageUri();
        this.zzaCo = game.getIconImageUrl();
        this.zzaCe = game.getHiResImageUri();
        this.zzaCp = game.getHiResImageUrl();
        this.zzaCf = game.getFeaturedImageUri();
        this.zzaCq = game.getFeaturedImageUrl();
        this.zzaCg = game.zzvx();
        this.zzaCh = game.zzvz();
        this.zzaCi = game.zzvA();
        this.zzaCj = game.zzvB();
        this.zzaCk = game.getAchievementTotalCount();
        this.zzaCl = game.getLeaderboardCount();
        this.zzaCm = game.isRealTimeMultiplayerEnabled();
        this.zzaCn = game.isTurnBasedMultiplayerEnabled();
        this.zzDZ = game.isMuted();
        this.zzaCr = game.zzvy();
        this.zzaCs = game.areSnapshotsEnabled();
        this.zzaCt = game.getThemeColor();
        this.zzaCu = game.hasGamepadSupport();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled, String themeColor, boolean hasGamepadSupport) {
        this.mVersionCode = versionCode;
        this.zzZC = applicationId;
        this.zzWQ = displayName;
        this.zzaCa = primaryCategory;
        this.zzaCb = secondaryCategory;
        this.zzaxl = description;
        this.zzaCc = developerName;
        this.zzaCd = iconImageUri;
        this.zzaCo = iconImageUrl;
        this.zzaCe = hiResImageUri;
        this.zzaCp = hiResImageUrl;
        this.zzaCf = featuredImageUri;
        this.zzaCq = featuredImageUrl;
        this.zzaCg = playEnabledGame;
        this.zzaCh = instanceInstalled;
        this.zzaCi = instancePackageName;
        this.zzaCj = gameplayAclStatus;
        this.zzaCk = achievementTotalCount;
        this.zzaCl = leaderboardCount;
        this.zzaCm = realTimeEnabled;
        this.zzaCn = turnBasedEnabled;
        this.zzDZ = muted;
        this.zzaCr = identitySharingConfirmed;
        this.zzaCs = snapshotsEnabled;
        this.zzaCt = themeColor;
        this.zzaCu = hasGamepadSupport;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getApplicationId() {
        return this.zzZC;
    }

    @Override
    public String getDisplayName() {
        return this.zzWQ;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzWQ, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.zzaCa;
    }

    @Override
    public String getSecondaryCategory() {
        return this.zzaCb;
    }

    @Override
    public String getDescription() {
        return this.zzaxl;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzaxl, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.zzaCc;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzaCc, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaCd;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaCo;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzaCe;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzaCp;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzaCf;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.zzaCq;
    }

    @Override
    public boolean isMuted() {
        return this.zzDZ;
    }

    @Override
    public boolean zzvy() {
        return this.zzaCr;
    }

    @Override
    public boolean zzvx() {
        return this.zzaCg;
    }

    @Override
    public boolean zzvz() {
        return this.zzaCh;
    }

    @Override
    public String zzvA() {
        return this.zzaCi;
    }

    @Override
    public int zzvB() {
        return this.zzaCj;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.zzaCk;
    }

    @Override
    public int getLeaderboardCount() {
        return this.zzaCl;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.zzaCm;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.zzaCn;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.zzaCs;
    }

    @Override
    public String getThemeColor() {
        return this.zzaCt;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.zzaCu;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzw.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzvx(), game.zzvz(), game.zzvA(), game.zzvB(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzvy(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object obj) {
        return GameEntity.zza(this, obj);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzw.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzw.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzw.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzw.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzw.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzw.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzw.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzw.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzw.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzw.equal((Object)game2.zzvx(), (Object)game.zzvx()) && zzw.equal((Object)game2.zzvz(), (Object)game.zzvz()) && zzw.equal((Object)game2.zzvA(), (Object)game.zzvA()) && zzw.equal((Object)game2.zzvB(), (Object)game.zzvB()) && zzw.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzw.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzw.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzw.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzw.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzw.equal((Object)game2.zzvy(), (Object)game.zzvy()) ? 1 : 0)) && zzw.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzw.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzw.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzw.zzy((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzvx()).zzg("InstanceInstalled", (Object)game.zzvz()).zzg("InstancePackageName", (Object)game.zzvA()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzqC()) {
            GameEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzZC);
            dest.writeString(this.zzWQ);
            dest.writeString(this.zzaCa);
            dest.writeString(this.zzaCb);
            dest.writeString(this.zzaxl);
            dest.writeString(this.zzaCc);
            dest.writeString(this.zzaCd == null ? null : this.zzaCd.toString());
            dest.writeString(this.zzaCe == null ? null : this.zzaCe.toString());
            dest.writeString(this.zzaCf == null ? null : this.zzaCf.toString());
            dest.writeInt(this.zzaCg ? 1 : 0);
            dest.writeInt(this.zzaCh ? 1 : 0);
            dest.writeString(this.zzaCi);
            dest.writeInt(this.zzaCj);
            dest.writeInt(this.zzaCk);
            dest.writeInt(this.zzaCl);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzea(Parcel parcel) {
            boolean bl = GameEntity.zzd(GameEntity.zzqB());
            if (bl || GameEntity.zzcF((String)GameEntity.class.getCanonicalName())) {
                return super.zzea(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            String string14 = null;
            boolean bl9 = false;
            return new GameEntity(7, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, bl4, bl5, string11, string12, string13, bl6, bl7, bl8, string14, bl9);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzea(parcel);
        }
    }
}

