/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.AchievementsImpl;
import com.google.android.gms.games.internal.api.AclsImpl;
import com.google.android.gms.games.internal.api.AppContentsImpl;
import com.google.android.gms.games.internal.api.EventsImpl;
import com.google.android.gms.games.internal.api.GamesMetadataImpl;
import com.google.android.gms.games.internal.api.InvitationsImpl;
import com.google.android.gms.games.internal.api.LeaderboardsImpl;
import com.google.android.gms.games.internal.api.MultiplayerImpl;
import com.google.android.gms.games.internal.api.NotificationsImpl;
import com.google.android.gms.games.internal.api.PlayersImpl;
import com.google.android.gms.games.internal.api.QuestsImpl;
import com.google.android.gms.games.internal.api.RealTimeMultiplayerImpl;
import com.google.android.gms.games.internal.api.RequestsImpl;
import com.google.android.gms.games.internal.api.SnapshotsImpl;
import com.google.android.gms.games.internal.api.StatsImpl;
import com.google.android.gms.games.internal.api.TurnBasedMultiplayerImpl;
import com.google.android.gms.games.internal.api.VideosImpl;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.Videos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    public static final String EXTRA_STATUS = "status";
    static final Api.zzc<GamesClientImpl> zzUI = new Api.zzc();
    private static final Api.zza<GamesClientImpl, GamesOptions> zzUJ = new GamesClientBuilder(){

        public List<Scope> zza(GamesOptions gamesOptions) {
            return Collections.singletonList(SCOPE_GAMES);
        }

        public /* synthetic */ List zzo(Object object) {
            return this.zza((GamesOptions)object);
        }
    };
    private static final Api.zza<GamesClientImpl, GamesOptions> zzaCv = new GamesClientBuilder(){

        public List<Scope> zza(GamesOptions gamesOptions) {
            return Collections.singletonList(zzaCw);
        }

        public /* synthetic */ List zzo(Object object) {
            return this.zza((GamesOptions)object);
        }
    };
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Api<GamesOptions> API = new Api("Games.API", zzUJ, zzUI);
    public static final Scope zzaCw = new Scope("https://www.googleapis.com/auth/games.firstparty");
    public static final Api<GamesOptions> zzaCx = new Api("Games.API_1P", zzaCv, zzUI);
    public static final GamesMetadata GamesMetadata = new GamesMetadataImpl();
    public static final Achievements Achievements = new AchievementsImpl();
    public static final AppContents zzaCy = new AppContentsImpl();
    public static final Events Events = new EventsImpl();
    public static final Leaderboards Leaderboards = new LeaderboardsImpl();
    public static final Invitations Invitations = new InvitationsImpl();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new TurnBasedMultiplayerImpl();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new RealTimeMultiplayerImpl();
    public static final Multiplayer zzaCz = new MultiplayerImpl();
    public static final Players Players = new PlayersImpl();
    public static final Notifications Notifications = new NotificationsImpl();
    public static final Quests Quests = new QuestsImpl();
    public static final Requests Requests = new RequestsImpl();
    public static final Snapshots Snapshots = new SnapshotsImpl();
    public static final Stats Stats = new StatsImpl();
    public static final Videos zzaCA = new VideosImpl();
    public static final Acls zzaCB = new AclsImpl();

    private Games() {
    }

    public static GamesClientImpl zzh(GoogleApiClient googleApiClient) {
        return Games.zzb(googleApiClient, true);
    }

    public static GamesClientImpl zzb(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzx.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return Games.zzc(googleApiClient, bl);
    }

    public static GamesClientImpl zzc(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Games.API and is not connected to Games. Use GoogleApiClient.hasConnectedApi(Games.API) to guard this call.");
        }
        return bl2 ? (GamesClientImpl)googleApiClient.zza(zzUI) : null;
    }

    public static void setGravityForPopups(GoogleApiClient apiClient, int gravity) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzgs(gravity);
        }
    }

    public static void setViewForPopups(GoogleApiClient apiClient, View gamesContentView) {
        zzx.zzz((Object)gamesContentView);
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzo(gamesContentView);
        }
    }

    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    public static String getCurrentAccountName(GoogleApiClient apiClient) {
        return Games.zzh(apiClient).zzww();
    }

    @Deprecated
    public static PendingResult<GetServerAuthCodeResult> getGamesServerAuthCode(GoogleApiClient apiClient, final String serverClientId) {
        zzx.zzh((String)serverClientId, (Object)"Please provide a valid serverClientId");
        return apiClient.zzb((zza.zza)new GetServerAuthCodeImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb(serverClientId, (zza.zzb<GetServerAuthCodeResult>)this);
            }
        });
    }

    public static String getAppId(GoogleApiClient apiClient) {
        return Games.zzh(apiClient).zzwK();
    }

    public static Intent getSettingsIntent(GoogleApiClient apiClient) {
        return Games.zzh(apiClient).zzwI();
    }

    public static PendingResult<Status> signOut(GoogleApiClient apiClient) {
        return apiClient.zzb((zza.zza)new SignOutImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzf((zza.zzb<Status>)this);
            }
        });
    }

    public static int getSdkVariant(GoogleApiClient apiClient) {
        return Games.zzh(apiClient).zzwJ();
    }

    public static interface LoadExperimentsResult
    extends Result {
    }

    private static abstract class SignOutImpl
    extends BaseGamesApiMethodImpl<Status> {
        private SignOutImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class GetServerAuthCodeImpl
    extends BaseGamesApiMethodImpl<GetServerAuthCodeResult> {
        private GetServerAuthCodeImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public GetServerAuthCodeResult zzX(final Status status) {
            return new GetServerAuthCodeResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public String getCode() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzX(status);
        }
    }

    private static abstract class GetTokenImpl
    extends BaseGamesApiMethodImpl<GetTokenResult> {
        public GetTokenResult zzY(final Status status) {
            return new GetTokenResult(){

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzY(status);
        }
    }

    @Deprecated
    public static interface GetServerAuthCodeResult
    extends Result {
        public String getCode();
    }

    public static interface GetTokenResult
    extends Result {
    }

    public static abstract class BaseGamesApiMethodImpl<R extends Result>
    extends zza.zza<R, GamesClientImpl> {
        public BaseGamesApiMethodImpl(GoogleApiClient googleApiClient) {
            super(zzUI, googleApiClient);
        }
    }

    private static abstract class GamesClientBuilder
    extends Api.zza<GamesClientImpl, GamesOptions> {
        private GamesClientBuilder() {
        }

        public GamesClientImpl zza(Context context, Looper looper, zzf zzf2, GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions();
            }
            return new GamesClientImpl(context, looper, zzf2, gamesOptions, connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return 1;
        }
    }

    public static final class GamesOptions
    implements Api.ApiOptions.Optional {
        public final boolean zzaCE;
        public final boolean zzaCF;
        public final int zzaCG;
        public final boolean zzaCH;
        public final int zzaCI;
        public final String zzaCJ;
        public final ArrayList<String> zzaCK;
        public final boolean zzaCL;

        private GamesOptions() {
            this.zzaCE = false;
            this.zzaCF = true;
            this.zzaCG = 17;
            this.zzaCH = false;
            this.zzaCI = 4368;
            this.zzaCJ = null;
            this.zzaCK = new ArrayList();
            this.zzaCL = false;
        }

        private GamesOptions(Builder builder) {
            this.zzaCE = builder.zzaCE;
            this.zzaCF = builder.zzaCF;
            this.zzaCG = builder.zzaCG;
            this.zzaCH = builder.zzaCH;
            this.zzaCI = builder.zzaCI;
            this.zzaCJ = builder.zzaCJ;
            this.zzaCK = builder.zzaCK;
            this.zzaCL = builder.zzaCL;
        }

        public Bundle zzvD() {
            Bundle bundle = new Bundle();
            bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.zzaCE);
            bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.zzaCF);
            bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.zzaCG);
            bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.zzaCH);
            bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.zzaCI);
            bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.zzaCJ);
            bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.zzaCK);
            bundle.putBoolean("com.google.android.gms.games.key.requireGooglePlus", this.zzaCL);
            return bundle;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            boolean zzaCE = false;
            boolean zzaCF = true;
            int zzaCG = 17;
            boolean zzaCH = false;
            int zzaCI = 4368;
            String zzaCJ = null;
            ArrayList<String> zzaCK = new ArrayList();
            boolean zzaCL = false;

            private Builder() {
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup) {
                this.zzaCF = showConnectingPopup;
                this.zzaCG = 17;
                return this;
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup, int gravity) {
                this.zzaCF = showConnectingPopup;
                this.zzaCG = gravity;
                return this;
            }

            public Builder setRequireGooglePlus(boolean requireGooglePlus) {
                this.zzaCL = requireGooglePlus;
                return this;
            }

            public Builder setSdkVariant(int variant) {
                this.zzaCI = variant;
                return this;
            }

            public GamesOptions build() {
                return new GamesOptions(this);
            }
        }
    }
}

