/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntity;

public final class AchievementRef
extends zzc
implements Achievement {
    AchievementRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
    }

    @Override
    public String getAchievementId() {
        return this.getString("external_achievement_id");
    }

    @Override
    public int getType() {
        return this.getInteger("type");
    }

    @Override
    public String getName() {
        return this.getString("name");
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        this.zza("name", dataOut);
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        this.zza("description", dataOut);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.zzcA("unlocked_icon_image_uri");
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.getString("unlocked_icon_image_url");
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.zzcA("revealed_icon_image_uri");
    }

    @Override
    public String getRevealedImageUrl() {
        return this.getString("revealed_icon_image_url");
    }

    @Override
    public int getTotalSteps() {
        zzb.zzab((this.getType() == 1 ? 1 : 0) != 0);
        return this.getInteger("total_steps");
    }

    @Override
    public String getFormattedTotalSteps() {
        zzb.zzab((this.getType() == 1 ? 1 : 0) != 0);
        return this.getString("formatted_total_steps");
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer dataOut) {
        zzb.zzab((this.getType() == 1 ? 1 : 0) != 0);
        this.zza("formatted_total_steps", dataOut);
    }

    @Override
    public Player getPlayer() {
        return new PlayerRef(this.zzahi, this.zzaje);
    }

    @Override
    public int getState() {
        return this.getInteger("state");
    }

    @Override
    public int getCurrentSteps() {
        zzb.zzab((this.getType() == 1 ? 1 : 0) != 0);
        return this.getInteger("current_steps");
    }

    @Override
    public String getFormattedCurrentSteps() {
        zzb.zzab((this.getType() == 1 ? 1 : 0) != 0);
        return this.getString("formatted_current_steps");
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer dataOut) {
        zzb.zzab((this.getType() == 1 ? 1 : 0) != 0);
        this.zza("formatted_current_steps", dataOut);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.getLong("last_updated_timestamp");
    }

    @Override
    public long getXpValue() {
        if (!this.zzcz("instance_xp_value") || this.zzcB("instance_xp_value")) {
            return this.getLong("definition_xp_value");
        }
        return this.getLong("instance_xp_value");
    }

    public Achievement freeze() {
        return new AchievementEntity(this);
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AchievementEntity achievementEntity = (AchievementEntity)this.freeze();
        achievementEntity.writeToParcel(dest, flags);
    }
}

