/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.appcontent;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.appcontent.AppContentAction;
import com.google.android.gms.games.appcontent.AppContentActionEntity;
import com.google.android.gms.games.appcontent.AppContentAnnotation;
import com.google.android.gms.games.appcontent.AppContentAnnotationEntity;
import com.google.android.gms.games.appcontent.AppContentCard;
import com.google.android.gms.games.appcontent.AppContentCardEntityCreator;
import com.google.android.gms.games.appcontent.AppContentCondition;
import com.google.android.gms.games.appcontent.AppContentConditionEntity;
import java.util.ArrayList;
import java.util.List;

public final class AppContentCardEntity
implements SafeParcelable,
AppContentCard {
    public static final AppContentCardEntityCreator CREATOR = new AppContentCardEntityCreator();
    private final int mVersionCode;
    private final ArrayList<AppContentActionEntity> mActions;
    private final ArrayList<AppContentAnnotationEntity> zzaDF;
    private final ArrayList<AppContentConditionEntity> zzaDv;
    private final String zzaDw;
    private final int zzaDG;
    private final String zzaxl;
    private final Bundle mExtras;
    private final String zzaDH;
    private final String zzapg;
    private final int zzaDI;
    private final String zzJN;
    private final String zzyv;

    public AppContentCardEntity(AppContentCard card) {
        this.mVersionCode = 4;
        this.zzaDw = card.zzvQ();
        this.zzaDG = card.zzwb();
        this.zzaxl = card.getDescription();
        this.mExtras = card.getExtras();
        this.zzyv = card.getId();
        this.zzapg = card.getTitle();
        this.zzaDH = card.zzwc();
        this.zzaDI = card.zzwd();
        this.zzJN = card.getType();
        List<AppContentAction> list = card.getActions();
        int n = list.size();
        this.mActions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.mActions.add((AppContentActionEntity)list.get(i).freeze());
        }
        List<AppContentAnnotation> list2 = card.zzwa();
        int n2 = list2.size();
        this.zzaDF = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            this.zzaDF.add((AppContentAnnotationEntity)list2.get(i).freeze());
        }
        List<AppContentCondition> list3 = card.zzvP();
        int n3 = list3.size();
        this.zzaDv = new ArrayList(n3);
        for (int i = 0; i < n3; ++i) {
            this.zzaDv.add((AppContentConditionEntity)list3.get(i).freeze());
        }
    }

    AppContentCardEntity(int versionCode, ArrayList<AppContentActionEntity> actions, ArrayList<AppContentAnnotationEntity> annotations, ArrayList<AppContentConditionEntity> conditions, String contentDescription, int currentProgress, String description, Bundle extras, String subtitle, String title, int totalProgress, String type, String id) {
        this.mVersionCode = versionCode;
        this.mActions = actions;
        this.zzaDF = annotations;
        this.zzaDv = conditions;
        this.zzaDw = contentDescription;
        this.zzaDG = currentProgress;
        this.zzaxl = description;
        this.mExtras = extras;
        this.zzyv = id;
        this.zzaDH = subtitle;
        this.zzapg = title;
        this.zzaDI = totalProgress;
        this.zzJN = type;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public List<AppContentAction> getActions() {
        return new ArrayList<AppContentAction>(this.mActions);
    }

    @Override
    public List<AppContentAnnotation> zzwa() {
        return new ArrayList<AppContentAnnotation>(this.zzaDF);
    }

    @Override
    public List<AppContentCondition> zzvP() {
        return new ArrayList<AppContentCondition>(this.zzaDv);
    }

    @Override
    public String zzvQ() {
        return this.zzaDw;
    }

    @Override
    public int zzwb() {
        return this.zzaDG;
    }

    @Override
    public String getDescription() {
        return this.zzaxl;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public String getId() {
        return this.zzyv;
    }

    @Override
    public String zzwc() {
        return this.zzaDH;
    }

    @Override
    public String getTitle() {
        return this.zzapg;
    }

    @Override
    public int zzwd() {
        return this.zzaDI;
    }

    @Override
    public String getType() {
        return this.zzJN;
    }

    public AppContentCard zzwe() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AppContentCardEntity.zza(this);
    }

    static int zza(AppContentCard appContentCard) {
        return zzw.hashCode((Object[])new Object[]{appContentCard.getActions(), appContentCard.zzwa(), appContentCard.zzvP(), appContentCard.zzvQ(), appContentCard.zzwb(), appContentCard.getDescription(), appContentCard.getExtras(), appContentCard.getId(), appContentCard.zzwc(), appContentCard.getTitle(), appContentCard.zzwd(), appContentCard.getType()});
    }

    public boolean equals(Object obj) {
        return AppContentCardEntity.zza(this, obj);
    }

    static boolean zza(AppContentCard appContentCard, Object object) {
        if (!(object instanceof AppContentCard)) {
            return false;
        }
        if (appContentCard == object) {
            return true;
        }
        AppContentCard appContentCard2 = (AppContentCard)object;
        return zzw.equal(appContentCard2.getActions(), appContentCard.getActions()) && zzw.equal(appContentCard2.zzwa(), appContentCard.zzwa()) && zzw.equal(appContentCard2.zzvP(), appContentCard.zzvP()) && zzw.equal((Object)appContentCard2.zzvQ(), (Object)appContentCard.zzvQ()) && zzw.equal((Object)appContentCard2.zzwb(), (Object)appContentCard.zzwb()) && zzw.equal((Object)appContentCard2.getDescription(), (Object)appContentCard.getDescription()) && zzw.equal((Object)appContentCard2.getExtras(), (Object)appContentCard.getExtras()) && zzw.equal((Object)appContentCard2.getId(), (Object)appContentCard.getId()) && zzw.equal((Object)appContentCard2.zzwc(), (Object)appContentCard.zzwc()) && zzw.equal((Object)appContentCard2.getTitle(), (Object)appContentCard.getTitle()) && zzw.equal((Object)appContentCard2.zzwd(), (Object)appContentCard.zzwd()) && zzw.equal((Object)appContentCard2.getType(), (Object)appContentCard.getType());
    }

    public String toString() {
        return AppContentCardEntity.zzb(this);
    }

    static String zzb(AppContentCard appContentCard) {
        return zzw.zzy((Object)appContentCard).zzg("Actions", appContentCard.getActions()).zzg("Annotations", appContentCard.zzwa()).zzg("Conditions", appContentCard.zzvP()).zzg("ContentDescription", (Object)appContentCard.zzvQ()).zzg("CurrentSteps", (Object)appContentCard.zzwb()).zzg("Description", (Object)appContentCard.getDescription()).zzg("Extras", (Object)appContentCard.getExtras()).zzg("Id", (Object)appContentCard.getId()).zzg("Subtitle", (Object)appContentCard.zzwc()).zzg("Title", (Object)appContentCard.getTitle()).zzg("TotalSteps", (Object)appContentCard.zzwd()).zzg("Type", (Object)appContentCard.getType()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        AppContentCardEntityCreator.zza(this, out, flags);
    }

    public /* synthetic */ Object freeze() {
        return this.zzwe();
    }
}

