/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.zzms;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int mVersionCode;
    private final String zzaDU;
    private final String mName;
    private final String zzaxl;
    private final Uri zzaCd;
    private final String zzaCo;
    private final PlayerEntity zzaDq;
    private final long zzaDV;
    private final String zzaDW;
    private final boolean zzsj;

    public EventEntity(Event event) {
        this.mVersionCode = 1;
        this.zzaDU = event.getEventId();
        this.mName = event.getName();
        this.zzaxl = event.getDescription();
        this.zzaCd = event.getIconImageUri();
        this.zzaCo = event.getIconImageUrl();
        this.zzaDq = (PlayerEntity)event.getPlayer().freeze();
        this.zzaDV = event.getValue();
        this.zzaDW = event.getFormattedValue();
        this.zzsj = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.mVersionCode = versionCode;
        this.zzaDU = eventId;
        this.mName = name;
        this.zzaxl = description;
        this.zzaCd = iconImageUri;
        this.zzaCo = iconImageUrl;
        this.zzaDq = new PlayerEntity(player);
        this.zzaDV = value;
        this.zzaDW = formattedValue;
        this.zzsj = isVisible;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.zzaDU;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzaxl;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzaxl, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaCd;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaCo;
    }

    @Override
    public Player getPlayer() {
        return this.zzaDq;
    }

    @Override
    public long getValue() {
        return this.zzaDV;
    }

    @Override
    public String getFormattedValue() {
        return this.zzaDW;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzaDW, (CharArrayBuffer)dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.zzsj;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzw.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object obj) {
        return EventEntity.zza(this, obj);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzw.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzw.equal((Object)event2.getName(), (Object)event.getName()) && zzw.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzw.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzw.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzw.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzw.equal((Object)event2.getValue(), (Object)event.getValue()) && zzw.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzw.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzw.zzy((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.zza(this, out, flags);
    }
}

