/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zze;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzq;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.AbstractGamesClient;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.PopupLocationInfoParcelable;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.PlayerStatsEntity;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.VideoBuffer;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.signin.internal.zzh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GamesClientImpl
extends zzj<IGamesService> {
    EventIncrementManager zzaDZ = new EventIncrementManager(){

        @Override
        public EventIncrementCache zzwS() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String zzaEa;
    private PlayerEntity zzaEb;
    private GameEntity zzaEc;
    private final PopupManager zzaEd;
    private boolean zzaEe = false;
    private final Binder zzaEf;
    private final long zzaEg;
    private final Games.GamesOptions zzaEh;

    public GamesClientImpl(Context context, Looper looper, com.google.android.gms.common.internal.zzf clientSettings, Games.GamesOptions options, GoogleApiClient.ConnectionCallbacks connectedListener, GoogleApiClient.OnConnectionFailedListener connectionFailedListener) {
        super(context, looper, 1, clientSettings, connectedListener, connectionFailedListener);
        this.zzaEa = clientSettings.zzqv();
        this.zzaEf = new Binder();
        this.zzaEd = PopupManager.zza(this, clientSettings.zzqr());
        this.zzo(clientSettings.zzqx());
        this.zzaEg = ((Object)((Object)this)).hashCode();
        this.zzaEh = options;
    }

    public boolean zzmE() {
        return true;
    }

    public void zza(@NonNull IGamesService iGamesService) {
        super.zza((IInterface)iGamesService);
        if (this.zzaEe) {
            this.zzaEd.zzxh();
            this.zzaEe = false;
        }
        if (!this.zzaEh.zzaCE) {
            this.zzb(iGamesService);
        }
    }

    public void onConnectionFailed(ConnectionResult result) {
        super.onConnectionFailed(result);
        this.zzaEe = false;
    }

    public void zzgs(int n) {
        this.zzaEd.setGravity(n);
    }

    public void zzo(View view) {
        this.zzaEd.zzp(view);
    }

    protected Set<Scope> zzb(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            zzx.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            zzx.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public void zza(GoogleApiClient.zza zza2) {
        this.zzwv();
        super.zza(zza2);
    }

    public void disconnect() {
        this.zzaEe = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.zzqJ();
                iGamesService.zzwR();
                this.zzaDZ.flush();
                iGamesService.zzF(this.zzaEg);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzz("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected String zzgu() {
        return "com.google.android.gms.games.service.START";
    }

    protected String zzgv() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService zzbV(IBinder iBinder) {
        return IGamesService.Stub.zzbY(iBinder);
    }

    public Bundle zzoi() {
        try {
            Bundle bundle = ((IGamesService)this.zzqJ()).zzoi();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    private void zzwv() {
        this.zzaEb = null;
        this.zzaEc = null;
    }

    protected Bundle zzml() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzaEh.zzvD();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzaEa);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzaEd.zzxj()));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 3);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzh.zza((com.google.android.gms.common.internal.zzf)this.zzqH()));
        return bundle;
    }

    public void zzb(IGamesService iGamesService) {
        try {
            PopupLocationInfoBinderCallbacks popupLocationInfoBinderCallbacks = new PopupLocationInfoBinderCallbacks(this.zzaEd);
            iGamesService.zza(popupLocationInfoBinderCallbacks, this.zzaEg);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public String zzww() {
        try {
            return ((IGamesService)this.zzqJ()).zzww();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zzd(zza.zzb<Games.GetTokenResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzk(new GetAuthTokenBinderCallbacks(zzb2));
    }

    public void zzb(String string, zza.zzb<Games.GetServerAuthCodeResult> zzb2) throws RemoteException {
        zzx.zzh((String)string, (Object)"Please provide a valid serverClientId");
        ((IGamesService)this.zzqJ()).zza(string, new GetServerAuthCodeBinderCallbacks(zzb2));
    }

    public String zzah(boolean bl) {
        if (bl && this.zzaEb != null) {
            return this.zzaEb.getPlayerId();
        }
        try {
            return ((IGamesService)this.zzqJ()).zzwT();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player zzwx() {
        this.zzqI();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaEb == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.zzqJ()).zzwU());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.zzaEb = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.zzaEb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game zzwy() {
        this.zzqI();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaEc == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.zzqJ()).zzwW());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.zzaEc = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzb(remoteException);
                }
            }
        }
        return this.zzaEc;
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzf((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), stringArray);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string);
            }
        }
        ((IGamesService)this.zzqJ()).zzd(new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string);
            }
        }
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zza(zza.zzb<Players.LoadPlayersResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), bl);
    }

    public Intent zzwz() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zzwz();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzl(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zzm(string, n, n2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzb(zza.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), bl);
    }

    public void zzb(zza.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzc((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zza.zzb<Leaderboards.LoadPlayerScoreResult> zzb2, String string, String string2, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(zzb2), string, string2, n, n2);
    }

    public void zza(zza.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zzb(zza.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzb((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zza(zza.zzb<Leaderboards.LoadScoresResult> zzb2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), leaderboardScoreBuffer.zzxJ().asBundle(), n, n2);
    }

    public void zza(zza.zzb<Leaderboards.SubmitScoreResult> zzb2, String string, long l, String string2) throws RemoteException {
        SubmitScoreBinderCallbacks submitScoreBinderCallbacks = zzb2 == null ? null : new SubmitScoreBinderCallbacks(zzb2);
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)submitScoreBinderCallbacks, string, l, string2);
    }

    public Intent zzwA() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zzwA();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzc(zza.zzb<Achievements.LoadAchievementsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zza.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzaEd.zzxj(), this.zzaEd.zzxi());
    }

    public void zzb(zza.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzqJ()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzaEd.zzxj(), this.zzaEd.zzxi());
    }

    public void zza(zza.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzaEd.zzxj(), this.zzaEd.zzxi());
    }

    public void zzb(zza.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzqJ()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzaEd.zzxj(), this.zzaEd.zzxi());
    }

    public void zzd(zza.zzb<Events.LoadEventsResult> zzb2, boolean bl) throws RemoteException {
        this.zzaDZ.flush();
        ((IGamesService)this.zzqJ()).zzf((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zza.zzb<Events.LoadEventsResult> zzb2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzaDZ.flush();
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl, stringArray);
    }

    public void zzp(String string, int n) {
        this.zzaDZ.zzp(string, n);
    }

    public Intent zzwB() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zzwB();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzwC() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zzwC();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzq<OnInvitationReceivedListener> zzq2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(zzq2);
            ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)invitationReceivedBinderCallback, this.zzaEg);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzwD() {
        try {
            ((IGamesService)this.zzqJ()).zzG(this.zzaEg);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzq<OnTurnBasedMatchUpdateReceivedListener> zzq2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(zzq2);
            ((IGamesService)this.zzqJ()).zzb((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.zzaEg);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzwE() {
        try {
            ((IGamesService)this.zzqJ()).zzH(this.zzaEg);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzc(zzq<QuestUpdateListener> zzq2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(zzq2);
            ((IGamesService)this.zzqJ()).zzd((IGamesCallbacks)questUpdateBinderCallback, this.zzaEg);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzwF() {
        try {
            ((IGamesService)this.zzqJ()).zzJ(this.zzaEg);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzd(zzq<OnRequestReceivedListener> zzq2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(zzq2);
            ((IGamesService)this.zzqJ()).zzc((IGamesCallbacks)requestReceivedBinderCallback, this.zzaEg);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzwG() {
        try {
            ((IGamesService)this.zzqJ()).zzI(this.zzaEg);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzwH() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zzwH();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzwI() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zzwI();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zze(zza.zzb<GamesMetadata.LoadGamesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzd(new GamesLoadedBinderCallback(zzb2));
    }

    public void zzf(zza.zzb<Status> zzb2) throws RemoteException {
        this.zzaDZ.flush();
        ((IGamesService)this.zzqJ()).zza(new SignOutCompleteBinderCallbacks(zzb2));
    }

    public int zzwJ() {
        int n = 4368;
        try {
            n = ((IGamesService)this.zzqJ()).zzwJ();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public String zzwK() {
        try {
            return ((IGamesService)this.zzqJ()).zzwK();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return null;
        }
    }

    public void zza(zza.zzb<Invitations.LoadInvitationsResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), n);
    }

    public void zzq(String string, int n) {
        try {
            ((IGamesService)this.zzqJ()).zzq(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzr(String string, int n) {
        try {
            ((IGamesService)this.zzqJ()).zzr(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzxP(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public void zzc(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzl(new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public void zzd(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzm(new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public int zzwL() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzqJ()).zzwL();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, string2, participantResultArray);
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, participantResultArray);
    }

    public void zze(zza.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzo(new TurnBasedMatchLeftBinderCallbacks(zzb2), string);
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzc((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zza.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzn(new TurnBasedMatchCanceledBinderCallbacks(zzb2), string);
    }

    public void zzdH(String string) {
        try {
            ((IGamesService)this.zzqJ()).zzdP(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), n, nArray);
    }

    public void zzg(zza.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzp(new TurnBasedMatchLoadedBinderCallbacks(zzb2), string);
    }

    public Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzq<RoomUpdateListener> zzq2, zzq<RoomStatusUpdateListener> zzq3, zzq<RealTimeMessageReceivedListener> zzq4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzq2, zzq3, zzq4);
            ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzaEf, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzaEg);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzb(zzq<RoomUpdateListener> zzq2, zzq<RoomStatusUpdateListener> zzq3, zzq<RealTimeMessageReceivedListener> zzq4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzq2, zzq3, zzq4);
            ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzaEf, roomConfig.getInvitationId(), false, this.zzaEg);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zzq<RoomUpdateListener> zzq2, String string) {
        try {
            ((IGamesService)this.zzqJ()).zzc((IGamesCallbacks)new RoomBinderCallbacks(zzq2), string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public int zza(zzq<RealTimeMultiplayer.ReliableMessageSentCallback> zzq2, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(zzq2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zza(byte[] byArray, String string, String[] stringArray) {
        zzx.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.zzqJ()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public int zzd(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.zzqJ()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            return -1;
        }
    }

    public void zzgt(int n) {
        try {
            ((IGamesService)this.zzqJ()).zzgt(n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public Intent zzwM() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zzwM();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zza(n, byArray, n2, string);
            zzx.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public int zzwN() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzqJ()).zzwN();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzwO() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzqJ()).zzwO();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public void zzb(zza.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zzc(zza.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzb((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zza(zza.zzb<Requests.LoadRequestsResult> zzb2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), n, n2, n3);
    }

    public void zza(zza.zzb<AppContents.LoadAppContentResult> zzb2, int n, String string, String[] stringArray, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new AppContentLoadedBinderCallbacks(zzb2), n, string, stringArray, bl);
    }

    public void zze(zza.zzb<Stats.LoadPlayerStatsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzi((IGamesCallbacks)new PlayerStatsLoadedBinderCallbacks(zzb2), bl);
    }

    public Intent zzb(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zzb(nArray);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzdI(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zzdI(string);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzh(zza.zzb<Quests.AcceptQuestResult> zzb2, String string) throws RemoteException {
        this.zzaDZ.flush();
        ((IGamesService)this.zzqJ()).zzu(new QuestAcceptedBinderCallbacks(zzb2), string);
    }

    public void zzb(zza.zzb<Quests.ClaimMilestoneResult> zzb2, String string, String string2) throws RemoteException {
        this.zzaDZ.flush();
        ((IGamesService)this.zzqJ()).zzf((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(zzb2, string2), string, string2);
    }

    public void zza(zza.zzb<Quests.LoadQuestsResult> zzb2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaDZ.flush();
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), nArray, n, bl);
    }

    public void zzb(zza.zzb<Quests.LoadQuestsResult> zzb2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaDZ.flush();
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), stringArray, bl);
    }

    public void zzdJ(String string) {
        try {
            ((IGamesService)this.zzqJ()).zza(string, this.zzaEd.zzxj(), this.zzaEd.zzxi());
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zza(zza.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaDZ.flush();
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, nArray, n, bl);
    }

    public void zza(zza.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaDZ.flush();
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, stringArray, bl);
    }

    public int zzwP() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzqJ()).zzwP();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public int zzwQ() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzqJ()).zzwQ();
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
        return n;
    }

    public Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzqJ()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzf(zza.zzb<Snapshots.LoadSnapshotsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzd((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), bl);
    }

    public void zza(zza.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, boolean bl, int n) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, bl, n);
    }

    public void zza(zza.zzb<Snapshots.CommitSnapshotResult> zzb2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzx.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzxU();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzsx();
        snapshotContents.close();
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(zzb2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzx.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        Contents contents = snapshotContents.zzsx();
        snapshotContents.close();
        try {
            ((IGamesService)this.zzqJ()).zza(contents);
        }
        catch (RemoteException remoteException) {
            this.zzb(remoteException);
        }
    }

    public void zzi(zza.zzb<Snapshots.DeleteSnapshotResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzr(new SnapshotDeletedBinderCallbacks(zzb2), string);
    }

    public void zza(zza.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        zzx.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzxU();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.zzsx();
        snapshotContents.close();
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, contents);
    }

    public void zza(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl, String string, String string2, VideoConfiguration videoConfiguration) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new StartRecordingBinderCallback(baseGamesApiMethodImpl), string, string2, videoConfiguration);
    }

    public void zzg(zza.zzb<Videos.VideoCapabilitiesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzm(new VideoRecordingCapabilitiesBinderCallback(zzb2));
    }

    public void zzh(zza.zzb<Videos.VideoAvailableResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzn(new VideoRecordingAvailableBinderCallback(zzb2));
    }

    public void zzi(zza.zzb<Videos.ListVideosResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzl(new ListVideosBinderCallback(zzb2));
    }

    public void zzj(zza.zzb<GamesMetadata.LoadGameInstancesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzf((IGamesCallbacks)new GameInstancesLoadedBinderCallback(zzb2), string);
    }

    public void zzk(zza.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzq(new GameSearchSuggestionsLoadedBinderCallback(zzb2), string);
    }

    public void zzc(zza.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzd((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zza.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zza(zza.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zza.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzb(new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zza.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzc(zza.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzd(zza.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zze(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzb(zza.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzb(zza.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zzl(zza.zzb<Players.LoadXpForGameCategoriesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzs(new PlayerXpForGameCategoriesLoadedBinderCallback(zzb2), string);
    }

    public void zzc(zza.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzb((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zzd(zza.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzc((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zzg(zza.zzb<Players.LoadProfileSettingsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzg((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zzh(zza.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzh((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(zzb2), bl);
    }

    public void zzb(zza.zzb<Achievements.LoadAchievementsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zzc(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzd((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzd(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zze((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zze(zza.zzb<Invitations.LoadInvitationsResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzb((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string, n, false);
    }

    public void zzm(zza.zzb<Invitations.LoadInvitationsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzk(new InvitationsLoadedBinderCallback(zzb2), string);
    }

    public void zza(zza.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, String string, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), string, n, nArray);
    }

    public void zzj(zza.zzb<Acls.LoadAclResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzh(new NotifyAclLoadedBinderCallback(zzb2));
    }

    public void zzn(zza.zzb<Status> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzj(new NotifyAclUpdatedBinderCallback(zzb2), string);
    }

    public void zzd(zza.zzb<Notifications.GameMuteStatusChangeResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(zzb2), string, bl);
    }

    public void zzo(zza.zzb<Notifications.GameMuteStatusLoadResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzi((IGamesCallbacks)new GameMuteStatusLoadedBinderCallback(zzb2), string);
    }

    public void zzi(zza.zzb<Notifications.ContactSettingLoadResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zze((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zza.zzb<Status> zzb2, boolean bl, Bundle bundle) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(zzb2), bl, bundle);
    }

    public void zzk(zza.zzb<Notifications.InboxCountResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzt(new InboxCountsLoadedBinderCallback(zzb2), null);
    }

    public void zza(zza.zzb<Requests.SendRequestResult> zzb2, String string, String[] stringArray, int n, byte[] byArray, int n2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new RequestSentBinderCallbacks(zzb2), string, stringArray, n, byArray, n2);
    }

    public void zza(zza.zzb<Requests.UpdateRequestsResult> zzb2, String string, String string2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), string, string2, stringArray);
    }

    public void zza(zza.zzb<Requests.LoadRequestsResult> zzb2, String string, String string2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), string, string2, n, n2, n3);
    }

    public void zzf(zza.zzb<Requests.LoadRequestSummariesResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzqJ()).zza((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(zzb2), string, n);
    }

    public void zzc(zza.zzb<Snapshots.LoadSnapshotsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzc((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), string, string2, bl);
    }

    public void zzl(zza.zzb<Games.LoadExperimentsResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzqJ()).zzo(new ExperimentsLoadedBinderCallback(zzb2));
    }

    public void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzqJ()).zza(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    public void zzwR() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzqJ()).zzwR();
            }
            catch (RemoteException remoteException) {
                this.zzb(remoteException);
            }
        }
    }

    private void zzb(RemoteException remoteException) {
        GamesLog.zzb("GamesClientImpl", "service died", remoteException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Room zzY(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzaEe = bundle.getBoolean("show_welcome_popup");
            this.zzaEb = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzaEc = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzbV(iBinder);
    }

    public static final class ListVideosResultImpl
    extends GamesDataHolderResult
    implements Videos.ListVideosResult {
        private final VideoBuffer zzaEx;

        public ListVideosResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaEx = new VideoBuffer(dataHolder);
        }
    }

    public static final class VideoCapabilitiesResultImpl
    implements Videos.VideoCapabilitiesResult {
        private final Status zzUX;
        private final VideoCapabilities zzaFD;

        VideoCapabilitiesResultImpl(Status status, VideoCapabilities capabilities) {
            this.zzUX = status;
            this.zzaFD = capabilities;
        }

        public Status getStatus() {
            return this.zzUX;
        }
    }

    public static final class VideoAvailableResultImpl
    implements Videos.VideoAvailableResult {
        private final Status zzUX;
        private final boolean zzaFC;

        VideoAvailableResultImpl(Status status, boolean isAvailable) {
            this.zzUX = status;
            this.zzaFC = isAvailable;
        }

        public Status getStatus() {
            return this.zzUX;
        }
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status zzUX;
        private final String zzaEp;

        DeleteSnapshotResultImpl(int statusCode, String snapshotId) {
            this.zzUX = GamesStatusCodes.zzgc(statusCode);
            this.zzaEp = snapshotId;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public String getSnapshotId() {
            return this.zzaEp;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzaEo;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzaEo = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.zzaEo;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzaEV;
        private final String zzaEW;
        private final Snapshot zzaEX;
        private final Contents zzaEY;
        private final SnapshotContents zzaEZ;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents currentContents) {
            this(dataHolder, null, currentContents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder metadataHolder, String conflictId, Contents currentContents, Contents conflictContents, Contents resolutionContents) {
            super(metadataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(metadataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzaEV = null;
                    this.zzaEX = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    zzb.zzab((metadataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.zzaEV = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(currentContents));
                    this.zzaEX = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.zzaEV = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(currentContents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(1));
                    this.zzaEX = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(conflictContents));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzaEW = conflictId;
            this.zzaEY = resolutionContents;
            this.zzaEZ = new SnapshotContentsEntity(resolutionContents);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.zzaEV;
        }

        @Override
        public String getConflictId() {
            return this.zzaEW;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.zzaEX;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.zzaEZ;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends GamesDataHolderResult
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzahi);
        }
    }

    private static final class LoadPlayerStatsResultImpl
    extends GamesDataHolderResult
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzaEI;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerStatsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzaEI = playerStatsBuffer.getCount() > 0 ? new PlayerStatsEntity(playerStatsBuffer.zzgV(0)) : null;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public PlayerStats getPlayerStats() {
            return this.zzaEI;
        }
    }

    private static final class LoadAppContentsResultImpl
    extends GamesDataHolderResult
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> zzaEz;

        LoadAppContentsResultImpl(DataHolder[] appContentData) {
            super(appContentData[0]);
            this.zzaEz = new ArrayList<DataHolder>(Arrays.asList(appContentData));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends GamesDataHolderResult
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzaEn;
        private final Quest zzaEk;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String milestoneId) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzaEk = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzaEk.zzxR();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(milestoneId)) continue;
                        this.zzaEn = list.get(i);
                        return;
                    }
                    this.zzaEn = null;
                } else {
                    this.zzaEn = null;
                    this.zzaEk = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.zzaEn;
        }

        @Override
        public Quest getQuest() {
            return this.zzaEk;
        }
    }

    private static final class AcceptQuestResultImpl
    extends GamesDataHolderResult
    implements Quests.AcceptQuestResult {
        private final Quest zzaEk;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzaEk = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.zzaEk;
        }
    }

    private static final class LoadQuestsResultImpl
    extends GamesDataHolderResult
    implements Quests.LoadQuestsResult {
        private final DataHolder zzahi;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzahi = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.zzahi);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends GamesDataHolderResult
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status zzUX;
        private final Bundle zzaEL;

        LoadRequestsResultImpl(Status status, Bundle requestData) {
            this.zzUX = status;
            this.zzaEL = requestData;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public GameRequestBuffer getRequests(int requestType) {
            String string = RequestType.zzgw(requestType);
            if (!this.zzaEL.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzaEL.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public void release() {
            for (String string : this.zzaEL.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzaEL.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends GamesDataHolderResult
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes zzaFB;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaFB = RequestUpdateOutcomes.zzab(dataHolder);
        }

        @Override
        public int getRequestOutcome(String requestId) {
            return this.zzaFB.getRequestOutcome(requestId);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.zzaFB.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends GamesDataHolderResult
    implements Requests.SendRequestResult {
        private final GameRequest zzaFi;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.zzaFi = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status zzUX;
        private final Bundle zzaEt;

        InboxCountResultImpl(Status status, Bundle inboxCounts) {
            this.zzUX = status;
            this.zzaEt = inboxCounts;
        }

        public Status getStatus() {
            return this.zzUX;
        }
    }

    private static final class LoadExperimentsResultImpl
    implements Games.LoadExperimentsResult {
        private final Status zzUX;
        private final Set<Long> zzaEB;

        LoadExperimentsResultImpl(int statusCode, long[] experimentIds) {
            this.zzUX = new Status(statusCode);
            this.zzaEB = new HashSet<Long>();
            for (int i = 0; i < experimentIds.length; ++i) {
                this.zzaEB.add(experimentIds[i]);
            }
        }

        public Status getStatus() {
            return this.zzUX;
        }
    }

    private static final class GetServerAuthCodeResultImpl
    implements Games.GetServerAuthCodeResult {
        private final Status zzUX;
        private final String zzaEs;

        GetServerAuthCodeResultImpl(Status status, String code) {
            this.zzUX = status;
            this.zzaEs = code;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public String getCode() {
            return this.zzaEs;
        }
    }

    private static final class GetTokenResultImpl
    implements Games.GetTokenResult {
        private final Status zzUX;
        private final String zzVo;

        GetTokenResultImpl(Status status, String token) {
            this.zzUX = status;
            this.zzVo = token;
        }

        public Status getStatus() {
            return this.zzUX;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends GamesDataHolderResult
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status zzUX;
        private final String zzaEq;
        private final boolean zzaEr;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.zzUX = GamesStatusCodes.zzgc(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.zzaEq = dataHolder.zzd("external_game_id", 0, 0);
                    this.zzaEr = dataHolder.zze("muted", 0, 0);
                } else {
                    this.zzaEq = null;
                    this.zzaEr = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzUX;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status zzUX;
        private final String zzaEq;
        private final boolean zzaEr;

        public GameMuteStatusChangeResultImpl(int statusCode, String externalGameId, boolean isMuted) {
            this.zzUX = GamesStatusCodes.zzgc(statusCode);
            this.zzaEq = externalGameId;
            this.zzaEr = isMuted;
        }

        public Status getStatus() {
            return this.zzUX;
        }
    }

    private static final class LoadAclResultImpl
    extends GamesDataHolderResult
    implements Acls.LoadAclResult {
        LoadAclResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status zzUX;
        private final String zzaEm;

        CancelMatchResultImpl(Status status, String externalMatchId) {
            this.zzUX = status;
            this.zzaEm = externalMatchId;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public String getMatchId() {
            return this.zzaEm;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends GamesDataHolderResult {
        final TurnBasedMatch zzaES;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzaES = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzaES;
        }
    }

    private static final class SubmitScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzaFu;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzaFu = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.zzaFu;
        }
    }

    private static final class LoadProfileSettingsResultImpl
    extends GamesDataHolderResult
    implements Players.LoadProfileSettingsResult {
        private final boolean zzsj;
        private final boolean zzaEK;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadProfileSettingsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                if (dataHolder.getCount() > 0) {
                    int n = dataHolder.zzbH(0);
                    this.zzsj = dataHolder.zze("profile_visible", 0, n);
                    this.zzaEK = dataHolder.zze("profile_visibility_explicitly_set", 0, n);
                } else {
                    this.zzsj = true;
                    this.zzaEK = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzUX;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends GamesDataHolderResult
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer zzaEQ;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaEQ = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status zzUX;
        private final List<String> zzaEO;
        private final Bundle zzaEP;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle xpData) {
            this.zzUX = status;
            this.zzaEO = xpData.getStringArrayList("game_category_list");
            this.zzaEP = xpData;
        }

        public Status getStatus() {
            return this.zzUX;
        }
    }

    private static final class LoadPlayersResultImpl
    extends GamesDataHolderResult
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzaEJ;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaEJ = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.zzaEJ;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status zzUX;
        private final LoadMatchesResponse zzaEG;

        LoadMatchesResultImpl(Status status, Bundle matchData) {
            this.zzUX = status;
            this.zzaEG = new LoadMatchesResponse(matchData);
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.zzaEG;
        }

        public void release() {
            this.zzaEG.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends GamesDataHolderResult
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzaEF;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaEF = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.zzaEF;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzaEH;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerScoreResultImpl(DataHolder scoreHolder) {
            super(scoreHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(scoreHolder);
            try {
                this.zzaEH = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)leaderboardScoreBuffer.get(0).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.zzaEH;
        }
    }

    private static final class LoadScoresResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzaEM;
        private final LeaderboardScoreBuffer zzaEN;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder leaderboard, DataHolder scores) {
            super(scores);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(leaderboard);
            try {
                this.zzaEM = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzaEN = new LeaderboardScoreBuffer(scores);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.zzaEM;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.zzaEN;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzaEv;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaEv = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.zzaEv;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer zzaED;

        LoadGameSearchSuggestionsResultImpl(DataHolder data) {
            super(data);
            this.zzaED = new GameSearchSuggestionBuffer(data);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer zzaEC;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaEC = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzaEE;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaEE = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.zzaEE;
        }
    }

    private static final class LoadEventResultImpl
    extends GamesDataHolderResult
    implements Events.LoadEventsResult {
        private final EventBuffer zzaEA;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaEA = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.zzaEA;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status zzUX;
        private final String zzaDj;

        UpdateAchievementResultImpl(int statusCode, String achievementId) {
            this.zzUX = GamesStatusCodes.zzgc(statusCode);
            this.zzaDj = achievementId;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public String getAchievementId() {
            return this.zzaDj;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends GamesDataHolderResult
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzaEy;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaEy = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.zzaEy;
        }
    }

    private static abstract class GamesDataHolderResult
    extends zzf {
        protected GamesDataHolderResult(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzgc(dataHolder.getStatusCode()));
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements zzq.zzb<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzade;
        private final String zzaFf;
        private final int zzaFg;

        RealTimeMessageSentNotifier(int statusCode, int token, String recipientParticipantId) {
            this.zzade = statusCode;
            this.zzaFg = token;
            this.zzaFf = recipientParticipantId;
        }

        public void zza(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.zzade, this.zzaFg, this.zzaFf);
            }
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements zzq.zzb<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzaET;

        MessageReceivedNotifier(RealTimeMessage message) {
            this.zzaET = message;
        }

        public void zza(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.zzaET);
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements zzq.zzb<RoomStatusUpdateListener> {
        private final String zzaFa;

        P2PDisconnectedNotifier(String participantId) {
            this.zzaFa = participantId;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.zzaFa);
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements zzq.zzb<RoomStatusUpdateListener> {
        private final String zzaFa;

        P2PConnectedNotifier(String participantId) {
            this.zzaFa = participantId;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.zzaFa);
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder, participantIds);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    private static final class LeftRoomNotifier
    implements zzq.zzb<RoomUpdateListener> {
        private final int zzade;
        private final String zzaEw;

        LeftRoomNotifier(int statusCode, String roomId) {
            this.zzade = statusCode;
            this.zzaEw = roomId;
        }

        public void zza(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.zzade, this.zzaEw);
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> zzaEj = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] participantIds) {
            super(dataHolder);
            int n = participantIds.length;
            for (int i = 0; i < n; ++i) {
                this.zzaEj.add(participantIds[i]);
            }
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzaEj);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends zze<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzY(dataHolder));
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends zze<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.zza(roomUpdateListener, GamesClientImpl.zzY(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements zzq.zzb<OnNearbyPlayerDetectedListener> {
        private final Player zzaEU;

        public void zza(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.zza(this.zzaEU);
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnNearbyPlayerDetectedListener)object);
        }
    }

    private static final class RequestRemovedNotifier
    implements zzq.zzb<OnRequestReceivedListener> {
        private final String zzEY;

        RequestRemovedNotifier(String requestId) {
            this.zzEY = requestId;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.zzEY);
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements zzq.zzb<OnRequestReceivedListener> {
        private final GameRequest zzaFi;

        RequestReceivedNotifier(GameRequest request) {
            this.zzaFi = request;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.zzaFi);
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements zzq.zzb<QuestUpdateListener> {
        private final Quest zzaEk;

        QuestCompletedNotifier(Quest quest) {
            this.zzaEk = quest;
        }

        public void zza(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.zzaEk);
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements zzq.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzaER;

        MatchRemovedNotifier(String matchId) {
            this.zzaER = matchId;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.zzaER);
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements zzq.zzb<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzaES;

        MatchUpdateReceivedNotifier(TurnBasedMatch match) {
            this.zzaES = match;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.zzaES);
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements zzq.zzb<OnInvitationReceivedListener> {
        private final String zzUO;

        InvitationRemovedNotifier(String invitationId) {
            this.zzUO = invitationId;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.zzUO);
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements zzq.zzb<OnInvitationReceivedListener> {
        private final Invitation zzaEu;

        InvitationReceivedNotifier(Invitation invitation) {
            this.zzaEu = invitation;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.zzaEu);
        }

        public void zzpr() {
        }

        public /* synthetic */ void zzt(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class ListVideosBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Videos.ListVideosResult> zzamC;

        ListVideosBinderCallback(zza.zzb<Videos.ListVideosResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzX(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new ListVideosResultImpl(dataHolder));
        }
    }

    private static final class VideoRecordingCapabilitiesBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Videos.VideoCapabilitiesResult> zzamC;

        VideoRecordingCapabilitiesBinderCallback(zza.zzb<Videos.VideoCapabilitiesResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, VideoCapabilities videoCapabilities) {
            this.zzamC.zzs((Object)new VideoCapabilitiesResultImpl(new Status(n), videoCapabilities));
        }
    }

    private static final class VideoRecordingAvailableBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Videos.VideoAvailableResult> zzamC;

        VideoRecordingAvailableBinderCallback(zza.zzb<Videos.VideoAvailableResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, boolean bl) {
            this.zzamC.zzs((Object)new VideoAvailableResultImpl(new Status(n), bl));
        }
    }

    private static final class StartRecordingBinderCallback
    extends AbstractGamesCallbacks {
        private final Games.BaseGamesApiMethodImpl<Status> zzaFt;

        StartRecordingBinderCallback(Games.BaseGamesApiMethodImpl<Status> holder) {
            this.zzaFt = (Games.BaseGamesApiMethodImpl)((Object)zzx.zzb(holder, (Object)"Holder must not be null"));
        }

        @Override
        public void zzgq(int n) {
            this.zzaFt.zza((Result)new Status(n));
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Snapshots.DeleteSnapshotResult> zzamC;

        public SnapshotDeletedBinderCallbacks(zza.zzb<Snapshots.DeleteSnapshotResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(int n, String string) {
            this.zzamC.zzs((Object)new DeleteSnapshotResultImpl(n, string));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Snapshots.CommitSnapshotResult> zzaFq;

        public SnapshotCommittedBinderCallbacks(zza.zzb<Snapshots.CommitSnapshotResult> resultHolder) {
            this.zzaFq = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzO(DataHolder dataHolder) {
            this.zzaFq.zzs((Object)new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Snapshots.OpenSnapshotResult> zzaFr;

        public SnapshotOpenedBinderCallbacks(zza.zzb<Snapshots.OpenSnapshotResult> resultHolder) {
            this.zzaFr = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, Contents contents) {
            this.zzaFr.zzs((Object)new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void zza(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            this.zzaFr.zzs((Object)new OpenSnapshotResultImpl(dataHolder, string, contents, contents2, contents3));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Snapshots.LoadSnapshotsResult> zzaFs;

        public SnapshotsLoadedBinderCallbacks(zza.zzb<Snapshots.LoadSnapshotsResult> resultHolder) {
            this.zzaFs = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzN(DataHolder dataHolder) {
            this.zzaFs.zzs((Object)new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class PlayerStatsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Stats.LoadPlayerStatsResult> zzamC;

        public PlayerStatsLoadedBinderCallbacks(zza.zzb<Stats.LoadPlayerStatsResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzW(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadPlayerStatsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<AppContents.LoadAppContentResult> zzaEl;

        public AppContentLoadedBinderCallbacks(zza.zzb<AppContents.LoadAppContentResult> resultHolder) {
            this.zzaEl = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder[] dataHolderArray) {
            this.zzaEl.zzs((Object)new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Quests.LoadQuestsResult> zzaFe;

        public QuestsLoadedBinderCallbacks(zza.zzb<Quests.LoadQuestsResult> resultHolder) {
            this.zzaFe = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzT(DataHolder dataHolder) {
            this.zzaFe.zzs((Object)new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Quests.ClaimMilestoneResult> zzaFc;
        private final String zzaFd;

        public QuestMilestoneClaimBinderCallbacks(zza.zzb<Quests.ClaimMilestoneResult> resultHolder, String milestoneId) {
            this.zzaFc = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
            this.zzaFd = (String)zzx.zzb((Object)milestoneId, (Object)"MilestoneId must not be null");
        }

        @Override
        public void zzP(DataHolder dataHolder) {
            this.zzaFc.zzs((Object)new ClaimMilestoneResultImpl(dataHolder, this.zzaFd));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Quests.AcceptQuestResult> zzaFb;

        public QuestAcceptedBinderCallbacks(zza.zzb<Quests.AcceptQuestResult> resultHolder) {
            this.zzaFb = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzQ(DataHolder dataHolder) {
            this.zzaFb.zzs((Object)new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Requests.LoadRequestSummariesResult> zzaFk;

        public RequestSummariesLoadedBinderCallbacks(zza.zzb<Requests.LoadRequestSummariesResult> resultHolder) {
            this.zzaFk = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzM(DataHolder dataHolder) {
            this.zzaFk.zzs((Object)new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Requests.LoadRequestsResult> zzaFl;

        public RequestsLoadedBinderCallbacks(zza.zzb<Requests.LoadRequestsResult> resultHolder) {
            this.zzaFl = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzgc(n);
            this.zzaFl.zzs((Object)new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Requests.SendRequestResult> zzaFj;

        public RequestSentBinderCallbacks(zza.zzb<Requests.SendRequestResult> resultHolder) {
            this.zzaFj = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzL(DataHolder dataHolder) {
            this.zzaFj.zzs((Object)new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Requests.UpdateRequestsResult> zzaFm;

        public RequestsUpdatedBinderCallbacks(zza.zzb<Requests.UpdateRequestsResult> resultHolder) {
            this.zzaFm = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzK(DataHolder dataHolder) {
            this.zzaFm.zzs((Object)new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class PopupLocationInfoBinderCallbacks
    extends AbstractGamesClient {
        private final PopupManager zzaEd;

        public PopupLocationInfoBinderCallbacks(PopupManager popupManager) {
            this.zzaEd = popupManager;
        }

        @Override
        public PopupLocationInfoParcelable zzws() {
            return new PopupLocationInfoParcelable(this.zzaEd.zzxk());
        }
    }

    private static final class ExperimentsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Games.LoadExperimentsResult> zzamC;

        ExperimentsLoadedBinderCallback(zza.zzb<Games.LoadExperimentsResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, long[] lArray) {
            this.zzamC.zzs((Object)new LoadExperimentsResultImpl(n, lArray));
        }
    }

    private static final class GetServerAuthCodeBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Games.GetServerAuthCodeResult> zzamC;

        public GetServerAuthCodeBinderCallbacks(zza.zzb<Games.GetServerAuthCodeResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, String string) {
            Status status = GamesStatusCodes.zzgc(n);
            this.zzamC.zzs((Object)new GetServerAuthCodeResultImpl(status, string));
        }
    }

    private static final class GetAuthTokenBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Games.GetTokenResult> zzamC;

        public GetAuthTokenBinderCallbacks(zza.zzb<Games.GetTokenResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, String string) {
            Status status = GamesStatusCodes.zzgc(n);
            this.zzamC.zzs((Object)new GetTokenResultImpl(status, string));
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Status> zzamC;

        public SignOutCompleteBinderCallbacks(zza.zzb<Status> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzwr() {
            Status status = GamesStatusCodes.zzgc(0);
            this.zzamC.zzs((Object)status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Notifications.InboxCountResult> zzamC;

        InboxCountsLoadedBinderCallback(zza.zzb<Notifications.InboxCountResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzgc(n);
            this.zzamC.zzs((Object)new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Status> zzamC;

        ContactSettingsUpdatedBinderCallback(zza.zzb<Status> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzgo(int n) {
            this.zzamC.zzs((Object)GamesStatusCodes.zzgc(n));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Notifications.ContactSettingLoadResult> zzamC;

        ContactSettingsLoadedBinderCallback(zza.zzb<Notifications.ContactSettingLoadResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzI(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Notifications.GameMuteStatusLoadResult> zzamC;

        GameMuteStatusLoadedBinderCallback(zza.zzb<Notifications.GameMuteStatusLoadResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzG(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Notifications.GameMuteStatusChangeResult> zzamC;

        GameMuteStatusChangedBinderCallback(zza.zzb<Notifications.GameMuteStatusChangeResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, String string, boolean bl) {
            this.zzamC.zzs((Object)new GameMuteStatusChangeResultImpl(n, string, bl));
        }
    }

    private static final class NotifyAclUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Status> zzamC;

        NotifyAclUpdatedBinderCallback(zza.zzb<Status> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzgn(int n) {
            this.zzamC.zzs((Object)GamesStatusCodes.zzgc(n));
        }
    }

    private static final class NotifyAclLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Acls.LoadAclResult> zzamC;

        NotifyAclLoadedBinderCallback(zza.zzb<Acls.LoadAclResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzH(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadAclResultImpl(dataHolder));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final zzq<RealTimeMultiplayer.ReliableMessageSentCallback> zzaFh;

        public RealTimeReliableMessageBinderCallbacks(zzq<RealTimeMultiplayer.ReliableMessageSentCallback> messageSentCallbacks) {
            this.zzaFh = messageSentCallbacks;
        }

        @Override
        public void zzb(int n, int n2, String string) {
            if (this.zzaFh != null) {
                this.zzaFh.zza((zzq.zzb)new RealTimeMessageSentNotifier(n, n2, string));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzq<? extends RoomUpdateListener> zzaFn;
        private final zzq<? extends RoomStatusUpdateListener> zzaFo;
        private final zzq<RealTimeMessageReceivedListener> zzaFp;

        public RoomBinderCallbacks(zzq<RoomUpdateListener> roomCallbacks) {
            this.zzaFn = (zzq)zzx.zzb(roomCallbacks, (Object)"Callbacks must not be null");
            this.zzaFo = null;
            this.zzaFp = null;
        }

        public RoomBinderCallbacks(zzq<? extends RoomUpdateListener> roomCallbacks, zzq<? extends RoomStatusUpdateListener> roomStatusCallbacks, zzq<RealTimeMessageReceivedListener> realTimeMessageReceivedCallbacks) {
            this.zzaFn = (zzq)zzx.zzb(roomCallbacks, (Object)"Callbacks must not be null");
            this.zzaFo = roomStatusCallbacks;
            this.zzaFp = realTimeMessageReceivedCallbacks;
        }

        @Override
        public void zzz(DataHolder dataHolder) {
            this.zzaFn.zza((zzq.zzb)new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void zzA(DataHolder dataHolder) {
            this.zzaFn.zza((zzq.zzb)new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int statusCode, String externalRoomId) {
            this.zzaFn.zza((zzq.zzb)new LeftRoomNotifier(statusCode, externalRoomId));
        }

        @Override
        public void zzD(DataHolder dataHolder) {
            this.zzaFn.zza((zzq.zzb)new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void zzB(DataHolder dataHolder) {
            if (this.zzaFo != null) {
                this.zzaFo.zza((zzq.zzb)new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void zzC(DataHolder dataHolder) {
            if (this.zzaFo != null) {
                this.zzaFo.zza((zzq.zzb)new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void zzE(DataHolder dataHolder) {
            if (this.zzaFo != null) {
                this.zzaFo.zza((zzq.zzb)new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zzF(DataHolder dataHolder) {
            if (this.zzaFo != null) {
                this.zzaFo.zza((zzq.zzb)new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaFo != null) {
                this.zzaFo.zza((zzq.zzb)new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaFo != null) {
                this.zzaFo.zza((zzq.zzb)new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaFo != null) {
                this.zzaFo.zza((zzq.zzb)new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaFo != null) {
                this.zzaFo.zza((zzq.zzb)new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaFo != null) {
                this.zzaFo.zza((zzq.zzb)new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzaFo != null) {
                this.zzaFo.zza((zzq.zzb)new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String participantId) {
            if (this.zzaFo != null) {
                this.zzaFo.zza((zzq.zzb)new P2PConnectedNotifier(participantId));
            }
        }

        @Override
        public void onP2PDisconnected(String participantId) {
            if (this.zzaFo != null) {
                this.zzaFo.zza((zzq.zzb)new P2PDisconnectedNotifier(participantId));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage message) {
            if (this.zzaFp != null) {
                this.zzaFp.zza((zzq.zzb)new MessageReceivedNotifier(message));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.CancelMatchResult> zzaFv;

        public TurnBasedMatchCanceledBinderCallbacks(zza.zzb<TurnBasedMultiplayer.CancelMatchResult> resultHolder) {
            this.zzaFv = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzgc(n);
            this.zzaFv.zzs((Object)new CancelMatchResultImpl(status, string));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzaFx;

        public TurnBasedMatchLeftBinderCallbacks(zza.zzb<TurnBasedMultiplayer.LeaveMatchResult> resultHolder) {
            this.zzaFx = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzx(DataHolder dataHolder) {
            this.zzaFx.zzs((Object)new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzaFz;

        public TurnBasedMatchUpdatedBinderCallbacks(zza.zzb<TurnBasedMultiplayer.UpdateMatchResult> resultHolder) {
            this.zzaFz = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzw(DataHolder dataHolder) {
            this.zzaFz.zzs((Object)new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzaFw;

        public TurnBasedMatchInitiatedBinderCallbacks(zza.zzb<TurnBasedMultiplayer.InitiateMatchResult> resultHolder) {
            this.zzaFw = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzv(DataHolder dataHolder) {
            this.zzaFw.zzs((Object)new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.LoadMatchResult> zzaFy;

        public TurnBasedMatchLoadedBinderCallbacks(zza.zzb<TurnBasedMultiplayer.LoadMatchResult> resultHolder) {
            this.zzaFy = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzu(DataHolder dataHolder) {
            this.zzaFy.zzs((Object)new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzaFA;

        public TurnBasedMatchesLoadedBinderCallbacks(zza.zzb<TurnBasedMultiplayer.LoadMatchesResult> resultHolder) {
            this.zzaFA = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzgc(n);
            this.zzaFA.zzs((Object)new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zza.zzb<Leaderboards.SubmitScoreResult> zzamC;

        public SubmitScoreBinderCallbacks(zza.zzb<Leaderboards.SubmitScoreResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Status> zzamC;

        ProfileSettingsUpdatedBinderCallback(zza.zzb<Status> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzgp(int n) {
            this.zzamC.zzs((Object)GamesStatusCodes.zzgc(n));
        }
    }

    static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadProfileSettingsResult> zzamC;

        ProfileSettingsLoadedBinderCallback(zza.zzb<Players.LoadProfileSettingsResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzV(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadProfileSettingsResultImpl(dataHolder));
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadXpStreamResult> zzamC;

        PlayerXpStreamLoadedBinderCallback(zza.zzb<Players.LoadXpStreamResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzU(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadXpForGameCategoriesResult> zzamC;

        PlayerXpForGameCategoriesLoadedBinderCallback(zza.zzb<Players.LoadXpForGameCategoriesResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzgc(n);
            this.zzamC.zzs((Object)new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Players.LoadPlayersResult> zzamC;

        PlayersLoadedBinderCallback(zza.zzb<Players.LoadPlayersResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void zzm(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzq<OnRequestReceivedListener> zzari;

        RequestReceivedBinderCallback(zzq<OnRequestReceivedListener> listener) {
            this.zzari = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzt(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzari.zza((zzq.zzb)new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String requestId) {
            this.zzari.zza((zzq.zzb)new RequestRemovedNotifier(requestId));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzq<QuestUpdateListener> zzari;

        QuestUpdateBinderCallback(zzq<QuestUpdateListener> listener) {
            this.zzari = listener;
        }

        @Override
        public void zzR(DataHolder dataHolder) {
            Quest quest = this.zzaa(dataHolder);
            if (quest != null) {
                this.zzari.zza((zzq.zzb)new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest zzaa(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzq<OnTurnBasedMatchUpdateReceivedListener> zzari;

        MatchUpdateReceivedBinderCallback(zzq<OnTurnBasedMatchUpdateReceivedListener> listener) {
            this.zzari = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzy(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzari.zza((zzq.zzb)new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String matchId) {
            this.zzari.zza((zzq.zzb)new MatchRemovedNotifier(matchId));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzq<OnInvitationReceivedListener> zzari;

        InvitationReceivedBinderCallback(zzq<OnInvitationReceivedListener> listener) {
            this.zzari = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzs(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzari.zza((zzq.zzb)new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String invitationId) {
            this.zzari.zza((zzq.zzb)new InvitationRemovedNotifier(invitationId));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Invitations.LoadInvitationsResult> zzamC;

        InvitationsLoadedBinderCallback(zza.zzb<Invitations.LoadInvitationsResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzr(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Leaderboards.LoadPlayerScoreResult> zzamC;

        PlayerLeaderboardScoreLoadedBinderCallback(zza.zzb<Leaderboards.LoadPlayerScoreResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzJ(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Leaderboards.LoadScoresResult> zzamC;

        LeaderboardScoresLoadedBinderCallback(zza.zzb<Leaderboards.LoadScoresResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzamC.zzs((Object)new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Leaderboards.LeaderboardMetadataResult> zzamC;

        LeaderboardsLoadedBinderCallback(zza.zzb<Leaderboards.LeaderboardMetadataResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzamC;

        GameSearchSuggestionsLoadedBinderCallback(zza.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzq(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<GamesMetadata.LoadGameInstancesResult> zzamC;

        GameInstancesLoadedBinderCallback(zza.zzb<GamesMetadata.LoadGameInstancesResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzp(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Events.LoadEventsResult> zzamC;

        EventsLoadedBinderCallback(zza.zzb<Events.LoadEventsResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<GamesMetadata.LoadGamesResult> zzamC;

        GamesLoadedBinderCallback(zza.zzb<GamesMetadata.LoadGamesResult> holder) {
            this.zzamC = (zza.zzb)zzx.zzb(holder, (Object)"Holder must not be null");
        }

        @Override
        public void zzn(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Achievements.UpdateAchievementResult> zzamC;

        AchievementUpdatedBinderCallback(zza.zzb<Achievements.UpdateAchievementResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, String string) {
            this.zzamC.zzs((Object)new UpdateAchievementResultImpl(n, string));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zza.zzb<Achievements.LoadAchievementsResult> zzamC;

        AchievementsLoadedBinderCallback(zza.zzb<Achievements.LoadAchievementsResult> resultHolder) {
            this.zzamC = (zza.zzb)zzx.zzb(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(DataHolder dataHolder) {
            this.zzamC.zzs((Object)new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void zzs(String string, int n) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.zzqJ()).zzp(string, n);
                } else {
                    GamesLog.zzA("GamesClientImpl", "Unable to increment event " + string + " by " + n + " because the games client is no longer connected");
                }
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.this.zzb(remoteException);
            }
        }
    }
}

