/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.internal.zzne;
import java.lang.ref.WeakReference;

public class PopupManager {
    protected GamesClientImpl zzaFJ;
    protected PopupLocationInfo zzaFK;

    public static PopupManager zza(GamesClientImpl gamesClientImpl, int n) {
        if (zzne.zzse()) {
            return new PopupManagerHCMR1(gamesClientImpl, n);
        }
        return new PopupManager(gamesClientImpl, n);
    }

    private PopupManager(GamesClientImpl gamesClientImpl, int gravity) {
        this.zzaFJ = gamesClientImpl;
        this.zzgv(gravity);
    }

    protected void zzgv(int n) {
        this.zzaFK = new PopupLocationInfo(n, (IBinder)new Binder());
    }

    public void setGravity(int gravity) {
        this.zzaFK.gravity = gravity;
    }

    public void zzp(View view) {
    }

    public void zzxh() {
        this.zzaFJ.zza(this.zzaFK.zzaFL, this.zzaFK.zzxg());
    }

    public Bundle zzxi() {
        return this.zzaFK.zzxg();
    }

    public IBinder zzxj() {
        return this.zzaFK.zzaFL;
    }

    public PopupLocationInfo zzxk() {
        return this.zzaFK;
    }

    public static final class PopupLocationInfo {
        public IBinder zzaFL;
        public int gravity;
        public int zzaFM = -1;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        private PopupLocationInfo(int gravity, IBinder windowToken) {
            this.gravity = gravity;
            this.zzaFL = windowToken;
        }

        public Bundle zzxg() {
            Bundle bundle = new Bundle();
            bundle.putInt("popupLocationInfo.gravity", this.gravity);
            bundle.putInt("popupLocationInfo.displayId", this.zzaFM);
            bundle.putInt("popupLocationInfo.left", this.left);
            bundle.putInt("popupLocationInfo.top", this.top);
            bundle.putInt("popupLocationInfo.right", this.right);
            bundle.putInt("popupLocationInfo.bottom", this.bottom);
            return bundle;
        }
    }

    @TargetApi(value=12)
    private static final class PopupManagerHCMR1
    extends PopupManager
    implements View.OnAttachStateChangeListener,
    ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<View> zzaFN;
        private boolean zzaEe = false;

        protected PopupManagerHCMR1(GamesClientImpl gamesClientImpl, int gravity) {
            super(gamesClientImpl, gravity);
        }

        @Override
        protected void zzgv(int n) {
            this.zzaFK = new PopupLocationInfo(n, null);
        }

        @Override
        @TargetApi(value=16)
        public void zzp(View view) {
            Context context;
            View view2;
            this.zzaFJ.zzwR();
            if (this.zzaFN != null) {
                view2 = (View)this.zzaFN.get();
                context = this.zzaFJ.getContext();
                if (view2 == null && context instanceof Activity) {
                    view2 = ((Activity)context).getWindow().getDecorView();
                }
                if (view2 != null) {
                    view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
                    if (zzne.zzsh()) {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
            this.zzaFN = null;
            view2 = this.zzaFJ.getContext();
            if (view == null && view2 instanceof Activity) {
                context = (Activity)view2;
                view = context.findViewById(0x1020002);
                if (view == null) {
                    view = ((Activity)view2).getWindow().getDecorView();
                }
                GamesLog.zzz("PopupManager", "You have not specified a View to use as content view for popups. Falling back to the Activity content view. Note that this may not work as expected in multi-screen environments");
            }
            if (view != null) {
                this.zzq(view);
                this.zzaFN = new WeakReference<View>(view);
                view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                context = view.getViewTreeObserver();
                context.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                GamesLog.zzA("PopupManager", "No content view usable to display popups. Popups will not be displayed in response to this client's calls. Use setViewForPopups() to set your content view.");
            }
        }

        @Override
        public void zzxh() {
            if (this.zzaFK.zzaFL != null) {
                super.zzxh();
                return;
            }
            this.zzaEe = this.zzaFN != null;
        }

        public void onViewAttachedToWindow(View v) {
            this.zzq(v);
        }

        public void onViewDetachedFromWindow(View v) {
            this.zzaFJ.zzwR();
            v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onGlobalLayout() {
            if (this.zzaFN == null) {
                return;
            }
            View view = (View)this.zzaFN.get();
            if (view == null) {
                return;
            }
            this.zzq(view);
        }

        @TargetApi(value=17)
        private void zzq(View view) {
            Display display;
            int n = -1;
            if (zzne.zzsi()) {
                display = view.getDisplay();
                n = display != null ? display.getDisplayId() : -1;
            }
            display = view.getWindowToken();
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            int n2 = view.getWidth();
            int n3 = view.getHeight();
            this.zzaFK.zzaFM = n;
            this.zzaFK.zzaFL = display;
            this.zzaFK.left = nArray[0];
            this.zzaFK.top = nArray[1];
            this.zzaFK.right = nArray[0] + n2;
            this.zzaFK.bottom = nArray[1] + n3;
            if (this.zzaEe) {
                this.zzxh();
                this.zzaEe = false;
            }
        }
    }
}

