/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.internal.zzq;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import java.util.List;

public final class RealTimeMultiplayerImpl
implements RealTimeMultiplayer {
    @Override
    public Intent getWaitingRoomIntent(GoogleApiClient apiClient, Room room, int minParticipantsToStart) {
        return Games.zzh(apiClient).zza(room, minParticipantsToStart);
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers) {
        return Games.zzh(apiClient).zzc(minPlayers, maxPlayers, true);
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers, boolean allowAutomatch) {
        return Games.zzh(apiClient).zzc(minPlayers, maxPlayers, allowAutomatch);
    }

    @Override
    public void create(GoogleApiClient apiClient, RoomConfig config) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl == null) {
            return;
        }
        zzq zzq2 = apiClient.zzr((Object)config.getRoomUpdateListener());
        zzq<RoomStatusUpdateListener> zzq3 = RealTimeMultiplayerImpl.zza(apiClient, config.getRoomStatusUpdateListener());
        zzq<RealTimeMessageReceivedListener> zzq4 = RealTimeMultiplayerImpl.zza(apiClient, config.getMessageReceivedListener());
        gamesClientImpl.zza((zzq<RoomUpdateListener>)zzq2, zzq3, zzq4, config);
    }

    @Override
    public void join(GoogleApiClient apiClient, RoomConfig config) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl == null) {
            return;
        }
        zzq zzq2 = apiClient.zzr((Object)config.getRoomUpdateListener());
        zzq<RoomStatusUpdateListener> zzq3 = RealTimeMultiplayerImpl.zza(apiClient, config.getRoomStatusUpdateListener());
        zzq<RealTimeMessageReceivedListener> zzq4 = RealTimeMultiplayerImpl.zza(apiClient, config.getMessageReceivedListener());
        gamesClientImpl.zzb((zzq<RoomUpdateListener>)zzq2, zzq3, zzq4, config);
    }

    @Override
    public void leave(GoogleApiClient apiClient, RoomUpdateListener listener, String roomId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            zzq zzq2 = apiClient.zzr((Object)listener);
            gamesClientImpl.zza((zzq<RoomUpdateListener>)zzq2, roomId);
        }
    }

    @Override
    public int sendReliableMessage(GoogleApiClient apiClient, RealTimeMultiplayer.ReliableMessageSentCallback callback, byte[] messageData, String roomId, String recipientParticipantId) {
        zzq<RealTimeMultiplayer.ReliableMessageSentCallback> zzq2 = RealTimeMultiplayerImpl.zza(apiClient, callback);
        return Games.zzh(apiClient).zza(zzq2, messageData, roomId, recipientParticipantId);
    }

    @Override
    public int sendUnreliableMessage(GoogleApiClient apiClient, byte[] messageData, String roomId, String recipientParticipantId) {
        return Games.zzh(apiClient).zza(messageData, roomId, new String[]{recipientParticipantId});
    }

    @Override
    public int sendUnreliableMessage(GoogleApiClient apiClient, byte[] messageData, String roomId, List<String> recipientParticipantIds) {
        String[] stringArray = recipientParticipantIds.toArray(new String[recipientParticipantIds.size()]);
        return Games.zzh(apiClient).zza(messageData, roomId, stringArray);
    }

    @Override
    public int sendUnreliableMessageToOthers(GoogleApiClient apiClient, byte[] messageData, String roomId) {
        return Games.zzh(apiClient).zzd(messageData, roomId);
    }

    @Override
    public void declineInvitation(GoogleApiClient apiClient, String invitationId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzr(invitationId, 0);
        }
    }

    @Override
    public void dismissInvitation(GoogleApiClient apiClient, String invitationId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzq(invitationId, 0);
        }
    }

    private static <L> zzq<L> zza(GoogleApiClient googleApiClient, L l) {
        if (l == null) {
            return null;
        }
        return googleApiClient.zzr(l);
    }
}

