/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzq;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import java.util.List;

public final class TurnBasedMultiplayerImpl
implements TurnBasedMultiplayer {
    @Override
    public Intent getInboxIntent(GoogleApiClient apiClient) {
        return Games.zzh(apiClient).zzwB();
    }

    @Override
    public void registerMatchUpdateListener(GoogleApiClient apiClient, OnTurnBasedMatchUpdateReceivedListener listener) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            zzq zzq2 = apiClient.zzr((Object)listener);
            gamesClientImpl.zzb((zzq<OnTurnBasedMatchUpdateReceivedListener>)zzq2);
        }
    }

    @Override
    public void unregisterMatchUpdateListener(GoogleApiClient apiClient) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzwE();
        }
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers) {
        return Games.zzh(apiClient).zzb(minPlayers, maxPlayers, true);
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers, boolean allowAutomatch) {
        return Games.zzh(apiClient).zzb(minPlayers, maxPlayers, allowAutomatch);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.InitiateMatchResult> createMatch(GoogleApiClient apiClient, final TurnBasedMatchConfig config) {
        return apiClient.zzb((zza.zza)new InitiateMatchImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<TurnBasedMultiplayer.InitiateMatchResult>)this, config);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.InitiateMatchResult> rematch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.zzb((zza.zza)new InitiateMatchImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzc((zza.zzb<TurnBasedMultiplayer.InitiateMatchResult>)this, matchId);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.InitiateMatchResult> acceptInvitation(GoogleApiClient apiClient, final String invitationId) {
        return apiClient.zzb((zza.zza)new InitiateMatchImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzd((zza.zzb<TurnBasedMultiplayer.InitiateMatchResult>)this, invitationId);
            }
        });
    }

    @Override
    public void declineInvitation(GoogleApiClient apiClient, String invitationId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzr(invitationId, 1);
        }
    }

    @Override
    public void dismissInvitation(GoogleApiClient apiClient, String invitationId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzq(invitationId, 1);
        }
    }

    @Override
    public int getMaxMatchDataSize(GoogleApiClient apiClient) {
        return Games.zzh(apiClient).zzwL();
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> takeTurn(GoogleApiClient apiClient, String matchId, byte[] matchData, String pendingParticipantId) {
        return this.takeTurn(apiClient, matchId, matchData, pendingParticipantId, (ParticipantResult[])null);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> takeTurn(GoogleApiClient apiClient, final String matchId, final byte[] matchData, final String pendingParticipantId, final ParticipantResult ... results) {
        return apiClient.zzb((zza.zza)new UpdateMatchImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<TurnBasedMultiplayer.UpdateMatchResult>)this, matchId, matchData, pendingParticipantId, results);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> takeTurn(GoogleApiClient apiClient, String matchId, byte[] matchData, String pendingParticipantId, List<ParticipantResult> results) {
        ParticipantResult[] participantResultArray = results == null ? null : results.toArray(new ParticipantResult[results.size()]);
        return this.takeTurn(apiClient, matchId, matchData, pendingParticipantId, participantResultArray);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> finishMatch(GoogleApiClient apiClient, String matchId) {
        return this.finishMatch(apiClient, matchId, null, (ParticipantResult[])null);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> finishMatch(GoogleApiClient apiClient, final String matchId, final byte[] matchData, final ParticipantResult ... results) {
        return apiClient.zzb((zza.zza)new UpdateMatchImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<TurnBasedMultiplayer.UpdateMatchResult>)this, matchId, matchData, results);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> finishMatch(GoogleApiClient apiClient, String matchId, byte[] matchData, List<ParticipantResult> results) {
        ParticipantResult[] participantResultArray = results == null ? null : results.toArray(new ParticipantResult[results.size()]);
        return this.finishMatch(apiClient, matchId, matchData, participantResultArray);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LeaveMatchResult> leaveMatch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.zzb((zza.zza)new LeaveMatchImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zze((zza.zzb<TurnBasedMultiplayer.LeaveMatchResult>)this, matchId);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LeaveMatchResult> leaveMatchDuringTurn(GoogleApiClient apiClient, final String matchId, final String pendingParticipantId) {
        return apiClient.zzb((zza.zza)new LeaveMatchImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<TurnBasedMultiplayer.LeaveMatchResult>)this, matchId, pendingParticipantId);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.CancelMatchResult> cancelMatch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.zzb((zza.zza)new CancelMatchImpl(matchId, apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzf((zza.zzb<TurnBasedMultiplayer.CancelMatchResult>)this, matchId);
            }
        });
    }

    @Override
    public void dismissMatch(GoogleApiClient apiClient, String matchId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzdH(matchId);
        }
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LoadMatchesResult> loadMatchesByStatus(GoogleApiClient apiClient, int[] matchTurnStatuses) {
        return this.loadMatchesByStatus(apiClient, 0, matchTurnStatuses);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LoadMatchesResult> loadMatchesByStatus(GoogleApiClient apiClient, final int invitationSortOrder, final int[] matchTurnStatuses) {
        return apiClient.zza((zza.zza)new LoadMatchesImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<TurnBasedMultiplayer.LoadMatchesResult>)this, invitationSortOrder, matchTurnStatuses);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LoadMatchResult> loadMatch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.zza((zza.zza)new LoadMatchImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzg((zza.zzb<TurnBasedMultiplayer.LoadMatchResult>)this, matchId);
            }
        });
    }

    private static abstract class LoadMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.LoadMatchResult> {
        private LoadMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.LoadMatchResult zzaL(final Status status) {
            return new TurnBasedMultiplayer.LoadMatchResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaL(status);
        }
    }

    private static abstract class LoadMatchesImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.LoadMatchesResult> {
        private LoadMatchesImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.LoadMatchesResult zzaM(final Status status) {
            return new TurnBasedMultiplayer.LoadMatchesResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public LoadMatchesResponse getMatches() {
                    return new LoadMatchesResponse(new Bundle());
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaM(status);
        }
    }

    private static abstract class CancelMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.CancelMatchResult> {
        private final String zzyv;

        public CancelMatchImpl(String id, GoogleApiClient googleApiClient) {
            super(googleApiClient);
            this.zzyv = id;
        }

        public TurnBasedMultiplayer.CancelMatchResult zzaI(final Status status) {
            return new TurnBasedMultiplayer.CancelMatchResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public String getMatchId() {
                    return CancelMatchImpl.this.zzyv;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaI(status);
        }
    }

    private static abstract class LeaveMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.LeaveMatchResult> {
        private LeaveMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.LeaveMatchResult zzaK(final Status status) {
            return new TurnBasedMultiplayer.LeaveMatchResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaK(status);
        }
    }

    private static abstract class UpdateMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.UpdateMatchResult> {
        private UpdateMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.UpdateMatchResult zzaN(final Status status) {
            return new TurnBasedMultiplayer.UpdateMatchResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaN(status);
        }
    }

    private static abstract class InitiateMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.InitiateMatchResult> {
        private InitiateMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.InitiateMatchResult zzaJ(final Status status) {
            return new TurnBasedMultiplayer.InitiateMatchResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaJ(status);
        }
    }
}

