/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntityCreator;

public final class GameBadgeEntity
extends GamesDowngradeableSafeParcel
implements GameBadge {
    public static final GameBadgeEntityCreator CREATOR = new GameBadgeEntityCreatorCompat();
    private final int mVersionCode;
    private int zzabB;
    private String zzapg;
    private String zzaxl;
    private Uri zzaCd;

    public GameBadgeEntity(GameBadge gameBadge) {
        this.mVersionCode = 1;
        this.zzabB = gameBadge.getType();
        this.zzapg = gameBadge.getTitle();
        this.zzaxl = gameBadge.getDescription();
        this.zzaCd = gameBadge.getIconImageUri();
    }

    GameBadgeEntity(int versionCode, int type, String title, String description, Uri iconImageUri) {
        this.mVersionCode = versionCode;
        this.zzabB = type;
        this.zzapg = title;
        this.zzaxl = description;
        this.zzaCd = iconImageUri;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getType() {
        return this.zzabB;
    }

    @Override
    public String getTitle() {
        return this.zzapg;
    }

    @Override
    public String getDescription() {
        return this.zzaxl;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaCd;
    }

    public GameBadge zzxm() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameBadgeEntity.zza(this);
    }

    static int zza(GameBadge gameBadge) {
        return zzw.hashCode((Object[])new Object[]{gameBadge.getType(), gameBadge.getTitle(), gameBadge.getDescription(), gameBadge.getIconImageUri()});
    }

    public boolean equals(Object obj) {
        return GameBadgeEntity.zza(this, obj);
    }

    static boolean zza(GameBadge gameBadge, Object object) {
        if (!(object instanceof GameBadge)) {
            return false;
        }
        if (gameBadge == object) {
            return true;
        }
        GameBadge gameBadge2 = (GameBadge)object;
        return zzw.equal((Object)gameBadge2.getType(), (Object)gameBadge.getTitle()) && zzw.equal((Object)gameBadge2.getDescription(), (Object)gameBadge.getIconImageUri());
    }

    public String toString() {
        return GameBadgeEntity.zzb(this);
    }

    static String zzb(GameBadge gameBadge) {
        return zzw.zzy((Object)gameBadge).zzg("Type", (Object)gameBadge.getType()).zzg("Title", (Object)gameBadge.getTitle()).zzg("Description", (Object)gameBadge.getDescription()).zzg("IconImageUri", (Object)gameBadge.getIconImageUri()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzqC()) {
            GameBadgeEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeInt(this.zzabB);
            dest.writeString(this.zzapg);
            dest.writeString(this.zzaxl);
            dest.writeString(this.zzaCd == null ? null : this.zzaCd.toString());
        }
    }

    public /* synthetic */ Object freeze() {
        return this.zzxm();
    }

    static final class GameBadgeEntityCreatorCompat
    extends GameBadgeEntityCreator {
        GameBadgeEntityCreatorCompat() {
        }

        @Override
        public GameBadgeEntity zzen(Parcel parcel) {
            boolean bl = GameBadgeEntity.zzd(GameBadgeEntity.zzqB());
            if (bl || GameBadgeEntity.zzcF((String)GameBadgeEntity.class.getCanonicalName())) {
                return super.zzen(parcel);
            }
            int n = parcel.readInt();
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            return new GameBadgeEntity(1, n, string, string2, uri);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzen(parcel);
        }
    }
}

