/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.zzms;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzaJe;
    private final String zzaJf;
    private final String zzaJg;
    private final long zzaJh;
    private final long zzaJi;
    private final String zzaJj;
    private final Uri zzaJk;
    private final Uri zzaJl;
    private final PlayerEntity zzaJm;
    private final String zzaJn;
    private final String zzaJo;
    private final String zzaJp;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.zzaJe = score.getRank();
        this.zzaJf = (String)zzx.zzz((Object)score.getDisplayRank());
        this.zzaJg = (String)zzx.zzz((Object)score.getDisplayScore());
        this.zzaJh = score.getRawScore();
        this.zzaJi = score.getTimestampMillis();
        this.zzaJj = score.getScoreHolderDisplayName();
        this.zzaJk = score.getScoreHolderIconImageUri();
        this.zzaJl = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.zzaJm = player == null ? null : (PlayerEntity)player.freeze();
        this.zzaJn = score.getScoreTag();
        this.zzaJo = score.getScoreHolderIconImageUrl();
        this.zzaJp = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.zzaJe;
    }

    @Override
    public String getDisplayRank() {
        return this.zzaJf;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzaJf, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.zzaJg;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzaJg, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getRawScore() {
        return this.zzaJh;
    }

    @Override
    public long getTimestampMillis() {
        return this.zzaJi;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzaJm == null) {
            return this.zzaJj;
        }
        return this.zzaJm.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.zzaJm == null) {
            zzms.zzb((String)this.zzaJj, (CharArrayBuffer)dataOut);
            return;
        }
        this.zzaJm.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzaJm == null) {
            return this.zzaJk;
        }
        return this.zzaJm.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzaJm == null) {
            return this.zzaJo;
        }
        return this.zzaJm.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzaJm == null) {
            return this.zzaJl;
        }
        return this.zzaJm.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzaJm == null) {
            return this.zzaJp;
        }
        return this.zzaJm.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.zzaJm;
    }

    @Override
    public String getScoreTag() {
        return this.zzaJn;
    }

    public LeaderboardScore zzxK() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzw.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.zza(this, obj);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzw.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzw.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzw.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzw.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzw.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzw.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzw.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzw.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzw.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzw.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzw.zzy((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzxK();
    }
}

