/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.stats;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsEntityCreator;

public class PlayerStatsEntity
implements SafeParcelable,
PlayerStats {
    public static final Parcelable.Creator<PlayerStatsEntity> CREATOR = new PlayerStatsEntityCreator();
    private final int mVersionCode;
    private final float zzaLd;
    private final float zzaLe;
    private final int zzaLf;
    private final int zzaLg;
    private final int zzaLh;
    private final float zzaLi;
    private final float zzaLj;
    private final Bundle zzaLk;
    private final float zzaLl;

    public PlayerStatsEntity(PlayerStats playerStats) {
        this.mVersionCode = 3;
        this.zzaLd = playerStats.getAverageSessionLength();
        this.zzaLe = playerStats.getChurnProbability();
        this.zzaLf = playerStats.getDaysSinceLastPlayed();
        this.zzaLg = playerStats.getNumberOfPurchases();
        this.zzaLh = playerStats.getNumberOfSessions();
        this.zzaLi = playerStats.getSessionPercentile();
        this.zzaLj = playerStats.getSpendPercentile();
        this.zzaLl = playerStats.getSpendProbability();
        this.zzaLk = playerStats.zzxV();
    }

    PlayerStatsEntity(int versionCode, float averageSessionLength, float churnProbability, int daysSinceLastPlayed, int numberOfPurchases, int numberOfSessions, float sessionPercentile, float spendPercentile, Bundle rawValues, float spendProbability) {
        this.mVersionCode = versionCode;
        this.zzaLd = averageSessionLength;
        this.zzaLe = churnProbability;
        this.zzaLf = daysSinceLastPlayed;
        this.zzaLg = numberOfPurchases;
        this.zzaLh = numberOfSessions;
        this.zzaLi = sessionPercentile;
        this.zzaLj = spendPercentile;
        this.zzaLk = rawValues;
        this.zzaLl = spendProbability;
    }

    @Override
    public float getAverageSessionLength() {
        return this.zzaLd;
    }

    @Override
    public float getChurnProbability() {
        return this.zzaLe;
    }

    @Override
    public int getDaysSinceLastPlayed() {
        return this.zzaLf;
    }

    @Override
    public int getNumberOfPurchases() {
        return this.zzaLg;
    }

    @Override
    public int getNumberOfSessions() {
        return this.zzaLh;
    }

    @Override
    public float getSessionPercentile() {
        return this.zzaLi;
    }

    @Override
    public float getSpendPercentile() {
        return this.zzaLj;
    }

    @Override
    public Bundle zzxV() {
        return this.zzaLk;
    }

    @Override
    public float getSpendProbability() {
        return this.zzaLl;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public PlayerStats zzxW() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerStatsEntity.zza(this);
    }

    static int zza(PlayerStats playerStats) {
        return zzw.hashCode((Object[])new Object[]{Float.valueOf(playerStats.getAverageSessionLength()), Float.valueOf(playerStats.getChurnProbability()), playerStats.getDaysSinceLastPlayed(), playerStats.getNumberOfPurchases(), playerStats.getNumberOfSessions(), Float.valueOf(playerStats.getSessionPercentile()), Float.valueOf(playerStats.getSpendPercentile()), Float.valueOf(playerStats.getSpendProbability())});
    }

    public boolean equals(Object obj) {
        return PlayerStatsEntity.zza(this, obj);
    }

    static boolean zza(PlayerStats playerStats, Object object) {
        if (!(object instanceof PlayerStats)) {
            return false;
        }
        if (playerStats == object) {
            return true;
        }
        PlayerStats playerStats2 = (PlayerStats)object;
        return zzw.equal((Object)Float.valueOf(playerStats2.getAverageSessionLength()), (Object)Float.valueOf(playerStats.getAverageSessionLength())) && zzw.equal((Object)Float.valueOf(playerStats2.getChurnProbability()), (Object)Float.valueOf(playerStats.getChurnProbability())) && zzw.equal((Object)playerStats2.getDaysSinceLastPlayed(), (Object)playerStats.getDaysSinceLastPlayed()) && zzw.equal((Object)playerStats2.getNumberOfPurchases(), (Object)playerStats.getNumberOfPurchases()) && zzw.equal((Object)playerStats2.getNumberOfSessions(), (Object)playerStats.getNumberOfSessions()) && zzw.equal((Object)Float.valueOf(playerStats2.getSessionPercentile()), (Object)Float.valueOf(playerStats.getSessionPercentile())) && zzw.equal((Object)Float.valueOf(playerStats2.getSpendPercentile()), (Object)Float.valueOf(playerStats.getSpendPercentile())) && zzw.equal((Object)Float.valueOf(playerStats2.getSpendProbability()), (Object)Float.valueOf(playerStats.getSpendProbability()));
    }

    public String toString() {
        return PlayerStatsEntity.zzb(this);
    }

    static String zzb(PlayerStats playerStats) {
        return zzw.zzy((Object)playerStats).zzg("AverageSessionLength", (Object)Float.valueOf(playerStats.getAverageSessionLength())).zzg("ChurnProbability", (Object)Float.valueOf(playerStats.getChurnProbability())).zzg("DaysSinceLastPlayed", (Object)playerStats.getDaysSinceLastPlayed()).zzg("NumberOfPurchases", (Object)playerStats.getNumberOfPurchases()).zzg("NumberOfSessions", (Object)playerStats.getNumberOfSessions()).zzg("SessionPercentile", (Object)Float.valueOf(playerStats.getSessionPercentile())).zzg("SpendPercentile", (Object)Float.valueOf(playerStats.getSpendPercentile())).zzg("SpendProbability", (Object)Float.valueOf(playerStats.getSpendProbability())).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerStatsEntityCreator.zza(this, out, flags);
    }

    public /* synthetic */ Object freeze() {
        return this.zzxW();
    }
}

