/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.google.android.gms.gcm.GcmReceiver;
import com.google.android.gms.gcm.zza;
import com.google.android.gms.gcm.zzb;
import java.util.Iterator;

public abstract class GcmListenerService
extends Service {
    private final Object zzpV = new Object();
    private int zzaLy;
    private int zzaLz = 0;

    public void onMessageReceived(String from, Bundle data) {
    }

    public void onDeletedMessages() {
    }

    public void onMessageSent(String msgId) {
    }

    public void onSendError(String msgId, String error) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int onStartCommand(Intent intent, int flags, int startId) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzaLy = startId;
            ++this.zzaLz;
        }
        if (intent == null) {
            this.zzyh();
            return 2;
        }
        if ("com.google.android.gms.gcm.NOTIFICATION_OPEN".equals(intent.getAction())) {
            this.zzm(intent);
            this.zzyh();
            GcmReceiver.completeWakefulIntent((Intent)intent);
        } else {
            this.zzn(intent);
        }
        return 3;
    }

    public final IBinder onBind(Intent intent) {
        return null;
    }

    private void zzm(Intent intent) {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("com.google.android.gms.gcm.PENDING_INTENT");
        if (pendingIntent != null) {
            try {
                pendingIntent.send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.e((String)"GcmListenerService", (String)"Notification pending intent canceled");
            }
        }
        if (GcmListenerService.zzx(intent.getExtras())) {
            zza.zzf((Context)this, intent);
        }
    }

    @TargetApi(value=11)
    private void zzn(final Intent intent) {
        if (Build.VERSION.SDK_INT >= 11) {
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    GcmListenerService.this.zzo(intent);
                }
            });
        } else {
            new AsyncTask<Void, Void, Void>(){

                protected Void zzb(Void ... voidArray) {
                    GcmListenerService.this.zzo(intent);
                    return null;
                }

                protected /* synthetic */ Object doInBackground(Object[] objectArray) {
                    return this.zzb((Void[])objectArray);
                }
            }.execute((Object[])new Void[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzo(Intent intent) {
        try {
            switch (intent.getAction()) {
                case "com.google.android.c2dm.intent.RECEIVE": {
                    this.zzp(intent);
                    break;
                }
                case "com.google.android.gms.gcm.NOTIFICATION_DISMISS": {
                    if (!GcmListenerService.zzx(intent.getExtras())) break;
                    zza.zzg((Context)this, intent);
                    break;
                }
                default: {
                    Log.d((String)"GcmListenerService", (String)("Unknown intent action: " + intent.getAction()));
                }
            }
            this.zzyh();
        }
        finally {
            GcmReceiver.completeWakefulIntent((Intent)intent);
        }
    }

    private void zzp(Intent intent) {
        String string = intent.getStringExtra("message_type");
        if (string == null) {
            string = "gcm";
        }
        switch (string) {
            case "gcm": {
                if (GcmListenerService.zzx(intent.getExtras())) {
                    zza.zze((Context)this, intent);
                }
                this.zzq(intent);
                break;
            }
            case "deleted_messages": {
                this.onDeletedMessages();
                break;
            }
            case "send_event": {
                this.onMessageSent(intent.getStringExtra("google.message_id"));
                break;
            }
            case "send_error": {
                this.onSendError(intent.getStringExtra("google.message_id"), intent.getStringExtra("error"));
                break;
            }
            default: {
                Log.w((String)"GcmListenerService", (String)("Received message with unknown type: " + string));
            }
        }
    }

    private void zzq(Intent intent) {
        Bundle bundle = intent.getExtras();
        bundle.remove("message_type");
        bundle.remove("android.support.content.wakelockid");
        if (zzb.zzy(bundle)) {
            if (!zzb.zzaI((Context)this)) {
                zzb.zzc((Context)this, ((Object)((Object)this)).getClass()).zzA(bundle);
                return;
            }
            if (GcmListenerService.zzx(intent.getExtras())) {
                zza.zzh((Context)this, intent);
            }
            zzb.zzz(bundle);
        }
        String string = bundle.getString("from");
        bundle.remove("from");
        GcmListenerService.zzw(bundle);
        this.onMessageReceived(string, bundle);
    }

    static void zzw(Bundle bundle) {
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || !string.startsWith("google.c.")) continue;
            iterator.remove();
        }
    }

    static boolean zzx(Bundle bundle) {
        return "1".equals(bundle.getString("google.c.a.e"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzyh() {
        Object object = this.zzpV;
        synchronized (object) {
            --this.zzaLz;
            if (this.zzaLz == 0) {
                this.zzhd(this.zzaLy);
            }
        }
    }

    boolean zzhd(int n) {
        return this.stopSelfResult(n);
    }
}

