/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.gcm.zzb;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.zzc;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GoogleCloudMessaging {
    public static int zzaLM = 5000000;
    public static int zzaLN = 6500000;
    public static int zzaLO = 7000000;
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    @Deprecated
    public static final String MESSAGE_TYPE_DELETED = "deleted_messages";
    @Deprecated
    public static final String MESSAGE_TYPE_MESSAGE = "gcm";
    @Deprecated
    public static final String MESSAGE_TYPE_SEND_EVENT = "send_event";
    @Deprecated
    public static final String MESSAGE_TYPE_SEND_ERROR = "send_error";
    public static final String INSTANCE_ID_SCOPE = "GCM";
    static GoogleCloudMessaging zzaLP;
    private Context context;
    private PendingIntent zzaLQ;
    private Map<String, Handler> zzaLR;
    private static final AtomicInteger zzaLS;
    private final BlockingQueue<Intent> zzaLT = new LinkedBlockingQueue<Intent>();
    final Messenger zzaLU;

    public static synchronized GoogleCloudMessaging getInstance(Context context) {
        if (zzaLP == null) {
            zzaLP = new GoogleCloudMessaging();
            GoogleCloudMessaging.zzaLP.context = context.getApplicationContext();
        }
        return zzaLP;
    }

    public GoogleCloudMessaging() {
        this.zzaLR = Collections.synchronizedMap(new HashMap());
        this.zzaLU = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                Intent intent;
                if (msg == null || !(msg.obj instanceof Intent)) {
                    Log.w((String)GoogleCloudMessaging.INSTANCE_ID_SCOPE, (String)"Dropping invalid message");
                }
                if ("com.google.android.c2dm.intent.REGISTRATION".equals((intent = (Intent)msg.obj).getAction())) {
                    GoogleCloudMessaging.this.zzaLT.add(intent);
                } else if (!GoogleCloudMessaging.this.zzr(intent)) {
                    intent.setPackage(GoogleCloudMessaging.this.context.getPackageName());
                    GoogleCloudMessaging.this.context.sendBroadcast(intent);
                }
            }
        });
    }

    public void close() {
        zzaLP = null;
        zzb.zzaLC = null;
        this.zzyl();
    }

    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public void send(String to, String msgId, Bundle data) throws IOException {
        this.send(to, msgId, -1L, data);
    }

    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public void send(String to, String msgId, long timeToLive, Bundle data) throws IOException {
        this.zza(to, msgId, timeToLive, -1, data);
    }

    private void zza(String string, String string2, long l, int n, Bundle bundle) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        this.zzs(intent);
        intent.setPackage(GoogleCloudMessaging.zzaJ(this.context));
        intent.putExtra("google.to", string);
        intent.putExtra("google.message_id", string2);
        intent.putExtra("google.ttl", Long.toString(l));
        intent.putExtra("google.delay", Integer.toString(n));
        intent.putExtra("google.from", this.zzdZ(string));
        if (GoogleCloudMessaging.zzaJ(this.context).contains(".gsf")) {
            Bundle bundle2 = new Bundle();
            for (String string3 : bundle.keySet()) {
                Object object = bundle.get(string3);
                if (!(object instanceof String)) continue;
                bundle2.putString("gcm." + string3, (String)object);
            }
            bundle2.putString("google.to", string);
            bundle2.putString("google.message_id", string2);
            InstanceID.getInstance(this.context).zzc(INSTANCE_ID_SCOPE, "upstream", bundle2);
            return;
        }
        this.context.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    private String zzdZ(String string) {
        int n = string.indexOf(64);
        String string2 = n > 0 ? string.substring(0, n) : string;
        InstanceID instanceID = InstanceID.getInstance(this.context);
        return instanceID.zzyB().zzi("", string2, INSTANCE_ID_SCOPE);
    }

    private boolean zzr(Intent intent) {
        String string = intent.getStringExtra("In-Reply-To");
        if (string == null && intent.hasExtra("error")) {
            string = intent.getStringExtra("google.message_id");
        }
        Handler handler = null;
        if (string != null && (handler = this.zzaLR.remove(string)) != null) {
            Message message = Message.obtain();
            message.obj = intent;
            return handler.sendMessage(message);
        }
        return false;
    }

    private String zzyk() {
        return "google.rpc" + String.valueOf(zzaLS.getAndIncrement());
    }

    @Deprecated
    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public synchronized void unregister() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        InstanceID.getInstance(this.context).deleteInstanceID();
    }

    @Deprecated
    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public synchronized String register(String ... senderIds) throws IOException {
        String string = this.zzc(senderIds);
        Bundle bundle = new Bundle();
        if (GoogleCloudMessaging.zzaJ(this.context).contains(".gsf")) {
            bundle.putString("legacy.sender", string);
            return InstanceID.getInstance(this.context).getToken(string, INSTANCE_ID_SCOPE, bundle);
        }
        bundle.putString("sender", string);
        Intent intent = this.zzE(bundle);
        return GoogleCloudMessaging.zza(intent, "registration_id");
    }

    @Deprecated
    Intent zzE(Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        int n = GoogleCloudMessaging.zzaK(this.context);
        if (n < 0) {
            throw new IOException("Google Play Services missing");
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(GoogleCloudMessaging.zzaJ(this.context));
        this.zzs(intent);
        String string = this.zzyk();
        intent.putExtra("google.message_id", string);
        intent.putExtras(bundle);
        intent.putExtra("google.messenger", (Parcelable)this.zzaLU);
        this.context.startService(intent);
        Intent intent2 = null;
        try {
            intent2 = this.zzaLT.poll(30000L, TimeUnit.MILLISECONDS);
            return intent2;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    static String zza(Intent intent, String string) throws IOException {
        if (intent == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        String string2 = intent.getStringExtra(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = intent.getStringExtra("error");
        if (string3 != null) {
            throw new IOException(string3);
        }
        throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
    }

    String zzc(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(',').append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public String getMessageType(Intent intent) {
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.RECEIVE".equals(string)) {
            return null;
        }
        String string2 = intent.getStringExtra("message_type");
        if (string2 != null) {
            return string2;
        }
        return MESSAGE_TYPE_MESSAGE;
    }

    synchronized void zzs(Intent intent) {
        if (this.zzaLQ == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzaLQ = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzaLQ);
    }

    synchronized void zzyl() {
        if (this.zzaLQ != null) {
            this.zzaLQ.cancel();
            this.zzaLQ = null;
        }
    }

    public static String zzaJ(Context context) {
        return zzc.zzaN(context);
    }

    public static int zzaK(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(GoogleCloudMessaging.zzaJ(context), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return -1;
        }
    }

    static {
        zzaLS = new AtomicInteger(1);
    }
}

