/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;

public class OneoffTask
extends Task {
    private final long zzaLW;
    private final long zzaLX;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new Parcelable.Creator<OneoffTask>(){

        public OneoffTask zzeI(Parcel parcel) {
            return new OneoffTask(parcel);
        }

        public OneoffTask[] zzhf(int n) {
            return new OneoffTask[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.zzhf(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzeI(parcel);
        }
    };

    private OneoffTask(Builder builder) {
        super(builder);
        this.zzaLW = builder.zzaLY;
        this.zzaLX = builder.zzaLZ;
    }

    @Deprecated
    private OneoffTask(Parcel in) {
        super(in);
        this.zzaLW = in.readLong();
        this.zzaLX = in.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.zzaLW);
        bundle.putLong("window_end", this.zzaLX);
    }

    public long getWindowStart() {
        return this.zzaLW;
    }

    public long getWindowEnd() {
        return this.zzaLX;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        super.writeToParcel(parcel, flags);
        parcel.writeLong(this.zzaLW);
        parcel.writeLong(this.zzaLX);
    }

    public String toString() {
        return super.toString() + " " + "windowStart=" + this.getWindowStart() + " " + "windowEnd=" + this.getWindowEnd();
    }

    public static class Builder
    extends Task.Builder {
        private long zzaLY = -1L;
        private long zzaLZ = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long windowStartDelaySeconds, long windowEndDelaySeconds) {
            this.zzaLY = windowStartDelaySeconds;
            this.zzaLZ = windowEndDelaySeconds;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> gcmTaskService) {
            this.gcmTaskService = gcmTaskService.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int requiredNetworkState) {
            this.requiredNetworkState = requiredNetworkState;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean requiresCharging) {
            this.requiresCharging = requiresCharging;
            return this;
        }

        @Override
        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public Builder setPersisted(boolean isPersisted) {
            this.isPersisted = isPersisted;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean updateCurrent) {
            this.updateCurrent = updateCurrent;
            return this;
        }

        @Override
        public Builder setExtras(Bundle extras) {
            this.extras = extras;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzaLY == -1L || this.zzaLZ == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.zzaLY >= this.zzaLZ) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            this.checkConditions();
            return new OneoffTask(this);
        }
    }
}

