/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.MessengerCompat;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class zzc {
    static String zzaNg = null;
    static int zzaNh = 0;
    static int zzaNi = 0;
    static int zzaNj = 0;
    Context context;
    Map<String, Object> zzaNk = new HashMap<String, Object>();
    Messenger zzaLU;
    Messenger zzaNl;
    MessengerCompat zzaNm;
    PendingIntent zzaLQ;
    long zzaNn;
    long zzaNo;
    int zzaNp;
    int zzaNq;
    long zzaNr;

    public zzc(Context context) {
        this.context = context;
    }

    public static String zzaN(Context context) {
        if (zzaNg != null) {
            return zzaNg;
        }
        zzaNh = Process.myUid();
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0);
        for (ResolveInfo resolveInfo : list) {
            if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.RECEIVE", resolveInfo.serviceInfo.packageName)) {
                try {
                    ApplicationInfo applicationInfo = packageManager.getApplicationInfo(resolveInfo.serviceInfo.packageName, 0);
                    Log.w((String)"InstanceID/Rpc", (String)("Found " + applicationInfo.uid));
                    zzaNi = applicationInfo.uid;
                    zzaNg = resolveInfo.serviceInfo.packageName;
                    return zzaNg;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    continue;
                }
            }
            Log.w((String)"InstanceID/Rpc", (String)("Possible malicious package " + resolveInfo.serviceInfo.packageName + " declares " + "com.google.android.c2dm.intent.REGISTER" + " without permission"));
        }
        Log.w((String)"InstanceID/Rpc", (String)"Failed to resolve REGISTER intent, falling back");
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo("com.google.android.gms", 0);
            zzaNg = applicationInfo.packageName;
            zzaNi = applicationInfo.uid;
            return zzaNg;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            try {
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo("com.google.android.gsf", 0);
                zzaNg = applicationInfo.packageName;
                zzaNi = applicationInfo.uid;
                return zzaNg;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException2) {
                Log.w((String)"InstanceID/Rpc", (String)"Both Google Play Services and legacy GSF package are missing");
                return null;
            }
        }
    }

    static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            String string = privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA";
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            return InstanceID.zzn(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    void zzyE() {
        if (this.zzaLU != null) {
            return;
        }
        zzc.zzaN(this.context);
        this.zzaLU = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                zzc.this.zze(msg);
            }
        });
    }

    public void zze(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.zzaNm = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzaNl = (Messenger)parcelable;
                }
            }
            this.zzw((Intent)message.obj);
        } else {
            Log.w((String)"InstanceID/Rpc", (String)"Dropping invalid message");
        }
    }

    synchronized void zzt(Intent intent) {
        if (this.zzaLQ == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzaLQ = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzaLQ);
    }

    void zza(Bundle bundle, KeyPair keyPair, String string) throws IOException {
        long l = SystemClock.elapsedRealtime();
        if (this.zzaNr != 0L && l <= this.zzaNr) {
            Log.w((String)"InstanceID/Rpc", (String)("Backoff mode, next request attempt: " + (this.zzaNr - l) + " interval: " + this.zzaNq));
            throw new IOException("RETRY_LATER");
        }
        this.zzyE();
        if (zzaNg == null) {
            throw new IOException("MISSING_INSTANCEID_SERVICE");
        }
        this.zzaNn = SystemClock.elapsedRealtime();
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(zzaNg);
        int n = GoogleCloudMessaging.zzaK(this.context);
        bundle.putString("gmsv", Integer.toString(n));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", Integer.toString(InstanceID.zzaL(this.context)));
        bundle.putString("cliv", "1");
        bundle.putString("appid", InstanceID.zza(keyPair));
        String string2 = InstanceID.zzn(keyPair.getPublic().getEncoded());
        bundle.putString("pub2", string2);
        bundle.putString("sig", zzc.zza(keyPair, this.context.getPackageName(), string2));
        intent.putExtras(bundle);
        this.zzt(intent);
        this.zzb(intent, string);
    }

    protected void zzb(Intent intent, String string) {
        Intent intent2;
        boolean bl;
        block10: {
            this.zzaNn = SystemClock.elapsedRealtime();
            intent.putExtra("kid", "|ID|" + string + "|");
            intent.putExtra("X-kid", "|ID|" + string + "|");
            bl = "com.google.android.gsf".equals(zzaNg);
            String string2 = intent.getStringExtra("useGsf");
            if (string2 != null) {
                bl = "1".equals(string2);
            }
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)("Sending " + intent.getExtras()));
            }
            if (this.zzaNl != null) {
                intent.putExtra("google.messenger", (Parcelable)this.zzaLU);
                intent2 = Message.obtain();
                intent2.obj = intent;
                try {
                    this.zzaNl.send((Message)intent2);
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block10;
                    Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                }
            }
        }
        if (bl) {
            intent2 = new Intent("com.google.android.gms.iid.InstanceID");
            intent2.setPackage(this.context.getPackageName());
            intent2.putExtra("GSF", (Parcelable)intent);
            this.context.startService(intent2);
        } else {
            block11: {
                intent.putExtra("google.messenger", (Parcelable)this.zzaLU);
                intent.putExtra("messenger2", "1");
                if (this.zzaNm != null) {
                    intent2 = Message.obtain();
                    intent2.obj = intent;
                    try {
                        this.zzaNm.send((Message)intent2);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block11;
                        Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            this.context.startService(intent);
        }
    }

    String zzu(Intent intent) throws IOException {
        boolean bl;
        if (intent == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = intent.getStringExtra("registration_id");
        if (string == null) {
            string = intent.getStringExtra("unregistered");
        }
        long l = intent.getLongExtra("Retry-After", 0L);
        boolean bl2 = bl = string != null;
        if (string == null) {
            string = intent.getStringExtra("error");
            if (string != null) {
                throw new IOException(string);
            }
            Log.w((String)"InstanceID/Rpc", (String)("Unexpected response from GCM " + intent.getExtras()), (Throwable)new Throwable());
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string;
    }

    void zzv(Intent intent) {
        String string = intent.getStringExtra("error");
        if (string == null) {
            Log.w((String)"InstanceID/Rpc", (String)("Unexpected response, no error or registration id " + intent.getExtras()));
            return;
        }
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            Log.d((String)"InstanceID/Rpc", (String)("Received InstanceID error " + string));
        }
        String string2 = null;
        if (string.startsWith("|")) {
            String[] stringArray = string.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                Log.w((String)"InstanceID/Rpc", (String)("Unexpected structured response " + string));
            }
            if (stringArray.length > 2) {
                string2 = stringArray[2];
                string = stringArray[3];
                if (string.startsWith(":")) {
                    string = string.substring(1);
                }
            } else {
                string = "UNKNOWN";
            }
            intent.putExtra("error", string);
        }
        if (null == string2) {
            this.zzE(string);
        } else {
            this.zzi(string2, string);
        }
        long l = intent.getLongExtra("Retry-After", 0L);
        if (l > 0L) {
            this.zzaNo = SystemClock.elapsedRealtime();
            this.zzaNq = (int)l * 1000;
            this.zzaNr = SystemClock.elapsedRealtime() + (long)this.zzaNq;
            Log.w((String)"InstanceID/Rpc", (String)("Explicit request from server to backoff: " + this.zzaNq));
        } else if ("SERVICE_NOT_AVAILABLE".equals(string) || "AUTHENTICATION_FAILED".equals(string)) {
            this.zzea(string);
        }
    }

    private void zzea(String string) {
        if (!"com.google.android.gsf".equals(zzaNg)) {
            return;
        }
        ++this.zzaNp;
        if (this.zzaNp < 3) {
            return;
        }
        if (this.zzaNp == 3) {
            this.zzaNq = 1000 + new Random().nextInt(1000);
        }
        this.zzaNq *= 2;
        this.zzaNr = SystemClock.elapsedRealtime() + (long)this.zzaNq;
        Log.w((String)"InstanceID/Rpc", (String)("Backoff due to " + string + " for " + this.zzaNq));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzE(Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            for (String string : this.zzaNk.keySet()) {
                Object object2 = this.zzaNk.get(string);
                this.zzaNk.put(string, object);
                this.zzg(object2, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzi(String string, Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Object object2 = this.zzaNk.get(string);
            this.zzaNk.put(string, object);
            this.zzg(object2, object);
        }
    }

    private void zzg(Object object, Object object2) {
        if (object instanceof ConditionVariable) {
            ((ConditionVariable)object).open();
        }
        if (object instanceof Messenger) {
            Messenger messenger = (Messenger)object;
            Message message = Message.obtain();
            message.obj = object2;
            try {
                messenger.send(message);
            }
            catch (RemoteException remoteException) {
                Log.w((String)"InstanceID/Rpc", (String)("Failed to send response " + (Object)((Object)remoteException)));
            }
        }
    }

    void zzw(Intent intent) {
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Unexpected response: null");
            }
            return;
        }
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string) && !"com.google.android.gms.iid.InstanceID".equals(string)) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)("Unexpected response " + intent.getAction()));
            }
            return;
        }
        String string2 = intent.getStringExtra("registration_id");
        if (string2 == null) {
            string2 = intent.getStringExtra("unregistered");
        }
        if (string2 == null) {
            this.zzv(intent);
            return;
        }
        this.zzaNn = SystemClock.elapsedRealtime();
        this.zzaNr = 0L;
        this.zzaNp = 0;
        this.zzaNq = 0;
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            Log.d((String)"InstanceID/Rpc", (String)("AppIDResponse: " + string2 + " " + intent.getExtras()));
        }
        String string3 = null;
        if (string2.startsWith("|")) {
            String[] stringArray = string2.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                Log.w((String)"InstanceID/Rpc", (String)("Unexpected structured response " + string2));
            }
            string3 = stringArray[2];
            if (stringArray.length > 4) {
                if ("SYNC".equals(stringArray[3])) {
                    InstanceIDListenerService.zzaM(this.context);
                } else if ("RST".equals(stringArray[3])) {
                    InstanceIDListenerService.zza(this.context, InstanceID.getInstance(this.context).zzyB());
                    intent.removeExtra("registration_id");
                    this.zzi(string3, intent);
                    return;
                }
            }
            if ((string2 = stringArray[stringArray.length - 1]).startsWith(":")) {
                string2 = string2.substring(1);
            }
            intent.putExtra("registration_id", string2);
        }
        if (null == string3) {
            this.zzE(intent);
        } else {
            this.zzi(string3, intent);
        }
    }

    Intent zza(Bundle bundle, KeyPair keyPair) throws IOException {
        Intent intent = this.zzb(bundle, keyPair);
        if (intent != null && intent.hasExtra("google.messenger")) {
            intent = this.zzb(bundle, keyPair);
        }
        return intent;
    }

    public static synchronized String zzyF() {
        return Integer.toString(zzaNj++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent zzb(Bundle bundle, KeyPair keyPair) throws IOException {
        ConditionVariable conditionVariable = new ConditionVariable();
        String string = zzc.zzyF();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.zzaNk.put(string, conditionVariable);
        }
        this.zza(bundle, keyPair, string);
        conditionVariable.block(30000L);
        clazz = this.getClass();
        synchronized (clazz) {
            Object object = this.zzaNk.remove(string);
            if (object instanceof Intent) {
                return (Intent)object;
            }
            if (object instanceof String) {
                throw new IOException((String)object);
            }
            Log.w((String)"InstanceID/Rpc", (String)("No response " + object));
            throw new IOException("TIMEOUT");
        }
    }
}

