/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzab;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;

class BaseAdView
extends ViewGroup {
    private final zzab zzoJ;

    public BaseAdView(Context context, int adViewType) {
        super(context);
        this.zzoJ = new zzab(this, BaseAdView.zze(adViewType));
    }

    public BaseAdView(Context context, AttributeSet attrs, int adViewType) {
        super(context, attrs);
        this.zzoJ = new zzab(this, attrs, false, BaseAdView.zze(adViewType));
    }

    public BaseAdView(Context context, AttributeSet attrs, int defStyle, int adViewType) {
        super(context, attrs, defStyle);
        this.zzoJ = new zzab(this, attrs, false, BaseAdView.zze(adViewType));
    }

    public void destroy() {
        this.zzoJ.destroy();
    }

    public AdListener getAdListener() {
        return this.zzoJ.getAdListener();
    }

    public AdSize getAdSize() {
        return this.zzoJ.getAdSize();
    }

    public String getAdUnitId() {
        return this.zzoJ.getAdUnitId();
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzoJ.getInAppPurchaseListener();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zzoJ.zza(adRequest.zzaE());
    }

    public void pause() {
        this.zzoJ.pause();
    }

    public void resume() {
        this.zzoJ.resume();
    }

    public boolean isLoading() {
        return this.zzoJ.isLoading();
    }

    public void setAdListener(AdListener adListener) {
        this.zzoJ.setAdListener(adListener);
        if (adListener != null && adListener instanceof zza) {
            this.zzoJ.zza((zza)((Object)adListener));
        } else if (adListener == null) {
            this.zzoJ.zza((zza)null);
        }
    }

    public void setAdSize(AdSize adSize) {
        this.zzoJ.setAdSizes(adSize);
    }

    public void setAdUnitId(String adUnitId) {
        this.zzoJ.setAdUnitId(adUnitId);
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        this.zzoJ.setInAppPurchaseListener(inAppPurchaseListener);
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        this.zzoJ.setPlayStorePurchaseParams(playStorePurchaseListener, publicKey);
    }

    public String getMediationAdapterClassName() {
        return this.zzoJ.getMediationAdapterClassName();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n = view.getMeasuredWidth();
            int n2 = view.getMeasuredHeight();
            int n3 = (right - left - n) / 2;
            int n4 = (bottom - top - n2) / 2;
            view.layout(n3, n4, n3 + n, n4 + n2);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n = 0;
        int n2 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
            n = view.getMeasuredWidth();
            n2 = view.getMeasuredHeight();
        } else {
            AdSize adSize = this.getAdSize();
            if (adSize != null) {
                Context context = this.getContext();
                n = adSize.getWidthInPixels(context);
                n2 = adSize.getHeightInPixels(context);
            }
        }
        n = Math.max(n, this.getSuggestedMinimumWidth());
        n2 = Math.max(n2, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n, (int)widthMeasureSpec), View.resolveSize((int)n2, (int)heightMeasureSpec));
    }

    private static boolean zze(int n) {
        return n == 2;
    }
}

