/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.Parcel;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.zzi;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzhb;

@zzhb
public class AdSizeParcel
implements SafeParcelable {
    public static final zzi CREATOR = new zzi();
    public final int versionCode;
    public final String zzuh;
    public final int height;
    public final int heightPixels;
    public final boolean zzui;
    public final int width;
    public final int widthPixels;
    public final AdSizeParcel[] zzuj;
    public final boolean zzuk;
    public final boolean zzul;
    public boolean zzum;

    public static int zza(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzb(DisplayMetrics displayMetrics) {
        return (int)((float)AdSizeParcel.zzc(displayMetrics) * displayMetrics.density);
    }

    private static int zzc(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static AdSizeParcel zzt(Context context) {
        return new AdSizeParcel(5, "320x50_mb", 0, 0, false, 0, 0, null, true, false, false);
    }

    public static AdSizeParcel zzcP() {
        return new AdSizeParcel(5, "reward_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public AdSizeParcel() {
        this(5, "interstitial_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public AdSizeParcel(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    public AdSizeParcel(Context context, AdSize[] adSizes) {
        int n;
        AdSize adSize = adSizes[0];
        this.versionCode = 5;
        this.zzui = false;
        this.zzul = adSize.isFluid();
        if (this.zzul) {
            this.width = AdSize.BANNER.getWidth();
            this.height = AdSize.BANNER.getHeight();
        } else {
            this.width = adSize.getWidth();
            this.height = adSize.getHeight();
        }
        boolean bl = this.width == -1;
        boolean bl2 = this.height == -2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (bl) {
            this.widthPixels = zzn.zzcS().zzV(context) && zzn.zzcS().zzW(context) ? AdSizeParcel.zza(displayMetrics) - zzn.zzcS().zzX(context) : AdSizeParcel.zza(displayMetrics);
            double d = (float)this.widthPixels / displayMetrics.density;
            n = (int)d;
            if (d - (double)((int)d) >= 0.01) {
                ++n;
            }
        } else {
            n = this.width;
            this.widthPixels = zzn.zzcS().zza(displayMetrics, this.width);
        }
        int n2 = bl2 ? AdSizeParcel.zzc(displayMetrics) : this.height;
        this.heightPixels = zzn.zzcS().zza(displayMetrics, n2);
        this.zzuh = bl || bl2 ? n + "x" + n2 + "_as" : (this.zzul ? "320x50_mb" : adSize.toString());
        if (adSizes.length > 1) {
            this.zzuj = new AdSizeParcel[adSizes.length];
            for (int i = 0; i < adSizes.length; ++i) {
                this.zzuj[i] = new AdSizeParcel(context, adSizes[i]);
            }
        } else {
            this.zzuj = null;
        }
        this.zzuk = false;
        this.zzum = false;
    }

    public AdSizeParcel(AdSizeParcel adSize, AdSizeParcel[] supportedAdSizes) {
        this(5, adSize.zzuh, adSize.height, adSize.heightPixels, adSize.zzui, adSize.width, adSize.widthPixels, supportedAdSizes, adSize.zzuk, adSize.zzul, adSize.zzum);
    }

    AdSizeParcel(int versionCode, String formatString, int height, int heightPixels, boolean isInterstitial, int width, int widthPixels, AdSizeParcel[] supportedAdSizes, boolean isNative, boolean isFluid, boolean isNativeExpress) {
        this.versionCode = versionCode;
        this.zzuh = formatString;
        this.height = height;
        this.heightPixels = heightPixels;
        this.zzui = isInterstitial;
        this.width = width;
        this.widthPixels = widthPixels;
        this.zzuj = supportedAdSizes;
        this.zzuk = isNative;
        this.zzul = isFluid;
        this.zzum = isNativeExpress;
    }

    public int describeContents() {
        return 0;
    }

    public AdSize zzcQ() {
        return zza.zza(this.width, this.height, this.zzuh);
    }

    public void writeToParcel(Parcel out, int flags) {
        zzi.zza(this, out, flags);
    }

    public void zzi(boolean bl) {
        this.zzum = bl;
    }
}

