/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzaa;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.reward.client.zzg;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzew;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zzhb;

@zzhb
public class zzac {
    private final zzew zzuJ = new zzew();
    private final Context mContext;
    private final zzh zzoB;
    private AdListener zztA;
    private zza zztz;
    private zzu zzuL;
    private String zzpS;
    private String zzuM;
    private AppEventListener zzun;
    private PlayStorePurchaseListener zzuP;
    private InAppPurchaseListener zzuO;
    private PublisherInterstitialAd zzuT;
    private OnCustomRenderedAdLoadedListener zzuQ;
    private Correlator zzuR;
    private RewardedVideoAdListener zzaX;
    private String zzaW;
    private boolean zzuU;

    public zzac(Context context) {
        this(context, zzh.zzcO(), null);
    }

    public zzac(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzh.zzcO(), publisherInterstitialAd);
    }

    public zzac(Context context, zzh zzh2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zzoB = zzh2;
        this.zzuT = publisherInterstitialAd;
    }

    public AdListener getAdListener() {
        return this.zztA;
    }

    public String getAdUnitId() {
        return this.zzpS;
    }

    public AppEventListener getAppEventListener() {
        return this.zzun;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzuO;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzuQ;
    }

    public boolean isLoaded() {
        try {
            if (this.zzuL == null) {
                return false;
            }
            return this.zzuL.isReady();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public boolean isLoading() {
        try {
            if (this.zzuL == null) {
                return false;
            }
            return this.zzuL.isLoading();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public void zza(zzaa zzaa2) {
        try {
            if (this.zzuL == null) {
                this.zzH("loadAd");
            }
            if (this.zzuL.zzb(this.zzoB.zza(this.mContext, zzaa2))) {
                this.zzuJ.zzg(zzaa2.zzdb());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zztA = adListener;
            if (this.zzuL != null) {
                this.zzuL.zza(adListener != null ? new zzc(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zza zza2) {
        try {
            this.zztz = zza2;
            if (this.zzuL != null) {
                this.zzuL.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdUnitId(String adUnitId) {
        if (this.zzpS != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzpS = adUnitId;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzun = appEventListener;
            if (this.zzuL != null) {
                this.zzuL.zza(appEventListener != null ? new zzj(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzuP != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzuO = inAppPurchaseListener;
            if (this.zzuL != null) {
                this.zzuL.zza(inAppPurchaseListener != null ? new zzgi(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzuQ = onCustomRenderedAdLoadedListener;
            if (this.zzuL != null) {
                this.zzuL.zza(onCustomRenderedAdLoadedListener != null ? new zzcg(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        if (this.zzuO != null) {
            throw new IllegalStateException("In app purchase parameter has already been set.");
        }
        try {
            this.zzuP = playStorePurchaseListener;
            this.zzuM = publicKey;
            if (this.zzuL != null) {
                this.zzuL.zza(playStorePurchaseListener != null ? new zzgm(playStorePurchaseListener) : null, publicKey);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public void setCorrelator(Correlator correlator) {
        this.zzuR = correlator;
        try {
            if (this.zzuL != null) {
                this.zzuL.zza(this.zzuR == null ? null : this.zzuR.zzaF());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set correlator.", remoteException);
        }
    }

    public void setRewardedVideoAdListener(RewardedVideoAdListener listener) {
        try {
            this.zzaX = listener;
            if (this.zzuL != null) {
                this.zzuL.zza(listener != null ? new zzg(listener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void setUserId(String userId) {
        try {
            this.zzaW = userId;
            if (this.zzuL != null) {
                this.zzuL.setUserId(userId);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(boolean bl) {
        this.zzuU = bl;
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzuL != null) {
                return this.zzuL.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public void show() {
        try {
            this.zzI("show");
            this.zzuL.showInterstitial();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to show interstitial.", remoteException);
        }
    }

    private void zzH(String string2) throws RemoteException {
        if (this.zzpS == null) {
            this.zzI(string2);
        }
        AdSizeParcel adSizeParcel = this.zzuU ? AdSizeParcel.zzcP() : new AdSizeParcel();
        this.zzuL = zzn.zzcT().zzb(this.mContext, adSizeParcel, this.zzpS, this.zzuJ);
        if (this.zztA != null) {
            this.zzuL.zza(new zzc(this.zztA));
        }
        if (this.zztz != null) {
            this.zzuL.zza(new zzb(this.zztz));
        }
        if (this.zzun != null) {
            this.zzuL.zza(new zzj(this.zzun));
        }
        if (this.zzuO != null) {
            this.zzuL.zza(new zzgi(this.zzuO));
        }
        if (this.zzuP != null) {
            this.zzuL.zza(new zzgm(this.zzuP), this.zzuM);
        }
        if (this.zzuQ != null) {
            this.zzuL.zza(new zzcg(this.zzuQ));
        }
        if (this.zzuR != null) {
            this.zzuL.zza(this.zzuR.zzaF());
        }
        if (this.zzaX != null) {
            this.zzuL.zza(new zzg(this.zzaX));
        }
        if (this.zzaW != null) {
            this.zzuL.setUserId(this.zzaW);
        }
    }

    private void zzI(String string2) {
        if (this.zzuL == null) {
            throw new IllegalStateException("The ad unit ID must be set on InterstitialAd before " + string2 + " is called.");
        }
    }
}

