/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.ads.internal.overlay.zzs;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzfv;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzjq;
import java.util.Collections;
import java.util.Map;

@zzhb
public class zzd
extends zzfv.zza
implements zzs {
    static final int zzEg = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzEh;
    zzjp zzpD;
    zzc zzEi;
    zzo zzEj;
    boolean zzEk = false;
    FrameLayout zzEl;
    WebChromeClient.CustomViewCallback zzEm;
    boolean zzEn = false;
    boolean zzEo = false;
    RelativeLayout zzDm;
    boolean zzEp = false;
    int zzEq = 0;
    zzl zzEr;
    private boolean zzEs;
    private boolean zzEt = false;
    private boolean zzEu = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
        this.zzEr = new zzq();
    }

    public void close() {
        this.zzEq = 2;
        this.mActivity.finish();
    }

    public void zzfl() {
        if (this.zzEh != null && this.zzEk) {
            this.setRequestedOrientation(this.zzEh.orientation);
        }
        if (this.zzEl != null) {
            this.mActivity.setContentView((View)this.zzDm);
            this.zzaD();
            this.zzEl.removeAllViews();
            this.zzEl = null;
        }
        if (this.zzEm != null) {
            this.zzEm.onCustomViewHidden();
            this.zzEm = null;
        }
        this.zzEk = false;
    }

    @Override
    public void zzfm() {
        this.zzEq = 1;
        this.mActivity.finish();
    }

    @Override
    public void onBackPressed() {
        this.zzEq = 0;
    }

    @Override
    public boolean zzfn() {
        boolean bl;
        this.zzEq = 0;
        if (this.zzpD == null) {
            return true;
        }
        boolean bl2 = bl = this.zzpD.zzfL() && this.zzEr.zzfL();
        if (!bl) {
            this.zzpD.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.zzEn = savedInstanceState != null ? savedInstanceState.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzEh = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzEh == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzEh.zzrl.zzNa > 7500000) {
                this.zzEq = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzEu = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzEo = this.zzEh.zzEM != null ? this.zzEh.zzEM.zzql : false;
            if (zzbt.zzxe.get().booleanValue() && this.zzEo && this.zzEh.zzEM.zzqn != null) {
                new zzd().zzhn();
            }
            if (savedInstanceState == null) {
                if (this.zzEh.zzEC != null && this.zzEu) {
                    this.zzEh.zzEC.zzaX();
                }
                if (this.zzEh.zzEJ != 1 && this.zzEh.zzEB != null) {
                    this.zzEh.zzEB.onAdClicked();
                }
            }
            this.zzDm = new zzb((Context)this.mActivity, this.zzEh.zzEL);
            this.zzDm.setId(1000);
            switch (this.zzEh.zzEJ) {
                case 1: {
                    this.zzx(false);
                    break;
                }
                case 2: {
                    this.zzEi = new zzc(this.zzEh.zzED);
                    this.zzx(false);
                    break;
                }
                case 3: {
                    this.zzx(true);
                    break;
                }
                case 4: {
                    if (this.zzEn) {
                        this.zzEq = 3;
                        this.mActivity.finish();
                        break;
                    }
                    if (!zzr.zzbz().zza((Context)this.mActivity, this.zzEh.zzEA, this.zzEh.zzEI)) {
                        this.zzEq = 3;
                        this.mActivity.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            zzin.zzaK(zza2.getMessage());
            this.zzEq = 3;
            this.mActivity.finish();
        }
    }

    @Override
    public void onRestart() {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onResume() {
        if (this.zzEh != null && this.zzEh.zzEJ == 4) {
            if (this.zzEn) {
                this.zzEq = 3;
                this.mActivity.finish();
            } else {
                this.zzEn = true;
            }
        }
        if (this.zzEh.zzEC != null) {
            this.zzEh.zzEC.onResume();
        }
        if (this.zzpD != null && !this.zzpD.isDestroyed()) {
            zzr.zzbE().zzj(this.zzpD);
        } else {
            zzin.zzaK("The webview does not exit. Ignoring action.");
        }
        this.zzEr.resume();
    }

    @Override
    public void onPause() {
        this.zzEr.pause();
        this.zzfl();
        if (this.zzEh.zzEC != null) {
            this.zzEh.zzEC.onPause();
        }
        if (!(this.zzpD == null || this.mActivity.isFinishing() && this.zzEi != null)) {
            zzr.zzbE().zzi(this.zzpD);
        }
        this.zzfp();
    }

    @Override
    public void onSaveInstanceState(Bundle outBundle) {
        outBundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzEn);
    }

    @Override
    public void onStop() {
        this.zzfp();
    }

    @Override
    public void onDestroy() {
        if (this.zzpD != null) {
            this.zzDm.removeView(this.zzpD.getView());
        }
        this.zzfp();
    }

    public void zzw(boolean bl) {
        int n = bl ? 50 : 32;
        this.zzEj = new zzo((Context)this.mActivity, n, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzEj.zza(bl, this.zzEh.zzEG);
        this.zzDm.addView((View)this.zzEj, (ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void zzaD() {
        this.zzEs = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzEj != null) {
            this.zzEj.zza(bl, bl2);
        }
    }

    public void zzfo() {
        this.zzDm.removeView((View)this.zzEj);
        this.zzw(true);
    }

    public void setRequestedOrientation(int requestedOrientation) {
        this.mActivity.setRequestedOrientation(requestedOrientation);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzEl = new FrameLayout((Context)this.mActivity);
        this.zzEl.setBackgroundColor(-16777216);
        this.zzEl.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzEl);
        this.zzaD();
        this.zzEm = customViewCallback;
        this.zzEk = true;
    }

    protected void zzx(boolean bl) throws zza {
        com.google.android.gms.ads.internal.zzd zzd2;
        zzm zzm2;
        Window window;
        if (!this.zzEs) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        if (!this.zzEo || this.zzEh.zzEM != null && this.zzEh.zzEM.zzqm) {
            window.setFlags(1024, 1024);
        }
        boolean bl2 = this.zzEh.zzED.zzhU().zzcv();
        this.zzEp = false;
        if (bl2) {
            if (this.zzEh.orientation == zzr.zzbE().zzhv()) {
                this.zzEp = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzEh.orientation == zzr.zzbE().zzhw()) {
                this.zzEp = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        zzin.zzaI("Delay onShow to next orientation change: " + this.zzEp);
        this.setRequestedOrientation(this.zzEh.orientation);
        if (zzr.zzbE().zza(window)) {
            zzin.zzaI("Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzEo) {
            this.zzDm.setBackgroundColor(-16777216);
        } else {
            this.zzDm.setBackgroundColor(zzEg);
        }
        this.mActivity.setContentView((View)this.zzDm);
        this.zzaD();
        if (bl) {
            this.zzpD = zzr.zzbD().zza((Context)this.mActivity, this.zzEh.zzED.zzaN(), true, bl2, null, this.zzEh.zzrl, null, this.zzEh.zzED.zzhR());
            this.zzpD.zzhU().zzb(null, null, this.zzEh.zzEE, this.zzEh.zzEI, true, this.zzEh.zzEK, null, this.zzEh.zzED.zzhU().zzig(), null);
            this.zzpD.zzhU().zza(new zzjq.zza(){

                @Override
                public void zza(zzjp zzjp2, boolean bl) {
                    zzjp2.zzfr();
                }
            });
            if (this.zzEh.url != null) {
                this.zzpD.loadUrl(this.zzEh.url);
            } else if (this.zzEh.zzEH != null) {
                this.zzpD.loadDataWithBaseURL(this.zzEh.zzEF, this.zzEh.zzEH, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzEh.zzED != null) {
                this.zzEh.zzED.zzc(this);
            }
        } else {
            this.zzpD = this.zzEh.zzED;
            this.zzpD.setContext((Context)this.mActivity);
        }
        this.zzpD.zzb(this);
        ViewParent viewParent = this.zzpD.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzpD.getView());
        }
        if (this.zzEo) {
            this.zzpD.setBackgroundColor(zzEg);
        }
        this.zzDm.addView(this.zzpD.getView(), -1, -1);
        if (!bl && !this.zzEp) {
            this.zzfr();
        }
        this.zzw(bl2);
        if (this.zzpD.zzhV()) {
            this.zza(bl2, true);
        }
        zzm zzm3 = zzm2 = (zzd2 = this.zzpD.zzhR()) != null ? zzd2.zzpy : null;
        if (zzm2 != null) {
            this.zzEr = zzm2.zza(this.mActivity, this.zzpD, this.zzDm);
        } else {
            zzin.zzaK("Appstreaming controller is null.");
        }
    }

    protected void zzfp() {
        if (!this.mActivity.isFinishing() || this.zzEt) {
            return;
        }
        this.zzEt = true;
        if (this.zzpD != null) {
            this.zzy(this.zzEq);
            this.zzDm.removeView(this.zzpD.getView());
            if (this.zzEi != null) {
                this.zzpD.setContext(this.zzEi.context);
                this.zzpD.zzD(false);
                this.zzEi.zzEx.addView(this.zzpD.getView(), this.zzEi.index, this.zzEi.zzEw);
                this.zzEi = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzpD.setContext(this.mActivity.getApplicationContext());
            }
            this.zzpD = null;
        }
        if (this.zzEh != null && this.zzEh.zzEC != null) {
            this.zzEh.zzEC.zzaW();
        }
        this.zzEr.destroy();
    }

    public void zzfq() {
        if (this.zzEp) {
            this.zzEp = false;
            this.zzfr();
        }
    }

    protected void zzfr() {
        this.zzpD.zzfr();
    }

    protected void zzy(int n) {
        this.zzpD.zzy(n);
    }

    public void zzg(zzjp zzjp2, Map<String, String> map) {
        this.zzEr.zzg(zzjp2, map);
    }

    @zzhb
    private class zzd
    extends zzim {
        private zzd() {
        }

        @Override
        public void zzbr() {
            Bitmap bitmap = zzr.zzbC().zzf((Context)zzd.this.mActivity, zzd.this.zzEh.zzEM.zzqn);
            if (bitmap != null) {
                final Drawable drawable = zzr.zzbE().zza((Context)zzd.this.mActivity, bitmap, zzd.this.zzEh.zzEM.zzqo, zzd.this.zzEh.zzEM.zzqp);
                zzir.zzMc.post(new Runnable(){

                    @Override
                    public void run() {
                        zzd.this.mActivity.getWindow().setBackgroundDrawable(drawable);
                    }
                });
            }
        }

        @Override
        public void onStop() {
        }
    }

    @zzhb
    static final class zzb
    extends RelativeLayout {
        zziu zzrU;

        public zzb(Context context, String string2) {
            super(context);
            this.zzrU = new zziu(context, string2);
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            this.zzrU.zze(event);
            return false;
        }
    }

    @zzhb
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzEw;
        public final ViewGroup zzEx;
        public final Context context;

        public zzc(zzjp zzjp2) throws zza {
            this.zzEw = zzjp2.getLayoutParams();
            ViewParent viewParent = zzjp2.getParent();
            this.context = zzjp2.zzhQ();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.zzEx = (ViewGroup)viewParent;
            this.index = this.zzEx.indexOfChild(zzjp2.getView());
            this.zzEx.removeView(zzjp2.getView());
            zzjp2.zzD(true);
        }
    }

    @zzhb
    private static final class zza
    extends Exception {
        public zza(String string2) {
            super(string2);
        }
    }
}

