/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzu;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzcb;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzjp;
import java.util.HashMap;

@zzhb
public class zzk
extends FrameLayout
implements zzh {
    private final zzjp zzpD;
    private final FrameLayout zzEN;
    private final zzu zzEO;
    @Nullable
    private zzi zzEP;
    private boolean zzEQ;
    private boolean zzER;
    private TextView zzES;
    private long zzET;
    private long zzEU;
    private String zzEV;
    private String zzzK;

    public static void zzg(zzjp zzjp2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzjp2.zza("onVideoEvent", hashMap);
    }

    public zzk(Context context, zzjp zzjp2, int n, zzcb zzcb2, zzbz zzbz2) {
        super(context);
        this.zzpD = zzjp2;
        this.zzEN = new FrameLayout(context);
        this.addView((View)this.zzEN, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb.zzv((Object)zzjp2.zzhR());
        this.zzEP = zzjp2.zzhR().zzpx.zza(context, zzjp2, n, zzcb2, zzbz2);
        if (this.zzEP != null) {
            this.zzEN.addView((View)this.zzEP, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        }
        this.zzES = new TextView(context);
        this.zzES.setBackgroundColor(-16777216);
        this.zzfG();
        this.zzEO = new zzu(this);
        this.zzEO.zzfQ();
        if (this.zzEP != null) {
            this.zzEP.zza(this);
        }
        if (this.zzEP == null) {
            this.zzg("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3 + 2, n4 + 2);
        layoutParams.setMargins(n - 1, n2 - 1, 0, 0);
        this.zzEN.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public void setMimeType(String mimeType) {
        this.zzEV = mimeType;
    }

    public void zzap(String string2) {
        this.zzzK = string2;
    }

    public void zzfD() {
        if (this.zzEP == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzzK)) {
            this.zzEP.setMimeType(this.zzEV);
            this.zzEP.setVideoPath(this.zzzK);
        } else {
            this.zza("no_src", new String[0]);
        }
    }

    public void pause() {
        if (this.zzEP == null) {
            return;
        }
        this.zzEP.pause();
    }

    public void play() {
        if (this.zzEP == null) {
            return;
        }
        this.zzEP.play();
    }

    public void seekTo(int millis) {
        if (this.zzEP == null) {
            return;
        }
        this.zzEP.seekTo(millis);
    }

    public void zzff() {
        if (this.zzEP == null) {
            return;
        }
        this.zzEP.zzff();
    }

    public void zzfg() {
        if (this.zzEP == null) {
            return;
        }
        this.zzEP.zzfg();
    }

    public void zza(float f) {
        if (this.zzEP == null) {
            return;
        }
        this.zzEP.zza(f);
    }

    public void zzd(MotionEvent motionEvent) {
        if (this.zzEP == null) {
            return;
        }
        this.zzEP.dispatchTouchEvent(motionEvent);
    }

    public void zzfE() {
        if (this.zzEP == null) {
            return;
        }
        Context context = this.zzEP.getContext();
        TextView textView = new TextView(context);
        textView.setText((CharSequence)("AdMob - " + this.zzEP.zzeZ()));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzEN.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzEN.bringChildToFront((View)textView);
    }

    @Override
    public void zzfy() {
    }

    @Override
    public void zzfz() {
        if (this.zzEP == null) {
            return;
        }
        if (this.zzEU == 0L) {
            float f = (float)this.zzEP.getDuration() / 1000.0f;
            int n = this.zzEP.getVideoWidth();
            int n2 = this.zzEP.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public void zzfA() {
        this.zzfJ();
    }

    @Override
    public void onPaused() {
        this.zza("pause", new String[0]);
        this.zzfK();
    }

    @Override
    public void zzfB() {
        this.zza("ended", new String[0]);
        this.zzfK();
    }

    @Override
    public void zzg(String string2, String string3) {
        this.zza("error", "what", string2, "extra", string3);
    }

    @Override
    public void zzfC() {
        this.zzfG();
        this.zzEU = this.zzET;
    }

    public void destroy() {
        this.zzEO.cancel();
        if (this.zzEP != null) {
            this.zzEP.stop();
        }
        this.zzfK();
    }

    void zzfF() {
        if (this.zzEP == null) {
            return;
        }
        long l = this.zzEP.getCurrentPosition();
        if (this.zzET != l && l > 0L) {
            this.zzfH();
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzET = l;
        }
    }

    private void zzfG() {
        if (!this.zzfI()) {
            this.zzEN.addView((View)this.zzES, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.zzEN.bringChildToFront((View)this.zzES);
        }
    }

    private void zzfH() {
        if (this.zzfI()) {
            this.zzEN.removeView((View)this.zzES);
        }
    }

    private boolean zzfI() {
        return this.zzES.getParent() != null;
    }

    private void zza(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        for (String string4 : stringArray) {
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzpD.zza("onVideoEvent", hashMap);
    }

    private void zzfJ() {
        if (this.zzpD.zzhP() == null) {
            return;
        }
        if (this.zzEQ) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.zzpD.zzhP().getWindow().getAttributes();
        boolean bl = this.zzER = (layoutParams.flags & 0x80) != 0;
        if (!this.zzER) {
            this.zzpD.zzhP().getWindow().addFlags(128);
            this.zzEQ = true;
        }
    }

    private void zzfK() {
        if (this.zzpD.zzhP() == null) {
            return;
        }
        if (this.zzEQ && !this.zzER) {
            this.zzpD.zzhP().getWindow().clearFlags(128);
            this.zzEQ = false;
        }
    }
}

