/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import com.google.ads.afma.nano.NanoAfmaSignals;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.internal.zzai;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzap;
import com.google.android.gms.internal.zzsl;
import com.google.android.gms.internal.zzsu;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.UUID;

public abstract class zzak
implements zzaj {
    protected MotionEvent zznx;
    protected LinkedList<MotionEvent> zzny = new LinkedList();
    protected long zznz = 0L;
    protected long zznA = 0L;
    protected long zznB = 0L;
    protected long zznC = 0L;
    private boolean zznD = false;
    protected DisplayMetrics zznE;
    protected zzap zznF;
    protected static GoogleApiClient zznG;

    protected zzak(Context context, zzap zzap2) {
        this.zznF = zzap2;
        try {
            this.zznE = context.getResources().getDisplayMetrics();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.zznE = new DisplayMetrics();
            this.zznE.density = 1.0f;
        }
    }

    protected abstract NanoAfmaSignals.AFMASignals zzc(Context var1);

    protected abstract NanoAfmaSignals.AFMASignals zzd(Context var1);

    @Override
    public String zzb(Context context) {
        return this.zza(context, null, false);
    }

    @Override
    public String zzb(Context context, String string2) {
        return this.zza(context, string2, true);
    }

    @Override
    public void zza(MotionEvent motionEvent) {
        if (this.zznD) {
            this.zznC = 0L;
            this.zznB = 0L;
            this.zznA = 0L;
            this.zznz = 0L;
            for (MotionEvent motionEvent2 : this.zzny) {
                motionEvent2.recycle();
            }
            this.zzny.clear();
            this.zznx = null;
            this.zznD = false;
        }
        switch (motionEvent.getAction()) {
            case 1: {
                this.zznx = MotionEvent.obtain((MotionEvent)motionEvent);
                this.zzny.add(this.zznx);
                if (this.zzny.size() > 6) {
                    this.zzny.remove().recycle();
                }
                ++this.zznB;
                break;
            }
            case 0: {
                ++this.zznz;
                break;
            }
            case 3: {
                ++this.zznC;
                break;
            }
            case 2: {
                this.zznA += (long)(motionEvent.getHistorySize() + 1);
            }
        }
    }

    @Override
    public void zza(int n, int n2, int n3) {
        if (this.zznx != null) {
            this.zznx.recycle();
        }
        this.zznx = MotionEvent.obtain((long)0L, (long)n3, (int)1, (float)((float)n * this.zznE.density), (float)((float)n2 * this.zznE.density), (float)0.0f, (float)0.0f, (int)0, (float)0.0f, (float)0.0f, (int)0, (int)0);
    }

    private String zza(Context context, String string2, boolean bl) {
        String string3;
        try {
            NanoAfmaSignals.AFMASignals aFMASignals;
            if (bl) {
                aFMASignals = this.zzd(context);
                this.zznD = true;
            } else {
                aFMASignals = this.zzc(context);
            }
            string3 = aFMASignals == null || aFMASignals.getSerializedSize() == 0 ? Integer.toString(5) : this.zza(aFMASignals, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string3 = Integer.toString(7);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string3 = Integer.toString(7);
        }
        catch (IOException iOException) {
            string3 = Integer.toString(3);
        }
        return string3;
    }

    protected String zza(NanoAfmaSignals.AFMASignals aFMASignals, String string2) throws NoSuchAlgorithmException, UnsupportedEncodingException, IOException {
        byte[] byArray = zzsu.toByteArray((zzsu)aFMASignals);
        return this.zza(byArray, string2);
    }

    String zza(byte[] byArray, String string2) throws NoSuchAlgorithmException, UnsupportedEncodingException, IOException {
        Object object;
        Object object2;
        if (byArray.length > 239) {
            object2 = new NanoAfmaSignals.AFMASignals();
            object2.psnSignal = 1L;
            byArray = zzsu.toByteArray((zzsu)object2);
        }
        if (byArray.length < 239) {
            object = new byte[239 - byArray.length];
            new SecureRandom().nextBytes((byte[])object);
            object2 = ByteBuffer.allocate(240).put((byte)byArray.length).put(byArray).put((byte[])object).array();
        } else {
            object2 = ByteBuffer.allocate(240).put((byte)byArray.length).put(byArray).array();
        }
        object = MessageDigest.getInstance("MD5");
        ((MessageDigest)object).update((byte[])object2);
        byte[] byArray2 = ((MessageDigest)object).digest();
        byte[] byArray3 = ByteBuffer.allocate(256).put(byArray2).put((byte[])object2).array();
        byte[] byArray4 = new byte[256];
        new zzai().zzb(byArray3, byArray4);
        if (string2 != null && string2.length() > 0) {
            this.zza(string2, byArray4);
        }
        return this.zznF.zza(byArray4, true);
    }

    void zza(String string2, byte[] byArray) throws UnsupportedEncodingException {
        if (string2.length() > 32) {
            string2 = string2.substring(0, 32);
        }
        byte[] byArray2 = string2.getBytes("UTF-8");
        new zzsl(byArray2).zzC(byArray);
    }

    protected String zzk(String string2) {
        if (string2 != null && string2.matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            UUID uUID = UUID.fromString(string2);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(uUID.getMostSignificantBits());
            byteBuffer.putLong(uUID.getLeastSignificantBits());
            string2 = this.zznF.zza(byArray, true);
        }
        return string2;
    }
}

