/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzay;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzjp;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
public abstract class zzau
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    protected final Object zzpV = new Object();
    private final WeakReference<zzif> zzrW;
    private WeakReference<ViewTreeObserver> zzrX;
    private final zzbb zzrY;
    protected final zzaw zzrZ;
    private final Context zzsa;
    private final WindowManager zzsb;
    private final PowerManager zzsc;
    private final KeyguardManager zzsd;
    private zzay zzse;
    private boolean zzsf;
    private boolean zzqJ = false;
    private boolean zzsg = false;
    private boolean zzsh;
    private boolean zzsi;
    private boolean zzsj;
    BroadcastReceiver zzsk;
    private final HashSet<zzav> zzsl = new HashSet();
    private zziz zzrQ;
    private final zzdf zzsm = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            if (!zzau.this.zzb(map)) {
                return;
            }
            zzau.this.zza(zzjp2.getView(), map);
        }
    };
    private final zzdf zzsn = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            if (!zzau.this.zzb(map)) {
                return;
            }
            zzin.zzaI("Received request to untrack: " + zzau.this.zzrZ.zzcu());
            zzau.this.destroy();
        }
    };
    private final zzdf zzso = new zzdf(){

        @Override
        public void zza(zzjp zzjp2, Map<String, String> map) {
            if (!zzau.this.zzb(map)) {
                return;
            }
            if (!map.containsKey("isVisible")) {
                return;
            }
            Boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
            zzau.this.zzg(bl);
        }
    };

    public zzau(Context context, AdSizeParcel adSizeParcel, zzif zzif2, VersionInfoParcel versionInfoParcel, zzbb zzbb2) {
        this.zzrW = new WeakReference<zzif>(zzif2);
        this.zzrY = zzbb2;
        this.zzrX = new WeakReference<Object>(null);
        this.zzsh = true;
        this.zzsj = false;
        this.zzrQ = new zziz(200L);
        this.zzrZ = new zzaw(UUID.randomUUID().toString(), versionInfoParcel, adSizeParcel.zzuh, zzif2.zzKT, zzif2.zzcv(), adSizeParcel.zzuk);
        this.zzsb = (WindowManager)context.getSystemService("window");
        this.zzsc = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzsd = (KeyguardManager)context.getSystemService("keyguard");
        this.zzsa = context;
    }

    public void zza(zzav zzav2) {
        this.zzsl.add(zzav2);
    }

    protected void zzg(boolean bl) {
        for (zzav zzav2 : this.zzsl) {
            zzav2.zza(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzcd() {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzsk != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zzsk = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzau.this.zzh(false);
                }
            };
            this.zzsa.registerReceiver(this.zzsk, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzce() {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzsk != null) {
                try {
                    this.zzsa.unregisterReceiver(this.zzsk);
                }
                catch (IllegalStateException illegalStateException) {
                    zzin.zzb("Failed trying to unregister the receiver", illegalStateException);
                }
                catch (Exception exception) {
                    zzr.zzbF().zzb(exception, true);
                }
                this.zzsk = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzcj();
            this.zzce();
            this.zzsh = false;
            this.zzcg();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcf() {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzsh) {
                this.zzsi = true;
                try {
                    JSONObject jSONObject = this.zzcn();
                    this.zza(jSONObject);
                }
                catch (JSONException jSONException) {
                    zzin.zzb("JSON failure while processing active view data.", jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzin.zzb("Failure while processing active view data.", runtimeException);
                }
                zzin.zzaI("Untracking ad unit: " + this.zzrZ.zzcu());
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzh(boolean bl) {
        Object object = this.zzpV;
        synchronized (object) {
            boolean bl2;
            if (!this.zzcl() || !this.zzsh) {
                return;
            }
            View view = this.zzrY.zzco();
            boolean bl3 = bl2 = view != null && zzr.zzbC().zza(view, this.zzsc, this.zzsd) && view.getGlobalVisibleRect(new Rect(), null);
            if (bl && !this.zzrQ.tryAcquire() && bl2 == this.zzsj) {
                return;
            }
            this.zzsj = bl2;
            boolean bl4 = this.zzrY.zzcp();
            if (bl4) {
                this.zzcf();
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject);
            }
            catch (RuntimeException | JSONException throwable) {
                zzin.zza("Active view update failed.", throwable);
            }
            this.zzci();
            this.zzcg();
        }
    }

    protected void zzcg() {
        if (this.zzse != null) {
            this.zzse.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzch() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzsh;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzci() {
        zzbb zzbb2 = this.zzrY.zzcq();
        View view = zzbb2.zzco();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzrX.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzcj();
        if (!this.zzsf || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zzsf = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzrX = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    protected boolean zzb(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzrZ.zzcu());
    }

    protected void zzb(zzeh zzeh2) {
        zzeh2.zza("/updateActiveView", this.zzsm);
        zzeh2.zza("/untrackActiveViewUnit", this.zzsn);
        zzeh2.zza("/visibilityChanged", this.zzso);
    }

    protected void zzc(zzeh zzeh2) {
        zzeh2.zzb("/visibilityChanged", this.zzso);
        zzeh2.zzb("/untrackActiveViewUnit", this.zzsn);
        zzeh2.zzb("/updateActiveView", this.zzsm);
    }

    protected void zzcj() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzrX.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzck() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzrZ.zzcs()).put("activeViewJSON", (Object)this.zzrZ.zzct()).put("timestamp", zzr.zzbG().elapsedRealtime()).put("adFormat", (Object)this.zzrZ.zzcr()).put("hashCode", (Object)this.zzrZ.zzcu()).put("isMraid", this.zzrZ.zzcv()).put("isStopped", this.zzsg).put("isPaused", this.zzqJ).put("isScreenOn", this.isScreenOn()).put("isNative", this.zzrZ.zzcw());
        return jSONObject;
    }

    protected void zza(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject2 = new JSONObject();
            jSONArray.put((Object)jSONObject);
            jSONObject2.put("units", (Object)jSONArray);
            this.zzb(jSONObject2);
        }
        catch (Throwable throwable) {
            zzin.zzb("Skipping active view message.", throwable);
        }
    }

    protected abstract void zzb(JSONObject var1);

    protected abstract boolean zzcl();

    protected JSONObject zzcm() throws JSONException {
        return this.zzck().put("isAttachedToWindow", false).put("isScreenOn", this.isScreenOn()).put("isVisible", false);
    }

    protected JSONObject zzd(View view) throws JSONException {
        if (view == null) {
            return this.zzcm();
        }
        boolean bl = zzr.zzbE().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzin.zzb("Failure getting view location.", exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zzsb.getDefaultDisplay().getWidth();
        rect2.bottom = this.zzsb.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzck();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", zzr.zzbC().zza(view, this.zzsc, this.zzsd));
        return jSONObject;
    }

    boolean isScreenOn() {
        return this.zzsc.isScreenOn();
    }

    protected JSONObject zzcn() throws JSONException {
        JSONObject jSONObject = this.zzck();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzh(true);
    }

    public void onGlobalLayout() {
        this.zzh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzay zzay2) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzse = zzay2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzsg = true;
            this.zzh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzqJ = true;
            this.zzh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzqJ = false;
            this.zzh(false);
        }
    }

    public static class zzb
    implements zzbb {
        private zzh zzsr;

        public zzb(zzh zzh2) {
            this.zzsr = zzh2;
        }

        @Override
        public View zzco() {
            return this.zzsr.zzdS();
        }

        @Override
        public boolean zzcp() {
            return this.zzsr == null;
        }

        @Override
        public zzbb zzcq() {
            return this;
        }
    }

    public static class zza
    implements zzbb {
        private WeakReference<zzh> zzsq;

        public zza(zzh zzh2) {
            this.zzsq = new WeakReference<zzh>(zzh2);
        }

        @Override
        public View zzco() {
            zzh zzh2 = (zzh)this.zzsq.get();
            return zzh2 != null ? zzh2.zzdS() : null;
        }

        @Override
        public boolean zzcp() {
            return this.zzsq.get() == null;
        }

        @Override
        public zzbb zzcq() {
            return new zzb((zzh)this.zzsq.get());
        }
    }

    public static class zzc
    implements zzbb {
        private final View mView;
        private final zzif zzss;

        public zzc(View view, zzif zzif2) {
            this.mView = view;
            this.zzss = zzif2;
        }

        @Override
        public View zzco() {
            return this.mView;
        }

        @Override
        public boolean zzcp() {
            return this.zzss == null || this.mView == null;
        }

        @Override
        public zzbb zzcq() {
            return this;
        }
    }

    public static class zzd
    implements zzbb {
        private final WeakReference<View> zzst;
        private final WeakReference<zzif> zzsu;

        public zzd(View view, zzif zzif2) {
            this.zzst = new WeakReference<View>(view);
            this.zzsu = new WeakReference<zzif>(zzif2);
        }

        @Override
        public View zzco() {
            return (View)this.zzst.get();
        }

        @Override
        public boolean zzcp() {
            return this.zzst.get() == null || this.zzsu.get() == null;
        }

        @Override
        public zzbb zzcq() {
            return new zzc((View)this.zzst.get(), (zzif)this.zzsu.get());
        }
    }
}

