/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzdh;
import com.google.android.gms.internal.zzfn;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzjq;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@zzhb
public final class zzdm
implements zzdf {
    private final zzdh zzzD;
    private final zze zzzA;
    private final zzfn zzzB;

    public zzdm(zzdh zzdh2, zze zze2, zzfn zzfn2) {
        this.zzzD = zzdh2;
        this.zzzA = zze2;
        this.zzzB = zzfn2;
    }

    @Override
    public void zza(zzjp zzjp2, Map<String, String> map) {
        String string2 = map.get("a");
        if (string2 == null) {
            zzin.zzaK("Action missing from an open GMSG.");
            return;
        }
        if (this.zzzA != null && !this.zzzA.zzbh()) {
            this.zzzA.zzq(map.get("u"));
            return;
        }
        zzjq zzjq2 = zzjp2.zzhU();
        if ("expand".equalsIgnoreCase(string2)) {
            if (zzjp2.zzhY()) {
                zzin.zzaK("Cannot expand WebView that is already expanded.");
                return;
            }
            this.zzo(false);
            zzjq2.zza(zzdm.zzc(map), zzdm.zzd(map));
        } else if ("webapp".equalsIgnoreCase(string2)) {
            String string3 = map.get("u");
            this.zzo(false);
            if (string3 != null) {
                zzjq2.zza(zzdm.zzc(map), zzdm.zzd(map), string3);
            } else {
                zzjq2.zza(zzdm.zzc(map), zzdm.zzd(map), map.get("html"), map.get("baseurl"));
            }
        } else if ("in_app_purchase".equalsIgnoreCase(string2)) {
            String string4 = map.get("product_id");
            String string5 = map.get("report_urls");
            if (this.zzzD == null) {
                return;
            }
            if (string5 != null && !string5.isEmpty()) {
                String[] stringArray = string5.split(" ");
                this.zzzD.zza(string4, new ArrayList<String>(Arrays.asList(stringArray)));
            } else {
                this.zzzD.zza(string4, new ArrayList<String>());
            }
        } else if ("app".equalsIgnoreCase(string2) && "true".equalsIgnoreCase(map.get("play_store"))) {
            zzdm.zze(zzjp2, map);
        } else if ("app".equalsIgnoreCase(string2) && "true".equalsIgnoreCase(map.get("system_browser"))) {
            this.zzo(true);
            zzdm.zzf(zzjp2, map);
        } else {
            this.zzo(true);
            String string6 = map.get("u");
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                string6 = zzr.zzbC().zza(zzjp2, string6);
            }
            zzjq2.zza(new AdLauncherIntentInfoParcel(map.get("i"), string6, map.get("m"), map.get("p"), map.get("c"), map.get("f"), map.get("e")));
        }
    }

    private static void zze(zzjp zzjp2, Map<String, String> map) {
        String string2 = map.get("u");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzin.zzaK("Destination url cannot be empty.");
            return;
        }
        zza zza2 = new zza(zzjp2, string2);
        zza2.zzhn();
    }

    private static void zzf(zzjp zzjp2, Map<String, String> map) {
        Context context = zzjp2.getContext();
        String string2 = map.get("u");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzin.zzaK("Destination url cannot be empty.");
            return;
        }
        zzjq zzjq2 = zzjp2.zzhU();
        zzb zzb2 = new zzb(zzjp2);
        Intent intent = zzb2.zza(context, map);
        try {
            zzjq2.zza(new AdLauncherIntentInfoParcel(intent));
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzin.zzaK(activityNotFoundException.getMessage());
        }
    }

    private static boolean zzc(Map<String, String> map) {
        return "1".equals(map.get("custom_close"));
    }

    private static int zzd(Map<String, String> map) {
        String string2 = map.get("o");
        if (string2 != null) {
            if ("p".equalsIgnoreCase(string2)) {
                return zzr.zzbE().zzhw();
            }
            if ("l".equalsIgnoreCase(string2)) {
                return zzr.zzbE().zzhv();
            }
            if ("c".equalsIgnoreCase(string2)) {
                return zzr.zzbE().zzhx();
            }
        }
        return -1;
    }

    private void zzo(boolean bl) {
        if (this.zzzB != null) {
            this.zzzB.zzp(bl);
        }
    }

    public static class zzb {
        private final zzjp zzpD;

        public zzb(zzjp zzjp2) {
            this.zzpD = zzjp2;
        }

        public Intent zzd(Uri uri) {
            if (uri == null) {
                return null;
            }
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10000000);
            intent.setData(uri);
            intent.setAction("android.intent.action.VIEW");
            return intent;
        }

        public ResolveInfo zza(Context context, Intent intent) {
            return this.zza(context, intent, new ArrayList<ResolveInfo>());
        }

        public ResolveInfo zza(Context context, Intent intent, ArrayList<ResolveInfo> arrayList) {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return null;
            }
            List list = packageManager.queryIntentActivities(intent, 65536);
            ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
            ResolveInfo resolveInfo2 = null;
            if (list != null && resolveInfo != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ResolveInfo resolveInfo3 = (ResolveInfo)list.get(i);
                    if (resolveInfo == null || !resolveInfo.activityInfo.name.equals(resolveInfo3.activityInfo.name)) continue;
                    resolveInfo2 = resolveInfo;
                    break;
                }
            }
            arrayList.addAll(list);
            return resolveInfo2;
        }

        public Intent zza(Intent intent, ResolveInfo resolveInfo) {
            Intent intent2 = new Intent(intent);
            intent2.setClassName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name);
            return intent2;
        }

        public Intent zza(Context context, Map<String, String> map) {
            Object object;
            ResolveInfo resolveInfo3;
            Object object2;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            String string2 = map.get("u");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            if (this.zzpD != null) {
                string2 = zzr.zzbC().zza(this.zzpD, string2);
            }
            Uri uri = Uri.parse((String)string2);
            boolean bl = Boolean.parseBoolean(map.get("use_first_package"));
            boolean bl2 = Boolean.parseBoolean(map.get("use_running_process"));
            Uri uri2 = null;
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                uri2 = uri.buildUpon().scheme("https").build();
            } else if ("https".equalsIgnoreCase(uri.getScheme())) {
                uri2 = uri.buildUpon().scheme("http").build();
            }
            ArrayList<ResolveInfo> arrayList = new ArrayList<ResolveInfo>();
            Intent intent = this.zzd(uri);
            Intent intent2 = this.zzd(uri2);
            ResolveInfo resolveInfo2 = this.zza(context, intent, arrayList);
            if (resolveInfo2 != null) {
                return this.zza(intent, resolveInfo2);
            }
            if (intent2 != null && (object2 = this.zza(context, intent2)) != null && (resolveInfo3 = this.zza(context, (Intent)(object = this.zza(intent, (ResolveInfo)object2)))) != null) {
                return object;
            }
            if (arrayList.size() == 0) {
                return intent;
            }
            if (bl2 && activityManager != null && (object2 = activityManager.getRunningAppProcesses()) != null) {
                for (ResolveInfo resolveInfo3 : arrayList) {
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)iterator.next();
                        if (!runningAppProcessInfo.processName.equals(resolveInfo3.activityInfo.packageName)) continue;
                        return this.zza(intent, resolveInfo3);
                    }
                }
            }
            if (bl) {
                return this.zza(intent, arrayList.get(0));
            }
            return intent;
        }
    }

    public static class zza
    extends zzim {
        private final String zzzE = "play.google.com";
        private final String zzzF = "market";
        private final int zzzG = 10;
        private final String zzF;
        private final zzjp zzpD;

        public zza(zzjp zzjp2, String string2) {
            this.zzpD = zzjp2;
            this.zzF = string2;
        }

        public Intent zzT(String string2) {
            Uri uri = Uri.parse((String)string2);
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10000000);
            intent.setData(uri);
            return intent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbr() {
            Object object;
            String string2 = this.zzF;
            int n = 0;
            while (n < 10) {
                ++n;
                try {
                    object = new URL(string2);
                    if ("play.google.com".equalsIgnoreCase(((URL)object).getHost()) || "market".equalsIgnoreCase(((URL)object).getProtocol())) break;
                    HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
                    try {
                        zzr.zzbC().zza(this.zzpD.getContext(), this.zzpD.zzhX().afmaVersion, false, httpURLConnection);
                        int n2 = httpURLConnection.getResponseCode();
                        Map<String, List<String>> map = httpURLConnection.getHeaderFields();
                        String string3 = "";
                        if (n2 >= 300 && n2 <= 399) {
                            List<String> list = null;
                            if (map.containsKey("Location")) {
                                list = map.get("Location");
                            } else if (map.containsKey("location")) {
                                list = map.get("location");
                            }
                            if (list != null && list.size() > 0) {
                                string3 = list.get(0);
                            }
                        }
                        if (TextUtils.isEmpty((CharSequence)string3)) {
                            zzin.zzaK("Arrived at landing page, this ideally should not happen. Will open it in browser.");
                            break;
                        }
                        string2 = string3;
                    }
                    finally {
                        httpURLConnection.disconnect();
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    zzin.zzd("Error while parsing ping URL: " + string2, indexOutOfBoundsException);
                    break;
                }
                catch (IOException iOException) {
                    zzin.zzd("Error while pinging URL: " + string2, iOException);
                    break;
                }
                catch (RuntimeException runtimeException) {
                    zzin.zzd("Error while pinging URL: " + string2, runtimeException);
                    break;
                }
            }
            object = this.zzT(string2);
            zzr.zzbC().zzb(this.zzpD.getContext(), (Intent)object);
        }

        @Override
        public void onStop() {
        }
    }
}

