/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzmr;
import java.util.Map;
import java.util.Set;

@zzhb
public class zzfn
extends zzfs {
    static final Set<String> zzDa = zzmr.zzc((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzDb = "top-right";
    private boolean zzDc = true;
    private int zzDd = 0;
    private int zzDe = 0;
    private int zzoH = -1;
    private int zzDf = 0;
    private int zzDg = 0;
    private int zzoG = -1;
    private final Object zzpV = new Object();
    private final zzjp zzpD;
    private final Activity zzDh;
    private AdSizeParcel zzCh;
    private ImageView zzDi;
    private LinearLayout zzDj;
    private zzft zzDk;
    private PopupWindow zzDl;
    private RelativeLayout zzDm;
    private ViewGroup zzDn;

    public zzfn(zzjp zzjp2, zzft zzft2) {
        super(zzjp2, "resize");
        this.zzpD = zzjp2;
        this.zzDh = zzjp2.zzhP();
        this.zzDk = zzft2;
    }

    private void zzh(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zzoG = zzr.zzbC().zzaD(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zzoH = zzr.zzbC().zzaD(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzDf = zzr.zzbC().zzaD(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzDg = zzr.zzbC().zzaD(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzDc = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzDb = string2;
        }
    }

    boolean zzeL() {
        return this.zzoG > -1 && this.zzoH > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzi(Map<String, String> map) {
        Object object = this.zzpV;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzDh == null) {
                this.zzam("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzpD.zzaN() == null) {
                this.zzam("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzpD.zzaN().zzui) {
                this.zzam("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzpD.zzhY()) {
                this.zzam("Cannot resize an expanded banner.");
                return;
            }
            this.zzh(map);
            if (!this.zzeL()) {
                this.zzam("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzDh.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzam("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzeM();
            if (nArray == null) {
                this.zzam("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzn.zzcS().zzb((Context)this.zzDh, this.zzoG);
            int n2 = zzn.zzcS().zzb((Context)this.zzDh, this.zzoH);
            ViewParent viewParent = this.zzpD.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzpD.getView());
                if (this.zzDl == null) {
                    this.zzDn = (ViewGroup)viewParent;
                    bitmap = zzr.zzbC().zzk(this.zzpD.getView());
                    this.zzDi = new ImageView((Context)this.zzDh);
                    this.zzDi.setImageBitmap(bitmap);
                    this.zzCh = this.zzpD.zzaN();
                    this.zzDn.addView((View)this.zzDi);
                } else {
                    this.zzDl.dismiss();
                }
            } else {
                this.zzam("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzDm = new RelativeLayout((Context)this.zzDh);
            this.zzDm.setBackgroundColor(0);
            this.zzDm.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzDl = zzr.zzbC().zza((View)this.zzDm, n, n2, false);
            this.zzDl.setOutsideTouchable(true);
            this.zzDl.setTouchable(true);
            this.zzDl.setClippingEnabled(!this.zzDc);
            this.zzDm.addView(this.zzpD.getView(), -1, -1);
            this.zzDj = new LinearLayout((Context)this.zzDh);
            bitmap = new RelativeLayout.LayoutParams(zzn.zzcS().zzb((Context)this.zzDh, 50), zzn.zzcS().zzb((Context)this.zzDh, 50));
            switch (this.zzDb) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzDj.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzfn.this.zzp(true);
                }
            });
            this.zzDj.setContentDescription((CharSequence)"Close button");
            this.zzDm.addView((View)this.zzDj, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzDl.showAtLocation(window.getDecorView(), 0, zzn.zzcS().zzb((Context)this.zzDh, nArray[0]), zzn.zzcS().zzb((Context)this.zzDh, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                this.zzam("Cannot show popup window: " + runtimeException.getMessage());
                this.zzDm.removeView(this.zzpD.getView());
                if (this.zzDn != null) {
                    this.zzDn.removeView((View)this.zzDi);
                    this.zzDn.addView(this.zzpD.getView());
                    this.zzpD.zza(this.zzCh);
                }
                return;
            }
            this.zzc(nArray[0], nArray[1]);
            this.zzpD.zza(new AdSizeParcel((Context)this.zzDh, new AdSize(this.zzoG, this.zzoH)));
            this.zzd(nArray[0], nArray[1]);
            this.zzao("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzp(boolean bl) {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzDl != null) {
                this.zzDl.dismiss();
                this.zzDm.removeView(this.zzpD.getView());
                if (this.zzDn != null) {
                    this.zzDn.removeView((View)this.zzDi);
                    this.zzDn.addView(this.zzpD.getView());
                    this.zzpD.zza(this.zzCh);
                }
                if (bl) {
                    this.zzao("default");
                    if (this.zzDk != null) {
                        this.zzDk.zzbf();
                    }
                }
                this.zzDl = null;
                this.zzDm = null;
                this.zzDn = null;
                this.zzDj = null;
            }
        }
    }

    private int[] zzeM() {
        if (!this.zzeO()) {
            return null;
        }
        if (this.zzDc) {
            return new int[]{this.zzDd + this.zzDf, this.zzDe + this.zzDg};
        }
        int[] nArray = zzr.zzbC().zzf(this.zzDh);
        int[] nArray2 = zzr.zzbC().zzh(this.zzDh);
        int n = nArray[0];
        int n2 = this.zzDd + this.zzDf;
        int n3 = this.zzDe + this.zzDg;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zzoG > n) {
            n2 = n - this.zzoG;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zzoH > nArray2[1]) {
            n3 = nArray2[1] - this.zzoH;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzDd = n;
            this.zzDe = n2;
            if (this.zzDl != null && bl) {
                int[] nArray = this.zzeM();
                if (nArray != null) {
                    this.zzDl.update(zzn.zzcS().zzb((Context)this.zzDh, nArray[0]), zzn.zzcS().zzb((Context)this.zzDh, nArray[1]), this.zzDl.getWidth(), this.zzDl.getHeight());
                    this.zzd(nArray[0], nArray[1]);
                } else {
                    this.zzp(true);
                }
            }
        }
    }

    void zzc(int n, int n2) {
        if (this.zzDk != null) {
            this.zzDk.zza(n, n2, this.zzoG, this.zzoH);
        }
    }

    void zzd(int n, int n2) {
        int n3 = zzr.zzbC().zzh(this.zzDh)[0];
        this.zzb(n, n2 - n3, this.zzoG, this.zzoH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzeN() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzDl != null;
        }
    }

    public void zze(int n, int n2) {
        this.zzDd = n;
        this.zzDe = n2;
    }

    boolean zzeO() {
        int[] nArray = zzr.zzbC().zzf(this.zzDh);
        int[] nArray2 = zzr.zzbC().zzh(this.zzDh);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zzoG < 50 || this.zzoG > n) {
            zzin.zzaK("Width is too small or too large.");
            return false;
        }
        if (this.zzoH < 50 || this.zzoH > n2) {
            zzin.zzaK("Height is too small or too large.");
            return false;
        }
        if (this.zzoH == n2 && this.zzoG == n) {
            zzin.zzaK("Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzDc) {
            int n3 = -1;
            int n4 = -2;
            switch (this.zzDb) {
                case "top-left": {
                    n3 = this.zzDd + this.zzDf;
                    n4 = this.zzDe + this.zzDg;
                    break;
                }
                case "top-center": {
                    n3 = this.zzDd + this.zzDf + this.zzoG / 2 - 25;
                    n4 = this.zzDe + this.zzDg;
                    break;
                }
                case "center": {
                    n3 = this.zzDd + this.zzDf + this.zzoG / 2 - 25;
                    n4 = this.zzDe + this.zzDg + this.zzoH / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n3 = this.zzDd + this.zzDf;
                    n4 = this.zzDe + this.zzDg + this.zzoH - 50;
                    break;
                }
                case "bottom-center": {
                    n3 = this.zzDd + this.zzDf + this.zzoG / 2 - 25;
                    n4 = this.zzDe + this.zzDg + this.zzoH - 50;
                    break;
                }
                case "bottom-right": {
                    n3 = this.zzDd + this.zzDf + this.zzoG - 50;
                    n4 = this.zzDe + this.zzDg + this.zzoH - 50;
                    break;
                }
                default: {
                    n3 = this.zzDd + this.zzDf + this.zzoG - 50;
                    n4 = this.zzDe + this.zzDg;
                }
            }
            if (n3 < 0 || n3 + 50 > n || n4 < nArray2[0] || n4 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

