/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzhb;
import java.util.Locale;

@zzhb
public final class zzhj {
    public final int zzJQ;
    public final boolean zzJR;
    public final boolean zzJS;
    public final String zzJT;
    public final String zzJU;
    public final boolean zzJV;
    public final boolean zzJW;
    public final boolean zzJX;
    public final boolean zzJY;
    public final String zzJZ;
    public final String zzKa;
    public final int zzKb;
    public final int zzKc;
    public final int zzKd;
    public final int zzKe;
    public final int zzKf;
    public final int zzKg;
    public final float zzHF;
    public final int zzHD;
    public final int zzHE;
    public final double zzKh;
    public final boolean zzKi;
    public final boolean zzKj;
    public final int zzKk;
    public final String zzKl;

    zzhj(int n, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string4, String string5, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, double d, boolean bl7, boolean bl8, int n10, String string6) {
        this.zzJQ = n;
        this.zzJR = bl;
        this.zzJS = bl2;
        this.zzJT = string2;
        this.zzJU = string3;
        this.zzJV = bl3;
        this.zzJW = bl4;
        this.zzJX = bl5;
        this.zzJY = bl6;
        this.zzJZ = string4;
        this.zzKa = string5;
        this.zzKb = n2;
        this.zzKc = n3;
        this.zzKd = n4;
        this.zzKe = n5;
        this.zzKf = n6;
        this.zzKg = n7;
        this.zzHF = f;
        this.zzHD = n8;
        this.zzHE = n9;
        this.zzKh = d;
        this.zzKi = bl7;
        this.zzKj = bl8;
        this.zzKk = n10;
        this.zzKl = string6;
    }

    public static final class zza {
        private int zzJQ;
        private boolean zzJX;
        private boolean zzJY;
        private int zzKb;
        private int zzKf;
        private int zzKg;
        private String zzJT;
        private int zzKc;
        private int zzKd;
        private int zzKe;
        private boolean zzKj;
        private int zzKk;
        private double zzKh;
        private boolean zzKi;
        private String zzKl;
        private boolean zzJR;
        private boolean zzJS;
        private String zzJU;
        private boolean zzJV;
        private boolean zzJW;
        private String zzJZ;
        private String zzKa;
        private float zzHF;
        private int zzHD;
        private int zzHE;

        public zza(Context context) {
            PackageManager packageManager = context.getPackageManager();
            this.zzB(context);
            this.zza(context, packageManager);
            this.zzC(context);
            Locale locale = Locale.getDefault();
            this.zzJR = zza.zza(packageManager, "geo:0,0?q=donuts") != null;
            this.zzJS = zza.zza(packageManager, "http://www.google.com") != null;
            this.zzJU = locale.getCountry();
            this.zzJV = zzn.zzcS().zzhI();
            this.zzJW = zze.zzap((Context)context);
            this.zzJZ = locale.getLanguage();
            this.zzKa = zza.zza(packageManager);
            Resources resources = context.getResources();
            if (resources == null) {
                return;
            }
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            if (displayMetrics == null) {
                return;
            }
            this.zzHF = displayMetrics.density;
            this.zzHD = displayMetrics.widthPixels;
            this.zzHE = displayMetrics.heightPixels;
        }

        public zza(Context context, zzhj zzhj2) {
            PackageManager packageManager = context.getPackageManager();
            this.zzB(context);
            this.zza(context, packageManager);
            this.zzC(context);
            this.zzD(context);
            this.zzJR = zzhj2.zzJR;
            this.zzJS = zzhj2.zzJS;
            this.zzJU = zzhj2.zzJU;
            this.zzJV = zzhj2.zzJV;
            this.zzJW = zzhj2.zzJW;
            this.zzJZ = zzhj2.zzJZ;
            this.zzKa = zzhj2.zzKa;
            this.zzHF = zzhj2.zzHF;
            this.zzHD = zzhj2.zzHD;
            this.zzHE = zzhj2.zzHE;
        }

        private void zzB(Context context) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            this.zzJQ = audioManager.getMode();
            this.zzJX = audioManager.isMusicActive();
            this.zzJY = audioManager.isSpeakerphoneOn();
            this.zzKb = audioManager.getStreamVolume(3);
            this.zzKf = audioManager.getRingerMode();
            this.zzKg = audioManager.getStreamVolume(2);
        }

        @TargetApi(value=16)
        private void zza(Context context, PackageManager packageManager) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.zzJT = telephonyManager.getNetworkOperator();
            this.zzKd = telephonyManager.getNetworkType();
            this.zzKe = telephonyManager.getPhoneType();
            this.zzKc = -2;
            this.zzKj = false;
            this.zzKk = -1;
            if (zzr.zzbC().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    this.zzKc = networkInfo.getType();
                    this.zzKk = networkInfo.getDetailedState().ordinal();
                } else {
                    this.zzKc = -1;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    this.zzKj = connectivityManager.isActiveNetworkMetered();
                }
            }
        }

        private void zzC(Context context) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            if (intent != null) {
                int n = intent.getIntExtra("status", -1);
                int n2 = intent.getIntExtra("level", -1);
                int n3 = intent.getIntExtra("scale", -1);
                this.zzKh = (float)n2 / (float)n3;
                this.zzKi = n == 2 || n == 5;
            } else {
                this.zzKh = -1.0;
                this.zzKi = false;
            }
        }

        private void zzD(Context context) {
            this.zzKl = Build.FINGERPRINT;
        }

        private static String zza(PackageManager packageManager) {
            ResolveInfo resolveInfo = zza.zza(packageManager, "market://details?id=com.google.android.gms.ads");
            if (resolveInfo == null) {
                return null;
            }
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null) {
                return null;
            }
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
                return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private static ResolveInfo zza(PackageManager packageManager, String string2) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }

        public zzhj zzgI() {
            return new zzhj(this.zzJQ, this.zzJR, this.zzJS, this.zzJT, this.zzJU, this.zzJV, this.zzJW, this.zzJX, this.zzJY, this.zzJZ, this.zzKa, this.zzKb, this.zzKc, this.zzKd, this.zzKe, this.zzKf, this.zzKg, this.zzHF, this.zzHD, this.zzHE, this.zzKh, this.zzKi, this.zzKj, this.zzKk, this.zzKl);
        }
    }
}

