/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzn;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzau;
import com.google.android.gms.internal.zzbx;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzca;
import com.google.android.gms.internal.zzcb;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzjc;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzjq;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzne;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
class zzjt
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzjp {
    private final zza zzNP;
    private final Object zzpV = new Object();
    private final zzan zzyt;
    private final VersionInfoParcel zzpT;
    private final zzd zzpm;
    private zzjq zzNQ;
    private com.google.android.gms.ads.internal.overlay.zzd zzNR;
    private AdSizeParcel zzCh;
    private boolean zzNS;
    private boolean zzNT;
    private boolean zzNU;
    private boolean zzNV;
    private Boolean zzLB;
    private int zzNW;
    private boolean zzNX = true;
    private String zzEY = "";
    private zzbz zzNY;
    private zzbz zzNZ;
    private zzbz zzOa;
    private zzca zzOb;
    private WeakReference<View.OnClickListener> zzOc;
    private com.google.android.gms.ads.internal.overlay.zzd zzOd;
    private zzjc zzrV;
    private int zzDD = -1;
    private int zzDC = -1;
    private int zzDF = -1;
    private int zzDG = -1;
    private Map<String, zzdr> zzOe;
    private final WindowManager zzsb;

    static zzjt zzb(Context context, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzan zzan2, VersionInfoParcel versionInfoParcel, zzcb zzcb2, zzd zzd2) {
        zza zza2 = new zza(context);
        return new zzjt(zza2, adSizeParcel, bl, bl2, zzan2, versionInfoParcel, zzcb2, zzd2);
    }

    protected zzjt(zza zza2, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzan zzan2, VersionInfoParcel versionInfoParcel, zzcb zzcb2, zzd zzd2) {
        super((Context)zza2);
        this.zzNP = zza2;
        this.zzCh = adSizeParcel;
        this.zzNU = bl;
        this.zzNW = -1;
        this.zzyt = zzan2;
        this.zzpT = versionInfoParcel;
        this.zzpm = zzd2;
        this.zzsb = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(0);
        }
        zzr.zzbC().zza((Context)zza2, versionInfoParcel.afmaVersion, webSettings);
        zzr.zzbE().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zziq();
        if (zzne.zzsi()) {
            this.addJavascriptInterface(new zzju(this), "googleAdsJsInterface");
        }
        this.zzrV = new zzjc(this.zzNP.zzhP(), this, null);
        this.zzd(zzcb2);
    }

    @Override
    public void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzjq) {
            this.zzNQ = (zzjq)webViewClient;
        }
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public zzd zzhR() {
        return this.zzpm;
    }

    public boolean zzin() {
        int n;
        int n2;
        if (!this.zzhU().zzcv()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzr.zzbC().zza(this.zzsb);
        int n3 = zzn.zzcS().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzn.zzcS().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzhP();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzr.zzbC().zze(activity);
            n2 = zzn.zzcS().zzb(displayMetrics, nArray[0]);
            n = zzn.zzcS().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzDC == n3 && this.zzDD == n4 && this.zzDF == n2 && this.zzDG == n) {
            return false;
        }
        boolean bl = this.zzDC != n3 || this.zzDD != n4;
        this.zzDC = n3;
        this.zzDD = n4;
        this.zzDF = n2;
        this.zzDG = n;
        new zzfs(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzsb.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzr.zzbC().zzG(map);
        }
        catch (JSONException jSONException) {
            zzin.zzaK("Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public void evaluateJavascript(String script, ValueCallback<String> resultCallback) {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzin.zzaK("The webview is destroyed. Ignoring action.");
                if (resultCallback != null) {
                    resultCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(script, resultCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzaO(String string2) {
        Object object = this.zzpV;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzin.zzaK("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String uri) {
        Object object = this.zzpV;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(uri);
                }
                catch (Throwable throwable) {
                    zzin.zzaK("Could not call loadUrl. " + throwable);
                }
            } else {
                zzin.zzaK("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaL(String string2) {
        Object object = this.zzpV;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Throwable throwable) {
                zzin.zzaK("Could not call loadUrl. " + throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String data, String mimeType, String encoding) {
        Object object = this.zzpV;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(data, mimeType, encoding);
            } else {
                zzin.zzaK("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        Object object = this.zzpV;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
            } else {
                zzin.zzaK("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzpV;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzin.zzaK("The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzaP(String string2) {
        if (zzne.zzsk()) {
            if (this.zzhg() == null) {
                this.zzio();
            }
            if (this.zzhg().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                this.zzaO("javascript:" + string2);
            }
        } else {
            this.zzaO("javascript:" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzio() {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzLB = zzr.zzbF().zzhg();
            if (this.zzLB == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    void zzb(Boolean bl) {
        this.zzLB = bl;
        zzr.zzbF().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zzhg() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzLB;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zze(string2, string3);
    }

    @Override
    public void zze(String string2, String string3) {
        String string4 = string2 + "(" + string3 + ");";
        this.zzaP(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        zzin.v("Dispatching AFMA event: " + stringBuilder.toString());
        this.zzaP(stringBuilder.toString());
    }

    @Override
    public void zzhN() {
        this.zzip();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzpT.afmaVersion);
        this.zza("onhide", hashMap);
    }

    @Override
    public void zzy(int n) {
        this.zzip();
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzpT.afmaVersion);
        this.zza("onhide", hashMap);
    }

    private void zzip() {
        zzbx.zza(this.zzOb.zzdA(), this.zzNY, "aeh");
    }

    @Override
    public void zzfr() {
        if (this.zzNY == null) {
            zzbx.zza(this.zzOb.zzdA(), this.zzOa, "aes");
            this.zzNY = zzbx.zzb(this.zzOb.zzdA());
            this.zzOb.zza("native:view_show", this.zzNY);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzpT.afmaVersion);
        this.zza("onshow", hashMap);
    }

    @Override
    public void zzhO() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("app_volume", String.valueOf(zzr.zzbC().zzbt()));
        hashMap.put("device_volume", String.valueOf(zzr.zzbC().zzQ(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzhS() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzNR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzhT() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzOd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdSizeParcel zzaN() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzCh;
        }
    }

    @Override
    public zzjq zzhU() {
        return this.zzNQ;
    }

    @Override
    public boolean zzhV() {
        return this.zzNS;
    }

    @Override
    public zzan zzhW() {
        return this.zzyt;
    }

    @Override
    public VersionInfoParcel zzhX() {
        return this.zzpT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzhY() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzNU;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            zzr.zzbC().zzb(this.getContext(), intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzin.zzaI("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.zzyt != null) {
            this.zzyt.zza(event);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzNU || this.zzCh.zzuk || this.zzCh.zzul) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            if (this.zzCh.zzui) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzsb.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n5 = Integer.MAX_VALUE;
            if (n == Integer.MIN_VALUE || n == 0x40000000) {
                n5 = n2;
            }
            int n6 = Integer.MAX_VALUE;
            if (n3 == Integer.MIN_VALUE || n3 == 0x40000000) {
                n6 = n4;
            }
            if (this.zzCh.widthPixels > n5 || this.zzCh.heightPixels > n6) {
                float f = this.zzNP.getResources().getDisplayMetrics().density;
                zzin.zzaK("Not enough space to show ad. Needs " + (int)((float)this.zzCh.widthPixels / f) + "x" + (int)((float)this.zzCh.heightPixels / f) + " dp, but only has " + (int)((float)n2 / f) + "x" + (int)((float)n4 / f) + " dp.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzCh.widthPixels, this.zzCh.heightPixels);
            }
        }
    }

    public void onGlobalLayout() {
        boolean bl = this.zzin();
        com.google.android.gms.ads.internal.overlay.zzd zzd2 = this.zzhS();
        if (zzd2 != null && bl) {
            zzd2.zzfq();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, AdSizeParcel adSizeParcel, zzcb zzcb2) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzrV.zzhF();
            this.setContext(context);
            this.zzNR = null;
            this.zzCh = adSizeParcel;
            this.zzNU = false;
            this.zzNS = false;
            this.zzEY = "";
            this.zzNW = -1;
            zzr.zzbE().zzj(this);
            this.loadUrl("about:blank");
            this.zzNQ.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzNX = true;
            this.zzd(zzcb2);
        }
    }

    private void zzd(zzcb zzcb2) {
        this.zziu();
        this.zzOb = new zzca(new zzcb(true, "make_wv", this.zzCh.zzuh));
        this.zzOb.zzdA().zzc(zzcb2);
        this.zzNZ = zzbx.zzb(this.zzOb.zzdA());
        this.zzOb.zza("native:view_create", this.zzNZ);
        this.zzOa = null;
        this.zzNY = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzNR = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzc(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzOd = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzCh = adSizeParcel;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzD(boolean bl) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzNU = bl;
            this.zziq();
        }
    }

    @Override
    public void zzid() {
        this.zzrV.zzhE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzpV;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzrV.onAttachedToWindow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzpV;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzrV.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
        }
    }

    @Override
    public void setContext(Context context) {
        this.zzNP.setBaseContext(context);
        this.zzrV.zzi(this.zzNP.zzhP());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzE(boolean bl) {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzNR != null) {
                this.zzNR.zza(this.zzNQ.zzcv(), bl);
            } else {
                this.zzNS = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzNW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int requestedOrientation) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzNW = requestedOrientation;
            if (this.zzNR != null) {
                this.zzNR.setRequestedOrientation(this.zzNW);
            }
        }
    }

    @Override
    public Activity zzhP() {
        return this.zzNP.zzhP();
    }

    @Override
    public Context zzhQ() {
        return this.zzNP.zzhQ();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zziq() {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzNU || this.zzCh.zzui) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzin.zzaI("Disabling hardware acceleration on an overlay.");
                    this.zzir();
                } else {
                    zzin.zzaI("Enabling hardware acceleration on an overlay.");
                    this.zzis();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzin.zzaI("Disabling hardware acceleration on an AdView.");
                this.zzir();
            } else {
                zzin.zzaI("Enabling hardware acceleration on an AdView.");
                this.zzis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzir() {
        Object object = this.zzpV;
        synchronized (object) {
            if (!this.zzNV) {
                zzr.zzbE().zzn((View)this);
            }
            this.zzNV = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzis() {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzNV) {
                zzr.zzbE().zzm((View)this);
            }
            this.zzNV = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzpV;
        synchronized (object) {
            this.zziu();
            this.zzrV.zzhF();
            if (this.zzNR != null) {
                this.zzNR.close();
                this.zzNR.onDestroy();
                this.zzNR = null;
            }
            this.zzNQ.reset();
            if (this.zzNT) {
                return;
            }
            zzr.zzbR().zzd(this);
            this.zzit();
            this.zzNT = true;
            zzin.v("Initiating WebView self destruct sequence in 3...");
            this.zzNQ.zzii();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.zzpV;
        synchronized (object) {
            if (!this.zzNT) {
                zzr.zzbR().zzd(this);
                this.zzit();
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzhZ() {
        Object object = this.zzpV;
        synchronized (object) {
            zzin.v("Destroying WebView!");
            zzir.zzMc.post(new Runnable(){

                @Override
                public void run() {
                    zzjt.super.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzNT;
        }
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    @Override
    public void zzie() {
        if (this.zzOa == null) {
            this.zzOa = zzbx.zzb(this.zzOb.zzdA());
            this.zzOb.zza("native:view_load", this.zzOa);
        }
    }

    @Override
    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzne.zzsd()) {
                super.onPause();
            }
        }
        catch (Exception exception) {
            zzin.zzb("Could not pause webview.", exception);
        }
    }

    @Override
    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzne.zzsd()) {
                super.onResume();
            }
        }
        catch (Exception exception) {
            zzin.zzb("Could not resume webview.", exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzin.zzb("Could not stop loading webview.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzF(boolean bl) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzNX = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzfL() {
        Object object = this.zzpV;
        synchronized (object) {
            zzbx.zza(this.zzOb.zzdA(), this.zzNY, "aebb");
            return this.zzNX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzit() {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzOe != null) {
                for (zzdr zzdr2 : this.zzOe.values()) {
                    zzdr2.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaM(String string2) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzEY = string2 == null ? "" : string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRequestId() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzEY;
        }
    }

    @Override
    public zzjo zzia() {
        return null;
    }

    @Override
    public zzbz zzib() {
        return this.zzOa;
    }

    @Override
    public zzca zzic() {
        return this.zzOb;
    }

    @Override
    public void setOnClickListener(View.OnClickListener listener) {
        this.zzOc = new WeakReference<View.OnClickListener>(listener);
        super.setOnClickListener(listener);
    }

    @Override
    public View.OnClickListener zzif() {
        return (View.OnClickListener)this.zzOc.get();
    }

    private void zziu() {
        if (this.zzOb == null) {
            return;
        }
        zzcb zzcb2 = this.zzOb.zzdA();
        if (zzcb2 != null && zzr.zzbF().zzhb() != null) {
            zzr.zzbF().zzhb().zza(zzcb2);
        }
    }

    @Override
    public void zza(zzau zzau2, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public void zza(String string2, zzdf zzdf2) {
        if (this.zzNQ != null) {
            this.zzNQ.zza(string2, zzdf2);
        }
    }

    @Override
    public void zzb(String string2, zzdf zzdf2) {
        if (this.zzNQ != null) {
            this.zzNQ.zzb(string2, zzdf2);
        }
    }

    @zzhb
    public static class zza
    extends MutableContextWrapper {
        private Activity zzMM;
        private Context zzsa;
        private Context zzOg;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.zzsa = base.getApplicationContext();
            this.zzMM = base instanceof Activity ? (Activity)base : null;
            this.zzOg = base;
            super.setBaseContext(this.zzsa);
        }

        public void startActivity(Intent intent) {
            if (this.zzMM != null && !zzne.isAtLeastL()) {
                this.zzMM.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zzsa.startActivity(intent);
            }
        }

        public Activity zzhP() {
            return this.zzMM;
        }

        public Object getSystemService(String service) {
            return this.zzOg.getSystemService(service);
        }

        public Context zzhQ() {
            return this.zzOg;
        }
    }
}

