/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzrp;

public class CampaignTrackingService
extends Service {
    private Handler mHandler;
    private static Boolean zzOO;

    public static boolean zzZ(Context context) {
        zzx.zzz((Object)context);
        if (zzOO != null) {
            return zzOO;
        }
        boolean bl = zzam.zza(context, CampaignTrackingService.class);
        zzOO = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onCreate() {
        super.onCreate();
        zzf zzf2 = zzf.zzaa((Context)this);
        zzaf zzaf2 = zzf2.zzjm();
        zzaf2.zzbd("CampaignTrackingService is starting up");
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onDestroy() {
        zzf zzf2 = zzf.zzaa((Context)this);
        zzaf zzaf2 = zzf2.zzjm();
        zzaf2.zzbd("CampaignTrackingService is shutting down");
        super.onDestroy();
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public int onStartCommand(Intent intent, int flags, final int startId) {
        String string;
        this.zziz();
        zzf zzf2 = zzf.zzaa((Context)this);
        final zzaf zzaf2 = zzf2.zzjm();
        String string2 = null;
        if (zzf2.zzjn().zzkr()) {
            zzaf2.zzbh("Unexpected installation campaign (package side)");
        } else {
            string2 = intent.getStringExtra("referrer");
        }
        final Handler handler = this.getHandler();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (!zzf2.zzjn().zzkr()) {
                zzaf2.zzbg("No campaign found on com.android.vending.INSTALL_REFERRER \"referrer\" extra");
            }
            zzf2.zzjo().zzf(new Runnable(){

                @Override
                public void run() {
                    CampaignTrackingService.this.zza(zzaf2, handler, startId);
                }
            });
            return 2;
        }
        int n = zzf2.zzjn().zzkv();
        if (string2.length() <= n) {
            string = string2;
        } else {
            zzaf2.zzc("Campaign data exceed the maximum supported size and will be clipped. size, limit", string2.length(), n);
            string = string2.substring(0, n);
        }
        zzaf2.zza("CampaignTrackingService called. startId, campaign", startId, string);
        zzf2.zziH().zza(string, new Runnable(){

            @Override
            public void run() {
                CampaignTrackingService.this.zza(zzaf2, handler, startId);
            }
        });
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zziz() {
        try {
            Object object = CampaignTrackingReceiver.zzqy;
            synchronized (object) {
                zzrp zzrp2 = CampaignTrackingReceiver.zzOM;
                if (zzrp2 != null && zzrp2.isHeld()) {
                    zzrp2.release();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected void zza(final zzaf zzaf2, Handler handler, final int n) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                boolean bl = CampaignTrackingService.this.stopSelfResult(n);
                if (bl) {
                    zzaf2.zza("Install campaign broadcast processed", bl);
                }
            }
        });
    }

    private Handler getHandler() {
        Handler handler = this.mHandler;
        if (handler == null) {
            this.mHandler = handler = new Handler(this.getMainLooper());
        }
        return handler;
    }
}

