/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import com.google.android.gms.analytics.internal.zzak;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzan;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzPe = new ArrayList<Runnable>();
    private boolean zzqA;
    private boolean zzPf;
    private Set<zza> zzPg = new HashSet<zza>();
    private boolean zzPh;
    private boolean zzPi;
    private volatile boolean zzPj;
    private boolean zzPk;

    public void zza() {
        this.zziE();
        this.zzqA = true;
    }

    void zziE() {
        Logger logger;
        zzan zzan2 = this.zziI();
        if (zzan2.zzlj()) {
            this.getLogger().setLogLevel(zzan2.getLogLevel());
        }
        if (zzan2.zzln()) {
            this.setDryRun(zzan2.zzlo());
        }
        if (zzan2.zzlj() && (logger = zzae.getLogger()) != null) {
            logger.setLogLevel(zzan2.getLogLevel());
        }
    }

    public boolean isInitialized() {
        return this.zzqA && !this.zzPf;
    }

    public GoogleAnalytics(zzf context) {
        super(context);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzf.zzaa(context).zzjz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zziF() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzPe != null) {
                for (Runnable runnable : zzPe) {
                    runnable.run();
                }
                zzPe = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setDryRun(boolean dryRun) {
        this.zzPi = dryRun;
    }

    public boolean isDryRunEnabled() {
        return this.zzPi;
    }

    @TargetApi(value=14)
    public void enableAutoActivityReports(Application application) {
        if (Build.VERSION.SDK_INT >= 14 && !this.zzPh) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzPh = true;
        }
    }

    public void reportActivityStart(Activity activity) {
        if (!this.zzPh) {
            this.zzj(activity);
        }
    }

    void zzj(Activity activity) {
        for (zza zza2 : this.zzPg) {
            zza2.zzl(activity);
        }
    }

    public void reportActivityStop(Activity activity) {
        if (!this.zzPh) {
            this.zzk(activity);
        }
    }

    void zzk(Activity activity) {
        for (zza zza2 : this.zzPg) {
            zza2.zzm(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(String trackingId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzix(), trackingId, null);
            tracker.zza();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(int configResId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzak zzak2;
            zzal zzal2;
            Tracker tracker = new Tracker(this.zzix(), null, null);
            if (configResId > 0 && (zzal2 = (zzal)(zzak2 = new zzak(this.zzix())).zzah(configResId)) != null) {
                tracker.zza(zzal2);
            }
            tracker.zza();
            return tracker;
        }
    }

    void zza(zza zza2) {
        this.zzPg.add(zza2);
        Context context = this.zzix().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    void zzb(zza zza2) {
        this.zzPg.remove(zza2);
    }

    public void setAppOptOut(boolean optOut) {
        this.zzPj = optOut;
        if (this.zzPj) {
            this.zziH().zzjc();
        }
    }

    public boolean getAppOptOut() {
        return this.zzPj;
    }

    @Deprecated
    public Logger getLogger() {
        return zzae.getLogger();
    }

    @Deprecated
    public void setLogger(Logger logger) {
        zzae.setLogger(logger);
        if (!this.zzPk) {
            Log.i((String)zzy.zzRL.get(), (String)("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag." + zzy.zzRL.get() + " DEBUG"));
            this.zzPk = true;
        }
    }

    public String getClientId() {
        zzx.zzcE((String)"getClientId can not be called from the main thread");
        return this.zzix().zzjC().zzkk();
    }

    public void setLocalDispatchPeriod(int dispatchPeriodInSeconds) {
        this.zziH().setLocalDispatchPeriod(dispatchPeriodInSeconds);
    }

    public void dispatchLocalHits() {
        this.zziH().zzjd();
    }

    void zziG() {
        this.zziH().zzje();
    }

    private com.google.android.gms.analytics.internal.zzb zziH() {
        return this.zzix().zziH();
    }

    private zzan zziI() {
        return this.zzix().zziI();
    }

    @TargetApi(value=14)
    class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zzj(activity);
        }

        public void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzk(activity);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }

    static interface zza {
        public void zzl(Activity var1);

        public void zzm(Activity var1);
    }
}

