/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

public class zza
extends zzd {
    public static boolean zzPV;
    private AdvertisingIdClient.Info zzPW;
    private final zzaj zzPX;
    private String zzPY;
    private boolean zzPZ = false;
    private Object zzQa = new Object();

    zza(zzf zzf2) {
        super(zzf2);
        this.zzPX = new zzaj(zzf2.zzjl());
    }

    @Override
    protected void zziJ() {
    }

    public boolean zziU() {
        this.zzjv();
        AdvertisingIdClient.Info info = this.zziZ();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public String zziY() {
        this.zzjv();
        AdvertisingIdClient.Info info = this.zziZ();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private synchronized AdvertisingIdClient.Info zziZ() {
        if (this.zzPX.zzv(1000L)) {
            this.zzPX.start();
            AdvertisingIdClient.Info info = this.zzja();
            if (this.zza(this.zzPW, info)) {
                this.zzPW = info;
            } else {
                this.zzbh("Failed to reset client id on adid change. Not using adid");
                this.zzPW = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzPW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string;
        String string2 = string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string3 = this.zzjr().zzkk();
        Object object = this.zzQa;
        synchronized (object) {
            String string4;
            if (!this.zzPZ) {
                this.zzPY = this.zzjb();
                this.zzPZ = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzPY)) {
                String string5 = string4 = info == null ? null : info.getId();
                if (string4 == null) {
                    return this.zzbc(string + string3);
                }
                this.zzPY = zza.zzbb(string4 + string3);
            }
            string4 = zza.zzbb(string + string3);
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            if (string4.equals(this.zzPY)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzPY)) {
                this.zzbd("Resetting the client id because Advertising Id changed.");
                string3 = this.zzjr().zzkl();
                this.zza("New client Id", string3);
            }
            return this.zzbc(string + string3);
        }
    }

    protected AdvertisingIdClient.Info zzja() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzbg("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzPV) break block3;
                zzPV = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzbb(String string) {
        MessageDigest messageDigest = zzam.zzbv("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private boolean zzbc(String string) {
        try {
            String string2 = zza.zzbb(string);
            this.zzbd("Storing hashed adid.");
            Context context = this.getContext();
            FileOutputStream fileOutputStream = context.openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzPY = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    protected String zzjb() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzbg("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzbd("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

