/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzm;
import com.google.android.gms.analytics.internal.zzo;
import com.google.android.gms.common.internal.zzx;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

class zzah
extends zzd {
    private final String zzzN = zzah.zza("GoogleAnalytics", zze.VERSION, Build.VERSION.RELEASE, zzam.zza(Locale.getDefault()), Build.MODEL, Build.ID);
    private final zzaj zzTc;
    private static final byte[] zzTd = "\n".getBytes();

    zzah(zzf zzf2) {
        super(zzf2);
        this.zzTc = new zzaj(zzf2.zzjl());
    }

    @Override
    protected void zziJ() {
        this.zza("Network initialized. User agent", this.zzzN);
    }

    private static String zza(String string, String string2, String string3, String string4, String string5, String string6) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string, string2, string3, string4, string5, string6);
    }

    public boolean zzlB() {
        this.zzjk();
        this.zzjv();
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzbd("No network connectivity");
            return false;
        }
        return true;
    }

    public List<Long> zzq(List<zzab> list) {
        boolean bl;
        boolean bl2;
        this.zzjk();
        this.zzjv();
        zzx.zzz(list);
        if (this.zzjn().zzkL().isEmpty() || !this.zzTc.zzv(this.zzjn().zzkE() * 1000L)) {
            bl2 = false;
            bl = false;
        } else {
            bl2 = this.zzjn().zzkJ() != zzm.zzRk;
            boolean bl3 = bl = this.zzjn().zzkK() == zzo.zzRv;
        }
        if (bl2) {
            return this.zza(list, bl);
        }
        return this.zzr(list);
    }

    List<Long> zzr(List<zzab> list) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
        for (zzab zzab2 : list) {
            if (!this.zzg(zzab2)) break;
            arrayList.add(zzab2.zzlq());
            if (arrayList.size() < this.zzjn().zzkC()) continue;
            break;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zzb(URL uRL) {
        zzx.zzz((Object)uRL);
        this.zzb("GET request", uRL);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.zzc(uRL);
            httpURLConnection.connect();
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zziH().zzjh();
            }
            this.zzb("GET status", n);
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            this.zzd("Network GET connection error", iOException);
            int n = 0;
            return n;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zza(URL uRL, byte[] byArray) {
        zzx.zzz((Object)uRL);
        zzx.zzz((Object)byArray);
        this.zzb("POST bytes, url", byArray.length, uRL);
        if (this.zzhp()) {
            this.zza("Post payload\n", new String(byArray));
        }
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            httpURLConnection = this.zzc(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setFixedLengthStreamingMode(byArray.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zziH().zzjh();
            }
            this.zzb("POST status", n);
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            this.zzd("Network POST connection error", iOException);
            int n = 0;
            return n;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private static byte[] zzg(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zzb(URL uRL, byte[] byArray) {
        zzx.zzz((Object)uRL);
        zzx.zzz((Object)byArray);
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            byte[] byArray2 = zzah.zzg(byArray);
            this.zza("POST compressed size, ratio %, url", byArray2.length, 100L * (long)byArray2.length / (long)byArray.length, uRL);
            if (byArray2.length > byArray.length) {
                this.zzc("Compressed payload is larger then uncompressed. compressed, uncompressed", byArray2.length, byArray.length);
            }
            if (this.zzhp()) {
                this.zza("Post payload", "\n" + new String(byArray));
            }
            httpURLConnection = this.zzc(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("Content-Encoding", "gzip");
            httpURLConnection.setFixedLengthStreamingMode(byArray2.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray2);
            outputStream.close();
            outputStream = null;
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zziH().zzjh();
            }
            this.zzb("POST status", n);
            int n2 = n;
            return n2;
        }
        catch (IOException iOException) {
            this.zzd("Network compressed POST connection error", iOException);
            int n = 0;
            return n;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http compressed post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(HttpURLConnection httpURLConnection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while (inputStream.read(byArray) > 0) {
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http connection input stream", iOException);
                }
            }
        }
    }

    HttpURLConnection zzc(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException("Failed to obtain http connection");
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setConnectTimeout(this.zzjn().zzkU());
        httpURLConnection.setReadTimeout(this.zzjn().zzkV());
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setRequestProperty("User-Agent", this.zzzN);
        httpURLConnection.setDoInput(true);
        return httpURLConnection;
    }

    private boolean zzg(zzab zzab2) {
        zzx.zzz((Object)zzab2);
        String string = this.zza(zzab2, !zzab2.zzlt());
        if (string == null) {
            this.zzjm().zza(zzab2, "Error formatting hit for upload");
            return true;
        }
        if (string.length() <= this.zzjn().zzku()) {
            URL uRL = this.zzb(zzab2, string);
            if (uRL == null) {
                this.zzbh("Failed to build collect GET endpoint url");
                return false;
            }
            return this.zzb(uRL) == 200;
        }
        string = this.zza(zzab2, false);
        if (string == null) {
            this.zzjm().zza(zzab2, "Error formatting hit for POST upload");
            return true;
        }
        byte[] byArray = string.getBytes();
        if (byArray.length > this.zzjn().zzkw()) {
            this.zzjm().zza(zzab2, "Hit payload exceeds size limit");
            return true;
        }
        URL uRL = this.zzh(zzab2);
        if (uRL == null) {
            this.zzbh("Failed to build collect POST endpoint url");
            return false;
        }
        return this.zza(uRL, byArray) == 200;
    }

    List<Long> zza(List<zzab> list, boolean bl) {
        zzx.zzac((!list.isEmpty() ? 1 : 0) != 0);
        this.zza("Uploading batched hits. compression, count", bl, list.size());
        zza zza2 = new zza();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (zzab zzab2 : list) {
            if (!zza2.zzj(zzab2)) break;
            arrayList.add(zzab2.zzlq());
        }
        if (zza2.zzlE() == 0) {
            return arrayList;
        }
        URL uRL = this.zzlC();
        if (uRL == null) {
            this.zzbh("Failed to build batching endpoint url");
            return Collections.emptyList();
        }
        int n = bl ? this.zzb(uRL, zza2.getPayload()) : this.zza(uRL, zza2.getPayload());
        if (200 == n) {
            this.zza("Batched upload completed. Hits batched", zza2.zzlE());
            return arrayList;
        }
        this.zza("Network error uploading hits. status code", n);
        if (this.zzjn().zzkL().contains(n)) {
            this.zzbg("Server instructed the client to stop batching");
            this.zzTc.start();
        }
        return Collections.emptyList();
    }

    private URL zzh(zzab zzab2) {
        String string = zzab2.zzlt() ? this.zzjn().zzkF() + this.zzjn().zzkH() : this.zzjn().zzkG() + this.zzjn().zzkH();
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private URL zzb(zzab zzab2, String string) {
        String string2 = zzab2.zzlt() ? this.zzjn().zzkF() + this.zzjn().zzkH() + "?" + string : this.zzjn().zzkG() + this.zzjn().zzkH() + "?" + string;
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private URL zzlC() {
        String string = this.zzjn().zzkF() + this.zzjn().zzkI();
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    String zza(zzab zzab2, boolean bl) {
        zzx.zzz((Object)zzab2);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : zzab2.zzn().entrySet()) {
                String string = entry.getKey();
                if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string) || "z".equals(string) || "_gmsv".equals(string)) continue;
                this.zza(stringBuilder, string, entry.getValue());
            }
            this.zza(stringBuilder, "ht", String.valueOf(zzab2.zzlr()));
            long l = this.zzjl().currentTimeMillis() - zzab2.zzlr();
            this.zza(stringBuilder, "qt", String.valueOf(l));
            if (this.zzjn().zzkr()) {
                this.zza(stringBuilder, "_gmsv", zze.VERSION);
            }
            if (bl) {
                long l2 = zzab2.zzlu();
                String string = l2 != 0L ? String.valueOf(l2) : this.zzi(zzab2);
                this.zza(stringBuilder, "z", string);
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.zze("Failed to encode name or value", unsupportedEncodingException);
            return null;
        }
    }

    private void zza(StringBuilder stringBuilder, String string, String string2) throws UnsupportedEncodingException {
        if (stringBuilder.length() != 0) {
            stringBuilder.append('&');
        }
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        stringBuilder.append('=');
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
    }

    private String zzi(zzab zzab2) {
        return String.valueOf(zzab2.zzlq());
    }

    private class zza {
        private int zzTe;
        private ByteArrayOutputStream zzTf = new ByteArrayOutputStream();

        public boolean zzj(zzab zzab2) {
            zzx.zzz((Object)zzab2);
            if (this.zzTe + 1 > zzah.this.zzjn().zzkD()) {
                return false;
            }
            String string = zzah.this.zza(zzab2, false);
            if (string == null) {
                zzah.this.zzjm().zza(zzab2, "Error formatting hit");
                return true;
            }
            byte[] byArray = string.getBytes();
            int n = byArray.length;
            if (n > zzah.this.zzjn().zzkv()) {
                zzah.this.zzjm().zza(zzab2, "Hit size exceeds the maximum size limit");
                return true;
            }
            if (this.zzTf.size() > 0) {
                ++n;
            }
            if (this.zzTf.size() + n > zzah.this.zzjn().zzkx()) {
                return false;
            }
            try {
                if (this.zzTf.size() > 0) {
                    this.zzTf.write(zzTd);
                }
                this.zzTf.write(byArray);
            }
            catch (IOException iOException) {
                zzah.this.zze("Failed to write payload when batching hits", iOException);
                return true;
            }
            ++this.zzTe;
            return true;
        }

        public int zzlE() {
            return this.zzTe;
        }

        public byte[] getPayload() {
            return this.zzTf.toByteArray();
        }
    }
}

