/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.analytics.internal.Command;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzac;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzb;
import java.util.Collections;
import java.util.List;

public class zzi
extends zzd {
    private final zza zzQH;
    private zzac zzQI;
    private final zzt zzQJ;
    private zzaj zzQK;

    protected zzi(zzf zzf2) {
        super(zzf2);
        this.zzQK = new zzaj(zzf2.zzjl());
        this.zzQH = new zza();
        this.zzQJ = new zzt(zzf2){

            @Override
            public void run() {
                zzi.this.zzjJ();
            }
        };
    }

    @Override
    protected void zziJ() {
    }

    public boolean isConnected() {
        this.zzjk();
        this.zzjv();
        return this.zzQI != null;
    }

    public boolean zzb(zzab zzab2) {
        zzx.zzz((Object)zzab2);
        this.zzjk();
        this.zzjv();
        zzac zzac2 = this.zzQI;
        if (zzac2 == null) {
            return false;
        }
        String string = zzab2.zzlt() ? this.zzjn().zzkF() : this.zzjn().zzkG();
        List<Command> list = Collections.emptyList();
        try {
            zzac2.zza(zzab2.zzn(), zzab2.zzlr(), string, list);
            this.zzjI();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzbd("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public boolean zzjH() {
        this.zzjk();
        this.zzjv();
        zzac zzac2 = this.zzQI;
        if (zzac2 == null) {
            return false;
        }
        try {
            zzac2.zzjc();
            this.zzjI();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzbd("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private void zzjI() {
        this.zzQK.start();
        this.zzQJ.zzt(this.zzjn().zzkM());
    }

    public boolean connect() {
        this.zzjk();
        this.zzjv();
        if (this.zzQI != null) {
            return true;
        }
        zzac zzac2 = this.zzQH.zzjK();
        if (zzac2 != null) {
            this.zzQI = zzac2;
            this.zzjI();
            return true;
        }
        return false;
    }

    private void zza(zzac zzac2) {
        this.zzjk();
        this.zzQI = zzac2;
        this.zzjI();
        this.zziH().onServiceConnected();
    }

    public void disconnect() {
        this.zzjk();
        this.zzjv();
        try {
            zzb zzb2 = zzb.zzrP();
            zzb2.zza(this.getContext(), (ServiceConnection)this.zzQH);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.zzQI != null) {
            this.zzQI = null;
            this.onDisconnect();
        }
    }

    private void onServiceDisconnected(ComponentName name) {
        this.zzjk();
        if (this.zzQI != null) {
            this.zzQI = null;
            this.zza("Disconnected from device AnalyticsService", name);
            this.onDisconnect();
        }
    }

    private void zzjJ() {
        this.zzjk();
        if (!this.isConnected()) {
            return;
        }
        this.zzbd("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    private void onDisconnect() {
        this.zziH().zzjf();
    }

    protected class zza
    implements ServiceConnection {
        private volatile zzac zzQM;
        private volatile boolean zzQN;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public zzac zzjK() {
            zzi.this.zzjk();
            Intent intent = new Intent("com.google.android.gms.analytics.service.START");
            intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
            Context context = zzi.this.getContext();
            intent.putExtra("app_package_name", context.getPackageName());
            zzb zzb2 = zzb.zzrP();
            zza zza2 = this;
            synchronized (zza2) {
                this.zzQM = null;
                this.zzQN = true;
                boolean bl = zzb2.zza(context, intent, (ServiceConnection)zzi.this.zzQH, 129);
                zzi.this.zza("Bind to service requested", bl);
                if (!bl) {
                    this.zzQN = false;
                    return null;
                }
                try {
                    long l = zzi.this.zzjn().zzkN();
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    zzi.this.zzbg("Wait for service connect was interrupted");
                }
                this.zzQN = false;
                zzac zzac2 = this.zzQM;
                this.zzQM = null;
                if (zzac2 == null) {
                    zzi.this.zzbh("Successfully bound to service but never got onServiceConnected callback");
                }
                return zzac2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder binder) {
            zzx.zzcD((String)"AnalyticsServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    Object object;
                    if (binder == null) {
                        zzi.this.zzbh("Service connected with null binder");
                        return;
                    }
                    zzac zzac2 = null;
                    try {
                        object = binder.getInterfaceDescriptor();
                        if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(object)) {
                            zzac2 = zzac.zza.zzaf(binder);
                            zzi.this.zzbd("Bound to IAnalyticsService interface");
                        } else {
                            zzi.this.zze("Got binder with a wrong descriptor", object);
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzi.this.zzbh("Service connect failed to get IAnalyticsService");
                    }
                    if (zzac2 == null) {
                        try {
                            zzb.zzrP().zza(zzi.this.getContext(), (ServiceConnection)zzi.this.zzQH);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else if (!this.zzQN) {
                        zzi.this.zzbg("onServiceConnected received after the timeout limit");
                        object = zzac2;
                        zzi.this.zzjo().zzf(new Runnable((zzac)object){
                            final /* synthetic */ zzac zzQO;
                            {
                                this.zzQO = zzac2;
                            }

                            @Override
                            public void run() {
                                if (!zzi.this.isConnected()) {
                                    zzi.this.zzbe("Connected to service after a timeout");
                                    zzi.this.zza(this.zzQO);
                                }
                            }
                        });
                    } else {
                        this.zzQM = zzac2;
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }

        public void onServiceDisconnected(final ComponentName name) {
            zzx.zzcD((String)"AnalyticsServiceConnection.onServiceDisconnected");
            zzi.this.zzjo().zzf(new Runnable(){

                @Override
                public void run() {
                    zzi.this.onServiceDisconnected(name);
                }
            });
        }
    }
}

