/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.AnalyticsReceiver;
import com.google.android.gms.analytics.AnalyticsService;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzag;
import com.google.android.gms.analytics.internal.zzah;
import com.google.android.gms.analytics.internal.zzai;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzg;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.analytics.internal.zzi;
import com.google.android.gms.analytics.internal.zzj;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.analytics.internal.zzv;
import com.google.android.gms.analytics.internal.zzw;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzpq;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.measurement.zzc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class zzl
extends zzd {
    private boolean mStarted;
    private final zzj zzQY;
    private final zzah zzQZ;
    private final zzag zzRa;
    private final zzi zzRb;
    private long zzRc;
    private final zzt zzRd;
    private final zzt zzRe;
    private final zzaj zzRf;
    private long zzRg;
    private boolean zzRh;

    protected zzl(zzf zzf2, zzg zzg2) {
        super(zzf2);
        zzx.zzz((Object)zzg2);
        this.zzRc = Long.MIN_VALUE;
        this.zzRa = zzg2.zzk(zzf2);
        this.zzQY = zzg2.zzm(zzf2);
        this.zzQZ = zzg2.zzn(zzf2);
        this.zzRb = zzg2.zzo(zzf2);
        this.zzRf = new zzaj(this.zzjl());
        this.zzRd = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zzjV();
            }
        };
        this.zzRe = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zzjW();
            }
        };
    }

    @Override
    protected void zziJ() {
        this.zzQY.zza();
        this.zzQZ.zza();
        this.zzRb.zza();
    }

    void start() {
        this.zzjv();
        zzx.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        if (!this.zzjn().zzkr()) {
            this.zzjT();
        }
        this.zzjo().zzf(new Runnable(){

            @Override
            public void run() {
                zzl.this.zzjU();
            }
        });
    }

    private void zzjT() {
        boolean bl;
        zzf zzf2 = this.zzji();
        Context context = zzf2.getContext();
        boolean bl2 = AnalyticsReceiver.zzY(context);
        if (!bl2) {
            this.zzbg("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            bl = AnalyticsService.zzZ(context);
            if (!bl) {
                this.zzbh("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
        bl = CampaignTrackingReceiver.zzY(context);
        if (!bl) {
            this.zzbg("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            boolean bl3 = CampaignTrackingService.zzZ(context);
            if (!bl3) {
                this.zzbg("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
    }

    private boolean zzbk(String string) {
        int n = this.getContext().checkCallingOrSelfPermission(string);
        return n == 0;
    }

    protected void zzjU() {
        this.zzjv();
        this.zzjq().zzlF();
        if (!this.zzbk("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzbh("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzkj();
        }
        if (!this.zzbk("android.permission.INTERNET")) {
            this.zzbh("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzkj();
        }
        if (AnalyticsService.zzZ(this.getContext())) {
            this.zzbd("AnalyticsService registered in the app manifest and enabled");
        } else if (this.zzjn().zzkr()) {
            this.zzbh("Device AnalyticsService not registered! Hits will not be delivered reliably.");
        } else {
            this.zzbg("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!(this.zzRh || this.zzjn().zzkr() || this.zzQY.isEmpty())) {
            this.zzjX();
        }
        this.zzkb();
    }

    private void zzjV() {
        this.zzb(new zzw(){

            @Override
            public void zzc(Throwable throwable) {
                zzl.this.zzkb();
            }
        });
    }

    void zzjh() {
        this.zzjk();
        this.zzRg = this.zzjl().currentTimeMillis();
    }

    protected void onServiceConnected() {
        this.zzjk();
        if (!this.zzjn().zzkr()) {
            this.zzjY();
        }
    }

    public void zzjf() {
        com.google.android.gms.measurement.zzg.zzjk();
        this.zzjv();
        this.zzbd("Service disconnected");
    }

    public void zzJ(boolean bl) {
        this.zzkb();
    }

    private void zzjW() {
        try {
            this.zzQY.zzjN();
            this.zzkb();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzRe.zzt(this.zzjn().zzkT());
    }

    protected void zzc(zzh zzh2) {
        this.zzjk();
        this.zzb("Sending first hit to property", zzh2.zzjE());
        if (this.zzjq().zzlG().zzv(this.zzjn().zzkW())) {
            return;
        }
        String string = this.zzjq().zzlJ();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzpr zzpr2 = zzam.zza(this.zzjm(), string);
        this.zzb("Found relevant installation campaign", zzpr2);
        this.zza(zzh2, zzpr2);
    }

    public void zzs(long l) {
        com.google.android.gms.measurement.zzg.zzjk();
        this.zzjv();
        if (l < 0L) {
            l = 0L;
        }
        this.zzRc = l;
        this.zzkb();
    }

    protected void zzjX() {
        if (this.zzRh) {
            return;
        }
        if (!this.zzjn().zzkt()) {
            return;
        }
        if (this.zzRb.isConnected()) {
            return;
        }
        long l = this.zzjn().zzkO();
        if (this.zzRf.zzv(l)) {
            this.zzRf.start();
            this.zzbd("Connecting to service");
            if (this.zzRb.connect()) {
                this.zzbd("Connected to service");
                this.zzRf.clear();
                this.onServiceConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zza(zzh zzh2, boolean bl) {
        zzx.zzz((Object)zzh2);
        this.zzjv();
        this.zzjk();
        long l = -1L;
        try {
            this.zzQY.beginTransaction();
            this.zzQY.zza(zzh2.zzjD(), zzh2.getClientId());
            l = this.zzQY.zza(zzh2.zzjD(), zzh2.getClientId(), zzh2.zzjE());
            if (!bl) {
                zzh2.zzn(l);
            } else {
                zzh2.zzn(l + 1L);
            }
            this.zzQY.zzb(zzh2);
            this.zzQY.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            long l2 = -1L;
            return l2;
        }
        finally {
            try {
                this.zzQY.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public void zza(zzab zzab2) {
        zzx.zzz((Object)zzab2);
        com.google.android.gms.measurement.zzg.zzjk();
        this.zzjv();
        if (this.zzRh) {
            this.zzbe("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzab2);
        }
        zzab2 = this.zzf(zzab2);
        this.zzjX();
        if (this.zzRb.zzb(zzab2)) {
            this.zzbe("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        if (this.zzjn().zzkr()) {
            this.zzjm().zza(zzab2, "Service unavailable on package side");
            return;
        }
        try {
            this.zzQY.zzc(zzab2);
            this.zzkb();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzjm().zza(zzab2, "deliver: failed to insert hit to database");
        }
    }

    public void zzjc() {
        com.google.android.gms.measurement.zzg.zzjk();
        this.zzjv();
        if (!this.zzjn().zzkr()) {
            this.zzbd("Delete all hits from local store");
            try {
                this.zzQY.zzjL();
                this.zzQY.zzjM();
                this.zzkb();
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Failed to delete hits from store", (Object)sQLiteException);
            }
        }
        this.zzjX();
        if (this.zzRb.zzjH()) {
            this.zzbd("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    zzab zzf(zzab zzab2) {
        if (!TextUtils.isEmpty((CharSequence)zzab2.zzlv())) {
            return zzab2;
        }
        zzai.zza zza2 = this.zzjq().zzlK();
        Pair<String, Long> pair = zza2.zzlN();
        if (pair == null) {
            return zzab2;
        }
        Long l = (Long)pair.second;
        String string = (String)pair.first;
        String string2 = l + ":" + string;
        HashMap<String, String> hashMap = new HashMap<String, String>(zzab2.zzn());
        hashMap.put("_m", string2);
        return zzab.zza(this, zzab2, hashMap);
    }

    public void zzjY() {
        com.google.android.gms.measurement.zzg.zzjk();
        this.zzjv();
        this.zzjj();
        if (!this.zzjn().zzkt()) {
            this.zzbg("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!this.zzRb.isConnected()) {
            this.zzbd("Service not connected");
            return;
        }
        if (this.zzQY.isEmpty()) {
            return;
        }
        this.zzbd("Dispatching local hits to device AnalyticsService");
        block4: while (true) {
            List<zzab> list;
            try {
                list = this.zzQY.zzp(this.zzjn().zzkC());
                if (list.isEmpty()) {
                    this.zzkb();
                    return;
                }
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to read hits from store", (Object)sQLiteException);
                this.zzkf();
                return;
            }
            while (true) {
                if (list.isEmpty()) continue block4;
                zzab zzab2 = list.get(0);
                if (!this.zzRb.zzb(zzab2)) {
                    this.zzkb();
                    return;
                }
                list.remove(zzab2);
                try {
                    this.zzQY.zzq(zzab2.zzlq());
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                    this.zzkf();
                    return;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean zzjZ() {
        boolean bl;
        com.google.android.gms.measurement.zzg.zzjk();
        this.zzjv();
        this.zzbd("Dispatching a batch of local hits");
        boolean bl2 = !this.zzRb.isConnected() && !this.zzjn().zzkr();
        boolean bl3 = bl = !this.zzQZ.zzlB();
        if (bl2 && bl) {
            this.zzbd("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(this.zzjn().zzkC(), this.zzjn().zzkD());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                Object object;
                List<zzab> list;
                block38: {
                    this.zzQY.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzQY.zzp(l);
                        if (!list.isEmpty()) break block38;
                        this.zzbd("Store is empty, nothing to dispatch");
                        this.zzkf();
                        boolean bl4 = false;
                        return bl4;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzkf();
                        boolean bl5 = false;
                        try {
                            this.zzQY.setTransactionSuccessful();
                            this.zzQY.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzkf();
                            return false;
                        }
                        return bl5;
                    }
                }
                this.zza("Hits loaded from store. count", (Object)list.size());
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((zzab)object).zzlq() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzkf();
                    boolean bl6 = false;
                    return bl6;
                }
                if (this.zzRb.isConnected() && !this.zzjn().zzkr()) {
                    this.zzbd("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzRb.zzb((zzab)(object2 = list.get(0)))) {
                        l2 = Math.max(l2, ((zzab)object2).zzlq());
                        list.remove(object2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", object2);
                        try {
                            this.zzQY.zzq(((zzab)object2).zzlq());
                            arrayList.add(((zzab)object2).zzlq());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzkf();
                            boolean bl7 = false;
                            try {
                                this.zzQY.setTransactionSuccessful();
                                this.zzQY.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzkf();
                                return false;
                            }
                            return bl7;
                        }
                    }
                }
                if (this.zzQZ.zzlB()) {
                    object2 = this.zzQZ.zzq(list);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Long l3 = (Long)object.next();
                        l2 = Math.max(l2, l3);
                    }
                    list.removeAll((Collection<?>)object2);
                    try {
                        this.zzQY.zzo((List<Long>)object2);
                        arrayList.addAll((Collection<Long>)object2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzkf();
                        boolean bl8 = false;
                        try {
                            this.zzQY.setTransactionSuccessful();
                            this.zzQY.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzkf();
                            return false;
                        }
                        return bl8;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                boolean bl9 = false;
                return bl9;
            }
            finally {
                try {
                    this.zzQY.setTransactionSuccessful();
                    this.zzQY.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzkf();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public void zzb(zzw zzw2) {
        this.zza(zzw2, this.zzRg);
    }

    public void zza(final zzw zzw2, final long l) {
        block8: {
            com.google.android.gms.measurement.zzg.zzjk();
            this.zzjv();
            long l2 = -1L;
            long l3 = this.zzjq().zzlH();
            if (l3 != 0L) {
                l2 = Math.abs(this.zzjl().currentTimeMillis() - l3);
            }
            this.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
            if (!this.zzjn().zzkr()) {
                this.zzjX();
            }
            try {
                boolean bl = this.zzjZ();
                if (bl) {
                    this.zzjo().zzf(new Runnable(){

                        @Override
                        public void run() {
                            zzl.this.zza(zzw2, l);
                        }
                    });
                } else {
                    this.zzjq().zzlI();
                    this.zzkb();
                    if (zzw2 != null) {
                        zzw2.zzc(null);
                    }
                    if (this.zzRg != l) {
                        this.zzRa.zzlA();
                    }
                }
            }
            catch (Throwable throwable) {
                this.zze("Local dispatch failed", throwable);
                this.zzjq().zzlI();
                this.zzkb();
                if (zzw2 == null) break block8;
                zzw2.zzc(throwable);
            }
        }
    }

    public void zzka() {
        com.google.android.gms.measurement.zzg.zzjk();
        this.zzjv();
        this.zzbe("Sync dispatching local hits");
        long l = this.zzRg;
        if (!this.zzjn().zzkr()) {
            this.zzjX();
        }
        try {
            while (this.zzjZ()) {
            }
            this.zzjq().zzlI();
            this.zzkb();
            if (this.zzRg != l) {
                this.zzRa.zzlA();
            }
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzkb();
        }
    }

    public long zzjO() {
        com.google.android.gms.measurement.zzg.zzjk();
        this.zzjv();
        try {
            return this.zzQY.zzjO();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public void zzkb() {
        boolean bl;
        this.zzji().zzjk();
        this.zzjv();
        if (!this.zzkc()) {
            this.zzRa.unregister();
            this.zzkf();
            return;
        }
        if (this.zzQY.isEmpty()) {
            this.zzRa.unregister();
            this.zzkf();
            return;
        }
        if (!zzy.zzSs.get().booleanValue()) {
            this.zzRa.zzly();
            bl = this.zzRa.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            this.zzke();
        } else {
            this.zzkf();
            this.zzkd();
        }
    }

    private boolean zzkc() {
        if (this.zzRh) {
            return false;
        }
        if (this.zzjn().zzkr() && !this.zzjn().zzks()) {
            return false;
        }
        return this.zzki() > 0L;
    }

    private void zzkd() {
        long l;
        long l2;
        long l3;
        zzv zzv2 = this.zzjp();
        if (!zzv2.zzlb()) {
            return;
        }
        if (!zzv2.zzbw() && (l3 = this.zzjO()) != 0L && (l2 = Math.abs((l = this.zzjl().currentTimeMillis()) - l3)) <= this.zzjn().zzkB()) {
            long l4 = this.zzjn().zzkA();
            this.zza("Dispatch alarm scheduled (ms)", (Object)l4);
            zzv2.zzlc();
        }
    }

    private void zzke() {
        long l;
        long l2;
        this.zzkd();
        long l3 = this.zzki();
        long l4 = this.zzjq().zzlH();
        long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(this.zzjl().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(this.zzjn().zzky(), l3)) : Math.min(this.zzjn().zzky(), l3);
        this.zza("Dispatch scheduled (ms)", (Object)l5);
        if (this.zzRd.zzbw()) {
            l = Math.max(1L, l5 + this.zzRd.zzkY());
            this.zzRd.zzu(l);
        } else {
            this.zzRd.zzt(l5);
        }
    }

    private void zzkf() {
        this.zzkg();
        this.zzkh();
    }

    private void zzkg() {
        if (this.zzRd.zzbw()) {
            this.zzbd("All hits dispatched or no network/service. Going to power save mode");
        }
        this.zzRd.cancel();
    }

    private void zzkh() {
        zzv zzv2 = this.zzjp();
        if (zzv2.zzbw()) {
            zzv2.cancel();
        }
    }

    public long zzki() {
        if (this.zzRc != Long.MIN_VALUE) {
            return this.zzRc;
        }
        long l = this.zzjn().zzkz();
        if (this.zziI().zzll()) {
            l = (long)this.zziI().zzmc() * 1000L;
        }
        return l;
    }

    public void zzbl(String string) {
        zzx.zzcM((String)string);
        this.zzjk();
        this.zzjj();
        zzpr zzpr2 = zzam.zza(this.zzjm(), string);
        if (zzpr2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzjq().zzlJ();
        if (string.equals(string2)) {
            this.zzbg("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzjq().zzbp(string);
        if (this.zzjq().zzlG().zzv(this.zzjn().zzkW())) {
            this.zzd("Campaign received too late, ignoring", zzpr2);
            return;
        }
        this.zzb("Received installation campaign", zzpr2);
        List<zzh> list = this.zzQY.zzr(0L);
        for (zzh zzh2 : list) {
            this.zza(zzh2, zzpr2);
        }
    }

    private void zza(zzh zzh2, zzpr zzpr2) {
        zzx.zzz((Object)zzh2);
        zzx.zzz((Object)zzpr2);
        zza zza2 = new zza(this.zzji());
        zza2.zzaS(zzh2.zzjE());
        zza2.enableAdvertisingIdCollection(zzh2.zzjF());
        zzc zzc2 = zza2.zziy();
        zzke zzke2 = zzc2.zzf(zzke.class);
        zzke2.zzaX("data");
        zzke2.zzI(true);
        zzc2.zzb(zzpr2);
        zzkd zzkd2 = zzc2.zzf(zzkd.class);
        zzpq zzpq2 = zzc2.zzf(zzpq.class);
        for (Map.Entry<String, String> entry : zzh2.zzn().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzpq2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzpq2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzpq2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzpq2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzke2.setUserId(string2);
                continue;
            }
            zzkd2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzh2.zzjE(), zzpr2);
        zzc2.zzM(this.zzjq().zzlF());
        zzc2.zzAy();
    }

    public void zzkj() {
        this.zzjv();
        this.zzjk();
        this.zzRh = true;
        this.zzRb.disconnect();
        this.zzkb();
    }
}

