/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzc;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzkc;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzpq;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzps;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.internal.zzpu;
import com.google.android.gms.internal.zzpv;
import com.google.android.gms.internal.zzpw;
import com.google.android.gms.internal.zzpx;
import com.google.android.gms.internal.zzpy;
import com.google.android.gms.measurement.zzi;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzb
extends zzc
implements zzi {
    private static DecimalFormat zzOU;
    private final zzf zzOK;
    private final String zzOV;
    private final Uri zzOW;
    private final boolean zzOX;
    private final boolean zzOY;

    public zzb(zzf zzf2, String string) {
        this(zzf2, string, true, false);
    }

    public zzb(zzf zzf2, String string, boolean bl, boolean bl2) {
        super(zzf2);
        zzx.zzcM((String)string);
        this.zzOK = zzf2;
        this.zzOV = string;
        this.zzOX = bl;
        this.zzOY = bl2;
        this.zzOW = zzb.zzaU(this.zzOV);
    }

    static Uri zzaU(String string) {
        zzx.zzcM((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public Uri zziA() {
        return this.zzOW;
    }

    @Override
    public void zzb(com.google.android.gms.measurement.zzc zzc2) {
        zzx.zzz((Object)zzc2);
        zzx.zzb((boolean)zzc2.zzAz(), (Object)"Can't deliver not submitted measurement");
        zzx.zzcE((String)"deliver should be called on worker thread");
        com.google.android.gms.measurement.zzc zzc3 = zzc2.zzAu();
        zzke zzke2 = zzc3.zzf(zzke.class);
        if (TextUtils.isEmpty((CharSequence)zzke2.zziS())) {
            this.zzjm().zzh(zzb.zzc(zzc3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzke2.getClientId())) {
            this.zzjm().zzh(zzb.zzc(zzc3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzOK.zzjz().getAppOptOut()) {
            return;
        }
        double d = zzke2.zziX();
        if (zzam.zza(d, zzke2.getClientId())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zzc3);
        map.put("v", "1");
        map.put("_v", zze.zzQm);
        map.put("tid", this.zzOV);
        if (this.zzOK.zzjz().isDryRunEnabled()) {
            String string = zzb.zzH(map);
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzam.zzc(hashMap, "uid", zzke2.getUserId());
        zzpq zzpq2 = zzc2.zze(zzpq.class);
        if (zzpq2 != null) {
            zzam.zzc(hashMap, "an", zzpq2.zzlg());
            zzam.zzc(hashMap, "aid", zzpq2.zzwK());
            zzam.zzc(hashMap, "av", zzpq2.zzli());
            zzam.zzc(hashMap, "aiid", zzpq2.zzAJ());
        }
        zzh zzh2 = new zzh(0L, zzke2.getClientId(), this.zzOV, !TextUtils.isEmpty((CharSequence)zzke2.zziT()), 0L, hashMap);
        long l = this.zziH().zza(zzh2);
        map.put("_s", String.valueOf(l));
        zzab zzab2 = new zzab(this.zzjm(), map, zzc2.zzAx(), true);
        this.zziH().zza(zzab2);
    }

    public static Map<String, String> zzc(com.google.android.gms.measurement.zzc zzc2) {
        zzpq zzpq2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        zzkb zzkb2;
        zzpy zzpy2;
        zzpx zzpx2;
        zzpv zzpv2;
        zzpr zzpr2;
        Object object5;
        Object object6;
        Object object7;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzkd zzkd2 = zzc2.zze(zzkd.class);
        if (zzkd2 != null) {
            object7 = zzkd2.zziR().entrySet().iterator();
            while (object7.hasNext()) {
                object6 = (Map.Entry)object7.next();
                object5 = zzb.zzi(object6.getValue());
                if (object5 == null) continue;
                hashMap.put((String)object6.getKey(), (String)object5);
            }
        }
        if ((object7 = zzc2.zze(zzke.class)) != null) {
            zzb.zzb(hashMap, "t", ((zzke)object7).zziS());
            zzb.zzb(hashMap, "cid", ((zzke)object7).getClientId());
            zzb.zzb(hashMap, "uid", ((zzke)object7).getUserId());
            zzb.zzb(hashMap, "sc", ((zzke)object7).zziV());
            zzb.zza(hashMap, "sf", ((zzke)object7).zziX());
            zzb.zza(hashMap, "ni", ((zzke)object7).zziW());
            zzb.zzb(hashMap, "adid", ((zzke)object7).zziT());
            zzb.zza(hashMap, "ate", ((zzke)object7).zziU());
        }
        if ((object6 = zzc2.zze(zzpw.class)) != null) {
            zzb.zzb(hashMap, "cd", ((zzpw)object6).zzBc());
            zzb.zza(hashMap, "a", ((zzpw)object6).zzBd());
            zzb.zzb(hashMap, "dr", ((zzpw)object6).zzBe());
        }
        if ((object5 = zzc2.zze(zzpu.class)) != null) {
            zzb.zzb(hashMap, "ec", ((zzpu)object5).zzAZ());
            zzb.zzb(hashMap, "ea", ((zzpu)object5).getAction());
            zzb.zzb(hashMap, "el", ((zzpu)object5).getLabel());
            zzb.zza(hashMap, "ev", ((zzpu)object5).getValue());
        }
        if ((zzpr2 = zzc2.zze(zzpr.class)) != null) {
            zzb.zzb(hashMap, "cn", zzpr2.getName());
            zzb.zzb(hashMap, "cs", zzpr2.getSource());
            zzb.zzb(hashMap, "cm", zzpr2.zzAK());
            zzb.zzb(hashMap, "ck", zzpr2.zzAL());
            zzb.zzb(hashMap, "cc", zzpr2.getContent());
            zzb.zzb(hashMap, "ci", zzpr2.getId());
            zzb.zzb(hashMap, "anid", zzpr2.zzAM());
            zzb.zzb(hashMap, "gclid", zzpr2.zzAN());
            zzb.zzb(hashMap, "dclid", zzpr2.zzAO());
            zzb.zzb(hashMap, "aclid", zzpr2.zzAP());
        }
        if ((zzpv2 = zzc2.zze(zzpv.class)) != null) {
            zzb.zzb(hashMap, "exd", zzpv2.getDescription());
            zzb.zza(hashMap, "exf", zzpv2.zzBa());
        }
        if ((zzpx2 = zzc2.zze(zzpx.class)) != null) {
            zzb.zzb(hashMap, "sn", zzpx2.zzBg());
            zzb.zzb(hashMap, "sa", zzpx2.getAction());
            zzb.zzb(hashMap, "st", zzpx2.getTarget());
        }
        if ((zzpy2 = zzc2.zze(zzpy.class)) != null) {
            zzb.zzb(hashMap, "utv", zzpy2.zzBh());
            zzb.zza(hashMap, "utt", zzpy2.getTimeInMillis());
            zzb.zzb(hashMap, "utc", zzpy2.zzAZ());
            zzb.zzb(hashMap, "utl", zzpy2.getLabel());
        }
        if ((zzkb2 = zzc2.zze(zzkb.class)) != null) {
            object4 = zzkb2.zziP();
            object3 = object4.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = com.google.android.gms.analytics.zzc.zzU((Integer)object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((object4 = zzc2.zze(zzkc.class)) != null) {
            object3 = ((zzkc)object4).zziQ();
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = com.google.android.gms.analytics.zzc.zzW((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zzb((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zzc2.zze(zzpt.class)) != null) {
            object2 = ((zzpt)object3).zzAV();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzpt)object3).zzAY()) {
                hashMap.putAll(promotion.zzba(com.google.android.gms.analytics.zzc.zzaa(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzpt)object3).zzAW()) {
                hashMap.putAll(product.zzba(com.google.android.gms.analytics.zzc.zzY(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzpt)object3).zzAX().entrySet()) {
                List<Product> list = entry.getValue();
                String string = com.google.android.gms.analytics.zzc.zzad(n);
                int n2 = 1;
                for (Product product : list) {
                    hashMap.putAll(product.zzba(string + com.google.android.gms.analytics.zzc.zzab(n2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    hashMap.put(string + "nm", entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zzc2.zze(zzps.class)) != null) {
            zzb.zzb(hashMap, "ul", ((zzps)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zzps)object2).zzAQ());
            zzb.zza(hashMap, "sr", ((zzps)object2).zzAR(), ((zzps)object2).zzAS());
            zzb.zza(hashMap, "vp", ((zzps)object2).zzAT(), ((zzps)object2).zzAU());
        }
        if ((zzpq2 = zzc2.zze(zzpq.class)) != null) {
            zzb.zzb(hashMap, "an", zzpq2.zzlg());
            zzb.zzb(hashMap, "aid", zzpq2.zzwK());
            zzb.zzb(hashMap, "aiid", zzpq2.zzAJ());
            zzb.zzb(hashMap, "av", zzpq2.zzli());
        }
        return hashMap;
    }

    private static void zzb(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    static String zzb(double d) {
        if (zzOU == null) {
            zzOU = new DecimalFormat("0.######");
        }
        return zzOU.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zzb(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, n + "x" + n2);
        }
    }

    private static String zzH(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    private static String zzi(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
            return null;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            if (d != 0.0) {
                return zzb.zzb(d);
            }
            return null;
        }
        if (object instanceof Boolean) {
            if (object != Boolean.FALSE) {
                return "1";
            }
            return null;
        }
        return String.valueOf(object);
    }
}

