/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.annotation.TargetApi;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.RawRes;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.tagmanager.ContainerHolder;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzct;
import com.google.android.gms.tagmanager.zzcu;
import com.google.android.gms.tagmanager.zzd;
import com.google.android.gms.tagmanager.zzo;
import com.google.android.gms.tagmanager.zzp;
import com.google.android.gms.tagmanager.zzs;
import com.google.android.gms.tagmanager.zzw;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TagManager {
    private final zza zzblj;
    private final Context mContext;
    private final DataLayer zzbhN;
    private final zzct zzblk;
    private final ConcurrentMap<zzo, Boolean> zzbll;
    private final zzs zzbkh;
    private static TagManager zzblm;

    TagManager(Context context, zza containerHolderLoaderProvider, DataLayer dataLayer, zzct serviceManager) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.mContext = context.getApplicationContext();
        this.zzblk = serviceManager;
        this.zzblj = containerHolderLoaderProvider;
        this.zzbll = new ConcurrentHashMap<zzo, Boolean>();
        this.zzbhN = dataLayer;
        this.zzbhN.zza(new DataLayer.zzb(){

            @Override
            public void zzQ(Map<String, Object> map) {
                Object object = map.get("event");
                if (object != null) {
                    TagManager.this.zzgp(object.toString());
                }
            }
        });
        this.zzbhN.zza(new zzd(this.mContext));
        this.zzbkh = new zzs();
        this.zzHt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static TagManager getInstance(Context context) {
        Class<TagManager> clazz = TagManager.class;
        synchronized (TagManager.class) {
            if (zzblm == null) {
                if (context == null) {
                    zzbg.e("TagManager.getInstance requires non-null context.");
                    throw new NullPointerException();
                }
                zza zza2 = new zza(){

                    @Override
                    public zzp zza(Context context, TagManager tagManager, Looper looper, String string, int n, zzs zzs2) {
                        return new zzp(context, tagManager, looper, string, n, zzs2);
                    }
                };
                zzw zzw2 = new zzw(context);
                zzblm = new TagManager(context, zza2, new DataLayer(zzw2), zzcu.zzHo());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzblm;
        }
    }

    public DataLayer getDataLayer() {
        return this.zzbhN;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String containerId, @RawRes int defaultContainerResourceId) {
        zzp zzp2 = this.zzblj.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzbkh);
        zzp2.zzGg();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String containerId, @RawRes int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzblj.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzbkh);
        zzp2.zzGg();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String containerId, @RawRes int defaultContainerResourceId) {
        zzp zzp2 = this.zzblj.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzbkh);
        zzp2.zzGh();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String containerId, @RawRes int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzblj.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzbkh);
        zzp2.zzGh();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String containerId, @RawRes int defaultContainerResourceId) {
        zzp zzp2 = this.zzblj.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzbkh);
        zzp2.zzGi();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String containerId, @RawRes int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzblj.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzbkh);
        zzp2.zzGi();
        return zzp2;
    }

    public void dispatch() {
        this.zzblk.dispatch();
    }

    public void setVerboseLoggingEnabled(boolean enableVerboseLogging) {
        zzbg.setLogLevel(enableVerboseLogging ? 2 : 5);
    }

    synchronized boolean zzp(Uri uri) {
        zzcb zzcb2 = zzcb.zzGU();
        if (zzcb2.zzp(uri)) {
            String string = zzcb2.getContainerId();
            switch (zzcb2.zzGV()) {
                case zzbjU: {
                    for (zzo zzo2 : this.zzbll.keySet()) {
                        if (!zzo2.getContainerId().equals(string)) continue;
                        zzo2.zzfT(null);
                        zzo2.refresh();
                    }
                    break;
                }
                case zzbjV: 
                case zzbjW: {
                    for (zzo zzo3 : this.zzbll.keySet()) {
                        if (zzo3.getContainerId().equals(string)) {
                            zzo3.zzfT(zzcb2.zzGW());
                            zzo3.refresh();
                            continue;
                        }
                        if (zzo3.zzGd() == null) continue;
                        zzo3.zzfT(null);
                        zzo3.refresh();
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void zza(zzo zzo2) {
        this.zzbll.put(zzo2, true);
    }

    public boolean zzb(zzo zzo2) {
        return this.zzbll.remove(zzo2) != null;
    }

    private void zzgp(String string) {
        for (zzo zzo2 : this.zzbll.keySet()) {
            zzo2.zzfR(string);
        }
    }

    @TargetApi(value=14)
    private void zzHt() {
        if (Build.VERSION.SDK_INT >= 14) {
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

                public void onTrimMemory(int i) {
                    if (i == 20) {
                        TagManager.this.dispatch();
                    }
                }

                public void onConfigurationChanged(Configuration configuration) {
                }

                public void onLowMemory() {
                }
            });
        }
    }

    public static interface zza {
        public zzp zza(Context var1, TagManager var2, Looper var3, String var4, int var5, zzs var6);
    }
}

