/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import java.util.Collections;
import java.util.List;

public class Credential
implements SafeParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    final int mVersionCode;
    private final String zzyv;
    @Nullable
    private final String mName;
    @Nullable
    private final Uri zzVV;
    private final List<IdToken> zzVW;
    @Nullable
    private final String zzVX;
    @Nullable
    private final String zzVY;
    @Nullable
    private final String zzVZ;
    @Nullable
    private final String zzWa;

    Credential(int version, String id, String name, Uri profilePictureUri, List<IdToken> idTokens, String password, String accountType, String generatedPassword, String generatedHintId) {
        this.mVersionCode = version;
        String string = ((String)zzx.zzb((Object)id, (Object)"credential identifier cannot be null")).trim();
        zzx.zzh((String)string, (Object)"credential identifier cannot be empty");
        this.zzyv = string;
        if (name != null && TextUtils.isEmpty((CharSequence)name.trim())) {
            name = null;
        }
        this.mName = name;
        this.zzVV = profilePictureUri;
        this.zzVW = idTokens == null ? Collections.emptyList() : Collections.unmodifiableList(idTokens);
        this.zzVX = password;
        if (password != null && password.isEmpty()) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        if (!TextUtils.isEmpty((CharSequence)accountType)) {
            Uri uri = Uri.parse((String)accountType);
            String string2 = uri.getScheme();
            zzx.zzac(("http".equalsIgnoreCase(string2) || "https".equalsIgnoreCase(string2) ? 1 : 0) != 0);
        }
        this.zzVY = accountType;
        this.zzVZ = generatedPassword;
        this.zzWa = generatedHintId;
        if (!TextUtils.isEmpty((CharSequence)this.zzVX) && !TextUtils.isEmpty((CharSequence)this.zzVY)) {
            throw new IllegalStateException("password and accountType cannot both be set");
        }
    }

    public String getId() {
        return this.zzyv;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zzVV;
    }

    public List<IdToken> getIdTokens() {
        return this.zzVW;
    }

    @Nullable
    public String getPassword() {
        return this.zzVX;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.zzVZ;
    }

    @Nullable
    public String getAccountType() {
        return this.zzVY;
    }

    public String zzmx() {
        return this.zzWa;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)other;
        return TextUtils.equals((CharSequence)this.zzyv, (CharSequence)credential.zzyv) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzw.equal((Object)this.zzVV, (Object)credential.zzVV) && TextUtils.equals((CharSequence)this.zzVX, (CharSequence)credential.zzVX) && TextUtils.equals((CharSequence)this.zzVY, (CharSequence)credential.zzVY) && TextUtils.equals((CharSequence)this.zzVZ, (CharSequence)credential.zzVZ);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzyv, this.mName, this.zzVV, this.zzVX, this.zzVY, this.zzVZ});
    }

    public static class Builder {
        private final String zzyv;
        private String mName;
        private Uri zzVV;
        private List<IdToken> zzVW;
        private String zzVX;
        private String zzVY;
        private String zzVZ;
        private String zzWa;

        public Builder(String id) {
            this.zzyv = id;
        }

        public Builder(Credential credential) {
            this.zzyv = credential.zzyv;
            this.mName = credential.mName;
            this.zzVV = credential.zzVV;
            this.zzVW = credential.zzVW;
            this.zzVX = credential.zzVX;
            this.zzVY = credential.zzVY;
            this.zzVZ = credential.zzVZ;
            this.zzWa = credential.zzWa;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setProfilePictureUri(Uri profilePictureUri) {
            this.zzVV = profilePictureUri;
            return this;
        }

        public Builder setPassword(String password) {
            this.zzVX = password;
            return this;
        }

        public Builder setAccountType(String accountType) {
            this.zzVY = accountType;
            return this;
        }

        public Credential build() {
            return new Credential(3, this.zzyv, this.mName, this.zzVV, this.zzVW, this.zzVX, this.zzVY, this.zzVZ, this.zzWa);
        }
    }
}

