/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzc;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;

public final class CredentialRequest
implements SafeParcelable {
    public static final Parcelable.Creator<CredentialRequest> CREATOR = new zzc();
    final int mVersionCode;
    private final boolean zzWd;
    private final String[] zzWe;
    private final CredentialPickerConfig zzWf;
    private final CredentialPickerConfig zzWg;

    CredentialRequest(int version, boolean passwordLoginSupported, String[] accountTypes, CredentialPickerConfig credentialPickerConfig, CredentialPickerConfig credentialHintPickerConfig) {
        this.mVersionCode = version;
        this.zzWd = passwordLoginSupported;
        this.zzWe = (String[])zzx.zzz((Object)accountTypes);
        this.zzWf = credentialPickerConfig == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig;
        this.zzWg = credentialHintPickerConfig == null ? new CredentialPickerConfig.Builder().build() : credentialHintPickerConfig;
    }

    private CredentialRequest(Builder builder) {
        this(2, builder.zzWd, builder.zzWe, builder.zzWf, builder.zzWg);
    }

    @Deprecated
    public boolean getSupportsPasswordLogin() {
        return this.isPasswordLoginSupported();
    }

    public boolean isPasswordLoginSupported() {
        return this.zzWd;
    }

    @NonNull
    public String[] getAccountTypes() {
        return this.zzWe;
    }

    @NonNull
    public CredentialPickerConfig getCredentialPickerConfig() {
        return this.zzWf;
    }

    @NonNull
    public CredentialPickerConfig getCredentialHintPickerConfig() {
        return this.zzWg;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    public static final class Builder {
        private boolean zzWd;
        private String[] zzWe;
        private CredentialPickerConfig zzWf;
        private CredentialPickerConfig zzWg;

        @Deprecated
        public Builder setSupportsPasswordLogin(boolean supportsPasswordLogin) {
            return this.setPasswordLoginSupported(supportsPasswordLogin);
        }

        public Builder setPasswordLoginSupported(boolean passwordLoginSupported) {
            this.zzWd = passwordLoginSupported;
            return this;
        }

        public Builder setAccountTypes(String ... accountTypes) {
            if (accountTypes == null) {
                accountTypes = new String[]{};
            }
            this.zzWe = accountTypes;
            return this;
        }

        public Builder setCredentialPickerConfig(CredentialPickerConfig config) {
            this.zzWf = config;
            return this;
        }

        public Builder setCredentialHintPickerConfig(CredentialPickerConfig config) {
            this.zzWg = config;
            return this;
        }

        public CredentialRequest build() {
            if (this.zzWe == null) {
                this.zzWe = new String[0];
            }
            if (!this.zzWd && this.zzWe.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new CredentialRequest(this);
        }
    }
}

