/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.zzf;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public final class PasswordSpecification
implements SafeParcelable {
    public static final zzf CREATOR = new zzf();
    public static final PasswordSpecification zzWl = new zza().zzh(12, 16).zzbG("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").zze("abcdefghijkmnopqrstxyz", 1).zze("ABCDEFGHJKLMNPQRSTXY", 1).zze("3456789", 1).zzmA();
    public static final PasswordSpecification zzWm = new zza().zzh(12, 16).zzbG("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").zze("abcdefghijklmnopqrstuvwxyz", 1).zze("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).zze("1234567890", 1).zzmA();
    final int mVersionCode;
    final String zzWn;
    final List<String> zzWo;
    final List<Integer> zzWp;
    final int zzWq;
    final int zzWr;
    private final int[] zzWs;
    private final Random zzuy;

    PasswordSpecification(int version, String allowedChars, List<String> requiredCharSets, List<Integer> requiredCharCounts, int minimumSize, int maximumSize) {
        this.mVersionCode = version;
        this.zzWn = allowedChars;
        this.zzWo = Collections.unmodifiableList(requiredCharSets);
        this.zzWp = Collections.unmodifiableList(requiredCharCounts);
        this.zzWq = minimumSize;
        this.zzWr = maximumSize;
        this.zzWs = this.zzmz();
        this.zzuy = new SecureRandom();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzf.zza(this, out, flags);
    }

    private int[] zzmz() {
        int[] nArray = new int[95];
        Arrays.fill(nArray, -1);
        int n = 0;
        for (String string : this.zzWo) {
            for (char c : string.toCharArray()) {
                nArray[this.zza((char)c)] = n;
            }
            ++n;
        }
        return nArray;
    }

    private int zza(char c) {
        return c - 32;
    }

    private static String zzb(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (char c : collection) {
            cArray[n++] = c;
        }
        return new String(cArray);
    }

    private static boolean zzb(int n, int n2, int n3) {
        return n < n2 || n > n3;
    }

    public static class zzb
    extends Error {
        public zzb(String string) {
            super(string);
        }
    }

    public static class zza {
        private final TreeSet<Character> zzWt = new TreeSet();
        private final List<String> zzWo = new ArrayList<String>();
        private final List<Integer> zzWp = new ArrayList<Integer>();
        private int zzWq = 12;
        private int zzWr = 16;

        public zza zzbG(@NonNull String string) {
            this.zzWt.addAll(this.zzq(string, "allowedChars"));
            return this;
        }

        public zza zze(@NonNull String string, int n) {
            if (n < 1) {
                throw new zzb("count must be at least 1");
            }
            TreeSet<Character> treeSet = this.zzq(string, "requiredChars");
            this.zzWo.add(PasswordSpecification.zzb(treeSet));
            this.zzWp.add(n);
            return this;
        }

        public zza zzh(int n, int n2) {
            if (n < 1) {
                throw new zzb("minimumSize must be at least 1");
            }
            if (n > n2) {
                throw new zzb("maximumSize must be greater than or equal to minimumSize");
            }
            this.zzWq = n;
            this.zzWr = n2;
            return this;
        }

        public PasswordSpecification zzmA() {
            if (this.zzWt.isEmpty()) {
                throw new zzb("no allowed characters specified");
            }
            this.zzmB();
            this.zzmC();
            return new PasswordSpecification(1, PasswordSpecification.zzb(this.zzWt), this.zzWo, this.zzWp, this.zzWq, this.zzWr);
        }

        private TreeSet<Character> zzq(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new zzb(string2 + " cannot be null or empty");
            }
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (char c : string.toCharArray()) {
                if (PasswordSpecification.zzb(c, 32, 126)) {
                    throw new zzb(string2 + " must only contain ASCII printable characters");
                }
                treeSet.add(Character.valueOf(c));
            }
            return treeSet;
        }

        private void zzmB() {
            int n = 0;
            for (int n2 : this.zzWp) {
                n += n2;
            }
            if (n > this.zzWr) {
                throw new zzb("required character count cannot be greater than the max password size");
            }
        }

        private void zzmC() {
            boolean[] blArray = new boolean[95];
            for (String string : this.zzWo) {
                for (char c : string.toCharArray()) {
                    if (blArray[c - 32]) {
                        throw new zzb("character " + c + " occurs in more than one required character set");
                    }
                    blArray[c - 32] = true;
                }
            }
        }
    }
}

