/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.AccountChangeEventsRequest;
import com.google.android.gms.auth.AccountChangeEventsResponse;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzas;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

public class zzd {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String KEY_REQUEST_ACTIONS = "request_visible_actions";
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    @Deprecated
    public static final String KEY_REQUEST_VISIBLE_ACTIVITIES = "request_visible_actions";
    public static final String KEY_CALLER_UID = Build.VERSION.SDK_INT >= 11 ? "callerUid" : "callerUid";
    public static final String KEY_ANDROID_PACKAGE_NAME = Build.VERSION.SDK_INT >= 14 ? "androidPackageName" : "androidPackageName";
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName zzVe = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
    private static final ComponentName zzVf = new ComponentName("com.google.android.gms", "com.google.android.gms.recovery.RecoveryService");

    @Deprecated
    public static String getToken(Context context, String accountName, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return zzd.getToken(context, account, scope);
    }

    @Deprecated
    public static String getToken(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return zzd.getToken(context, account, scope, extras);
    }

    public static String getToken(Context context, Account account, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zzd.getToken(context, account, scope, new Bundle());
    }

    public static String getToken(Context context, Account account, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        TokenData tokenData = zzd.zzc(context, account, scope, extras);
        return tokenData.getToken();
    }

    public static TokenData zzc(Context context, final Account account, final String string2, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        zzx.zzcE("Calling this from your main thread can lead to deadlock");
        zzd.zzad(context);
        final Bundle bundle2 = bundle == null ? new Bundle() : new Bundle(bundle);
        String string3 = context.getApplicationInfo().packageName;
        bundle2.putString("clientPackageName", string3);
        if (TextUtils.isEmpty((CharSequence)bundle2.getString(KEY_ANDROID_PACKAGE_NAME))) {
            bundle2.putString(KEY_ANDROID_PACKAGE_NAME, string3);
        }
        bundle2.putLong("service_connection_start_time_millis", SystemClock.elapsedRealtime());
        zza<TokenData> zza2 = new zza<TokenData>(){

            public TokenData zzam(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzas zzas2 = zzas.zza.zza(iBinder);
                Bundle bundle = (Bundle)zzd.zzm(zzas2.zza(account, string2, bundle2));
                TokenData tokenData = TokenData.zzc(bundle, "tokenDetails");
                if (tokenData != null) {
                    return tokenData;
                }
                String string22 = bundle.getString("Error");
                Intent intent = (Intent)bundle.getParcelable("userRecoveryIntent");
                com.google.android.gms.auth.firstparty.shared.zzd zzd2 = com.google.android.gms.auth.firstparty.shared.zzd.zzbY(string22);
                if (com.google.android.gms.auth.firstparty.shared.zzd.zza(zzd2)) {
                    throw new UserRecoverableAuthException(string22, intent);
                }
                if (com.google.android.gms.auth.firstparty.shared.zzd.zzc(zzd2)) {
                    throw new IOException(string22);
                }
                throw new GoogleAuthException(string22);
            }

            @Override
            public /* synthetic */ Object zzan(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzam(iBinder);
            }
        };
        return zzd.zza(context, zzVe, zza2);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(Context context, String token) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, token);
    }

    public static void clearToken(Context context, final String token) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        zzx.zzcE("Calling this from your main thread can lead to deadlock");
        zzd.zzad(context);
        final Bundle bundle = new Bundle();
        String string2 = context.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", string2);
        if (!bundle.containsKey(KEY_ANDROID_PACKAGE_NAME)) {
            bundle.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        zza<Void> zza2 = new zza<Void>(){

            public Void zzao(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzas zzas2 = zzas.zza.zza(iBinder);
                Bundle bundle2 = (Bundle)zzd.zzm(zzas2.zza(token, bundle));
                String string2 = bundle2.getString("Error");
                if (!bundle2.getBoolean("booleanResult")) {
                    throw new GoogleAuthException(string2);
                }
                return null;
            }

            @Override
            public /* synthetic */ Object zzan(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzao(iBinder);
            }
        };
        zzd.zza(context, zzVe, zza2);
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, final int eventIndex, final String accountName) throws GoogleAuthException, IOException {
        zzx.zzh(accountName, "accountName must be provided");
        zzx.zzcE("Calling this from your main thread can lead to deadlock");
        zzd.zzad(context);
        zza<List<AccountChangeEvent>> zza2 = new zza<List<AccountChangeEvent>>(){

            public List<AccountChangeEvent> zzap(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzas zzas2 = zzas.zza.zza(iBinder);
                AccountChangeEventsRequest accountChangeEventsRequest = new AccountChangeEventsRequest().setAccountName(accountName).setEventIndex(eventIndex);
                AccountChangeEventsResponse accountChangeEventsResponse = (AccountChangeEventsResponse)zzd.zzm(zzas2.zza(accountChangeEventsRequest));
                return accountChangeEventsResponse.getEvents();
            }

            @Override
            public /* synthetic */ Object zzan(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzap(iBinder);
            }
        };
        return zzd.zza(context, zzVe, zza2);
    }

    public static String getAccountId(Context ctx, String accountName) throws GoogleAuthException, IOException {
        zzx.zzh(accountName, "accountName must be provided");
        zzx.zzcE("Calling this from your main thread can lead to deadlock");
        zzd.zzad(ctx);
        return zzd.getToken(ctx, accountName, "^^_account_id_^^", new Bundle());
    }

    static void zzi(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("Callback cannot be null.");
        }
        String string2 = intent.toUri(1);
        try {
            Intent.parseUri((String)string2, (int)1);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
        }
    }

    private static void zzad(Context context) throws GoogleAuthException {
        try {
            zze.zzad(context.getApplicationContext());
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new GoogleAuthException(googlePlayServicesNotAvailableException.getMessage());
        }
    }

    private static <T> T zzm(T t) throws IOException {
        if (t == null) {
            Log.w((String)"GoogleAuthUtil", (String)"Binder call returned null.");
            throw new IOException("Service unavailable.");
        }
        return t;
    }

    private static <T> T zza(Context context, ComponentName componentName, zza<T> zza2) throws IOException, GoogleAuthException {
        com.google.android.gms.common.zza zza3 = new com.google.android.gms.common.zza();
        zzl zzl2 = zzl.zzau(context);
        if (zzl2.zza(componentName, (ServiceConnection)zza3, "GoogleAuthUtil")) {
            try {
                T t = zza2.zzan(zza3.zzoJ());
                return t;
            }
            catch (RemoteException | InterruptedException throwable) {
                Log.i((String)"GoogleAuthUtil", (String)"Error on service connection.", (Throwable)throwable);
                throw new IOException("Error on service connection.", throwable);
            }
            finally {
                zzl2.zzb(componentName, (ServiceConnection)zza3, "GoogleAuthUtil");
            }
        }
        throw new IOException("Could not bind to service.");
    }

    zzd() {
    }

    private static interface zza<T> {
        public T zzan(IBinder var1) throws RemoteException, IOException, GoogleAuthException;
    }
}

