/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.zze;

public class zzc {
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = zze.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    private static final zzc zzafF = new zzc();

    public static zzc zzoK() {
        return zzafF;
    }

    zzc() {
    }

    public int isGooglePlayServicesAvailable(Context context) {
        int n = zze.isGooglePlayServicesAvailable(context);
        if (zze.zzd(context, n)) {
            n = 18;
        }
        return n;
    }

    public void zzak(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        zze.zzad(context);
    }

    public boolean isUserResolvableError(int errorCode) {
        return zze.isUserRecoverableError(errorCode);
    }

    @Deprecated
    @Nullable
    public Intent zzbu(int n) {
        return this.zza(null, n, null);
    }

    @Nullable
    public Intent zza(Context context, int n, @Nullable String string2) {
        switch (n) {
            case 1: 
            case 2: {
                return zzn.zzx(GOOGLE_PLAY_SERVICES_PACKAGE, this.zzj(context, string2));
            }
            case 42: {
                return zzn.zzqU();
            }
            case 3: {
                return zzn.zzcJ(GOOGLE_PLAY_SERVICES_PACKAGE);
            }
        }
        return null;
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, int errorCode, int requestCode) {
        return this.zza(context, errorCode, requestCode, null);
    }

    @Nullable
    public PendingIntent zza(Context context, int n, int n2, @Nullable String string2) {
        Intent intent = this.zza(context, n, string2);
        if (intent == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)context, (int)n2, (Intent)intent, (int)0x10000000);
    }

    public void zzal(Context context) {
        zze.zzal(context);
    }

    @Nullable
    public String getOpenSourceSoftwareLicenseInfo(Context context) {
        return zze.getOpenSourceSoftwareLicenseInfo(context);
    }

    public int zzaj(Context context) {
        return zze.zzaj(context);
    }

    public boolean zzd(Context context, int n) {
        return zze.zzd(context, n);
    }

    public boolean zzi(Context context, String string2) {
        return zze.zzi(context, string2);
    }

    public String getErrorString(int errorCode) {
        return zze.getErrorString(errorCode);
    }

    private String zzj(@Nullable Context context, @Nullable String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("gcore_");
        stringBuilder.append(GOOGLE_PLAY_SERVICES_VERSION_CODE);
        stringBuilder.append("-");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string2);
        }
        stringBuilder.append("-");
        if (context != null) {
            stringBuilder.append(context.getPackageName());
        }
        stringBuilder.append("-");
        if (context != null) {
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                stringBuilder.append(packageInfo.versionCode);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }
}

