/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zzd;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zzne;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;

public class zze {
    @Deprecated
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = zze.zzoM();
    @Deprecated
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    public static boolean zzafL = false;
    public static boolean zzafM = false;
    static int zzafN = -1;
    private static final Object zzqy = new Object();
    private static String zzafO = null;
    private static Integer zzafP = null;
    static final AtomicBoolean zzafQ = new AtomicBoolean();
    private static final AtomicBoolean zzafR = new AtomicBoolean();

    zze() {
    }

    private static int zzoM() {
        return 8487000;
    }

    @Deprecated
    public static String getErrorString(int errorCode) {
        return ConnectionResult.getStatusString(errorCode);
    }

    @Deprecated
    public static int isGooglePlayServicesAvailable(Context context) {
        Resources resources;
        if (zzd.zzakE) {
            return 0;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            resources = context.getResources();
            resources.getString(R.string.common_google_play_services_unknown_issue);
        }
        catch (Throwable throwable) {
            Log.e((String)"GooglePlayServicesUtil", (String)"The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
        }
        if (!GOOGLE_PLAY_SERVICES_PACKAGE.equals(context.getPackageName())) {
            zze.zzan(context);
        }
        try {
            resources = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 1;
        }
        zzf zzf2 = zzf.zzoO();
        if (zzmu.zzaw(context)) {
            if (zzf2.zza((PackageInfo)resources, zzd.zzd.zzafK) == null) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                return 9;
            }
        } else {
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, 8256);
                zzd.zza zza2 = zzf2.zza(packageInfo, zzd.zzd.zzafK);
                if (zza2 == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store signature invalid.");
                    return 9;
                }
                if (zzf2.zza((PackageInfo)resources, zza2) == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                    return 9;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store is neither installed nor updating.");
                return 9;
            }
        }
        int n = zzmx.zzco(GOOGLE_PLAY_SERVICES_VERSION_CODE);
        int n2 = zzmx.zzco(resources.versionCode);
        if (n2 < n) {
            Log.w((String)"GooglePlayServicesUtil", (String)("Google Play services out of date.  Requires " + GOOGLE_PLAY_SERVICES_VERSION_CODE + " but found " + resources.versionCode));
            return 2;
        }
        ApplicationInfo applicationInfo = resources.applicationInfo;
        if (applicationInfo == null) {
            try {
                applicationInfo = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.wtf((String)"GooglePlayServicesUtil", (String)"Google Play services missing when getting application info.", (Throwable)nameNotFoundException);
                return 1;
            }
        }
        if (!applicationInfo.enabled) {
            return 3;
        }
        return 0;
    }

    @Deprecated
    public static void zzad(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        int n = zzc.zzoK().isGooglePlayServicesAvailable(context);
        if (n != 0) {
            Intent intent = zzc.zzoK().zza(context, n, "e");
            Log.e((String)"GooglePlayServicesUtil", (String)("GooglePlayServices not available due to error " + n));
            if (intent == null) {
                throw new GooglePlayServicesNotAvailableException(n);
            }
            throw new GooglePlayServicesRepairableException(n, "Google Play Services not available", intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzan(Context context) {
        Integer n;
        if (zzafR.get()) {
            return;
        }
        Object object = zzqy;
        synchronized (object) {
            block12: {
                if (zzafO == null) {
                    zzafO = context.getPackageName();
                    try {
                        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                        Bundle bundle = applicationInfo.metaData;
                        if (bundle != null) {
                            zzafP = bundle.getInt("com.google.android.gms.version");
                            break block12;
                        }
                        zzafP = null;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.wtf((String)"GooglePlayServicesUtil", (String)"This should never happen.", (Throwable)nameNotFoundException);
                    }
                } else if (!zzafO.equals(context.getPackageName())) {
                    throw new IllegalArgumentException("isGooglePlayServicesAvailable should only be called with Context from your application's package. A previous call used package '" + zzafO + "' and this call used package '" + context.getPackageName() + "'.");
                }
            }
            n = zzafP;
        }
        if (n == null) {
            throw new IllegalStateException("A required meta-data tag in your app's AndroidManifest.xml does not exist.  You must have the following declaration within the <application> element:     <meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />");
        }
        if (n != GOOGLE_PLAY_SERVICES_VERSION_CODE) {
            throw new IllegalStateException("The meta-data tag in your app's AndroidManifest.xml does not have the right value.  Expected " + GOOGLE_PLAY_SERVICES_VERSION_CODE + " but" + " found " + n + ".  You must have the" + " following declaration within the <application> element: " + "    <meta-data android:name=\"" + "com.google.android.gms.version" + "\" android:value=\"@integer/google_play_services_version\" />");
        }
    }

    public static boolean zzf(Context context, int n) {
        PackageInfo packageInfo;
        if (!zze.zzb(context, n, GOOGLE_PLAY_SERVICES_PACKAGE)) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            if (Log.isLoggable((String)"GooglePlayServicesUtil", (int)3)) {
                Log.d((String)"GooglePlayServicesUtil", (String)"Package manager can't find google play services package, defaulting to false");
            }
            return false;
        }
        return zzf.zzoO().zza(context.getPackageManager(), packageInfo);
    }

    @TargetApi(value=19)
    public static boolean zzb(Context context, int n, String string2) {
        if (zzne.zzsk()) {
            AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
            try {
                appOpsManager.checkPackage(n, string2);
                return true;
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        PackageManager packageManager = context.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (string2 != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static Intent zzbv(int n) {
        return zzc.zzoK().zza(null, n, null);
    }

    public static boolean zzoN() {
        if (zzafL) {
            return zzafM;
        }
        return "user".equals(Build.TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzb(PackageManager packageManager) {
        Object object = zzqy;
        synchronized (object) {
            if (zzafN == -1) {
                try {
                    PackageInfo packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
                    zzafN = zzf.zzoO().zza(packageInfo, zzd.zzd.zzafK[1]) != null ? 1 : 0;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    zzafN = 0;
                }
            }
            return zzafN != 0;
        }
    }

    public static boolean zzc(PackageManager packageManager) {
        return zze.zzb(packageManager) || !zze.zzoN();
    }

    static boolean zzbw(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 18: 
            case 42: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static PendingIntent getErrorPendingIntent(int errorCode, Context context, int requestCode) {
        return zzc.zzoK().getErrorResolutionPendingIntent(context, errorCode, requestCode);
    }

    @Deprecated
    public static void zzal(Context context) {
        if (zzafQ.getAndSet(true)) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.cancel(10436);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Deprecated
    public static boolean isUserRecoverableError(int errorCode) {
        switch (errorCode) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        String string2;
        block9: {
            Uri uri = new Uri.Builder().scheme("android.resource").authority(GOOGLE_PLAY_SERVICES_PACKAGE).appendPath("raw").appendPath("oss_notice").build();
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            try {
                string2 = new Scanner(inputStream).useDelimiter("\\A").next();
                if (inputStream == null) break block9;
            }
            catch (NoSuchElementException noSuchElementException) {
                String string3;
                block10: {
                    try {
                        string3 = null;
                        if (inputStream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return string3;
            }
            inputStream.close();
        }
        return string2;
    }

    public static Resources getRemoteResource(Context context) {
        try {
            return context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static Context getRemoteContext(Context context) {
        try {
            return context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static String zzao(Context context) {
        String string2 = context.getApplicationInfo().name;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            ApplicationInfo applicationInfo;
            string2 = context.getPackageName();
            PackageManager packageManager = context.getApplicationContext().getPackageManager();
            try {
                applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                applicationInfo = null;
            }
            if (applicationInfo != null) {
                string2 = packageManager.getApplicationLabel(applicationInfo).toString();
            }
        }
        return string2;
    }

    @Deprecated
    public static int zzaj(Context context) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 0;
        }
        return packageInfo.versionCode;
    }

    public static boolean zzap(Context context) {
        PackageManager packageManager = context.getPackageManager();
        return zzne.zzsm() && packageManager.hasSystemFeature("cn.google");
    }

    @Deprecated
    public static boolean zzd(Context context, int n) {
        if (n == 18) {
            return true;
        }
        if (n == 1) {
            return zze.zzi(context, GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        return false;
    }

    @Deprecated
    public static boolean zze(Context context, int n) {
        if (n == 9) {
            return zze.zzi(context, GOOGLE_PLAY_STORE_PACKAGE);
        }
        return false;
    }

    @TargetApi(value=21)
    static boolean zzi(Context context, String string2) {
        List list;
        if (zzne.zzsm()) {
            list = context.getPackageManager().getPackageInstaller().getAllSessions();
            for (PackageInstaller.SessionInfo sessionInfo : list) {
                if (!string2.equals(sessionInfo.getAppPackageName())) continue;
                return true;
            }
        }
        if (zze.zzaq(context)) {
            return false;
        }
        list = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = list.getApplicationInfo(string2, 8192);
            return applicationInfo.enabled;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    @TargetApi(value=18)
    public static boolean zzaq(Context context) {
        Bundle bundle;
        return zzne.zzsj() && (bundle = ((UserManager)context.getSystemService("user")).getApplicationRestrictions(context.getPackageName())) != null && "true".equals(bundle.getString("restricted_profile"));
    }
}

